/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.ISprite;
import com.jarbull.efw.ui.Component;
import javax.microedition.lcdui.Graphics;

public class Animation {
    public static final int FRAME = 0;
    public static final int TRANSLATION = 1;
    public static final int TRANSLATION_QUAD = 2;
    public static final int ALPHA = 3;
    public static final int ORIENTATION = 4;
    public static final int COLOR = 5;
    public static final int SHAKE = 6;
    public static final int SCALE = 7;
    public static final int CLIP = 8;
    public static final int VISIBILITY = 9;
    public static final int CONSTANT = 0;
    public static final int LOOP = 1;
    String id;
    boolean enabled;
    int repeatMode;
    int type;
    int[] typeParameters;
    int startTime;
    int endTime;
    int loopDelay;
    int loopCount;
    int currentLoopCount;
    ISprite gameObject;
    Graphics g;
    Component component;
    int[] frameSequence;
    String originalImageId;

    public Animation(String id, ISprite gameObject, int type, int[] typeParameters) {
        this.id = id;
        this.gameObject = gameObject;
        this.type = type;
        this.typeParameters = typeParameters;
        this.enabled = true;
        this.originalImageId = "original" + gameObject.getImageId();
        switch (type) {
            case 0: {
                this.frameSequence = typeParameters;
                gameObject.setFrameSequence(this.frameSequence);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                ImageHandler.getInstance().setImage(this.originalImageId, ImageHandler.getInstance().getImage(gameObject.getImageId()));
            }
        }
    }

    public Animation(String id, Graphics g, int type, int[] typeParameters) {
        this.id = id;
        this.g = g;
        this.type = type;
        this.typeParameters = typeParameters;
        this.enabled = true;
    }

    public Animation(String id, Component component, int type, int[] typeParameters) {
        this.id = id;
        this.component = component;
        this.type = type;
        this.typeParameters = typeParameters;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    int[] getFrameSequence() {
        return this.frameSequence;
    }

    String getOriginalImageId() {
        return this.originalImageId;
    }

    void setOriginalImageId(String originalImageId) {
        this.originalImageId = originalImageId;
    }

    public String getId() {
        return this.id;
    }

    public int getLoopDelay() {
        return this.loopDelay;
    }

    public void setLoopDelay(int loopDelay) {
        this.loopDelay = loopDelay;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public int getCurrentLoopCount() {
        return this.currentLoopCount;
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    public void setRepeatMode(int mode) {
        this.repeatMode = mode;
    }

    public ISprite getGameObject() {
        return this.gameObject;
    }

    public Component getComponent() {
        return this.component;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setInterval(int startTime, int endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public int getType() {
        return this.type;
    }

    public int[] getTypeParameters() {
        return this.typeParameters;
    }

    public void onAnimationFinished() {
    }
}

