/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.connection;

import com.jarbull.efw.connection.IErrorListener;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public abstract class HTTPConnection {
    private IErrorListener errorListener;

    public IErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(IErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public abstract void onTextReceived(String var1);

    public abstract void onImageReceived(Image var1);

    public void askRemoteText(final String url) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection connection = null;
                InputStream inputStream = null;
                StringBuffer buffer = new StringBuffer();
                try {
                    int ch;
                    connection = (HttpConnection)Connector.open((String)url);
                    inputStream = connection.openInputStream();
                    while ((ch = inputStream.read()) != -1) {
                        buffer.append((char)ch);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SecurityException ex) {
                    if (HTTPConnection.this.errorListener != null) {
                        HTTPConnection.this.errorListener.errorRaised(ex);
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (inputStream != null) {
                            connection.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    HTTPConnection.this.onTextReceived(buffer.toString());
                }
            }
        });
        thread.start();
    }

    public void askRemoteImage(final String url) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection connection = null;
                byte[] data = null;
                FilterInputStream dataInputStream = null;
                try {
                    connection = (HttpConnection)Connector.open((String)url);
                    int length = (int)connection.getLength();
                    data = new byte[length];
                    dataInputStream = new DataInputStream(connection.openInputStream());
                    ((DataInputStream)dataInputStream).readFully(data);
                }
                catch (SecurityException ex) {
                    if (HTTPConnection.this.errorListener != null) {
                        HTTPConnection.this.errorListener.errorRaised(ex);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    HTTPConnection.this.onImageReceived(Image.createImage((byte[])data, (int)0, (int)data.length));
                }
            }
        });
        thread.start();
    }
}

