/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.Log;
import baltorogames.system.InternalStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BGStore {
    RecordStore recordStore = null;
    private OutputStream _out;
    private DataInputStream in;
    private DataOutputStream out;
    private String storeName;

    public DataOutputStream getOutStream() {
        return this.out;
    }

    public DataInputStream getInStream() {
        return this.in;
    }

    private BGStore(InputStream streamIn, OutputStream streamOut, String name) {
        this.storeName = name;
        if (streamOut != null) {
            this._out = streamOut;
            this.out = new DataOutputStream(streamOut);
        } else {
            try {
                this.recordStore = RecordStore.openRecordStore((String)this.storeName, (boolean)false);
                this.recordStore.enumerateRecords(null, null, true);
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(1));
                this.in = new DataInputStream(bais);
            }
            catch (Exception e) {
                Log.DEBUG_LOG(4, "Reading Options settings from RS failed!");
            }
        }
    }

    public void close() {
        block10: {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                    try {
                        if (this.recordStore != null) {
                            this.recordStore.closeRecordStore();
                        }
                    }
                    catch (Exception e) {
                        Log.DEBUG_LOG(4, "Closing Options RS failed!");
                    }
                }
                if (this.out == null) break block10;
                try {
                    byte[] b = ((ByteArrayOutputStream)this._out).toByteArray();
                    RecordStore recordStore = RecordStore.openRecordStore((String)this.storeName, (boolean)true);
                    if (recordStore.getNumRecords() != 0) {
                        recordStore.setRecord(1, b, 0, b.length);
                    } else {
                        recordStore.addRecord(b, 0, b.length);
                    }
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException rse) {
                    Log.DEBUG_LOG(4, "Reading Options settings from RS failed!");
                    rse.printStackTrace();
                }
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                Log.DEBUG_LOG(4, "Failed to close store + name: " + this.storeName);
                e.printStackTrace();
            }
        }
    }

    public static boolean checkStoreExists(String storeName) {
        return InternalStorage.CheckFile(storeName);
    }

    public static void delete(String storeName) {
        InternalStorage.DeleteFile(storeName);
    }

    public static BGStore openStoreToRead(String storeName) {
        return new BGStore(null, null, storeName);
    }

    public static BGStore openStoreToWrite(String storeName) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (stream != null) {
            return new BGStore(null, stream, storeName);
        }
        return null;
    }
}

