/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Log;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public class YesNoDialogBox
extends MainScreen {
    private Vector textLines = new Vector();
    private int backgroundColor;
    private String captionText;
    private CGTexture image;
    private CGTexture[] animation;
    private int currentFrame = 0;

    public YesNoDialogBox(String caption, String main, int color, String imgName, int numFrames, long speed) {
        this.drawTop = false;
        this.drawTitle = false;
        Log.DEBUG_LOG(16, "opening YesNoDialog box");
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
        this.animation = new CGTexture[numFrames];
        try {
            for (int i = 0; i < numFrames; ++i) {
                Log.DEBUG_LOG(16, "Loading anim frame: " + imgName + i + ".png");
                this.animation[i] = TextureManager.AddTexture(imgName + i + ".png");
            }
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Could not load entry screeen aimation!");
        }
        boolean bIsOK = true;
        for (int i = 0; i < numFrames; ++i) {
            if (this.animation[i] != null) continue;
            bIsOK = false;
            break;
        }
        if (!bIsOK) {
            this.animation = new CGTexture[1];
            this.animation[0] = TextureManager.AddTexture(imgName + 0 + ".png");
        }
        if (this.animation[0] == null) {
            Log.DEBUG_LOG(16, "Could not load simple frame as well!");
        }
    }

    public YesNoDialogBox(String caption, String main, int color, String imgName) {
        this.drawTop = false;
        this.drawTitle = false;
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
        try {
            this.image = TextureManager.AddTexture(imgName);
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Could not load entry screeen image");
        }
    }

    private void init(String caption, String main, int color) {
        Log.DEBUG_LOG(16, "Spliting text");
        this.backgroundColor = color;
        this.captionText = caption;
        this.textLines = Utils.splitText(main, "+", this.width, 0);
        Log.DEBUG_LOG(16, "Done");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbCANCEL, ObjectsCache.menuSbCANCEL_a);
    }

    public YesNoDialogBox(String caption, String main, int color) {
        this.drawTop = false;
        this.drawTitle = false;
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
    }

    public void updateSize() {
    }

    public void drawWindowBackground() {
        this.drawBottom = false;
        if (this.drawTop) {
            // empty if block
        }
        if (this.drawBottom) {
            // empty if block
        }
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        if (this.animation != null) {
            this.image = this.animation[this.currentFrame];
        }
        int fontHeight = ApplicationData.defaultFont.getFontHeight();
        int yCenterAlign = (this.height - fontHeight * this.textLines.size() - (this.image != null ? this.image.GetHeight() : 0)) / 2;
        int yPosition = 0;
        for (int i = 0; i < this.textLines.size(); ++i) {
            yPosition = 0 + i * fontHeight + 0 + yCenterAlign;
            Utils.drawString((String)this.textLines.elementAt(i), this.width >> 1, yPosition, 17, 0);
        }
        if (this.image != null) {
            Graphic2D.DrawImage(this.image, this.width >> 1, yPosition += fontHeight, 17);
        }
    }
}

