/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.GameModeInfoScreen;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.SelectSurvivalScreen;
import baltorogames.project_gui.SelectWorldScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectGameModeScreen
extends MainListAnimated {
    private int STORY_ID = 0;
    private int SURV_ID = 1;

    public SelectGameModeScreen() {
        this.drawTop = false;
        this.drawTitle = true;
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_STORY"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SURVIVAL"));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public void onFocusBack() {
        super.onFocusBack();
        this.currentItem = 0;
    }

    public void currentItemChanged(int previousId, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
        if (currentItemId == this.STORY_ID) {
            CGSoundSystem.Play(2, false);
            if (CGUserCareer.isStoryPopupInfoOn) {
                UIScreen.SetNextScreen(new GameModeInfoScreen(1));
                UIScreen.GetNextScreen().setParent(this);
                CGUserCareer.isStoryPopupInfoOn = false;
            } else {
                UIScreen.SetNextScreen(new SelectWorldScreen());
                UIScreen.GetNextScreen().setParent(this);
            }
            this.readyForClose = true;
        } else if (currentItemId == this.SURV_ID) {
            CGSoundSystem.Play(2, false);
            if (CGUserCareer.isSurviPopupInfoOn) {
                UIScreen.SetNextScreen(new GameModeInfoScreen(2));
                UIScreen.GetNextScreen().setParent(this);
                CGUserCareer.isSurviPopupInfoOn = false;
            } else {
                UIScreen.SetNextScreen(new SelectSurvivalScreen());
                UIScreen.GetNextScreen().setParent(this);
            }
            this.readyForClose = true;
        }
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        if (nID >= 1000) {
            this.currentItemSelected(nID - 1000);
            return true;
        }
        return super.actionSoftButton(nID, pressed);
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        UIScreen.SetNextScreen(new MainMenu());
        this.readyForClose = true;
        return true;
    }
}

