/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainTextBox;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class NewItemInfoScreen
extends MainTextBox {
    private final int m_nListSize;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public int m_nCurrentIndex = 0;
    private CGTexture groundTexture = null;
    private String csText1;
    private String csText2;
    private CGTexture image = null;

    protected void Clean() {
    }

    public void onFocusBack() {
        super.onFocusBack();
    }

    public NewItemInfoScreen(int nWorldNr, int nItemNr) {
        super(Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_Y, ApplicationData.screenWidth - 2 * Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_H, true);
        this.m_nListSize = 5;
        this.LEFT_ARROW_ID = 200;
        this.RIGHT_ARROW_ID = 201;
        CGEngine.m_bPause = true;
        this.m_bModalScreen = false;
        this.groundTexture = TextureManager.AddTexture("/menu/popup_bg.png");
        this.m_nCurrentIndex = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.image = TextureManager.AddTexture("/gameplay/fant_" + nWorldNr + "_" + nItemNr + ".png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.image.GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.image.GetHeight();
        int nStartBoxY = ApplicationData.screenHeight / 2 + ObjectsCache.arrowLeft.GetHeight() / 2;
        int nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight();
        this.Setup(0, nStartBoxY, ApplicationData.screenWidth, nStopBoxY - nStartBoxY, true);
        this.csText1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_NEW_ITEM");
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_NEW_ITEM_" + nWorldNr + "_" + nItemNr);
        this.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ITEM_DESC_" + nItemNr));
    }

    public void autoSize() {
    }

    public void drawWindowBackground() {
        int backgroundTileWidth = ObjectsCache.topMenuBar.GetWidth();
        int backgroundTileHeight = ObjectsCache.topMenuBar.GetHeight();
        int numTilesX = ApplicationData.screenWidth / backgroundTileWidth;
        int numTilesY = ApplicationData.screenHeight / backgroundTileHeight;
        for (int x = 0; x <= numTilesX; ++x) {
            for (int y = 0; y <= numTilesY; ++y) {
                Graphic2D.DrawImage(ObjectsCache.topMenuBar, x * backgroundTileWidth, y * backgroundTileHeight, 20);
            }
        }
        Graphic2D.DrawImage(this.groundTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
    }

    public void draw() {
        super.draw();
        int trackIconX = ApplicationData.screenWidth / 2 - this.image.GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.image.GetHeight() - ObjectsCache.arrowLeft.GetHeight();
        Graphic2D.DrawImage(this.image, trackIconX, ApplicationData.screenHeight / 2 - this.groundTexture.GetHeight() / 2 + 3 * ApplicationData.getFontByID(0).getFontHeight(), 20);
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 2 - this.groundTexture.GetHeight() / 2 + ApplicationData.getFontByID(0).getFontHeight(), 17, 0);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 2 - this.groundTexture.GetHeight() / 2 + 2 * ApplicationData.getFontByID(0).getFontHeight(), 17, 0);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            CGEngine.m_bPause = false;
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        return super.actionSoftButton(nID, pressed);
    }
}

