/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class GetPowerupAnimationObject {
    public static final float eWidth = 128.0f;
    public static final float eHeight = 128.0f;
    public static final int eSize = 8;
    public static final int eMaxTime = 500;
    public float m_fPosX;
    public float m_fPosY;
    public int m_nTime;
    protected static Vector m_List = null;
    protected static Vector m_TmpList = null;
    protected static CGTexture[] m_arrTextures;

    public void Destroy() {
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
    }

    public void Render() {
        if (this.m_nTime < 500) {
            int nFrame = (int)(8.0f * (float)this.m_nTime / 500.0f);
            if (nFrame >= 8) {
                nFrame = 7;
            }
            CGTexture t = m_arrTextures[nFrame];
            CGEngineRenderer.RenderGetPowerupAnimation(t, this.m_fPosX, this.m_fPosY);
        }
    }

    public static void Init() {
        m_arrTextures = new CGTexture[8];
        GetPowerupAnimationObject.m_arrTextures[0] = TextureManager.CreateTexture("/gameplay/getpowerup_1.png");
        GetPowerupAnimationObject.m_arrTextures[1] = TextureManager.CreateTexture("/gameplay/getpowerup_2.png");
        GetPowerupAnimationObject.m_arrTextures[2] = TextureManager.CreateTexture("/gameplay/getpowerup_3.png");
        GetPowerupAnimationObject.m_arrTextures[3] = TextureManager.CreateTexture("/gameplay/getpowerup_4.png");
        GetPowerupAnimationObject.m_arrTextures[4] = TextureManager.CreateTexture("/gameplay/getpowerup_5.png");
        GetPowerupAnimationObject.m_arrTextures[5] = TextureManager.CreateTexture("/gameplay/getpowerup_6.png");
        GetPowerupAnimationObject.m_arrTextures[6] = TextureManager.CreateTexture("/gameplay/getpowerup_7.png");
        GetPowerupAnimationObject.m_arrTextures[7] = TextureManager.CreateTexture("/gameplay/getpowerup_8.png");
        m_List = new Vector();
        m_TmpList = new Vector();
        for (int i = 0; i < 20; ++i) {
            m_TmpList.addElement(new GetPowerupAnimationObject());
        }
    }

    public static void NewItem(float x, float y) {
        GetPowerupAnimationObject to = null;
        if (m_TmpList.size() > 0) {
            to = (GetPowerupAnimationObject)m_TmpList.elementAt(0);
            m_TmpList.removeElementAt(0);
        } else {
            to = new GetPowerupAnimationObject();
        }
        to.m_fPosX = x;
        to.m_fPosY = y;
        to.m_nTime = 0;
        m_List.addElement(to);
    }

    public static void StepAll(int nDeltaTimeInMs) {
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            GetPowerupAnimationObject to = (GetPowerupAnimationObject)m_List.elementAt(i);
            to.Step(nDeltaTimeInMs);
            if (to.m_nTime < 500) continue;
            m_TmpList.addElement(to);
            m_List.removeElementAt(i);
        }
    }

    public static void RenderAll() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            ((GetPowerupAnimationObject)m_List.elementAt(i)).Render();
        }
    }

    public static int GetCurrentSize() {
        return m_List.size();
    }

    public static void Reset() {
        int nS = m_List.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpList.addElement(m_List.elementAt(i));
            }
            m_List.removeAllElements();
        }
    }
}

