/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.Log;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static final int[] m_arrCashToUnlockWorld = new int[]{0, 50, 100, 150, 200};
    public static final int eMaxWorld = 5;
    public static final int eMaxLevels = 45;
    public static final int eNumSurvivalLevels = 5;
    public static final int eNumBoost = 5;
    public static boolean isStoryTutorialOn = true;
    public static boolean isSurvivalTutorialOn = true;
    public static boolean isStoryPopupInfoOn = true;
    public static boolean isSurviPopupInfoOn = true;
    public static boolean isSequencePopupInfoOn = true;
    public static boolean isStoryNormalMode_PopupInfoOn = true;
    public static boolean isStoryTimeMode_PopupInfoOn = true;
    public static boolean isStoryScoreMode_PopupInfoOn = true;
    public static boolean isStoryBombMode_PopupInfoOn = true;
    public static boolean isStoryBounceMode_PopupInfoOn = true;
    public static boolean[][] m_arrItems_PopupInfoOn;
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    public static int m_nMoney;
    public static int[] m_arrLevelScore;
    public static int[] m_arrLevelBestScore;
    public static int[] m_arrBestSurvivalScore;
    public static int[] m_arrSurvivalLevelAvailable;
    public static boolean[] m_arrBoostAvailable;
    public static boolean m_bReadyToSave;

    public static void Reset() {
        int i;
        isStoryTutorialOn = true;
        isSurvivalTutorialOn = true;
        isStoryPopupInfoOn = true;
        isSurviPopupInfoOn = true;
        isSequencePopupInfoOn = true;
        isStoryNormalMode_PopupInfoOn = true;
        isStoryTimeMode_PopupInfoOn = true;
        isStoryScoreMode_PopupInfoOn = true;
        isStoryBombMode_PopupInfoOn = true;
        isStoryBounceMode_PopupInfoOn = true;
        m_szNick = "";
        m_szDevicePlatform = "";
        m_nMoney = 0;
        m_arrItems_PopupInfoOn = new boolean[5][6];
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 6; ++j) {
                CGUserCareer.m_arrItems_PopupInfoOn[i][j] = false;
            }
        }
        m_arrLevelBestScore = new int[45];
        m_arrLevelScore = new int[45];
        for (i = 0; i < 45; ++i) {
            CGUserCareer.m_arrLevelBestScore[i] = -1;
            CGUserCareer.m_arrLevelScore[i] = -1;
        }
        CGUserCareer.m_arrLevelScore[0] = 0;
        m_arrSurvivalLevelAvailable = new int[5];
        m_arrBestSurvivalScore = new int[5];
        for (i = 0; i < 5; ++i) {
            CGUserCareer.m_arrSurvivalLevelAvailable[i] = 0;
            CGUserCareer.m_arrBestSurvivalScore[i] = 0;
        }
        CGUserCareer.m_arrSurvivalLevelAvailable[0] = 1;
        m_arrBoostAvailable = new boolean[5];
        for (i = 0; i < 5; ++i) {
            CGUserCareer.m_arrBoostAvailable[i] = false;
        }
    }

    public static boolean IsStoryLevelReadyToAvailable(int nLevelNumber) {
        if (nLevelNumber == 0) {
            return true;
        }
        if (nLevelNumber >= 45) {
            return false;
        }
        int nWorld = nLevelNumber / 9;
        return m_nMoney >= m_arrCashToUnlockWorld[nWorld] || m_arrLevelScore[nLevelNumber - 1] > 0;
    }

    public static void CheckUnlockNewWorld() {
        for (int i = 1; i <= 4; ++i) {
            if (m_nMoney < m_arrCashToUnlockWorld[i] || m_arrLevelScore[i * 9] >= 0) continue;
            CGUserCareer.m_arrLevelScore[i * 9] = 0;
            CGUserCareer.UnlockSurvivalLevel(i);
        }
    }

    public static boolean AllLevelsUnlocked() {
        for (int i = 0; i < 45; ++i) {
            if (m_arrLevelScore[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public static void Load() {
        CGUserCareer.Reset();
        m_bReadyToSave = true;
        BGStore store = BGStore.openStoreToRead("UserCareer");
        if (store == null) {
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                int i;
                for (i = 0; i < 45; ++i) {
                    CGUserCareer.m_arrLevelBestScore[i] = inputStream.readInt();
                    CGUserCareer.m_arrLevelScore[i] = inputStream.readInt();
                }
                m_nMoney = inputStream.readInt();
                for (i = 0; i < 5; ++i) {
                    CGUserCareer.m_arrSurvivalLevelAvailable[i] = inputStream.readInt();
                    CGUserCareer.m_arrBestSurvivalScore[i] = inputStream.readInt();
                }
                for (i = 0; i < m_arrBoostAvailable.length; ++i) {
                    CGUserCareer.m_arrBoostAvailable[i] = inputStream.readBoolean();
                }
                isStoryTutorialOn = inputStream.readBoolean();
                isSurvivalTutorialOn = inputStream.readBoolean();
                isStoryPopupInfoOn = inputStream.readBoolean();
                isSurviPopupInfoOn = inputStream.readBoolean();
                isSequencePopupInfoOn = inputStream.readBoolean();
                isStoryNormalMode_PopupInfoOn = inputStream.readBoolean();
                isStoryTimeMode_PopupInfoOn = inputStream.readBoolean();
                isStoryScoreMode_PopupInfoOn = inputStream.readBoolean();
                isStoryBombMode_PopupInfoOn = inputStream.readBoolean();
                isStoryBounceMode_PopupInfoOn = inputStream.readBoolean();
                for (i = 0; i < 5; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        CGUserCareer.m_arrItems_PopupInfoOn[i][j] = inputStream.readBoolean();
                    }
                }
            }
            store.close();
        }
        catch (Exception e) {
            Log.DEBUG_LOG(4, "Reading UserCareer from RS failed!");
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        if (!m_bReadyToSave) {
            return;
        }
        BGStore store = BGStore.openStoreToWrite("UserCareer");
        if (store == null) {
            return;
        }
        try {
            int i;
            DataOutputStream outputStream = store.getOutStream();
            for (i = 0; i < 45; ++i) {
                outputStream.writeInt(m_arrLevelBestScore[i]);
                outputStream.writeInt(m_arrLevelScore[i]);
            }
            outputStream.writeInt(m_nMoney);
            for (i = 0; i < 5; ++i) {
                outputStream.writeInt(m_arrSurvivalLevelAvailable[i]);
                outputStream.writeInt(m_arrBestSurvivalScore[i]);
            }
            for (i = 0; i < m_arrBoostAvailable.length; ++i) {
                outputStream.writeBoolean(m_arrBoostAvailable[i]);
            }
            outputStream.writeBoolean(isStoryTutorialOn);
            outputStream.writeBoolean(isSurvivalTutorialOn);
            outputStream.writeBoolean(isStoryPopupInfoOn);
            outputStream.writeBoolean(isSurviPopupInfoOn);
            outputStream.writeBoolean(isSequencePopupInfoOn);
            outputStream.writeBoolean(isStoryNormalMode_PopupInfoOn);
            outputStream.writeBoolean(isStoryTimeMode_PopupInfoOn);
            outputStream.writeBoolean(isStoryScoreMode_PopupInfoOn);
            outputStream.writeBoolean(isStoryBombMode_PopupInfoOn);
            outputStream.writeBoolean(isStoryBounceMode_PopupInfoOn);
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 6; ++j) {
                    outputStream.writeBoolean(m_arrItems_PopupInfoOn[i][j]);
                }
            }
            store.close();
        }
        catch (IOException ioe) {
            Log.DEBUG_LOG(4, "Serialization of UserCareer failed!");
            ioe.printStackTrace();
        }
    }

    public static void SetNick(String s) {
        m_szNick = s;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String s) {
        m_szDevicePlatform = s;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void UnlockAllLevels() {
        int i;
        for (i = 0; i < 45; ++i) {
            CGUserCareer.m_arrLevelScore[i] = 3;
        }
        for (i = 0; i < 5; ++i) {
            CGUserCareer.m_arrSurvivalLevelAvailable[i] = 1;
        }
    }

    public static void UnlockSurvivalLevel(int nLevel) {
        CGUserCareer.m_arrSurvivalLevelAvailable[nLevel] = 1;
    }

    public static boolean IsSurvivalLevelAvailable(int nLevel) {
        return m_arrSurvivalLevelAvailable[nLevel] > 0;
    }

    public static void UnlockAllBoosts() {
        for (int i = 0; i < m_arrBoostAvailable.length; ++i) {
            CGUserCareer.m_arrBoostAvailable[i] = true;
        }
    }

    static {
        m_szNick = new String("");
        m_nMoney = 0;
        m_bReadyToSave = false;
    }
}

