/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CrashAnimationObject;
import baltorogames.project_gameplay.ExplodeAnimationObject;
import baltorogames.project_gameplay.HitAnimationObject;
import baltorogames.project_gameplay.PowerupManager;
import baltorogames.project_gameplay.SelectBoostScreen;
import baltorogames.system.Platform;

public class BombObject {
    public static final float eWidth = 72.0f;
    public static final float eHeight = 72.0f;
    public static final int eState_Start = 0;
    public static final int eState_Jump = 1;
    public static final int eState_Over = 2;
    public int m_nStartTime;
    public int m_nDelayTime;
    public int m_nState;
    public float m_fPosX;
    public float m_fPosY;
    public float m_fLastPosY;
    public float m_fSpeedY;
    public float m_fSpeedX;
    protected CGTexture m_pPreTexture;
    protected CGTexture m_pTexture;
    protected float m_fCurrentG;
    CGDynamicObj m_pDynamic = null;

    public void Destroy() {
    }

    public void Create(int x, int nDelayTime) {
        this.m_fPosX = RandSync.nextInt(10) >= 5 ? (float)(480 - x) : (float)x;
        this.m_fPosY = -100.0f;
        this.m_fSpeedY = 30.0f;
        this.m_fSpeedX = 0.0f;
        this.m_nState = 0;
        this.m_nStartTime = 0;
        this.m_nDelayTime = nDelayTime;
        this.ConfigureType();
    }

    public void ConfigureType() {
        this.m_fCurrentG = 700.0f + (float)(RandSync.nextInt() % 100);
        this.m_pPreTexture = TextureManager.CreateTexture("/gameplay/bomb_indicator.png");
        this.m_pTexture = TextureManager.CreateTexture("/gameplay/bomb.png");
        this.m_pDynamic = CGDynamicObj.AddToCurrentDynamics("bomb.do", -1000.0f, -1000.0f, 0.0f);
    }

    protected void PlaySoundDropBomb() {
        CGSoundSystem.Play(11, false);
    }

    protected void PlaySound_HeadKick() {
        CGSoundSystem.Play(6, false);
    }

    public void Step(int nDeltaTimeInMs) {
        if (this.m_nState == 0) {
            this.m_nStartTime += nDeltaTimeInMs;
            if (this.m_nStartTime >= this.m_nDelayTime) {
                this.m_nState = 1;
                this.m_fPosY = -100.0f;
                this.PlaySoundDropBomb();
            }
        }
        if (this.m_nState == 1) {
            this.m_fLastPosY = this.m_fPosY;
            float t = (float)nDeltaTimeInMs / 1000.0f;
            this.m_fSpeedY += this.m_fCurrentG * t;
            this.m_fPosY += this.m_fSpeedY * t;
            this.m_fPosX += this.m_fSpeedX * t;
            if (this.m_fLastPosY + 36.0f < 630.0f && this.m_fPosY + 36.0f >= 630.0f) {
                if (CGEngine.GetTrampoline().IsGoodPlace(this.m_fPosX)) {
                    this.m_fPosY = 594.0f;
                    this.m_fSpeedY = Math.abs(this.m_fSpeedY);
                    this.m_fSpeedY = -(350.0f + (float)(RandSync.nextInt() % 350));
                    this.m_fSpeedX = -50.0f + (float)(RandSync.nextInt() % 100);
                    CGEngine.GetTrampoline().SetDeflection(12.0f);
                    this.PlaySound_HeadKick();
                    HitAnimationObject.NewItem(this.m_fPosX, this.m_fPosY, 1);
                }
            } else if (this.m_fLastPosY + 36.0f < 670.0f && this.m_fPosY + 36.0f >= 670.0f && CGEngine.GetTrampoline().IsVeryGoodPlace(this.m_fPosX)) {
                this.m_fPosY = 670.0f;
                this.m_nState = 2;
                if (this.m_pDynamic != null) {
                    this.m_pDynamic.Stop();
                    CGDynamicObj.RemoveFromCurrentDynamics(this.m_pDynamic, '\u0000');
                }
                if (!PowerupManager.IsPowerup_Shield()) {
                    ExplodeAnimationObject.NewItem(this.m_fPosX, this.m_fPosY - 36.0f, true, 0);
                    CrashAnimationObject.NewItem(this.m_fPosX, this.m_fPosY - 36.0f);
                    for (int i = 1; i <= 4; ++i) {
                        float fAddX = -40 + RandSync.nextInt() % 80;
                        float fAddY = -40 + RandSync.nextInt() % 80;
                        boolean bBig = true;
                        if (RandSync.nextInt() % 100 > 50) {
                            bBig = false;
                        }
                        ExplodeAnimationObject.NewItem(this.m_fPosX + fAddX, this.m_fPosY - 18.0f + fAddY, bBig, i * 300);
                    }
                    if (CGEngine.m_nCurrentGamingMode == 3) {
                        CGEngine.EventLostBombMode(true);
                    } else if (CGEngine.m_nCurrentGamingMode == 4) {
                        CGEngine.EventLostNormalMode(true);
                    } else if (CGEngine.m_nCurrentGamingMode == 1) {
                        CGEngine.EventLostMoney(true);
                    } else if (CGEngine.m_nCurrentGamingMode == 2) {
                        CGEngine.EventStreakModeLost(false);
                    } else {
                        CGEngine.EventLost(true);
                    }
                    CGEngine.GetTrampoline().m_bAfterBomb = true;
                    CGEngine.GetTrampoline().m_nCurrentFrame = 0;
                    CGEngine.GetTrampoline().m_nLastFrameTime = 0;
                } else {
                    ++PowerupManager.m_nShieldCounter;
                    if (SelectBoostScreen.isBoostTopShieldActivate()) {
                        if (PowerupManager.m_nShieldCounter >= 3) {
                            PowerupManager.DisactivatePowerup(0);
                        }
                    } else {
                        PowerupManager.DisactivatePowerup(0);
                    }
                }
            }
            if (this.m_fPosY >= 710.0f) {
                this.m_fPosY = 710.0f;
                this.m_nState = 2;
                if (this.m_pDynamic != null) {
                    this.m_pDynamic.Stop();
                    CGDynamicObj.RemoveFromCurrentDynamics(this.m_pDynamic, '\u0000');
                }
                if (Platform.isAndroid) {
                    CGDynamicObj.AddToCurrentDynamics("bomb_explode_ground.do", this.m_fPosX, this.m_fPosY, 0.0f);
                } else {
                    ExplodeAnimationObject.NewItem(this.m_fPosX, this.m_fPosY, false, 0);
                }
                CGSoundSystem.Play(10, false);
                if (CGEngine.m_nCurrentGamingMode == 3 && !CGEngine.m_bGameOver) {
                    ++CGLevelStats.m_nBombsAvoided;
                }
            }
            if (this.m_pDynamic != null) {
                this.m_pDynamic.SetPosition(this.m_fPosX, this.m_fPosY, 0.0f);
            }
        }
    }

    public void Render() {
        if (this.m_nState == 0) {
            int nT = this.m_nDelayTime - this.m_nStartTime;
            if (nT <= 1200 && nT % 300 < 150) {
                CGEngineRenderer.RenderBomb(this, this.m_pPreTexture, this.m_fPosX, 36.0f);
            }
        } else if (this.m_pDynamic == null) {
            CGEngineRenderer.RenderBomb(this, this.m_pTexture, this.m_fPosX, this.m_fPosY);
        }
    }
}

