/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.core.Log;
import baltorogames.graphic2d.CGTexture;
import java.io.InputStream;
import java.util.Vector;

public class TextureManager {
    private static Vector m_arrTextures = new Vector(3, 2);

    public static CGTexture AddTexture(String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        int nRes = 0;
        try {
            nRes = t.Create(szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Load texture error!!!");
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        Log.DEBUG_LOG(16, "TextureManager Add: " + szName);
        return t;
    }

    public static CGTexture AddTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture CreateTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture CreateFilteredTexture(String str) {
        return TextureManager.AddTexture(str, 0, 0, null, null);
    }

    public static CGTexture AddTexture(String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight, boolean bNotDelete) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        int nRes = 0;
        try {
            nRes = t.Create(szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Load texture error!!!");
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        Log.DEBUG_LOG(16, "TextureManager Add: " + szName);
        return t;
    }

    public static CGTexture AddTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture CreateTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture CreateFilteredTexture(String str, boolean bNotDelete) {
        return TextureManager.AddTexture(str, 0, 0, null, null, bNotDelete);
    }

    public static CGTexture AddTexture(InputStream is, String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight) {
        CGTexture t = TextureManager.GetTexture(szName);
        if (t != null) {
            return t;
        }
        t = new CGTexture();
        t.m_szName = szName;
        int nRes = 0;
        try {
            nRes = t.Create(is, szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Load texture error!!!");
        }
        if (nRes == 0) {
            return null;
        }
        m_arrTextures.addElement(t);
        Log.DEBUG_LOG(16, "TextureManager Add: " + szName);
        return t;
    }

    public static void AddTexture(CGTexture t) {
        m_arrTextures.addElement(t);
    }

    public static void AddTexture(CGTexture t, boolean bNotDelete) {
        m_arrTextures.addElement(t);
    }

    public static CGTexture GetTexture(String szName) {
        int nSize = m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if (!((CGTexture)TextureManager.m_arrTextures.elementAt((int)i)).m_szName.equals(szName)) continue;
            return (CGTexture)m_arrTextures.elementAt(i);
        }
        return null;
    }

    public static void DeleteTexture(CGTexture t) {
        int nSize = m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if ((CGTexture)m_arrTextures.elementAt(i) != t) continue;
            m_arrTextures.removeElementAt(i);
            return;
        }
    }

    public static void ClearTextures() {
        m_arrTextures.removeAllElements();
    }

    public static void Destroy() {
        m_arrTextures.removeAllElements();
    }
}

