/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class TrailObject {
    public static final float eWidth = 64.0f;
    public static final float eHeight = 64.0f;
    public static final int eLifeTime1 = 300;
    public static final int eLifeTime2 = 500;
    public float m_fPosX;
    public float m_fPosY;
    public float m_fAlpha;
    public int m_nTime;
    public int m_nLifeTime;
    public int m_nType;
    protected static Vector m_List = null;
    protected static Vector m_TmpList = null;
    protected static CGTexture[] m_pTexture;

    public void Destroy() {
    }

    public static void Reset() {
        int nS = m_List.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpList.addElement(m_List.elementAt(i));
            }
            m_List.removeAllElements();
        }
    }

    public void Step(int nDeltaTimeinMs) {
        this.m_nTime -= nDeltaTimeinMs;
        if (this.m_nTime < 0) {
            this.m_fAlpha = 0.0f;
        } else {
            this.m_fAlpha = (float)this.m_nTime / (float)this.m_nLifeTime;
            if (this.m_nType == 0) {
                this.m_fAlpha *= 0.25f;
            }
        }
    }

    public void Render() {
        CGEngineRenderer.RenderTrail(m_pTexture[this.m_nType], this.m_fPosX, this.m_fPosY, this.m_fAlpha);
    }

    public static void Init() {
        m_pTexture = new CGTexture[2];
        TrailObject.m_pTexture[0] = TextureManager.CreateTexture("/gameplay/trail.png");
        TrailObject.m_pTexture[1] = TextureManager.CreateTexture("/gameplay/trail2.png");
        m_List = new Vector();
        m_TmpList = new Vector();
        for (int i = 0; i < 200; ++i) {
            m_TmpList.addElement(new TrailObject());
        }
    }

    public static void NewTrail(float x, float y, int nType) {
        TrailObject to = null;
        if (m_TmpList.size() > 0) {
            to = (TrailObject)m_TmpList.elementAt(0);
            m_TmpList.removeElementAt(0);
        } else {
            to = new TrailObject();
        }
        to.m_nType = nType;
        to.m_fPosX = x;
        to.m_fPosY = y;
        to.m_fAlpha = 1.0f;
        to.m_nLifeTime = to.m_nType == 0 ? 300 : 500;
        to.m_nTime = to.m_nLifeTime;
        m_List.addElement(to);
    }

    public static void StepAll(int nDeltaTimeinMs) {
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            TrailObject to = (TrailObject)m_List.elementAt(i);
            to.Step(nDeltaTimeinMs);
            if (to.m_nTime >= 0) continue;
            m_TmpList.addElement(to);
            m_List.removeElementAt(i);
        }
    }

    public static void RenderAllType1() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            TrailObject t = (TrailObject)m_List.elementAt(i);
            if (t.m_nType != 0) continue;
            t.Render();
        }
    }

    public static void RenderAllType2() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            TrailObject t = (TrailObject)m_List.elementAt(i);
            if (t.m_nType <= 0) continue;
            t.Render();
        }
    }
}

