/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.BombManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.CrashAnimationObject;
import baltorogames.project_gameplay.ExplodeAnimationObject;
import baltorogames.project_gameplay.FlyingScoreObject;
import baltorogames.project_gameplay.GetPowerupAnimationObject;
import baltorogames.project_gameplay.HitAnimationObject;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gameplay.PowerupManager;
import baltorogames.project_gameplay.SelectBoostScreen;
import baltorogames.project_gameplay.ThingObject;
import baltorogames.project_gameplay.TrailObject;
import baltorogames.project_gameplay.TrampolineObject;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.NewItemInfoScreen;
import baltorogames.project_gui.StoryScoreScreen;
import baltorogames.project_gui.SurvivalScoreScreen;
import java.io.DataInputStream;
import java.util.Vector;

public class CGEngine {
    public static final int eGameMode_Timed = 0;
    public static final int eGameMode_Score = 1;
    public static final int eGameMode_Streak = 2;
    public static final int eGameMode_Bomb = 3;
    public static final int eGameMode_Normal = 4;
    public static final int eGameMode_Surv = 5;
    public static final int MAX_THING_TYPES = 6;
    public static final int eLevelGroundOffset = 40;
    public static final int eHumanHeadAltitude = 630;
    public static final int eTrampolineAltitude = 670;
    public static final int eGroundAltitude = 710;
    public static int m_nCurrentGamingMode = 0;
    public static final String[] m_arrLevelGoalDescriptions = new String[]{"TID_GOAL_TIMED", "TID_GOAL_SCORE", "TID_GOAL_STREAK", "TID_GOAL_BOMB", "TID_GOAL_NORMAL"};
    public static final String[] m_arrLevelGoalDescriptionsPostfixes = new String[]{"TID_GOAL_TIMED_POSTFIX", "TID_GOAL_SCORE_POSTFIX", "TID_GOAL_STREAK_POSTFIX", "TID_GOAL_BOMB_POSTFIX", "TID_GOAL_NORMAL_POSTFIX"};
    public static final int[] m_arrGameModes = new int[]{4, 1, 0, 3, 2, 4, 3, 2, 0, 4, 1, 0, 3, 2, 4, 3, 2, 0, 4, 1, 0, 3, 2, 4, 3, 2, 0, 4, 1, 0, 3, 2, 4, 3, 2, 0, 4, 1, 0, 3, 2, 4, 3, 2, 0};
    public static final int[] m_arrStoryLevelScoreNeededStar3 = new int[]{1500, 6, 1100, 30, 25, 2500, 40, 35, 2200, 3500, 10, 3300, 50, 45, 4500, 60, 55, 4500, 5500, 15, 6000, 70, 65, 6500, 80, 75, 7000, 7500, 20, 8000, 90, 85, 8500, 100, 95, 9200, 9500, 25, 10500, 110, 105, 10500, 120, 115, 12000};
    public static final int[] m_arrStoryLevelScoreNeededStar2 = new int[]{1000, 4, 700, 20, 16, 1700, 30, 22, 1400, 2300, 6, 2200, 35, 30, 3000, 40, 36, 3000, 3600, 10, 4000, 46, 42, 4300, 53, 50, 4600, 5000, 12, 5300, 60, 55, 5500, 66, 62, 6100, 6300, 16, 7000, 73, 70, 7000, 80, 75, 8000};
    public static final int[] m_arrStoryLevelScoreNeededStar1 = new int[]{500, 2, 350, 10, 8, 800, 20, 11, 700, 1150, 3, 1100, 17, 15, 1500, 20, 18, 1500, 1800, 5, 2000, 23, 21, 2100, 26, 25, 2300, 2500, 6, 2600, 30, 28, 2800, 33, 31, 3000, 3100, 8, 3500, 36, 35, 3500, 40, 38, 4000};
    public static final int[] m_arrStoryLevelTimeLimit = new int[]{25, 30, 30, 40, 45, 50, 55, 65, 45, 40, 40, 60, 40, 40, 40, 40, 40, 75, 40, 40, 90, 40, 40, 40, 40, 40, 105, 40, 40, 120, 40, 40, 40, 40, 40, 135, 40, 40, 150, 40, 40, 40, 40, 40, 165};
    public static int[][] m_arrThingLevelProbabilities = new int[][]{{0, 0, 50, 0, 0, 100}, {0, 0, 50, 0, 0, 100}, {0, 0, 33, 66, 0, 100}, {0, 0, 33, 66, 0, 100}, {0, 0, 25, 50, 75, 100}, {20, 0, 40, 66, 80, 100}, {20, 0, 40, 66, 80, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {0, 0, 50, 0, 0, 100}, {0, 0, 25, 50, 75, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {0, 0, 50, 0, 0, 100}, {0, 0, 25, 50, 75, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {0, 0, 50, 0, 0, 100}, {0, 0, 25, 50, 75, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {0, 0, 50, 0, 0, 100}, {0, 0, 25, 50, 75, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}, {17, 34, 51, 68, 85, 100}};
    public static int[][] m_arrThingLevelIDs = new int[][]{{5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}, {5, 6, 1, 2, 3, 4}};
    public static int GAME_OVER_DELAY = 2000;
    public static final int eGameMode_Story = 1;
    public static final int eGameMode_Survival = 2;
    public static final int eGameWorld_1 = 0;
    public static final int eGameWorld_2 = 1;
    public static final int eGameWorld_3 = 2;
    public static final int eGameWorld_4 = 3;
    public static final int eGameWorld_5 = 4;
    public static final int eLevelsPerWorld = 9;
    public static int m_nCurrentWorld = 0;
    public static int m_nSurvivalLevel = -1;
    public static int m_nGameMode = 1;
    public static int m_nViewMode = 0;
    public static int m_nGameTick = 0;
    public static int m_nCurrentStoryLevel = 0;
    public static int m_nSpawnCounter = 0;
    public static TrampolineObject m_TrampolineObject;
    public static Vector m_ThingsVector;
    public static int m_nLastThingTimer;
    public static int m_nCurrentLevelScoreNeeded;
    public static int m_nCurrentLevelTimeLimit;
    public static int m_nCurrentLevelTime;
    public static boolean m_bGameActive;
    public static float m_fCameraPosX;
    public static float m_fCameraPosY;
    public static boolean m_nTouchActive;
    public static float m_fTouchX;
    public static float m_fTouchY;
    private static int testTime;
    public static float m_fEngineScale;
    public static boolean m_bPause;
    public static boolean m_bGameOver;
    public static int m_nGameOverDelay;
    public static int m_nGameResult;
    protected static int m_nUpdateDeltaTime;
    public static int m_nEngineTime;
    public static int m_nDisplayComboTime;

    public static TrampolineObject GetTrampoline() {
        return m_TrampolineObject;
    }

    public static void Load1(DataInputStream dis) {
        CGEngine.Destroy();
        int nScreenX = 480;
        int nScreenY = 800;
        float fScaleX = (float)ApplicationData.screenWidth / (float)nScreenX;
        float fScaleY = (float)ApplicationData.screenHeight / (float)nScreenY;
        m_fEngineScale = fScaleX < fScaleY ? fScaleX : fScaleY;
        CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenX) / 2.0f;
        CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight - m_fEngineScale * (float)nScreenY) / 2.0f;
    }

    public static void Load2(DataInputStream dis) {
        CGLevelStats.Reset();
        m_bPause = false;
        m_nEngineTime = 0;
        m_bGameOver = false;
        m_nGameOverDelay = 0;
        m_nGameResult = 0;
        m_nUpdateDeltaTime = 0;
        m_bGameActive = true;
        m_nCurrentLevelTime = m_arrStoryLevelTimeLimit[m_nCurrentStoryLevel] * 1000;
        if (SelectBoostScreen.isBoostExtraTimeActivate()) {
            m_nCurrentLevelTime += m_nCurrentLevelTime / 5;
        }
        m_nCurrentLevelScoreNeeded = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
        m_nCurrentGamingMode = m_nGameMode == 1 ? m_arrGameModes[m_nCurrentStoryLevel] : 5;
        BombManager.Reset();
        CGEngine.InitGamingModeData();
        m_nLastThingTimer = 5000;
        WorldMap wm = ((MyGame)ApplicationData.game).m_WorldMap;
        m_bGameActive = true;
        m_nTouchActive = false;
        m_fTouchX = -1000000.0f;
        m_fTouchY = -1000000.0f;
        m_nViewMode = 0;
        CGEngineRenderer.m_nComboTime = -1;
        m_nGameTick = 0;
        m_TrampolineObject = new TrampolineObject();
        m_TrampolineObject.Create();
        m_TrampolineObject.Reset();
        m_nSpawnCounter = 0;
        m_ThingsVector = new Vector();
        PowerupManager.Reset();
        TrailObject.Reset();
        HitAnimationObject.Reset();
        CrashAnimationObject.Reset();
        GetPowerupAnimationObject.Reset();
        ExplodeAnimationObject.Reset();
        FlyingScoreObject.Reset();
        CGDynamicObj.ClearCurrentDynamics();
    }

    private static void InitGamingModeData() {
        if (m_nGameMode == 1) {
            if (m_nCurrentGamingMode == 3) {
                BombManager.SetDefaultRespawnTime(1000);
                BombManager.SetInitCounter(25);
                BombManager.SetNextRespawnTime(3000);
            } else {
                BombManager.SetDefaultRespawnTime(10000);
                BombManager.SetNextRespawnTime(10000);
                BombManager.SetInitCounter(0);
                BombManager.SetInitCounter(18);
            }
        } else {
            BombManager.SetDefaultRespawnTime(10000);
            BombManager.SetInitCounter(0);
        }
    }

    public static int Init() {
        return 1;
    }

    public static void Destroy() {
    }

    public static void Update(int nDeltaTimeInMs) {
        if (m_bPause || !m_bGameActive) {
            return;
        }
        if (m_nGameMode == 1 && m_bGameActive) {
            int nItemType = -1;
            int nWorldNr = m_nCurrentStoryLevel / 9;
            int nLevelNr = m_nCurrentStoryLevel % 9;
            if (nWorldNr == 0) {
                if (nLevelNr == 0) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[0][0]) {
                        nItemType = 1;
                        CGUserCareer.m_arrItems_PopupInfoOn[0][0] = true;
                    } else if (!CGUserCareer.m_arrItems_PopupInfoOn[0][3]) {
                        nItemType = 4;
                        CGUserCareer.m_arrItems_PopupInfoOn[0][3] = true;
                    }
                } else if (nLevelNr == 2) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[0][1]) {
                        nItemType = 2;
                        CGUserCareer.m_arrItems_PopupInfoOn[0][1] = true;
                    }
                } else if (nLevelNr == 4) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[0][2]) {
                        nItemType = 3;
                        CGUserCareer.m_arrItems_PopupInfoOn[0][2] = true;
                    }
                } else if (nLevelNr == 5) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[0][4]) {
                        nItemType = 5;
                        CGUserCareer.m_arrItems_PopupInfoOn[0][4] = true;
                    }
                } else if (nLevelNr == 7 && !CGUserCareer.m_arrItems_PopupInfoOn[0][5]) {
                    nItemType = 6;
                    CGUserCareer.m_arrItems_PopupInfoOn[0][5] = true;
                }
            } else {
                if (nLevelNr == 0) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][0]) {
                        nItemType = 1;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][0] = true;
                    } else if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][3]) {
                        nItemType = 4;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][3] = true;
                    }
                }
                if (nLevelNr == 1) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][1]) {
                        nItemType = 2;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][1] = true;
                    } else if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][2]) {
                        nItemType = 3;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][2] = true;
                    }
                }
                if (nLevelNr == 2) {
                    if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][4]) {
                        nItemType = 5;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][4] = true;
                    } else if (!CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][5]) {
                        nItemType = 6;
                        CGUserCareer.m_arrItems_PopupInfoOn[nWorldNr][5] = true;
                    }
                }
            }
            if (nItemType > 0) {
                NewItemInfoScreen tis = new NewItemInfoScreen(nWorldNr + 1, nItemType);
                UIScreen.SetNextScreen(tis);
                UIScreen.GetNextScreen().setParent(UIScreen.GetCurrentScreen());
                UIScreen.GetCurrentScreen().readyForClose = true;
            }
        }
        if (nDeltaTimeInMs <= 30) {
            CGEngine.UpdateInternal(nDeltaTimeInMs);
        } else {
            int nT = 0;
            for (nT = 30; nT < nDeltaTimeInMs; nT += 30) {
                CGEngine.UpdateInternal(30);
            }
            nT = nDeltaTimeInMs % 30;
            if (nT > 0) {
                CGEngine.UpdateInternal(nT);
            }
        }
    }

    public static void UpdateInternal(int nDeltaTimeInMs) {
        m_nUpdateDeltaTime = nDeltaTimeInMs;
        m_nEngineTime += m_nUpdateDeltaTime;
        CGLevelStats.m_nTimeStatsInMs += nDeltaTimeInMs;
        m_nViewMode = 0;
        ++m_nGameTick;
        if (m_bGameActive) {
            int nSize = m_ThingsVector.size();
            for (int i = nSize - 1; i >= 0; --i) {
                ThingObject o = (ThingObject)m_ThingsVector.elementAt(i);
                o.Step(nDeltaTimeInMs);
                if (!o.IsToDestroy()) continue;
                m_ThingsVector.removeElementAt(i);
            }
            if (!CGEngine.m_TrampolineObject.m_bAfterBomb && !m_bPause) {
                if (ApplicationData.isLeftPressed2() || Game.leftTouchKeyPressed) {
                    float fAdd = 500.0f * (float)nDeltaTimeInMs / 1000.0f;
                    m_TrampolineObject.SetPos(m_TrampolineObject.GetPos() - fAdd);
                } else if (ApplicationData.isRightPressed2() || Game.rightTouchKeyPressed) {
                    float fAdd = 500.0f * (float)nDeltaTimeInMs / 1000.0f;
                    m_TrampolineObject.SetPos(m_TrampolineObject.GetPos() + fAdd);
                }
            }
            m_TrampolineObject.Step(nDeltaTimeInMs);
            CGEngine.CheckSuccessLosConditions(nDeltaTimeInMs);
            if (!m_bGameOver && m_nCurrentGamingMode != 3) {
                CGEngine.GenerateNewThing(nDeltaTimeInMs);
            }
            if (m_nCurrentGamingMode == 3) {
                TrailObject.StepAll(nDeltaTimeInMs);
                HitAnimationObject.StepAll(nDeltaTimeInMs);
                CrashAnimationObject.StepAll(nDeltaTimeInMs);
                BombManager.Step(nDeltaTimeInMs);
                ExplodeAnimationObject.StepAll(nDeltaTimeInMs);
                FlyingScoreObject.StepAll(nDeltaTimeInMs);
            } else {
                PowerupManager.Step(nDeltaTimeInMs);
                TrailObject.StepAll(nDeltaTimeInMs);
                HitAnimationObject.StepAll(nDeltaTimeInMs);
                CrashAnimationObject.StepAll(nDeltaTimeInMs);
                GetPowerupAnimationObject.StepAll(nDeltaTimeInMs);
                BombManager.Step(nDeltaTimeInMs);
                ExplodeAnimationObject.StepAll(nDeltaTimeInMs);
                FlyingScoreObject.StepAll(nDeltaTimeInMs);
            }
        }
        if (CGEngine.CheckIsLevelComplete()) {
            CGEngine.EventWin();
        }
        if (m_bGameActive && m_bGameOver) {
            CGEngine.HandleGameOver(nDeltaTimeInMs);
        }
    }

    private static void CheckSuccessLosConditions(int nDeltaTimeInMs) {
        if (m_nGameMode == 1 && UIScreen.GetCurrentScreen().GetModalScreen() < 1 && m_nCurrentGamingMode == 0) {
            if (m_nCurrentLevelTime <= 0) {
                int nMinimumScore = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
                float fScale = 1.0f;
                if (SelectBoostScreen.isBoostExtraScoreActivate()) {
                    fScale = 1.2f;
                }
                int nScore = (int)(fScale * (float)CGLevelStats.m_nScore);
                if (nMinimumScore > 0 && nMinimumScore > nScore) {
                    CGEngine.EventLost(false);
                } else {
                    CGEngine.EventWin();
                }
            } else if ((m_nCurrentLevelTime -= nDeltaTimeInMs) < 0) {
                m_nCurrentLevelTime = 0;
            }
        }
    }

    private static void HandleGameOver(int nDeltaTimeInMs) {
        if ((m_nGameOverDelay -= nDeltaTimeInMs) <= 0 && m_ThingsVector.size() == 0 && PowerupManager.GetCurrentSize() == 0 && CrashAnimationObject.GetCurrentSize() == 0 && GetPowerupAnimationObject.GetCurrentSize() == 0 && BombManager.GetCurrentSize() == 0 && ExplodeAnimationObject.GetCurrentSize() == 0) {
            m_bGameActive = false;
            if (m_nGameResult < 0) {
                if (m_nGameMode == 1) {
                    UIScreen.SetCurrentScreen(new StoryScoreScreen(-1));
                } else if (m_nGameMode == 2) {
                    UIScreen.SetCurrentScreen(new SurvivalScoreScreen(999));
                }
            } else {
                float fScale = 1.0f;
                if (SelectBoostScreen.isBoostExtraScoreActivate()) {
                    fScale = 1.2f;
                }
                if (m_nCurrentGamingMode == 0 || m_nCurrentGamingMode == 4) {
                    CGLevelStats.m_nScore = (int)(fScale * (float)CGLevelStats.m_nScore);
                } else if (m_nCurrentGamingMode == 2) {
                    CGLevelStats.m_nMaxStreak = (int)(fScale * (float)CGLevelStats.m_nMaxStreak);
                } else if (m_nCurrentGamingMode == 3) {
                    CGLevelStats.m_nBombsAvoided = (int)(fScale * (float)CGLevelStats.m_nBombsAvoided);
                } else if (m_nCurrentGamingMode == 1) {
                    CGLevelStats.m_nCoinsGathered = (int)(fScale * (float)CGLevelStats.m_nCoinsGathered);
                }
                UIScreen.SetCurrentScreen(new StoryScoreScreen(999));
            }
        }
    }

    private static boolean CheckIsLevelComplete() {
        float fScale = 1.0f;
        if (SelectBoostScreen.isBoostExtraScoreActivate()) {
            fScale = 1.2f;
        }
        return m_nCurrentGamingMode == 4 ? (int)(fScale * (float)CGLevelStats.m_nScore) > m_arrStoryLevelScoreNeededStar3[m_nCurrentStoryLevel] : (m_nCurrentGamingMode == 2 ? (int)(fScale * (float)CGLevelStats.m_nMaxStreak) > m_arrStoryLevelScoreNeededStar3[m_nCurrentStoryLevel] : (m_nCurrentGamingMode == 3 ? (int)(fScale * (float)CGLevelStats.m_nBombsAvoided) > m_arrStoryLevelScoreNeededStar3[m_nCurrentStoryLevel] : m_nCurrentGamingMode == 1 && (int)(fScale * (float)CGLevelStats.m_nCoinsGathered) > m_arrStoryLevelScoreNeededStar3[m_nCurrentStoryLevel]));
    }

    private static void GenerateNewThing(int nDeltaTimeInMs) {
        if ((m_nLastThingTimer -= nDeltaTimeInMs) < 0) {
            int i;
            int nPosType = RandSync.nextInt(3);
            int nR = RandSync.nextInt(100);
            int nType = 1;
            if (m_nGameMode == 1) {
                for (i = 0; i < 6; ++i) {
                    if (nR >= m_arrThingLevelProbabilities[m_nCurrentStoryLevel][i]) continue;
                    nType = m_arrThingLevelIDs[m_nCurrentStoryLevel][i];
                    break;
                }
            } else {
                for (i = 0; i < 6; ++i) {
                    if (nR >= m_arrThingLevelProbabilities[44][i]) continue;
                    nType = m_arrThingLevelIDs[44][i];
                    break;
                }
            }
            ThingObject pObject = new ThingObject();
            pObject.Create(nType, nPosType);
            m_ThingsVector.addElement(pObject);
            m_nLastThingTimer = 2200 - ++m_nSpawnCounter * 15;
            if (m_nLastThingTimer < 750) {
                m_nLastThingTimer = 750;
            }
        }
    }

    public static void EventWin() {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            m_nGameResult = 1;
            CGSoundSystem.Play(1, false);
        }
    }

    public static void EventLostMoney(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            int coinsNeeded = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
            m_nGameResult = CGLevelStats.m_nCoinsGathered > coinsNeeded ? 1 : -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void EventLostNormalMode(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            int scoreNeeded = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
            m_nGameResult = CGLevelStats.m_nScore > scoreNeeded ? 1 : -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void EventLostBombMode(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            int bombsAvoidedNeeded = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
            m_nGameResult = CGLevelStats.m_nBombsAvoided > bombsAvoidedNeeded ? 1 : -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void EventStreakModeLost(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            int bouncesNeeded = m_arrStoryLevelScoreNeededStar1[m_nCurrentStoryLevel];
            m_nGameResult = CGLevelStats.m_nMaxStreak > bouncesNeeded ? 1 : -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void EventLost(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            m_nGameResult = -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void RenderThings() {
        if (m_bGameActive && UIScreen.GetCurrentScreen().GetModalScreen() < 1) {
            int nSize = m_ThingsVector.size();
            for (int i = nSize - 1; i >= 0; --i) {
                ThingObject o = (ThingObject)m_ThingsVector.elementAt(i);
                o.Render();
            }
        }
    }

    public static void Render() {
        if (m_bGameActive && UIScreen.GetCurrentScreen().GetModalScreen() < 1) {
            TrailObject.RenderAllType2();
            PowerupManager.Render();
            m_TrampolineObject.Render();
            BombManager.Render();
            HitAnimationObject.RenderAll();
            CrashAnimationObject.RenderAll();
            GetPowerupAnimationObject.RenderAll();
            ExplodeAnimationObject.RenderAll();
            FlyingScoreObject.RenderAll();
            CGDynamicObj.StepCurrentDynamics(m_nUpdateDeltaTime);
            AchievementPopup.Step();
        }
    }

    static {
        m_nCurrentLevelScoreNeeded = 60;
        m_nCurrentLevelTimeLimit = 60;
        m_nCurrentLevelTime = 60000;
        m_bGameActive = false;
        m_fCameraPosX = 0.0f;
        m_fCameraPosY = 0.0f;
        m_nTouchActive = false;
        m_fTouchX = -1000000.0f;
        m_fTouchY = -1000000.0f;
        testTime = 0;
        m_fEngineScale = 1.0f;
        m_bPause = false;
        m_bGameOver = false;
        m_nGameOverDelay = 0;
        m_nGameResult = 0;
        m_nUpdateDeltaTime = 0;
        m_nEngineTime = 0;
    }
}

