/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.project_gameplay.BombObject;
import baltorogames.project_gameplay.CGEngine;
import java.util.Vector;

public class BombManager {
    public static final int DEFAULT_RESPAWN_TIME = 15000;
    public static final int DEFAULT_RESPAWN_TIMESPREAD = 5000;
    protected static Vector m_List = null;
    protected static int m_nNextSpawnTime;
    protected static int m_nTime;
    protected static int m_nCounter;
    private static int m_nDefaultRespawnTime;

    public static void SetDefaultRespawnTime(int timeMs) {
        m_nDefaultRespawnTime = timeMs;
    }

    public static void Init() {
        m_List = new Vector();
        m_nTime = 0;
        m_nNextSpawnTime = m_nDefaultRespawnTime;
        m_nCounter = 0;
    }

    public static void SetNextRespawnTime(int nTime) {
        m_nNextSpawnTime = nTime;
    }

    public static void Reset() {
        m_List.removeAllElements();
        m_nCounter = 0;
        m_nNextSpawnTime = m_nDefaultRespawnTime;
    }

    public static void SetInitCounter(int i) {
        m_nCounter = i;
    }

    public static int GetCurrentSize() {
        return m_List.size();
    }

    public static void Respown1() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
    }

    public static void Respown2() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int s2 = 1 + RandSync.nextInt() % 9;
        if (s2 == s1 && ++s2 > 9) {
            s2 = 1;
        }
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
        BombManager.NewBomb(s2 * nD, 2000);
    }

    public static void Respown3() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int s2 = 1 + (s1 + 2) % 9;
        int s3 = 1 + (s1 + 6) % 9;
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
        BombManager.NewBomb(s2 * nD, 2000);
        BombManager.NewBomb(s3 * nD, 2500);
    }

    public static void Respown4() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int s2 = 1 + (s1 + 2) % 9;
        int s3 = 1 + (s1 + 6) % 9;
        int s4 = 1 + RandSync.nextInt() % 9;
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
        BombManager.NewBomb(s2 * nD, 1900);
        BombManager.NewBomb(s3 * nD, 2300);
        BombManager.NewBomb(s4 * nD, 2700);
    }

    public static void Respown5() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int s2 = 1 + (s1 + 2) % 9;
        int s3 = 1 + (s1 + 6) % 9;
        int s4 = 1 + RandSync.nextInt() % 9;
        int s5 = 1 + RandSync.nextInt() % 9;
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
        BombManager.NewBomb(s2 * nD, 1900);
        BombManager.NewBomb(s3 * nD, 2300);
        BombManager.NewBomb(s4 * nD, 2700);
        BombManager.NewBomb(s5 * nD, 3100);
    }

    public static void Respown6() {
        int s1 = 1 + RandSync.nextInt() % 9;
        int s2 = 1 + RandSync.nextInt() % 9;
        int s3 = 1 + RandSync.nextInt() % 9;
        int s4 = 1 + RandSync.nextInt() % 9;
        int s5 = 1 + RandSync.nextInt() % 9;
        int s6 = 1 + RandSync.nextInt() % 9;
        int nD = 48;
        BombManager.PlaySoundBombSignal();
        BombManager.NewBomb(s1 * nD, 1500);
        BombManager.NewBomb(s2 * nD, 1900);
        BombManager.NewBomb(s3 * nD, 2300);
        BombManager.NewBomb(s4 * nD, 2700);
        BombManager.NewBomb(s5 * nD, 3100);
        BombManager.NewBomb(s6 * nD, 3400);
    }

    protected static void PlaySoundBombSignal() {
    }

    public static void Step(int nDeltaTimeInMs) {
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            BombObject po = (BombObject)m_List.elementAt(i);
            po.Step(nDeltaTimeInMs);
            if (po.m_nState != 2) continue;
            m_List.removeElementAt(i);
        }
        if (CGEngine.m_bGameOver) {
            return;
        }
        if ((m_nTime += nDeltaTimeInMs) >= m_nNextSpawnTime) {
            if (m_nCounter < 5) {
                BombManager.Respown1();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            } else if (m_nCounter < 12) {
                BombManager.Respown2();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            } else if (m_nCounter < 20) {
                BombManager.Respown3();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            } else if (m_nCounter < 30) {
                BombManager.Respown4();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            } else if (m_nCounter < 40) {
                BombManager.Respown5();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            } else {
                BombManager.Respown6();
                m_nNextSpawnTime = m_nDefaultRespawnTime + RandSync.nextInt() % 5000;
                ++m_nCounter;
            }
            m_nTime = 0;
        }
    }

    public static void Render() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            ((BombObject)m_List.elementAt(i)).Render();
        }
    }

    protected static void NewBomb(int x, int nDelayTime) {
        BombObject po = new BombObject();
        po.Create(x, nDelayTime);
        m_List.addElement(po);
    }

    static {
        m_nDefaultRespawnTime = 15000;
    }
}

