/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.CustomFont;
import baltorogames.core.KeyCommand;
import baltorogames.core.LanguagePack;
import baltorogames.core.Log;
import baltorogames.core.MsgManager;
import baltorogames.core.TouchCommand;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gui.DebugConsole;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.project_gui.LoadingScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MasterSoundSwitch;
import baltorogames.project_gui.SelectDefaultLanguage;
import baltorogames.system.Application;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import baltorogames.system.SoundEngine;
import java.util.Random;
import java.util.Vector;

public class ApplicationData {
    public static final int GAME_MODE_MAIN_MENU = 3;
    public static final int GAME_MODE_IN_GAME = 4;
    public static String m_szGlobalText = new String();
    public static int screenWidth;
    public static int screenHeight;
    public static boolean isTouchScreen;
    public static CustomFont defaultFont;
    public static CustomFont smallRedFont;
    public static CustomFont smallGreyFont;
    public static CustomFont digitsFont;
    public static LanguagePack lp;
    public static SoundEngine soundEngine;
    public static boolean Enable_Multilang;
    public static int SoftButton1_Code;
    public static int SoftButton2_Code;
    public static boolean m_bAppBlocked;
    public static long m_nAppBlockedStartTime;
    public static boolean upSellEnabled;
    public static String upSellURL;
    public static boolean demoEnabled;
    public static boolean demoExpired;
    public static boolean demoTimeLimited;
    public static boolean demoLevelLimited;
    public static String demoURL;
    public static int demoTimeLeft;
    public static int demoLevelsLeft;
    private static int NUM_LOADING_HINTS;
    public static boolean needDefaultlanguage;
    public static boolean gameIsContinued;
    private static boolean firstTimeInit;
    public static boolean incomingCall;
    public static Random rnd;
    public static int currentLoadingHint;
    public static boolean modeFirstFrame;
    public static boolean gameRunning;
    public static Game game;
    private static long previousTime;
    public static int stepDeltaTime;
    private static long timeAccumulator;
    public static final long STAMP_SIZE_MILLI = 150L;
    public static boolean freezeNetworkGame;
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    public static int generalGameMode;
    public static long m_nStats_PrevTime;
    public static int m_nStats_CurrFrame;
    public static int m_nStats_FPS;
    public static long m_deltaTime;
    private static Vector landscapeLinedText;

    public static long getAppTime() {
        return System.currentTimeMillis();
    }

    public static void setGameMode() {
        generalGameMode = 4;
    }

    public static void setMainMenuMode() {
        generalGameMode = 3;
    }

    public static boolean isInGameMode() {
        return generalGameMode == 4;
    }

    public static boolean isMainMenuMode() {
        return generalGameMode == 3;
    }

    public static CustomFont getFontByID(int id) {
        switch (id) {
            case 0: {
                return defaultFont;
            }
            case 1: {
                return smallRedFont;
            }
            case 2: {
                return smallGreyFont;
            }
        }
        return null;
    }

    public static Game getGame() {
        return game;
    }

    public static boolean isInGame() {
        return gameRunning;
    }

    public static boolean checkIsLandscape() {
        int nV1 = -80;
        int nV2 = screenWidth - screenHeight;
        return nV1 * nV2 < 0;
    }

    public static void askAbortToMainMenu() {
        UIScreen currentScreen = null;
        InGameMainMenu newScreen = new InGameMainMenu();
        newScreen.setParent(currentScreen);
        UIScreen.SetCurrentScreen(newScreen);
    }

    public static void goToMainMenu() {
        Log.DEBUG_LOG(2, "Application.goToMainMenu");
        generalGameMode = 3;
        UIScreen.SetCurrentScreen(new MainMenu());
    }

    public static void askForDefaultLanguage() {
        UIScreen.SetCurrentScreen(new SelectDefaultLanguage());
    }

    public static void askForSoundMasterSwitch() {
        Log.DEBUG_LOG(16, "Application.askForSoundMasterSwitch");
        MasterSoundSwitch mss = new MasterSoundSwitch(lp.getTranslatedString(Options.languageID, "GAME_TITLE"), lp.getTranslatedString(Options.languageID, "TID_ENABLE_SOUND"), Platform.BACKGROUND_COLOR, "/sndTube", 1, 100L);
        UIScreen.SetCurrentScreen(mss);
    }

    public static void showLoadingSplash() {
        UIScreen.SetCurrentScreen(new LoadingScreen());
    }

    public static void StartTimer() {
        previousTime = System.currentTimeMillis();
        timeAccumulator = 0L;
        gameRunning = true;
    }

    public static void startApp() {
        Log.DEBUG_LOG(2, "Application.startApp");
        if (firstTimeInit) {
            defaultFont = new CustomFont();
            defaultFont.Load("/font.txt");
            smallRedFont = defaultFont;
            smallGreyFont = defaultFont;
            digitsFont = defaultFont;
            rnd.setSeed(10000000L);
            CGTexture.Init(0, 0);
            ApplicationData.readFromStore();
            Options.readDefaults();
            Options.readConfigurationFromStore();
            CGUserCareer.Load();
            CGAchievements.Load();
            soundEngine.initialize();
            String locale = Application.getApplication().checkStringProperty("Glu-Locale", "NULL");
            if (locale.compareTo("NULL") == 0) {
                Enable_Multilang = true;
                needDefaultlanguage = true;
            } else {
                Enable_Multilang = false;
                needDefaultlanguage = false;
                Options.languageID = 0;
                if (locale.compareTo("en") == 0) {
                    Options.languageID = 0;
                }
                if (locale.compareTo("fr") == 0) {
                    Options.languageID = 1;
                }
                if (locale.compareTo("de") == 0) {
                    Options.languageID = 2;
                }
                if (locale.compareTo("it") == 0) {
                    Options.languageID = 3;
                }
                if (locale.compareTo("es") == 0) {
                    Options.languageID = 4;
                }
                if (locale.compareTo("pt") == 0) {
                    Options.languageID = 5;
                }
            }
            lp = LanguagePack.create("/gameTexts.EEE", Options.languageID);
            upSellEnabled = Application.getApplication().checkBooleanProperty("Glu-Upsell-Enabled", false);
            if (upSellEnabled && (upSellURL = Application.getApplication().checkStringProperty("Glu-Upsell-URL", null)) == null) {
                upSellEnabled = false;
            }
            if ((demoEnabled = Application.getApplication().checkBooleanProperty("Glu-Demo-Enabled", false)) && (demoURL = Application.getApplication().checkStringProperty("Glu-Demo-URL", null)) == null) {
                demoEnabled = false;
            }
            ObjectsCache.initializeMenuResources();
            ApplicationData.StartTimer();
            firstTimeInit = false;
            if (needDefaultlanguage) {
                ApplicationData.askForDefaultLanguage();
            } else {
                ApplicationData.askForSoundMasterSwitch();
            }
        } else {
            Application.gameCanvas.isForeground = true;
            if (soundEngine != null && !Application.gameCanvas.firstCanvasFrame) {
                soundEngine.resumeMID();
            }
            Application.gameCanvas.firstCanvasFrame = false;
        }
        incomingCall = false;
    }

    public static int loadApp() {
        game = new MyGame();
        if (game.init() == 0) {
            return 0;
        }
        generalGameMode = 3;
        return 1;
    }

    public static void readFromStore() {
    }

    public static void writeToStore() {
    }

    public static boolean isLeftPressed() {
        Application.getApplication();
        return Application.gameCanvas.IsLeftPressed() || Game.leftTouchKeyPressed;
    }

    public static boolean isLeftPressed2() {
        if (isTouchScreen) {
            return false;
        }
        Application.getApplication();
        return Application.gameCanvas.IsLeftPressed2() || Game.leftTouchKeyPressed;
    }

    public static boolean isRightPressed() {
        Application.getApplication();
        return Application.gameCanvas.IsRightPressed() || Game.rightTouchKeyPressed;
    }

    public static boolean isRightPressed2() {
        if (isTouchScreen) {
            return false;
        }
        Application.getApplication();
        return Application.gameCanvas.IsRightPressed2() || Game.leftTouchKeyPressed;
    }

    public static boolean isUpPressed() {
        Application.getApplication();
        return Application.gameCanvas.IsUpPressed() || Game.upTouchKeyPressed;
    }

    public static boolean isDownPressed() {
        Application.getApplication();
        return Application.gameCanvas.IsDownPressed() || Game.downTouchKeyPressed;
    }

    public static void pauseApp() {
        incomingCall = true;
    }

    public static void SetMusic() {
        if (Options.GfxOnOff) {
            if (ApplicationData.isMainMenuMode()) {
                CGSoundSystem.PlayMusic("/mainmenu.mid");
            } else {
                CGSoundSystem.PlayMusic("/galaxy_3.mid");
            }
        }
    }

    public static void PlayMusicInGame() {
        if (Options.GfxOnOff) {
            CGSoundSystem.PlayMusic("/galaxy_3.mid");
        }
    }

    public static void resumeApp() {
        incomingCall = false;
        if (!firstTimeInit) {
            ApplicationData.SetMusic();
        }
    }

    public static void destroyApp(boolean unconditional) {
        Options.writeConfigurationToStore();
        ApplicationData.writeToStore();
        CGUserCareer.Save();
        CGAchievements.Save();
        if (soundEngine != null) {
            soundEngine.stopAllSounds();
        }
    }

    public static void quitApp() {
        gameRunning = false;
    }

    public static void hintGC() {
        Log.DEBUG_LOG(2, "Application.hintGC");
        Runtime.getRuntime().gc();
        Log.DEBUG_LOG(16, "Free mem:" + Runtime.getRuntime().freeMemory());
    }

    public static void processKeyCommands() {
        while (true) {
            KeyCommand cmd = MsgManager.getKeyCommand(false);
            boolean bServed = false;
            if (cmd == null) break;
            if (UIScreen.GetCurrentScreen() != null) {
                bServed = UIScreen.GetCurrentScreen().keyEvent(cmd);
            }
            if (!bServed && game != null && UIScreen.GetCurrentScreen() == null) {
                game.processKeyCommand(cmd);
            }
            MsgManager.removeKeyCommand();
        }
        MsgManager.clearKeyCommands();
    }

    public static void processTouchCommands() {
        while (true) {
            TouchCommand cmd = MsgManager.getTouchCommand(false);
            boolean bServed = false;
            if (cmd == null) break;
            if (UIScreen.GetCurrentScreen() != null) {
                bServed = UIScreen.GetCurrentScreen().keyTouchEvent(cmd);
            }
            if (!(bServed || game == null || UIScreen.GetCurrentScreen() != null && UIScreen.GetCurrentScreen().isModalScreen())) {
                game.processTouchCommand(cmd);
            }
            MsgManager.removeTouchCommand();
        }
        MsgManager.clearTouchCommands();
    }

    public static void Step() {
        long currentTime = 0L;
        Application.getApplication();
        screenWidth = Application.gameCanvas.getWidth();
        Application.getApplication();
        screenHeight = Application.gameCanvas.getHeight();
        if (m_bAppBlocked) {
            long lValue;
            if (System.currentTimeMillis() - m_nAppBlockedStartTime > 6000L) {
                gameRunning = false;
            }
            if ((lValue = 6L - (System.currentTimeMillis() - m_nAppBlockedStartTime) / 1000L) < 1L) {
                lValue = 1L;
            }
            MsgManager.clearKeyCommands();
            MsgManager.clearTouchCommands();
            if (ApplicationData.checkIsLandscape()) {
                Application.getApplication();
                screenHeight = Application.gameCanvas.getWidth();
                Application.getApplication();
                screenWidth = Application.gameCanvas.getHeight();
                Graphic2D.SetColor(0);
                Graphic2D.SetClip(0, 0, screenHeight, screenWidth);
                Graphic2D.FillRect(0, 0, screenHeight, screenWidth);
                String landscapeText = lp.getTranslatedString(Options.languageID, "ID_NO_LANDSCAPE");
                landscapeLinedText = Utils.splitText(landscapeText, defaultFont.encodeDynamicString("+"), screenHeight, 0);
                ApplicationData.DrawInfoText(landscapeLinedText, screenHeight / 2, 0);
                int nY = screenWidth / 2 + (landscapeLinedText.size() + 2) * defaultFont.getFontHeight();
                Utils.drawString(defaultFont.encodeDynamicString("" + (int)lValue), screenHeight / 2, nY, 3, 0);
                Graphic2D.FlushGraphics();
            } else {
                Graphic2D.SetColor(0);
                Graphic2D.SetClip(0, 0, screenWidth, screenHeight);
                Graphic2D.FillRect(0, 0, screenWidth, screenHeight);
                String landscapeText = lp.getTranslatedString(Options.languageID, "ID_NO_LANDSCAPE");
                landscapeLinedText = Utils.splitText(landscapeText, defaultFont.encodeDynamicString("+"), screenWidth, 0);
                ApplicationData.DrawInfoText(landscapeLinedText, screenWidth / 2, 0);
                int nY = screenHeight / 2 + (landscapeLinedText.size() + 2) * defaultFont.getFontHeight();
                Utils.drawString(defaultFont.encodeDynamicString("" + (int)lValue), screenWidth / 2, nY, 3, 0);
                Graphic2D.FlushGraphics();
            }
            return;
        }
        if (ApplicationData.checkIsLandscape()) {
            MsgManager.clearKeyCommands();
            MsgManager.clearTouchCommands();
            Application.getApplication();
            screenHeight = Application.gameCanvas.getWidth();
            Application.getApplication();
            screenWidth = Application.gameCanvas.getHeight();
            if (generalGameMode != 3 && UIScreen.GetCurrentScreen() == null) {
                ApplicationData.askAbortToMainMenu();
            }
            Graphic2D.SetColor(0);
            Graphic2D.SetClip(0, 0, screenHeight, screenWidth);
            Graphic2D.FillRect(0, 0, screenHeight, screenWidth);
            String landscapeText = lp.getTranslatedString(Options.languageID, "ID_NO_LANDSCAPE");
            landscapeLinedText = Utils.splitText(landscapeText, defaultFont.encodeDynamicString("+"), screenHeight, 0);
            ApplicationData.DrawInfoText(landscapeLinedText, screenHeight / 2, 0);
            Graphic2D.FlushGraphics();
            return;
        }
        ++m_nStats_CurrFrame;
        if (System.currentTimeMillis() - m_nStats_PrevTime >= 1000L) {
            m_nStats_FPS = m_nStats_CurrFrame;
            m_nStats_PrevTime = System.currentTimeMillis();
            m_nStats_CurrFrame = 0;
        }
        if (modeFirstFrame) {
            modeFirstFrame = false;
            timeAccumulator = 0L;
            currentTime = previousTime = System.currentTimeMillis();
            m_deltaTime = currentTime - previousTime;
        } else {
            currentTime = System.currentTimeMillis();
            m_deltaTime = currentTime - previousTime;
            if (m_deltaTime > 100L) {
                m_deltaTime = 100L;
            }
        }
        stepDeltaTime = (int)m_deltaTime;
        timeAccumulator += m_deltaTime;
        previousTime = currentTime;
        if (!incomingCall) {
            if (!incomingCall) {
                if (game != null && generalGameMode == 4) {
                    game.updateLogic((int)m_deltaTime);
                }
                if (UIScreen.GetCurrentScreen() != null) {
                    UIScreen.GetCurrentScreen().updateSize();
                    UIScreen.GetCurrentScreen().autoSize();
                    UIScreen.GetCurrentScreen().onUpdate((float)m_deltaTime / 1000.0f);
                }
                CGEngineRenderer.Render();
                if (game != null && generalGameMode == 4) {
                    game.drawGamePlay();
                }
                if (UIScreen.GetCurrentScreen() != null) {
                    UIScreen.GetCurrentScreen().paint();
                }
                if (m_szGlobalText != null && m_szGlobalText.length() > 0) {
                    Utils.drawString(m_szGlobalText, screenWidth >> 1, screenHeight >> 1, 3, 0);
                }
                AchievementPopup.Step();
                DebugConsole.draw();
                Graphic2D.FlushGraphics();
            } else {
                currentTime = previousTime = System.currentTimeMillis();
                timeAccumulator = 0L;
                if (UIScreen.GetCurrentScreen() != null) {
                    UIScreen.GetCurrentScreen().updateSize();
                    UIScreen.GetCurrentScreen().autoSize();
                    UIScreen.GetCurrentScreen().onUpdate((float)m_deltaTime / 1000.0f);
                }
                if (UIScreen.GetCurrentScreen() != null) {
                    UIScreen.GetCurrentScreen().paint();
                }
                if (m_szGlobalText != null && m_szGlobalText.length() > 0) {
                    Utils.drawString(m_szGlobalText, screenWidth >> 1, screenHeight >> 1, 3, 0);
                }
                Graphic2D.FlushGraphics();
            }
        } else {
            currentTime = previousTime = System.currentTimeMillis();
            timeAccumulator = 0L;
        }
        ApplicationData.checkDemoExpired(m_deltaTime);
        ApplicationData.processKeyCommands();
        ApplicationData.processTouchCommands();
        if (UIScreen.GetCurrentScreen() != null && UIScreen.GetCurrentScreen().isReadyForClose()) {
            UIScreen.GetCurrentScreen().onDestroy();
            if (UIScreen.GetNextScreen() != null) {
                UIScreen.SetCurrentScreen(UIScreen.GetNextScreen());
                UIScreen.SetNextScreen(null);
            } else {
                UIScreen scr = UIScreen.GetCurrentScreen().getParent();
                if (scr == null) {
                    int a = 0;
                    ++a;
                }
                UIScreen.SetCurrentScreen(scr);
                if (scr != null) {
                    scr.onFocusBack();
                }
            }
        }
    }

    private static void checkDemoExpired(long miliseconds) {
        if (demoEnabled && !demoExpired) {
            if (demoTimeLimited && (demoTimeLeft = (int)((long)demoTimeLeft - miliseconds)) <= 0) {
                demoTimeLeft = 0;
                demoExpired = true;
            }
            if (demoLevelLimited && demoLevelsLeft <= 0) {
                demoLevelsLeft = 0;
                demoExpired = true;
            }
        }
    }

    private static void DrawInfoText(Vector textLines, int xPos, int yPos) {
        int fontH = defaultFont.getFontHeight();
        for (int i = 0; i < textLines.size(); ++i) {
            Utils.drawString((String)textLines.elementAt(i), xPos, fontH * i + yPos, 17, 0);
        }
    }

    static {
        isTouchScreen = false;
        defaultFont = null;
        smallRedFont = null;
        smallGreyFont = null;
        digitsFont = null;
        lp = null;
        soundEngine = new SoundEngine();
        SoftButton1_Code = -6;
        SoftButton2_Code = -7;
        m_bAppBlocked = false;
        m_nAppBlockedStartTime = 0L;
        upSellEnabled = false;
        upSellURL = null;
        demoEnabled = false;
        demoExpired = false;
        demoTimeLimited = false;
        demoLevelLimited = false;
        demoURL = null;
        demoTimeLeft = -1;
        demoLevelsLeft = -1;
        NUM_LOADING_HINTS = 3;
        needDefaultlanguage = false;
        gameIsContinued = false;
        firstTimeInit = true;
        incomingCall = false;
        rnd = new Random();
        currentLoadingHint = 0;
        modeFirstFrame = true;
        gameRunning = false;
        freezeNetworkGame = false;
        generalGameMode = 3;
        m_nStats_PrevTime = 0L;
        m_nStats_CurrFrame = 0;
        m_nStats_FPS = 0;
        m_deltaTime = 0L;
        landscapeLinedText = new Vector();
    }
}

