/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.HudScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectSurvivalScreen;
import baltorogames.system.Options;

public class SurvivalScoreScreen
extends MainScreen {
    CGTexture titleTexture;
    CGTexture backGroundTexture;
    String szTitle;
    String szText;
    boolean newhighscore;

    public SurvivalScoreScreen(int nScore) {
        this.autoSize();
        this.szTitle = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULTS");
        this.szText = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_USER_SCORE_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nScore);
        CGEngine.m_bPause = true;
        this.m_bModalScreen = false;
        CGTexture retryTexture1 = TextureManager.AddTexture("/menu/retry.png");
        CGTexture retryTexture2 = TextureManager.AddTexture("/menu/retry_s.png");
        CGTexture exitTexture1 = TextureManager.AddTexture("/menu/menu.png");
        CGTexture exitTexture2 = TextureManager.AddTexture("/menu/menu_s.png");
        this.setSoftButtonImage(retryTexture1, retryTexture2, exitTexture1, exitTexture2);
        this.titleTexture = TextureManager.AddTexture("/menu/b_txt_window.png");
        this.backGroundTexture = TextureManager.AddTexture("/menu/popup_bg.png");
        if (CGUserCareer.m_arrBestSurvivalScore[CGEngine.m_nCurrentWorld] < CGLevelStats.m_nScore) {
            CGUserCareer.m_arrBestSurvivalScore[CGEngine.m_nCurrentWorld] = CGLevelStats.m_nScore;
            this.newhighscore = true;
        }
        CGAchievements.completeAchievement(4);
        if (CGLevelStats.m_nTimeStatsInMs / 1000 >= 60) {
            CGAchievements.completeAchievement(5);
        }
        if (CGLevelStats.m_nTimeStatsInMs / 1000 >= 120) {
            CGAchievements.completeAchievement(6);
        }
        if (CGLevelStats.m_nTimeStatsInMs / 1000 >= 300) {
            CGAchievements.completeAchievement(7);
        }
        if (CGLevelStats.m_nTimeStatsInMs / 1000 >= 600) {
            CGAchievements.completeAchievement(8);
        }
        if (CGLevelStats.m_nTimeStatsInMs / 1000 >= 1200) {
            CGAchievements.completeAchievement(9);
        }
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void drawWindowBackground() {
        Graphic2D.DrawImage(this.backGroundTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        if (this.newhighscore) {
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_NEW_HIGH_SCORE"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - ApplicationData.defaultFont.getFontHeight(), 3, 0);
        }
        Utils.drawString(this.szText, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
        int nY = ApplicationData.screenHeight / 2 - this.backGroundTexture.GetHeight() / 2 - this.titleTexture.GetHeight();
        if (nY < this.titleTexture.GetHeight() / 2) {
            nY = this.titleTexture.GetHeight() / 2;
        }
        Graphic2D.DrawImage(this.titleTexture, ApplicationData.screenWidth / 2, nY, 3);
        Utils.drawString(this.szTitle, ApplicationData.screenWidth / 2, nY, 3, 0);
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        ApplicationData.setMainMenuMode();
        CGEngine.m_bPause = false;
        CGEngine.m_bGameActive = false;
        UIScreen.SetNextScreen(new SelectSurvivalScreen());
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        CGSoundSystem.Play(2, false);
        CGEngine.Load2(null);
        UIScreen.SetCurrentScreen(new HudScreen());
        ApplicationData.PlayMusicInGame();
        ApplicationData.generalGameMode = 4;
        CGEngine.m_bGameActive = true;
        this.readyForClose = true;
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

