/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainTextBox;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class Sub3HelpMenu
extends MainTextBox {
    private final int m_nListSize;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public int m_nCurrentIndex = 0;
    private String csText1;
    private CGTexture[] listImages = null;

    protected void Clean() {
        for (int i = 0; i < 5; ++i) {
            TextureManager.DeleteTexture(this.listImages[i]);
            this.listImages[i] = null;
        }
        this.listImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.listImages == null) {
            this.listImages = new CGTexture[5];
            this.listImages[0] = TextureManager.AddTexture("/menu/bomb.png");
            this.listImages[1] = TextureManager.AddTexture("/menu/money.png");
            this.listImages[2] = TextureManager.AddTexture("/menu/powerup_bigsize.png");
            this.listImages[3] = TextureManager.AddTexture("/menu/powerup_magnet.png");
            this.listImages[4] = TextureManager.AddTexture("/menu/powerup_shield.png");
        }
    }

    public Sub3HelpMenu() {
        super(Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_Y, ApplicationData.screenWidth - 2 * Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_H, true);
        this.m_nListSize = 5;
        this.LEFT_ARROW_ID = 200;
        this.RIGHT_ARROW_ID = 201;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.listImages = new CGTexture[5];
        this.listImages[0] = TextureManager.AddTexture("/menu/bomb.png");
        this.listImages[1] = TextureManager.AddTexture("/menu/money.png");
        this.listImages[2] = TextureManager.AddTexture("/menu/powerup_bigsize.png");
        this.listImages[3] = TextureManager.AddTexture("/menu/powerup_magnet.png");
        this.listImages[4] = TextureManager.AddTexture("/menu/powerup_shield.png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.listImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.listImages[0].GetHeight() - ObjectsCache.arrowLeft.GetHeight();
        int arrowsY = trackIconY + this.listImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - this.listImages[0].GetWidth() - ObjectsCache.arrowLeft.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + this.listImages[0].GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 201);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 200);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        int nStartBoxY = ApplicationData.screenHeight / 2 + ObjectsCache.arrowLeft.GetHeight();
        int nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight();
        this.Setup(0, nStartBoxY, ApplicationData.screenWidth, nStopBoxY - nStartBoxY, true);
        this.updateInfo();
    }

    private void updateInfo() {
        this.csText1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SPECIAL_HEADER_" + (this.m_nCurrentIndex + 0));
        this.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SPECIAL_DESCRIPTION_" + (this.m_nCurrentIndex + 0)));
    }

    public void autoSize() {
    }

    public void draw() {
        super.draw();
        int trackIconX = ApplicationData.screenWidth / 2 - this.listImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.listImages[0].GetHeight() - ObjectsCache.arrowLeft.GetHeight();
        Graphic2D.DrawImage(this.listImages[this.m_nCurrentIndex], trackIconX, trackIconY, 20);
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(200);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(201);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.m_nCurrentIndex;
        if (this.m_nCurrentIndex >= 5) {
            this.m_nCurrentIndex = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.m_nCurrentIndex;
        if (this.m_nCurrentIndex < 0) {
            this.m_nCurrentIndex = 4;
        }
        this.updateInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 200) {
                this.onLeftAction();
                return true;
            }
            if (nID == 201) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

