/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EndOfCareerScreen;
import baltorogames.project_gui.HudScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectLevelScreen;
import baltorogames.system.Options;

public class StoryScoreScreen
extends MainScreen {
    CGTexture titleTexture;
    CGTexture backGroundTexture;
    private CGTexture starTexture = null;
    private CGTexture starEmptyTexture = null;
    String szTitle;
    String szText;
    int m_nCurrentScore;
    int m_nMinimumScore;
    boolean m_bEndOfCareer = false;
    boolean m_bNextLevelAvailable = true;
    int m_nScore = -1;
    int m_nNumStars = 0;

    public StoryScoreScreen(int nScore) {
        this.autoSize();
        CGEngine.m_bPause = true;
        this.m_bModalScreen = false;
        this.titleTexture = TextureManager.AddTexture("/menu/b_txt_window.png");
        this.backGroundTexture = TextureManager.AddTexture("/menu/popup_bg.png");
        this.starTexture = TextureManager.AddTexture("/menu/img_star.png");
        this.starEmptyTexture = TextureManager.AddTexture("/menu/img_star_empty.png");
        this.m_bNextLevelAvailable = true;
        this.m_nScore = nScore;
        CGEngine.m_bGameActive = false;
        CGEngine.m_bPause = true;
        int nCS = 0;
        int nStars = CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel];
        this.m_nCurrentScore = 0;
        this.m_nMinimumScore = 0;
        if (this.m_nScore > 0) {
            if (CGEngine.m_nCurrentGamingMode == 0 || CGEngine.m_nCurrentGamingMode == 4) {
                this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel];
                this.m_nCurrentScore = CGLevelStats.m_nScore;
                if (CGLevelStats.m_nScore > CGEngine.m_arrStoryLevelScoreNeededStar3[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 3;
                } else if (CGLevelStats.m_nScore > CGEngine.m_arrStoryLevelScoreNeededStar2[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 2;
                } else if (CGLevelStats.m_nScore > CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 1;
                }
                if (CGLevelStats.m_nScore > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
                    CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nScore;
                }
            } else if (CGEngine.m_nCurrentGamingMode == 2) {
                this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel];
                this.m_nCurrentScore = CGLevelStats.m_nMaxStreak;
                if (CGLevelStats.m_nMaxStreak > CGEngine.m_arrStoryLevelScoreNeededStar3[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 3;
                } else if (CGLevelStats.m_nMaxStreak > CGEngine.m_arrStoryLevelScoreNeededStar2[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 2;
                } else if (CGLevelStats.m_nMaxStreak > CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 1;
                }
                if (CGLevelStats.m_nMaxStreak > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
                    CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nMaxStreak;
                }
            } else if (CGEngine.m_nCurrentGamingMode == 3) {
                this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel];
                this.m_nCurrentScore = CGLevelStats.m_nBombsAvoided;
                if (CGLevelStats.m_nBombsAvoided > CGEngine.m_arrStoryLevelScoreNeededStar3[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 3;
                } else if (CGLevelStats.m_nBombsAvoided > CGEngine.m_arrStoryLevelScoreNeededStar2[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 2;
                } else if (CGLevelStats.m_nBombsAvoided > CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 1;
                }
                if (CGLevelStats.m_nBombsAvoided > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
                    CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nBombsAvoided;
                }
            } else if (CGEngine.m_nCurrentGamingMode == 1) {
                this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel];
                this.m_nCurrentScore = CGLevelStats.m_nCoinsGathered;
                if (CGLevelStats.m_nCoinsGathered > CGEngine.m_arrStoryLevelScoreNeededStar3[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 3;
                } else if (CGLevelStats.m_nCoinsGathered > CGEngine.m_arrStoryLevelScoreNeededStar2[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 2;
                } else if (CGLevelStats.m_nCoinsGathered > CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel]) {
                    nCS = 1;
                }
                if (CGLevelStats.m_nCoinsGathered > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
                    CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nCoinsGathered;
                }
            }
        }
        int scoreWhenFailed = 0;
        scoreWhenFailed = CGEngine.m_nCurrentGamingMode == 2 ? CGLevelStats.m_nMaxStreak : (CGEngine.m_nCurrentGamingMode == 3 ? CGLevelStats.m_nBombsAvoided : (CGEngine.m_nCurrentGamingMode == 1 ? CGLevelStats.m_nCoinsGathered : CGLevelStats.m_nScore));
        this.szText = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_USER_SCORE_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString(" " + (nScore == -1 ? scoreWhenFailed : this.m_nCurrentScore));
        if (nCS > nStars) {
            CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel] = nCS;
            if (CGEngine.m_nCurrentGamingMode == 1) {
                CGUserCareer.m_nMoney += CGLevelStats.m_nCoinsGathered * nCS;
            }
        }
        CGUserCareer.CheckUnlockNewWorld();
        if (this.m_nScore > 0 && CGUserCareer.IsStoryLevelReadyToAvailable(CGEngine.m_nCurrentStoryLevel + 1) && CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel + 1] < 0) {
            CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel + 1] = 0;
        }
        this.szTitle = this.m_nScore < 0 ? ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_LOST") : ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_WIN");
        if (CGEngine.m_nCurrentStoryLevel + 1 >= 45) {
            if (this.m_nScore > 0) {
                this.m_bEndOfCareer = true;
            } else {
                this.m_bNextLevelAvailable = false;
            }
        } else if (CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel + 1] < 0) {
            this.m_bNextLevelAvailable = false;
        }
        if (this.m_bNextLevelAvailable) {
            CGTexture retryTexture1 = TextureManager.AddTexture("/menu/play.png");
            CGTexture retryTexture2 = TextureManager.AddTexture("/menu/play_s.png");
            CGTexture exitTexture1 = TextureManager.AddTexture("/menu/menu.png");
            CGTexture exitTexture2 = TextureManager.AddTexture("/menu/menu_s.png");
            this.setSoftButtonImage(retryTexture1, retryTexture2, exitTexture1, exitTexture2);
        } else {
            CGTexture retryTexture1 = TextureManager.AddTexture("/menu/retry.png");
            CGTexture retryTexture2 = TextureManager.AddTexture("/menu/retry_s.png");
            CGTexture exitTexture1 = TextureManager.AddTexture("/menu/menu.png");
            CGTexture exitTexture2 = TextureManager.AddTexture("/menu/menu_s.png");
            this.setSoftButtonImage(retryTexture1, retryTexture2, exitTexture1, exitTexture2);
        }
        this.UpdateInfo();
        this.m_nNumStars = nCS;
        if (this.m_nNumStars == 3) {
            CGAchievements.completeAchievement(2);
        }
    }

    public void UpdateInfo() {
        if (this.m_nCurrentScore > this.m_nMinimumScore) {
            CGAchievements.completeAchievement(0);
            int nWorld = (CGEngine.m_nCurrentStoryLevel + 1) / 9;
            if (nWorld < 5) {
                CGUserCareer.UnlockSurvivalLevel(nWorld);
            }
            if (CGUserCareer.IsStoryLevelReadyToAvailable(CGEngine.m_nCurrentStoryLevel + 1) && CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel + 1] < 0) {
                CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel + 1] = 0;
            }
            if (CGUserCareer.AllLevelsUnlocked()) {
                CGAchievements.completeAchievement(3);
            }
        } else {
            CGAchievements.completeAchievement(1);
        }
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void drawWindowBackground() {
        Graphic2D.DrawImage(this.backGroundTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Utils.drawString(this.szText, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + ApplicationData.defaultFont.getFontHeight(), 3, 0);
        int nY = ApplicationData.screenHeight / 2 - this.backGroundTexture.GetHeight() / 2 - this.titleTexture.GetHeight();
        if (nY < this.titleTexture.GetHeight() / 2) {
            nY = this.titleTexture.GetHeight() / 2;
        }
        Graphic2D.DrawImage(this.titleTexture, ApplicationData.screenWidth / 2, nY, 3);
        Utils.drawString(this.szTitle, ApplicationData.screenWidth / 2, nY, 3, 0);
        int nStarsY = ApplicationData.screenHeight / 2 - this.backGroundTexture.GetHeight() / 4;
        int nStar1X = ApplicationData.screenWidth / 2 - 3 * this.starTexture.GetWidth() / 2;
        int nStar2X = ApplicationData.screenWidth / 2;
        int nStar3X = ApplicationData.screenWidth / 2 + 3 * this.starTexture.GetWidth() / 2;
        Graphic2D.DrawImage(this.starEmptyTexture, nStar1X, nStarsY, 3);
        Graphic2D.DrawImage(this.starEmptyTexture, nStar2X, nStarsY, 3);
        Graphic2D.DrawImage(this.starEmptyTexture, nStar3X, nStarsY, 3);
        if (this.m_nNumStars > 0) {
            Graphic2D.DrawImage(this.starTexture, nStar1X, nStarsY, 3);
        }
        if (this.m_nNumStars > 1) {
            Graphic2D.DrawImage(this.starTexture, nStar2X, nStarsY, 3);
        }
        if (this.m_nNumStars > 2) {
            Graphic2D.DrawImage(this.starTexture, nStar3X, nStarsY, 3);
        }
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        ApplicationData.setMainMenuMode();
        CGEngine.m_bPause = false;
        CGEngine.m_bGameActive = false;
        UIScreen.SetNextScreen(new SelectLevelScreen(CGEngine.m_nCurrentStoryLevel % 9));
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        CGSoundSystem.Play(2, false);
        if (!this.m_bNextLevelAvailable) {
            CGEngine.Load2(null);
            UIScreen.SetCurrentScreen(new HudScreen());
            ApplicationData.PlayMusicInGame();
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
        } else if (!this.m_bEndOfCareer) {
            CGEngine.m_nCurrentWorld = ++CGEngine.m_nCurrentStoryLevel / 9;
            ApplicationData.setMainMenuMode();
            CGEngine.m_bGameActive = false;
            CGEngine.m_bPause = false;
            UIScreen.SetNextScreen(new SelectLevelScreen(CGEngine.m_nCurrentStoryLevel % 9));
            UIScreen.GetNextScreen().setParent(null);
            this.readyForClose = true;
        } else {
            ApplicationData.setMainMenuMode();
            CGEngine.m_bGameActive = false;
            CGEngine.m_bPause = false;
            UIScreen.SetNextScreen(new EndOfCareerScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        this.readyForClose = true;
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

