/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.SelectBoostScreen;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectWorldScreen;
import baltorogames.project_gui.StoryGameModeInfoScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectLevelScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int selectedLevel = 0;
    private CGTexture starTexture = null;
    private CGTexture starEmptyTexture = null;
    private CGTexture[] typeImages = null;
    private CGTexture groundTexture = null;
    private CGTexture lockTexture = null;
    private int m_nTypeIconY;
    private int m_nStarsIconY;
    private int m_nLevelNrY;
    private String m_szLevelNr;
    private int m_nText3StarsY;
    private String m_szText3Stars;
    private int m_nText2StarsY;
    private String m_szText2Stars;
    private int m_nText1StarsY;
    private String m_szText1Stars;
    private String unlock_text;
    private String unlock_requirement;
    private UIFloatingTextBox infoBox;
    private UIFloatingTextBox descBox;

    protected void Clean() {
        for (int i = 0; i < 5; ++i) {
            TextureManager.DeleteTexture(this.typeImages[i]);
            this.typeImages[i] = null;
        }
        this.typeImages = null;
        TextureManager.DeleteTexture(this.groundTexture);
        this.groundTexture = null;
        TextureManager.DeleteTexture(this.lockTexture);
        this.lockTexture = null;
        TextureManager.DeleteTexture(this.starTexture);
        this.starTexture = null;
        TextureManager.DeleteTexture(this.starEmptyTexture);
        this.starEmptyTexture = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.typeImages == null) {
            this.typeImages = new CGTexture[6];
            this.typeImages[0] = TextureManager.AddTexture("/menu/b_mode1.png");
            this.typeImages[1] = TextureManager.AddTexture("/menu/b_mode2.png");
            this.typeImages[2] = TextureManager.AddTexture("/menu/b_mode3.png");
            this.typeImages[3] = TextureManager.AddTexture("/menu/b_mode4.png");
            this.typeImages[4] = TextureManager.AddTexture("/menu/b_mode5.png");
            this.typeImages[5] = TextureManager.AddTexture("/menu/b_mode0.png");
        }
        this.lockTexture = TextureManager.AddTexture("/menu/b_world_locked.png");
        this.groundTexture = TextureManager.AddTexture("/menu/popup_bg.png");
        this.starTexture = TextureManager.AddTexture("/menu/img_star.png");
        this.starEmptyTexture = TextureManager.AddTexture("/menu/img_star_empty.png");
    }

    public SelectLevelScreen(int nSelectedLevel) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.selectedLevel = nSelectedLevel;
        this.drawTop = true;
        this.drawTitle = false;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.typeImages = new CGTexture[6];
        this.typeImages[0] = TextureManager.AddTexture("/menu/b_mode1.png");
        this.typeImages[1] = TextureManager.AddTexture("/menu/b_mode2.png");
        this.typeImages[2] = TextureManager.AddTexture("/menu/b_mode3.png");
        this.typeImages[3] = TextureManager.AddTexture("/menu/b_mode4.png");
        this.typeImages[4] = TextureManager.AddTexture("/menu/b_mode5.png");
        this.typeImages[5] = TextureManager.AddTexture("/menu/b_mode0.png");
        this.lockTexture = TextureManager.AddTexture("/menu/b_world_locked.png");
        this.groundTexture = TextureManager.AddTexture("/menu/popup_bg.png");
        this.starTexture = TextureManager.AddTexture("/menu/img_star.png");
        this.starEmptyTexture = TextureManager.AddTexture("/menu/img_star_empty.png");
        int arrowsY = ApplicationData.screenHeight / 2 - ObjectsCache.arrowLeft.GetHeight();
        int arrowLeftX = ObjectsCache.arrowLeft.GetWidth() / 10;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth() / 10 - ObjectsCache.arrowLeft.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.m_nTypeIconY = ApplicationData.screenHeight / 2 - this.groundTexture.GetHeight() / 2 + 12;
        if (this.m_nTypeIconY < 0) {
            this.m_nTypeIconY = 0;
        }
        this.m_nStarsIconY = this.m_nTypeIconY + this.typeImages[0].GetHeight();
        this.m_nLevelNrY = ApplicationData.screenHeight / 2 + this.groundTexture.GetHeight() / 2 + ApplicationData.defaultFont.getFontHeight();
        int nStartBoxY = ApplicationData.screenHeight / 2 - this.groundTexture.GetHeight() / 2;
        int nStopBoxY = ApplicationData.screenHeight / 2 + this.groundTexture.GetHeight() / 4;
        int nBoxWidth = 7 * ApplicationData.screenWidth / 10;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - nBoxWidth) / 2, nStartBoxY, nBoxWidth, nStopBoxY - nStartBoxY);
        this.m_nText1StarsY = ApplicationData.screenHeight / 2 + this.groundTexture.GetHeight() / 2 - 3 * ApplicationData.defaultFont.getFontHeight();
        this.m_nText2StarsY = this.m_nText1StarsY - this.starTexture.GetHeight();
        this.m_nText3StarsY = this.m_nText2StarsY - this.starTexture.GetHeight();
        this.updateInfo();
    }

    private void updateInfo() {
        boolean unlocked;
        int nCurrentStoryLevel = CGEngine.m_nCurrentWorld * 9 + this.selectedLevel;
        this.m_szLevelNr = ApplicationData.defaultFont.encodeDynamicString("" + (CGEngine.m_nCurrentWorld + 1) + " - " + (this.selectedLevel + 1));
        boolean bl = unlocked = CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] >= 0;
        if (unlocked) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
            String szPostfix = ApplicationData.lp.getTranslatedString(Options.languageID, CGEngine.m_arrLevelGoalDescriptionsPostfixes[CGEngine.m_arrGameModes[nCurrentStoryLevel]]);
            String szGoal = ApplicationData.lp.getTranslatedString(Options.languageID, CGEngine.m_arrLevelGoalDescriptions[CGEngine.m_arrGameModes[nCurrentStoryLevel]]);
            this.m_szText3Stars = ApplicationData.defaultFont.encodeDynamicString("> " + CGEngine.m_arrStoryLevelScoreNeededStar3[nCurrentStoryLevel] + " ") + szPostfix;
            this.m_szText2Stars = ApplicationData.defaultFont.encodeDynamicString("> " + CGEngine.m_arrStoryLevelScoreNeededStar2[nCurrentStoryLevel] + " ") + szPostfix;
            this.m_szText1Stars = ApplicationData.defaultFont.encodeDynamicString("> " + CGEngine.m_arrStoryLevelScoreNeededStar1[nCurrentStoryLevel] + " ") + szPostfix;
            this.infoBox.setText(szGoal);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
            this.infoBox.setText("");
        }
    }

    public void autoSize() {
    }

    public void draw() {
        Graphic2D.DrawImage(this.groundTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        int nCurrentStoryLevel = CGEngine.m_nCurrentWorld * 9 + this.selectedLevel;
        boolean unlocked = CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] >= 0;
        int nType = CGEngine.m_arrGameModes[nCurrentStoryLevel];
        if (!unlocked) {
            nType = 5;
        }
        Graphic2D.DrawImage(this.typeImages[nType], ApplicationData.screenWidth / 2, this.m_nTypeIconY, 17);
        if (!unlocked) {
            Graphic2D.DrawImage(this.lockTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - 2 * ApplicationData.defaultFont.getFontHeight(), 3);
            this.descBox = new UIFloatingTextBox(false, ApplicationData.screenWidth / 2 - 3 * this.groundTexture.GetWidth() / 8, ApplicationData.screenHeight / 2 + this.lockTexture.GetHeight() / 2 - 2 * ApplicationData.defaultFont.getFontHeight(), 3 * this.groundTexture.GetWidth() / 4, 3 * ApplicationData.defaultFont.getFontHeight());
            String unlocks = new String(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_UNLOCK_REQUIREMENT"));
            unlocks = unlocks + '\u00ff';
            unlocks = unlocks + ApplicationData.defaultFont.encodeDynamicString(" " + (CGEngine.m_nCurrentWorld + 1) + " - " + this.selectedLevel);
            this.descBox.setText(unlocks);
            this.descBox.draw();
        } else {
            int nMargin = this.starTexture.GetWidth() / 2;
            int nFirstStarX = ApplicationData.screenWidth / 2 - this.starTexture.GetWidth() / 2 - nMargin - this.starTexture.GetWidth();
            int nSecondStarX = ApplicationData.screenWidth / 2 - this.starTexture.GetWidth() / 2;
            int nThirdStarX = ApplicationData.screenWidth / 2 + this.starTexture.GetWidth() / 2 + nMargin;
            Graphic2D.DrawImage(this.starEmptyTexture, nFirstStarX, this.m_nStarsIconY, 20);
            Graphic2D.DrawImage(this.starEmptyTexture, nSecondStarX, this.m_nStarsIconY, 20);
            Graphic2D.DrawImage(this.starEmptyTexture, nThirdStarX, this.m_nStarsIconY, 20);
            if (CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] > 0) {
                Graphic2D.DrawImage(this.starTexture, nFirstStarX, this.m_nStarsIconY, 20);
            }
            if (CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] > 1) {
                Graphic2D.DrawImage(this.starTexture, nSecondStarX, this.m_nStarsIconY, 20);
            }
            if (CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] > 2) {
                Graphic2D.DrawImage(this.starTexture, nThirdStarX, this.m_nStarsIconY, 20);
            }
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight(), this.m_nText1StarsY, 3);
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight() - this.starTexture.GetHeight() / 2, this.m_nText2StarsY, 3);
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight() + this.starTexture.GetHeight() / 2, this.m_nText2StarsY, 3);
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight(), this.m_nText3StarsY, 3);
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight() - this.starTexture.GetHeight(), this.m_nText3StarsY, 3);
            Graphic2D.DrawImage(this.starTexture, ApplicationData.screenWidth / 4 - this.starTexture.GetHeight() + this.starTexture.GetHeight(), this.m_nText3StarsY, 3);
            Utils.drawString(this.m_szText1Stars, ApplicationData.screenWidth / 2 - this.starTexture.GetHeight() - this.starTexture.GetWidth(), this.m_nText1StarsY, 6, 0);
            Utils.drawString(this.m_szText2Stars, ApplicationData.screenWidth / 2 - this.starTexture.GetHeight() - this.starTexture.GetWidth(), this.m_nText2StarsY, 6, 0);
            Utils.drawString(this.m_szText3Stars, ApplicationData.screenWidth / 2 - this.starTexture.GetHeight() - this.starTexture.GetWidth(), this.m_nText3StarsY, 6, 0);
        }
        this.infoBox.draw();
        Utils.drawString(this.m_szLevelNr, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.groundTexture.GetHeight() / 2 - 2 * ApplicationData.defaultFont.getFontHeight(), 3, 0);
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        UIScreen.SetNextScreen(new SelectWorldScreen());
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        boolean unlocked;
        int nCurrentStoryLevel = CGEngine.m_nCurrentWorld * 9 + this.selectedLevel;
        boolean bl = unlocked = CGUserCareer.m_arrLevelScore[nCurrentStoryLevel] >= 0;
        if (!unlocked) {
            return true;
        }
        CGEngine.m_nCurrentStoryLevel = CGEngine.m_nCurrentWorld * 9 + this.selectedLevel;
        CGEngine.m_nGameMode = 1;
        CGEngine.m_nCurrentGamingMode = CGEngine.m_arrGameModes[CGEngine.m_nCurrentStoryLevel];
        SelectBoostScreen.ResetBoosts();
        if (CGEngine.m_nCurrentGamingMode == 0 && CGUserCareer.isStoryTimeMode_PopupInfoOn) {
            UIScreen.SetNextScreen(new StoryGameModeInfoScreen(0));
            UIScreen.GetNextScreen().setParent(this);
            CGUserCareer.isStoryTimeMode_PopupInfoOn = false;
        } else if (CGEngine.m_nCurrentGamingMode == 1 && CGUserCareer.isStoryScoreMode_PopupInfoOn) {
            UIScreen.SetNextScreen(new StoryGameModeInfoScreen(1));
            UIScreen.GetNextScreen().setParent(this);
            CGUserCareer.isStoryScoreMode_PopupInfoOn = false;
        } else if (CGEngine.m_nCurrentGamingMode == 2 && CGUserCareer.isStoryBounceMode_PopupInfoOn) {
            UIScreen.SetNextScreen(new StoryGameModeInfoScreen(2));
            UIScreen.GetNextScreen().setParent(this);
            CGUserCareer.isStoryBounceMode_PopupInfoOn = false;
        } else if (CGEngine.m_nCurrentGamingMode == 3 && CGUserCareer.isStoryBombMode_PopupInfoOn) {
            UIScreen.SetNextScreen(new StoryGameModeInfoScreen(3));
            UIScreen.GetNextScreen().setParent(this);
            CGUserCareer.isStoryBombMode_PopupInfoOn = false;
        } else if (CGEngine.m_nCurrentGamingMode == 4 && CGUserCareer.isStoryNormalMode_PopupInfoOn) {
            UIScreen.SetNextScreen(new StoryGameModeInfoScreen(4));
            UIScreen.GetNextScreen().setParent(this);
            CGUserCareer.isStoryNormalMode_PopupInfoOn = false;
        } else {
            UIScreen.SetNextScreen(new LoadingLevelScreen());
            UIScreen.GetNextScreen().setParent(this);
        }
        this.readyForClose = true;
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.selectedLevel;
        if (this.selectedLevel >= 9) {
            this.selectedLevel = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.selectedLevel;
        if (this.selectedLevel < 0) {
            this.selectedLevel = 8;
        }
        this.updateInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

