/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.SplashScreens;
import baltorogames.project_gui.YesNoDialogBox;
import baltorogames.system.Options;
import baltorogames.system.SoundEngine;

public class MasterSoundSwitch
extends YesNoDialogBox {
    CGTexture texture = null;

    public MasterSoundSwitch(String caption, String main, int color, String imageName, int numFrames, long speed) {
        super(caption, main, color, imageName, numFrames, speed);
        Options.GfxOnOff = false;
        this.texture = TextureManager.AddTexture("/menu/sound_ico_1.png");
    }

    public MasterSoundSwitch(String caption, String main, int color, String imageName) {
        super(caption, main, color, imageName);
        Options.GfxOnOff = false;
        this.texture = TextureManager.AddTexture("/menu/sound_ico_1.png");
    }

    public MasterSoundSwitch(String caption, String main, int color) {
        super(caption, main, color);
        Options.GfxOnOff = false;
    }

    public boolean leftSoftButton() {
        ApplicationData.soundEngine.enableSound();
        if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_SILENCE) {
            SoundEngine.soundVolume = SoundEngine.SOUND_VOLUME_MEDIUM;
        }
        Options.GfxOnOff = true;
        this.continueGameStart();
        return true;
    }

    public boolean rightSoftButton() {
        ApplicationData.soundEngine.disableSound();
        if (SoundEngine.soundVolume != SoundEngine.SOUND_VOLUME_SILENCE) {
            SoundEngine.soundVolume = SoundEngine.SOUND_VOLUME_SILENCE;
        }
        Options.GfxOnOff = false;
        this.continueGameStart();
        return true;
    }

    public boolean selectFireAction() {
        return this.rightSelectSoftButton();
    }

    public boolean onFireAction() {
        return this.rightSoftButton();
    }

    private void continueGameStart() {
        UIScreen.SetCurrentScreen(new SplashScreens());
    }

    public void draw() {
        Graphic2D.SetColor(0);
        Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        if (this.texture != null) {
            Graphic2D.DrawImage(this.texture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
    }
}

