/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.SelectBoostScreen;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class HudScreen
extends UIScreen {
    CGTexture coinsTexture = null;
    CGTexture loadingBar = null;
    CGTexture loadingBarBg = null;
    CGTexture[] starsBar = null;
    String strMoney;
    String strLeft;
    String strRight;

    public HudScreen() {
        this.m_bModalScreen = false;
        this.loadingBar = TextureManager.AddTexture("/menu/bar_fill.png");
        this.loadingBarBg = TextureManager.AddTexture("/menu/bar_bg.png");
        this.starsBar = new CGTexture[3];
        this.starsBar[0] = TextureManager.AddTexture("/menu/bar_1star.png");
        this.starsBar[1] = TextureManager.AddTexture("/menu/bar_2star.png");
        this.starsBar[2] = TextureManager.AddTexture("/menu/bar_3star.png");
        this.coinsTexture = TextureManager.AddTexture("/menu/ico_cash.png");
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbPAUSE, ObjectsCache.menuSbPAUSE);
    }

    public void drawWindowBackground() {
        this.strMoney = ApplicationData.defaultFont.encodeDynamicString(" " + CGUserCareer.m_nMoney);
        this.strLeft = "";
        if (CGEngine.m_nGameMode == 1) {
            if (CGEngine.m_nCurrentGamingMode == 3) {
                this.strRight = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GOAL_HEADER_4") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nBombsAvoided + "  ");
            } else if (CGEngine.m_nCurrentGamingMode == 2) {
                this.strRight = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GOAL_HEADER_3") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nMaxStreak + "  ");
            } else if (CGEngine.m_nCurrentGamingMode == 0) {
                String szTime = ApplicationData.defaultFont.makeTimeChars(CGEngine.m_nCurrentLevelTime);
                this.strLeft = ApplicationData.defaultFont.encodeDynamicString(" " + szTime);
                this.strRight = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GOAL_HEADER_1") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nScore + "  ");
            } else {
                this.strRight = CGEngine.m_nCurrentGamingMode == 4 ? ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GOAL_HEADER_5") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nScore + "  ") : (CGEngine.m_nCurrentGamingMode == 1 ? ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GOAL_HEADER_2") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nCoinsGathered + "  ") : " ");
            }
            Utils.drawString(this.strLeft, 0, 0, 20, 0);
            Utils.drawString(this.strRight, ApplicationData.screenWidth, 0, 24, 0);
            Graphic2D.DrawImage(this.coinsTexture, 0, ApplicationData.screenHeight, 36);
            Utils.drawString(this.strMoney, this.coinsTexture.GetWidth(), ApplicationData.screenHeight - this.coinsTexture.GetHeight() / 2, 6, 0);
        } else if (CGEngine.m_nGameMode == 2) {
            this.strRight = ApplicationData.defaultFont.encodeDynamicString("Score: " + CGLevelStats.m_nScore + "  ");
            Utils.drawString(this.strRight, ApplicationData.screenWidth, 0, 24, 0);
        }
    }

    public void drawWindowForeground() {
        float fValue;
        if (CGEngine.m_nGameMode == 2) {
            return;
        }
        float fBarDX = this.loadingBarBg.GetWidth();
        float fBarDY = this.loadingBarBg.GetHeight();
        float fStarDX = this.starsBar[0].GetWidth();
        float fStarDY = this.starsBar[0].GetHeight();
        float fBarX = (float)ApplicationData.screenWidth - 20.0f * CGEngine.m_fEngineScale;
        float fBarY = (float)(ApplicationData.screenHeight / 2) - fBarDY / 2.0f;
        Graphic2D.DrawRegion(this.loadingBarBg, fBarX, fBarY, 0.0f, 0.0f, fBarX + fBarDX, fBarY + fBarDY, 1.0f, 1.0f);
        float fCurrentScore = 0.0f;
        float fScoreForStar1 = 1 + CGEngine.m_arrStoryLevelScoreNeededStar1[CGEngine.m_nCurrentStoryLevel];
        float fScoreForStar2 = 1 + CGEngine.m_arrStoryLevelScoreNeededStar2[CGEngine.m_nCurrentStoryLevel];
        float fScoreForStar3 = 1 + CGEngine.m_arrStoryLevelScoreNeededStar3[CGEngine.m_nCurrentStoryLevel];
        if (CGEngine.m_nCurrentGamingMode == 0 || CGEngine.m_nCurrentGamingMode == 4) {
            fCurrentScore = CGLevelStats.m_nScore;
        } else if (CGEngine.m_nCurrentGamingMode == 2) {
            fCurrentScore = CGLevelStats.m_nMaxStreak;
        } else if (CGEngine.m_nCurrentGamingMode == 3) {
            fCurrentScore = CGLevelStats.m_nBombsAvoided;
        } else if (CGEngine.m_nCurrentGamingMode == 1) {
            fCurrentScore = CGLevelStats.m_nCoinsGathered;
        }
        if (SelectBoostScreen.isBoostExtraScoreActivate()) {
            fCurrentScore *= 1.2f;
        }
        if ((fValue = 100.0f * (fCurrentScore / fScoreForStar3)) > 100.0f) {
            fValue = 100.0f;
        }
        if (fValue < 0.0f) {
            fValue = 0.0f;
        }
        float fFillY = fBarY + fBarDY * (100.0f - fValue) / 100.0f;
        Graphic2D.DrawRegion(this.loadingBar, fBarX, fFillY, 0.0f, 1.0f - fValue / 100.0f, fBarX + fBarDX, fFillY + fBarDY * fValue / 100.0f, 1.0f, 1.0f);
        float fV = fScoreForStar1 / fScoreForStar3;
        float fStarX = fBarX + fBarDX - fStarDX;
        float fStarY = fBarY + (1.0f - fV) * fBarDY;
        Graphic2D.DrawRegion(this.starsBar[0], fStarX, fStarY, 0.0f, 0.0f, fStarX + fStarDX, fStarY + fStarDY, 1.0f, 1.0f);
        fV = fScoreForStar2 / fScoreForStar3;
        fStarX = fBarX + fBarDX - fStarDX;
        fStarY = fBarY + (1.0f - fV) * fBarDY;
        Graphic2D.DrawRegion(this.starsBar[1], fStarX, fStarY, 0.0f, 0.0f, fStarX + fStarDX, fStarY + fStarDY, 1.0f, 1.0f);
        fV = fScoreForStar3 / fScoreForStar3;
        fStarX = fBarX + fBarDX - fStarDX;
        fStarY = fBarY + (1.0f - fV) * fBarDY;
        Graphic2D.DrawRegion(this.starsBar[2], fStarX, fStarY, 0.0f, 0.0f, fStarX + fStarDX, fStarY + fStarDY, 1.0f, 1.0f);
    }

    public void draw() {
    }

    public void onSystemPauseAction() {
        UIScreen.SetNextScreen(new InGameMainMenu());
        UIScreen.GetNextScreen().setParent(this);
        this.readyForClose = true;
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        UIScreen.SetNextScreen(new InGameMainMenu());
        UIScreen.GetNextScreen().setParent(this);
        this.readyForClose = true;
        return true;
    }

    public boolean onFireAction() {
        return false;
    }

    public boolean selectLeftAction() {
        return false;
    }

    public boolean selectRightAction() {
        return false;
    }

    public boolean onLeftAction() {
        return false;
    }

    public boolean onRightAction() {
        return false;
    }

    public boolean selectUpAction() {
        return false;
    }

    public boolean onUpAction() {
        return false;
    }

    public boolean selectDownAction() {
        return false;
    }

    public boolean onDownAction() {
        return false;
    }

    public boolean keyEvent(KeyCommand cmd) {
        if (!cmd.pressed) {
            this.unselectAllButtons();
            if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
                return this.leftSoftButton();
            }
            if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
                return this.rightSoftButton();
            }
            return this.onKeyAction(cmd.keyCode);
        }
        if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
            return this.leftSelectSoftButton();
        }
        if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
            return this.rightSelectSoftButton();
        }
        return this.onKeyDownAction(cmd.keyCode);
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return false;
        }
        if (!pressed) {
            this.unselectAllButtons();
        }
        return false;
    }

    public void onUpdate(float deltaTime) {
    }
}

