/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class AchievementsScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedAchiev = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private CGTexture[] achievImages = null;

    protected void Clean() {
        for (int i = 0; i < 2; ++i) {
            TextureManager.DeleteTexture(this.achievImages[i]);
            this.achievImages[i] = null;
        }
        this.achievImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.achievImages == null) {
            this.achievImages = new CGTexture[2];
            this.achievImages[0] = TextureManager.AddTexture("/menu/ico_achi_on.png");
            this.achievImages[1] = TextureManager.AddTexture("/menu/ico_achi_off.png");
        }
    }

    public AchievementsScreen() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedAchiev = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.achievImages = new CGTexture[2];
        this.achievImages[0] = TextureManager.AddTexture("/menu/ico_achi_on.png");
        this.achievImages[1] = TextureManager.AddTexture("/menu/ico_achi_off.png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        int arrowsY = trackIconY + this.achievImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() - ObjectsCache.arrowLeft.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.nStartBoxY = arrowsY + ApplicationData.getFontByID(0).getFontHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedAchiev + 1) + " / " + 10);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + selectedAchiev);
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_LONG_DESCRIPTION_" + selectedAchiev));
    }

    public void autoSize() {
    }

    public void draw() {
        int trackIconX = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        boolean unlocked = CGAchievements.isAchievementCompleted(selectedAchiev);
        if (unlocked) {
            Graphic2D.DrawImage(this.achievImages[0], trackIconX, trackIconY, 20);
        } else {
            Graphic2D.DrawImage(this.achievImages[1], trackIconX, trackIconY, 20);
        }
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 10) {
            selectedAchiev = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 9;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

