/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CrashAnimationObject;
import baltorogames.project_gameplay.HitAnimationObject;
import baltorogames.project_gameplay.PowerupManager;

public class ThingObject {
    public static final int SCORE_FOR_ITEM = 100;
    public static final int[] m_arrScoreForItem = new int[]{0, 100, 150, 200, 100, 150, 200};
    public static final float eWidth = 128.0f;
    public static final float eHeight = 128.0f;
    public static final float eThiefWidth = 96.0f;
    public static final float eThiefHeight = 96.0f;
    public static final int eState_Start = 1;
    public static final int eState_Jump = 2;
    public static final int eState_Dead = 3;
    public static final int eState_Over = 4;
    public static final float[] m_SlotX = new float[]{96.0f, 96.0f, 96.0f};
    public static final float[] m_SlotY = new float[]{101.111115f, 270.0f, 438.8889f};
    public static final float[] m_RunSlotX = new float[]{-70.0f, -70.0f, -70.0f};
    public static final float[] m_RunSlotY = new float[]{88.33334f, 257.22223f, 426.1111f};
    public static CGDynamicObj m_pDynamic = null;
    public int m_nState;
    public int m_nStateTime;
    public float m_fPosX;
    public float m_fPosY;
    public float m_fRadius;
    public float m_fAngle;
    public float m_fSpeed;
    public float m_fLastPosX;
    public float m_fLastPosY;
    public float m_fSpeedX;
    public float m_fSpeedY;
    protected int m_nDeadTime;
    protected int m_nKickCounter;
    protected CGTexture m_pJumpTextures;
    protected CGTexture[] m_pDeadTexture;
    protected CGTexture[][] m_pRunThiefTexture;
    protected int m_nPosType;
    protected int m_nType;
    protected float m_nKickNr;
    protected float m_fCurrentG;
    protected float m_fFreezeTime;

    public void Dispose() {
    }

    public void Destroy() {
    }

    public void Create(int nType, int nPosType) {
        this.m_fPosX = m_SlotX[nPosType];
        this.m_fPosY = m_SlotY[nPosType];
        this.m_fPosX = m_RunSlotX[this.m_nPosType];
        this.m_fPosY = m_RunSlotY[this.m_nPosType];
        this.m_nState = 1;
        this.m_nStateTime = 0;
        this.m_nKickCounter = 0;
        this.m_nType = nType;
        this.m_nPosType = nPosType;
        this.ConfigureType();
    }

    public void ConfigureType() {
        this.m_pRunThiefTexture = new CGTexture[3][4];
        this.m_pRunThiefTexture[0][0] = TextureManager.CreateTexture("/gameplay/thief_T_1.png");
        this.m_pRunThiefTexture[0][1] = TextureManager.CreateTexture("/gameplay/thief_T_1.png");
        this.m_pRunThiefTexture[0][2] = TextureManager.CreateTexture("/gameplay/thief_T_1.png");
        this.m_pRunThiefTexture[0][3] = TextureManager.CreateTexture("/gameplay/thief_T_1.png");
        this.m_pRunThiefTexture[1][0] = TextureManager.CreateTexture("/gameplay/thief_T_2.png");
        this.m_pRunThiefTexture[1][1] = TextureManager.CreateTexture("/gameplay/thief_T_2.png");
        this.m_pRunThiefTexture[1][2] = TextureManager.CreateTexture("/gameplay/thief_T_2.png");
        this.m_pRunThiefTexture[1][3] = TextureManager.CreateTexture("/gameplay/thief_T_2.png");
        this.m_pRunThiefTexture[2][0] = TextureManager.CreateTexture("/gameplay/thief_T_3.png");
        this.m_pRunThiefTexture[2][1] = TextureManager.CreateTexture("/gameplay/thief_T_3.png");
        this.m_pRunThiefTexture[2][2] = TextureManager.CreateTexture("/gameplay/thief_T_3.png");
        this.m_pRunThiefTexture[2][3] = TextureManager.CreateTexture("/gameplay/thief_T_3.png");
        String sName = "/gameplay/fant_" + (CGEngine.m_nCurrentWorld + 1) + "_" + this.m_nType + ".png";
        this.m_pJumpTextures = TextureManager.CreateTexture(sName);
        sName = "/gameplay/fant_" + (CGEngine.m_nCurrentWorld + 1) + "_" + this.m_nType + "_dead.png";
        this.m_pDeadTexture = new CGTexture[8];
        for (int i = 0; i < 8; ++i) {
            this.m_pDeadTexture[i] = TextureManager.CreateTexture(sName);
        }
        if (this.m_nType == 1) {
            this.m_fSpeedX = 80.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 200);
            this.m_fRadius = 60.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 1.0f;
        } else if (this.m_nType == 2) {
            this.m_fSpeedX = 80.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 200);
            this.m_fRadius = 32.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 2.0f;
        } else if (this.m_nType == 3) {
            this.m_fSpeedX = 80.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 200);
            this.m_fRadius = 30.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 3.0f;
        } else if (this.m_nType == 4) {
            this.m_fSpeedX = 80.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 200);
            this.m_fRadius = 45.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 1.0f;
        } else if (this.m_nType == 5) {
            this.m_fSpeedX = 85.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 250);
            this.m_fRadius = 45.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 2.0f;
        } else if (this.m_nType == 6) {
            this.m_fSpeedX = 90.0f + (float)(RandSync.nextInt() % 100);
            this.m_fSpeedY = -(400.0f + (float)(RandSync.nextInt() % 200));
            this.m_fCurrentG = 1200.0f + (float)(RandSync.nextInt() % 250);
            this.m_fRadius = 45.0f;
            this.m_fAngle = 0.0f;
            this.m_nKickNr = 3.0f;
        }
    }

    protected void Step(int nDeltaTimeInMs) {
        this.m_nStateTime += nDeltaTimeInMs;
        if (this.m_nState == 1) {
            this.HandleStartState();
        } else if (this.m_nState == 2) {
            this.HandleJumpState(nDeltaTimeInMs);
        } else if (this.m_nState == 3) {
            this.HandleDeadState(nDeltaTimeInMs);
        }
    }

    private void HandleStartState() {
        this.m_fPosX = m_RunSlotX[this.m_nPosType] + 200.0f * (float)this.m_nStateTime / 1000.0f;
        this.m_fPosY = m_RunSlotY[this.m_nPosType];
        if (this.m_fPosX >= m_SlotX[this.m_nPosType]) {
            this.m_fPosX = m_SlotX[this.m_nPosType];
            this.m_fPosY = m_SlotY[this.m_nPosType];
            this.m_nState = 2;
            this.m_nStateTime = 0;
        }
    }

    private void HandleDeadState(int nDeltaTimeInMs) {
        this.m_fAngle = 0.0f;
        this.m_nDeadTime -= nDeltaTimeInMs;
        if (this.m_nDeadTime < 0) {
            this.m_nState = 4;
            this.m_nStateTime = 0;
        }
    }

    private void HandleJumpState(int nDeltaTimeInMs) {
        if (this.m_nType == 1) {
            this.m_fAngle += 4.0f * (float)nDeltaTimeInMs / 1000.0f;
        } else if (this.m_nType == 2) {
            this.m_fAngle += 5.0f * (float)nDeltaTimeInMs / 1000.0f;
        } else if (this.m_nType == 3) {
            this.m_fAngle += 6.0f * (float)nDeltaTimeInMs / 1000.0f;
        } else if (this.m_nType == 4) {
            this.m_fAngle += 8.0f * (float)nDeltaTimeInMs / 1000.0f;
        } else if (this.m_nType == 5) {
            this.m_fAngle += 7.0f * (float)nDeltaTimeInMs / 1000.0f;
        } else if (this.m_nType == 6) {
            this.m_fAngle += 6.0f * (float)nDeltaTimeInMs / 1000.0f;
        }
        this.m_fLastPosX = this.m_fPosX;
        this.m_fLastPosY = this.m_fPosY;
        float t = (float)nDeltaTimeInMs / 1000.0f;
        this.m_fPosX += this.m_fSpeedX * t;
        this.m_fSpeedY += this.m_fCurrentG * t;
        this.m_fPosY += this.m_fSpeedY * t;
        if (this.m_fPosY > this.m_fLastPosY && PowerupManager.IsPowerup_Magnet() && (float)this.m_nKickCounter < this.m_nKickNr) {
            float fDeltaX = Math.abs(CGEngine.GetTrampoline().GetMiddleX() - this.m_fPosX);
            float fFactorY = Math.abs(this.m_fSpeedY * t) / Math.abs(CGEngine.GetTrampoline().GetTopY() - (this.m_fPosY - this.m_fSpeedY * t));
            if ((fDeltaX *= fFactorY) > this.m_fSpeedY * t) {
                fDeltaX = this.m_fSpeedY * t;
            }
            this.m_fPosX = CGEngine.GetTrampoline().GetMiddleX() > this.m_fPosX ? (this.m_fPosX += fDeltaX) : (this.m_fPosX -= fDeltaX);
        }
        if (this.m_fLastPosY + this.m_fRadius < 630.0f && this.m_fPosY + this.m_fRadius >= 630.0f) {
            if (CGEngine.GetTrampoline().IsGoodPlace(this.m_fPosX)) {
                this.m_fPosY = 630.0f - this.m_fRadius;
                this.m_fSpeedY = Math.abs(this.m_fSpeedY);
                this.m_fSpeedY = -(650.0f + (float)(RandSync.nextInt() % 350));
                this.m_fSpeedX = -10.0f + (float)(RandSync.nextInt() % 20);
                CGEngine.GetTrampoline().SetDeflection(12.0f);
                this.PlaySound_GreatJump();
                HitAnimationObject.NewItem(this.m_fPosX, this.m_fPosY, 1);
            }
        } else if (this.m_fLastPosY + this.m_fRadius < 670.0f && this.m_fPosY + this.m_fRadius >= 670.0f) {
            if (CGEngine.GetTrampoline().IsVeryGoodPlace(this.m_fPosX)) {
                this.m_fPosY = 670.0f - this.m_fRadius;
                ++this.m_nKickCounter;
                if ((float)this.m_nKickCounter >= this.m_nKickNr) {
                    this.m_fSpeedY = Math.abs(this.m_fSpeedY);
                    if (this.m_fPosX > (float)(ApplicationData.screenWidth / 2)) {
                        this.m_fSpeedX = 450.0f + (float)(RandSync.nextInt() % 100);
                        this.m_fSpeedY = -(550.0f + (float)(RandSync.nextInt() % 300));
                    } else {
                        this.m_fSpeedX = 650.0f + (float)(RandSync.nextInt() % 200);
                        this.m_fSpeedY = -(650.0f + (float)(RandSync.nextInt() % 300));
                    }
                    int n = this.m_nType;
                    CGLevelStats.m_nReflectionCounterByType[n] = CGLevelStats.m_nReflectionCounterByType[n] + 1;
                    ++CGLevelStats.m_nAllReflectionCounter;
                    ++CGLevelStats.m_nCurrentGoodReflectionCounter;
                    if (CGEngine.m_nCurrentGamingMode != 1 && CGEngine.m_nCurrentGamingMode != 2) {
                        if (this.m_nType == 1) {
                            CGDynamicObj.AddToCurrentDynamics("get_100.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        } else if (this.m_nType == 2) {
                            CGDynamicObj.AddToCurrentDynamics("get_150.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        } else if (this.m_nType == 3) {
                            CGDynamicObj.AddToCurrentDynamics("get_200.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        } else if (this.m_nType == 4) {
                            CGDynamicObj.AddToCurrentDynamics("get_100.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        } else if (this.m_nType == 5) {
                            CGDynamicObj.AddToCurrentDynamics("get_150.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        } else {
                            CGDynamicObj.AddToCurrentDynamics("get_200.do", this.m_fPosX, this.m_fPosY, 0.0f);
                        }
                        CGLevelStats.AddScore(m_arrScoreForItem[this.m_nType]);
                    }
                } else {
                    this.m_fSpeedY = Math.abs(this.m_fSpeedY);
                    this.m_fSpeedY = -(650.0f + (float)(RandSync.nextInt() % 350));
                    this.m_fSpeedX = -25.0f + (float)(RandSync.nextInt() % 50);
                }
                CGEngine.GetTrampoline().SetDeflection(12.0f);
                if (CGEngine.GetTrampoline().IsVeryGoodPlace(this.m_fPosX)) {
                    if (CGEngine.m_nCurrentGamingMode == 2 && !CGEngine.m_bGameOver) {
                        ++CGLevelStats.m_nMaxStreak;
                    }
                    this.PlaySound_GreatJump();
                    HitAnimationObject.NewItem(CGEngine.GetTrampoline().GetMiddleX(), CGEngine.GetTrampoline().GetTopY(), 1);
                } else {
                    this.PlaySound_Jump();
                    if (CGEngine.m_nCurrentGamingMode == 2 && !CGEngine.m_bGameOver) {
                        ++CGLevelStats.m_nMaxStreak;
                    }
                    HitAnimationObject.NewItem(CGEngine.GetTrampoline().GetMiddleX(), CGEngine.GetTrampoline().GetTopY(), 0);
                }
            }
        } else if (this.m_fPosY + this.m_fRadius >= 710.0f) {
            if (CGEngine.m_nCurrentGamingMode == 2 && (float)this.m_nKickCounter < this.m_nKickNr) {
                CGEngine.EventStreakModeLost(false);
            }
            this.m_fPosY = 710.0f - this.m_fRadius;
            this.m_nState = 3;
            this.m_nStateTime = 0;
            this.m_nDeadTime = 2000;
            this.PlaySound_Fall();
            CrashAnimationObject.NewItem(this.m_fPosX, this.m_fPosY);
            ++CGLevelStats.m_nAllBadReflectionCounter;
            CGLevelStats.m_nCurrentGoodReflectionCounter = 0;
        }
    }

    protected void PlaySound_Fall() {
        int nR = RandSync.nextInt() % 100;
        if (nR > 75) {
            CGSoundSystem.Play(9, false);
        } else if (nR > 50) {
            CGSoundSystem.Play(9, false);
        } else if (nR > 25) {
            CGSoundSystem.Play(9, false);
        } else {
            CGSoundSystem.Play(9, false);
        }
    }

    protected void PlaySound_GreatJump() {
        CGSoundSystem.Play(7, false);
    }

    protected void PlaySound_Jump() {
        CGSoundSystem.Play(7, false);
    }

    public boolean IsToDestroy() {
        return this.m_nState == 4;
    }

    public void Render() {
        if (this.m_nState == 1) {
            int nFrame = (int)(8.0f * (float)this.m_nStateTime / 500.0f);
            CGEngineRenderer.RenderThiefThingObject(this.m_pRunThiefTexture[this.m_nPosType][nFrame %= 4], this.m_fPosX, this.m_fPosY, 1.0f);
        } else if (this.m_nState == 2) {
            float fPosX = m_RunSlotX[this.m_nPosType] + 100.0f;
            float fPosY = m_RunSlotY[this.m_nPosType];
            int nFrame = 3;
            float fAlpha = (float)this.m_nStateTime / 500.0f;
            if (fAlpha > 1.0f) {
                fAlpha = 1.0f;
            }
            fAlpha = 1.0f - fAlpha;
            CGEngineRenderer.RenderThiefThingObject(this.m_pRunThiefTexture[this.m_nPosType][nFrame], fPosX, fPosY, fAlpha);
            CGEngineRenderer.RenderThingObject(this.m_pJumpTextures, this.m_fPosX, this.m_fPosY, this.m_fAngle);
        } else if (this.m_nState == 3) {
            int nFrame = this.m_nStateTime / 62;
            if (nFrame > 7) {
                nFrame = 7;
            }
            CGEngineRenderer.RenderThingObject(this.m_pDeadTexture[nFrame], this.m_fPosX, this.m_fPosY, this.m_fAngle);
        }
    }
}

