/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.GetPowerupAnimationObject;
import baltorogames.project_gameplay.PowerupManager;
import baltorogames.project_gameplay.SelectBoostScreen;

public class PowerupObject {
    public static final int eType_Shield = 0;
    public static final int eType_BigSize = 1;
    public static final int eType_Magnet = 2;
    public static final int eType_Money = 3;
    public static final int eType_Last = 4;
    public static final float eWidth = 48.0f;
    public static final float eHeight = 48.0f;
    public static final float eDefaultG = 1000.0f;
    public static final int eState_Jump = 1;
    public static final int eState_Over = 2;
    public int m_nState;
    public float m_fPosX;
    public float m_fPosY;
    public float m_fDirection;
    public float m_fLastPosX;
    public float m_fLastPosY;
    public float m_fSpeedX;
    public float m_fSpeedY;
    protected CGTexture m_pTexture;
    protected int m_nType;
    protected float m_fCurrentG;

    public void Destroy() {
    }

    public void Create(int nType) {
        this.m_fPosX = RandSync.nextInt() % 70;
        this.m_fPosY = -50.0f;
        this.m_fDirection = 1.0f;
        this.m_fSpeedX = this.m_fDirection * (float)(80 + RandSync.nextInt() % 80);
        this.m_fSpeedY = 0.0f;
        this.m_nState = 1;
        this.m_nType = nType;
        this.ConfigureType();
    }

    public void ConfigureType() {
        if (this.m_nType == 0) {
            this.m_fCurrentG = 450.0f + (float)(RandSync.nextInt() % 200);
            this.m_pTexture = TextureManager.CreateTexture("/gameplay/powerup_shield.png");
        } else if (this.m_nType == 1) {
            this.m_fCurrentG = 575.0f + (float)(RandSync.nextInt() % 200);
            this.m_pTexture = TextureManager.CreateTexture("/gameplay/powerup_bigsize.png");
        } else if (this.m_nType == 2) {
            this.m_fCurrentG = 575.0f + (float)(RandSync.nextInt() % 200);
            this.m_pTexture = TextureManager.CreateTexture("/gameplay/powerup_magnet.png");
        } else if (this.m_nType == 3) {
            this.m_fCurrentG = 575.0f + (float)(RandSync.nextInt() % 200);
            this.m_pTexture = TextureManager.CreateTexture("/gameplay/money.png");
        }
    }

    public void Step(int nDeltaTimeInMs) {
        if (this.m_nState == 1) {
            this.m_fLastPosX = this.m_fPosX;
            this.m_fLastPosY = this.m_fPosY;
            float t = (float)nDeltaTimeInMs / 1000.0f;
            this.m_fPosX += this.m_fSpeedX * t;
            this.m_fSpeedY += this.m_fCurrentG * t;
            this.m_fPosY += this.m_fSpeedY * t;
            if (this.m_fLastPosY < 670.0f && this.m_fPosY > 670.0f) {
                if (CGEngine.GetTrampoline().IsVeryGoodPlace(this.m_fPosX)) {
                    this.m_fPosY = 670.0f;
                    this.m_nState = 2;
                    this.PlaySound_GetPowerup();
                    if (this.m_nType == 0) {
                        PowerupManager.ActivatePowerup(0, 8000);
                    } else if (this.m_nType == 1) {
                        PowerupManager.ActivatePowerup(1, 8000);
                    } else if (this.m_nType == 2) {
                        if (SelectBoostScreen.isBoostSuperMagnerActivate()) {
                            PowerupManager.ActivatePowerup(2, 12000);
                        } else {
                            PowerupManager.ActivatePowerup(2, 8000);
                        }
                    } else if (this.m_nType == 3 && !CGEngine.m_bGameOver) {
                        ++CGLevelStats.m_nCoinsGathered;
                        ++CGUserCareer.m_nMoney;
                        CGDynamicObj.AddToCurrentDynamics("get_money.do", this.m_fPosX, this.m_fPosY, 0.0f);
                    }
                    GetPowerupAnimationObject.NewItem(this.m_fPosX, this.m_fPosY - 24.0f);
                    this.m_nState = 2;
                }
            } else if (this.m_fLastPosY < 710.0f && this.m_fPosY > 710.0f) {
                this.m_fPosY = 710.0f;
                this.m_nState = 2;
            }
        }
    }

    protected void PlaySound_GetPowerup() {
        CGSoundSystem.Play(3, false);
    }

    public void Render() {
        CGEngineRenderer.RenderPowerup(this.m_pTexture, this.m_fPosX, this.m_fPosY);
    }
}

