/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.PowerupObject;
import java.util.Vector;

public class PowerupManager {
    protected static Vector m_List = null;
    protected static int m_nNextSpawnTime;
    protected static int m_nTime;
    public static int m_nShieldCounter;
    protected static int m_nWhichInPacket;
    protected static int[] m_arrPowerupTime;

    public static void Init() {
        m_arrPowerupTime = new int[4];
        m_List = new Vector();
        m_nTime = 0;
        m_nNextSpawnTime = 10000;
    }

    public static int GetCurrentSize() {
        return m_List.size();
    }

    public static void Step(int nDeltaTimeInMs) {
        for (int i = 0; i < m_arrPowerupTime.length; ++i) {
            if (m_arrPowerupTime[i] <= 0) continue;
            int n = i;
            m_arrPowerupTime[n] = m_arrPowerupTime[n] - nDeltaTimeInMs;
            if (m_arrPowerupTime[i] >= 0) continue;
            PowerupManager.m_arrPowerupTime[i] = 0;
        }
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            PowerupObject po = (PowerupObject)m_List.elementAt(i);
            po.Step(nDeltaTimeInMs);
            if (po.m_nState != 2) continue;
            m_List.removeElementAt(i);
        }
        if (!CGEngine.m_bGameOver && (m_nTime += nDeltaTimeInMs) >= m_nNextSpawnTime) {
            if (CGEngine.m_nGameMode == 1) {
                if (m_nWhichInPacket == 0) {
                    PowerupManager.RandomPowerup();
                } else {
                    PowerupManager.NewPowerup(3);
                }
                int nR = RandSync.nextInt() % 10;
                if (nR > 4) {
                    m_nNextSpawnTime = 5000 + RandSync.nextInt() % 5000;
                    m_nWhichInPacket = 0;
                } else if (nR > 2) {
                    m_nNextSpawnTime = 1000 + RandSync.nextInt() % 500;
                    ++m_nWhichInPacket;
                } else {
                    m_nNextSpawnTime = 200 + RandSync.nextInt() % 200;
                    ++m_nWhichInPacket;
                }
            } else {
                PowerupManager.RandomPowerupSurvival();
                m_nNextSpawnTime = 5000 + RandSync.nextInt() % 5000;
                m_nWhichInPacket = 0;
            }
            m_nTime = 0;
        }
    }

    public static void RandomPowerup() {
        int nT = 3;
        int nR = RandSync.nextInt() % 100;
        if (CGEngine.m_nSpawnCounter < 40) {
            nT = nR < 30 ? 1 : (nR < 50 ? 0 : (nR < 60 ? 2 : 3));
        }
        nT = CGEngine.m_nSpawnCounter < 100 ? (nR < 20 ? 1 : (nR < 40 ? 0 : (nR < 70 ? 2 : 3))) : (nR < 20 ? 1 : (nR < 40 ? 0 : (nR < 60 ? 2 : 3)));
        PowerupManager.NewPowerup(nT);
    }

    public static void RandomPowerupSurvival() {
        int nT = 1;
        int nR = RandSync.nextInt() % 100;
        if (CGEngine.m_nSpawnCounter < 40) {
            nT = nR < 33 ? 0 : (nR < 66 ? 2 : 1);
        }
        nT = CGEngine.m_nSpawnCounter < 100 ? (nR < 33 ? 0 : (nR < 66 ? 2 : 1)) : (nR < 33 ? 0 : (nR < 66 ? 2 : 1));
        PowerupManager.NewPowerup(nT);
    }

    public static void Render() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            ((PowerupObject)m_List.elementAt(i)).Render();
        }
    }

    protected static void NewPowerup(int nType) {
        PowerupObject po = new PowerupObject();
        po.Create(nType);
        m_List.addElement(po);
    }

    public static void Reset() {
        m_List.removeAllElements();
        for (int i = 0; i < 4; ++i) {
            PowerupManager.m_arrPowerupTime[i] = 0;
        }
    }

    public static void ActivatePowerup(int nType, int nTime) {
        PowerupManager.m_arrPowerupTime[nType] = nTime;
        if (nType == 0) {
            m_nShieldCounter = 0;
        }
    }

    public static void DisactivatePowerup(int nType) {
        PowerupManager.m_arrPowerupTime[nType] = 0;
    }

    public static boolean IsPowerup_Shield() {
        return m_arrPowerupTime[0] > 0;
    }

    public static boolean IsPowerup_BigSize() {
        return m_arrPowerupTime[1] > 0;
    }

    public static boolean IsPowerup_Magnet() {
        return m_arrPowerupTime[2] > 0;
    }

    static {
        m_nShieldCounter = 0;
        m_nWhichInPacket = 0;
        m_arrPowerupTime = new int[4];
    }
}

