/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Log;
import baltorogames.core.RandSync;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.BombManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.CrashAnimationObject;
import baltorogames.project_gameplay.ExplodeAnimationObject;
import baltorogames.project_gameplay.FlyingScoreObject;
import baltorogames.project_gameplay.GetPowerupAnimationObject;
import baltorogames.project_gameplay.HitAnimationObject;
import baltorogames.project_gameplay.PowerupManager;
import baltorogames.project_gameplay.TrailObject;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.HudScreen;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.InputStream;

public class MyGame
extends Game {
    public WorldMap m_WorldMap = null;
    protected DataInputStream m_dis = null;
    public int m_nLoadingStepNr = 0;
    public int m_nLastTouchX = -1;
    public int m_nLastTouchY = -1;
    public int m_nLastFlickX = -1;
    public int m_nLastFlickY = -1;
    public static final int NUM_WAVES = 10;

    public int init() {
        CGUserCareer.Reset();
        CGUserCareer.Load();
        CGAchievements.Load();
        CGDynamicObj.Initialize();
        CGEngine.Init();
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/bomb.do", "bomb.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/bomb_explode.do", "bomb_explode.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/bomb_explode_ground.do", "bomb_explode_ground.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/get_money.do", "get_money.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/get_100.do", "get_100.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/get_150.do", "get_150.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/get_200.do", "get_200.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/get_powerup.do", "get_powerup.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/item_bounce.do", "item_bounce.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_shield.do", "pow_shield.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_magnes.do", "pow_magnes.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/item_trail.do", "item_trail.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/item_crash.do", "item_crash.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/item_bounce_center.do", "item_bounce_center.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_wider.do", "pow_wider.do");
        AchievementPopup.Init();
        BombManager.Init();
        PowerupManager.Init();
        TrailObject.Init();
        HitAnimationObject.Init();
        CrashAnimationObject.Init();
        GetPowerupAnimationObject.Init();
        ExplodeAnimationObject.Init();
        FlyingScoreObject.Initialize();
        RandSync.Init();
        RandSync.SetStartValue((int)System.currentTimeMillis() % 1000);
        return CGEngine.Init();
    }

    public void destroy() {
        CGDynamicObj.Uninitialize();
        CGUserCareer.Save();
        CGEngine.Destroy();
    }

    public int startLoading(String fileName) {
        TextureManager.ClearTextures();
        CGEngineRenderer.Init();
        this.m_dis = null;
        this.m_nLoadingStepNr = 0;
        return 1;
    }

    public int stepLoading(String fileName) {
        try {
            if (this.m_nLoadingStepNr == 0) {
                InputStream is = null;
                is = null;
                if (is == null) {
                    is = FileManager.OpenFile(fileName);
                }
                if (is == null) {
                    return 0;
                }
                this.m_dis = new DataInputStream(is);
                this.m_nLoadingStepNr = 1;
            } else if (this.m_nLoadingStepNr == 1) {
                if (this.m_dis != null) {
                    this.m_WorldMap = new WorldMap();
                    this.m_WorldMap.Load(this.m_dis);
                }
                this.m_nLoadingStepNr = 2;
            } else if (this.m_nLoadingStepNr == 2) {
                if (this.m_dis != null) {
                    CGEngine.Load1(this.m_dis);
                }
                this.m_nLoadingStepNr = 3;
            } else if (this.m_nLoadingStepNr == 3) {
                if (this.m_dis != null) {
                    CGEngine.Load2(this.m_dis);
                }
                this.m_nLoadingStepNr = 4;
            }
            return 1;
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Engine " + fileName + " loading error!!! - m_nLoadingStepNr = " + this.m_nLoadingStepNr);
            return 0;
        }
    }

    public int endLoading(String fileName) {
        UIScreen.SetNextScreen(new HudScreen());
        ApplicationData.setGameMode();
        ApplicationData.PlayMusicInGame();
        CGEngine.m_nTouchActive = false;
        CGEngine.m_fTouchX = -1000000.0f;
        CGEngine.m_fTouchY = -1000000.0f;
        Game.leftTouchKeyPressed = false;
        Game.rightTouchKeyPressed = false;
        return 1;
    }

    public void updateLogic(long deltaTimeInMs) {
        CGEngine.Update((int)deltaTimeInMs);
    }

    public void drawGamePlay() {
        CGEngineRenderer.Render();
        if (this.m_WorldMap != null) {
            this.m_WorldMap.Render(0, 6, 0, 100);
            CGEngine.RenderThings();
            this.m_WorldMap.Render(7, 9, 0, 100);
        }
        CGEngine.Render();
    }

    public void processTouchCommand(TouchCommand cmd) {
        if (CGEngine.m_bGameActive) {
            if (cmd.onPressed == 1 || cmd.onPressed == 3) {
                float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
                float fX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) / fViewModeScale;
                float fY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) / fViewModeScale;
                CGEngine.m_nTouchActive = true;
                CGEngine.m_fTouchX = fX;
                CGEngine.m_fTouchY = fY;
                if (cmd.areaX > ApplicationData.screenWidth / 2) {
                    Game.rightTouchKeyPressed = true;
                    Game.leftTouchKeyPressed = false;
                } else {
                    Game.leftTouchKeyPressed = true;
                    Game.rightTouchKeyPressed = false;
                }
            } else if (cmd.onPressed == 2) {
                float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
                float fX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) / fViewModeScale;
                float fY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) / fViewModeScale;
                float fDX = fX - CGEngine.m_fTouchX;
                float fDY = fY - CGEngine.m_fTouchY;
                if (!CGEngine.GetTrampoline().m_bAfterBomb && !CGEngine.m_bPause) {
                    CGEngine.GetTrampoline().SetPos(CGEngine.GetTrampoline().m_fPosX + fDX);
                }
                CGEngine.m_nTouchActive = true;
                CGEngine.m_fTouchX = fX;
                CGEngine.m_fTouchY = fY;
            } else {
                Game.leftTouchKeyPressed = false;
                Game.rightTouchKeyPressed = false;
            }
        }
    }

    public void processKeyCommand(KeyCommand cmd) {
    }
}

