/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGSoundSystem;
import java.util.Vector;

public class FlyingScoreObject {
    static final float TargetPosition1_X = 450.0f;
    static final float TargetPosition1_Y = 30.0f;
    static final float TargetPosition2_X = 30.0f;
    static final float TargetPosition2_Y = 750.0f;
    static final int eType_Money = 1;
    static final int eType_Score1 = 2;
    static final int eType_Score2 = 3;
    static final int eType_Score3 = 4;
    static final int eType_Score4 = 5;
    static final int eType_Score5 = 6;
    static final int eType_Score6 = 7;
    public float m_fStartX;
    public float m_fStartY;
    public float m_fStopX = 10.0f;
    public float m_fStopY = 10.0f;
    public float m_fCurrentX;
    public float m_fCurrentY;
    public int m_nTime = 1000000;
    public int m_nFullTime = 300;
    public int m_nType;
    CGDynamicObj m_pParticle;
    static Vector m_TmpVector = null;
    static Vector m_Vector = null;

    public static void Initialize() {
        m_TmpVector = new Vector();
        m_Vector = new Vector();
        for (int i = 0; i < 32; ++i) {
            FlyingScoreObject pH = new FlyingScoreObject();
            m_TmpVector.addElement(pH);
        }
    }

    public static void Reset() {
        int nS = m_Vector.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpVector.addElement(m_Vector.elementAt(i));
            }
            m_Vector.removeAllElements();
        }
    }

    public static void NewFlyingScore(float x, float y, int nType) {
        int nS = m_TmpVector.size();
        if (nS > 0) {
            FlyingScoreObject pH = (FlyingScoreObject)m_TmpVector.elementAt(nS - 1);
            m_TmpVector.removeElementAt(nS - 1);
            pH.Active(x, y, nType);
            m_Vector.addElement(pH);
        }
    }

    public static void StepAll(int nDeltaTimeInMs) {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            FlyingScoreObject pH = (FlyingScoreObject)m_Vector.elementAt(i);
            pH.Step(nDeltaTimeInMs);
            if (pH.m_nTime < 1000000) continue;
            m_Vector.removeElementAt(i);
            m_TmpVector.addElement(pH);
        }
    }

    public static void RenderAll() {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            ((FlyingScoreObject)m_Vector.elementAt(i)).Render();
        }
    }

    public void Init() {
        this.m_nTime = -1;
    }

    public void Active(float x, float y, int nT) {
        this.m_nTime = 0;
        this.m_nType = nT;
        if (this.m_nType == 1) {
            this.m_fStopX = 30.0f;
            this.m_fStopY = 750.0f;
            this.m_nFullTime = 600;
            this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_money.do", this.m_fStartX, this.m_fStartY, 0.0f);
        } else {
            this.m_fStopX = 450.0f;
            this.m_fStopY = 30.0f;
            this.m_nFullTime = 300;
            if (this.m_nType == 2) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_100.do", this.m_fStartX, this.m_fStartY, 0.0f);
            } else if (this.m_nType == 3) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_150.do", this.m_fStartX, this.m_fStartY, 0.0f);
            } else if (this.m_nType == 4) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_200.do", this.m_fStartX, this.m_fStartY, 0.0f);
            } else if (this.m_nType == 5) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_100.do", this.m_fStartX, this.m_fStartY, 0.0f);
            } else if (this.m_nType == 6) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_150.do", this.m_fStartX, this.m_fStartY, 0.0f);
            } else if (this.m_nType == 7) {
                this.m_pParticle = CGDynamicObj.AddToCurrentDynamics("get_200.do", this.m_fStartX, this.m_fStartY, 0.0f);
            }
        }
        this.m_fStartX = x;
        this.m_fStartY = y;
        CGSoundSystem.Play(8, false);
    }

    public void Disactive() {
        this.m_nTime = 1000000;
        if (this.m_pParticle != null) {
            CGDynamicObj.RemoveFromCurrentDynamics(this.m_pParticle, '\u0000');
            this.m_pParticle = null;
        }
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
        if (this.m_nTime < 0) {
            return;
        }
        if (this.m_nTime > this.m_nFullTime) {
            this.m_nTime = 1000000;
            return;
        }
        float fT = (float)this.m_nTime / (float)this.m_nFullTime;
        this.m_fCurrentX = this.m_fStartX + fT * (this.m_fStopX - this.m_fStartX);
        this.m_fCurrentY = this.m_fStartY + fT * (this.m_fStopY - this.m_fStartY);
    }

    public void Render() {
        if (this.m_nTime < 0) {
            return;
        }
        float fX = CGEngineRenderer.m_fScreenOffsetX + this.m_fCurrentX * CGEngine.m_fEngineScale;
        float fY = CGEngineRenderer.m_fScreenOffsetY + this.m_fCurrentY * CGEngine.m_fEngineScale;
        if (this.m_pParticle != null) {
            this.m_pParticle.SetPosition(fX, fY, 0.0f);
        }
    }
}

