/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectGameModeScreen;
import baltorogames.project_gui.SelectLevelScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectWorldScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int selectedWorld = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private CGTexture[] worldImages = null;
    private CGTexture lockTexture = null;
    private CGTexture coinsTexture = TextureManager.AddTexture("/menu/ico_cash.png");
    String strMoney;

    protected void Clean() {
        for (int i = 0; i < 5; ++i) {
            TextureManager.DeleteTexture(this.worldImages[i]);
            this.worldImages[i] = null;
        }
        this.worldImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.worldImages == null) {
            this.worldImages = new CGTexture[5];
            this.worldImages[0] = TextureManager.AddTexture("/menu/b_world_1.png");
            this.worldImages[1] = TextureManager.AddTexture("/menu/b_world_2.png");
            this.worldImages[2] = TextureManager.AddTexture("/menu/b_world_3.png");
            this.worldImages[3] = TextureManager.AddTexture("/menu/b_world_4.png");
            this.worldImages[4] = TextureManager.AddTexture("/menu/b_world_5.png");
        }
        this.lockTexture = TextureManager.AddTexture("/menu/b_world_locked.png");
    }

    public SelectWorldScreen() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SURVIVAL"));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.worldImages = new CGTexture[5];
        this.worldImages[0] = TextureManager.AddTexture("/menu/b_world_1.png");
        this.worldImages[1] = TextureManager.AddTexture("/menu/b_world_2.png");
        this.worldImages[2] = TextureManager.AddTexture("/menu/b_world_3.png");
        this.worldImages[3] = TextureManager.AddTexture("/menu/b_world_4.png");
        this.worldImages[4] = TextureManager.AddTexture("/menu/b_world_5.png");
        this.lockTexture = TextureManager.AddTexture("/menu/b_world_locked.png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - 2 * this.worldImages[0].GetHeight() / 3;
        int arrowsY = trackIconY + this.worldImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2 - ObjectsCache.arrowLeft.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + this.worldImages[0].GetWidth() / 2;
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.nStartBoxY = ApplicationData.screenHeight / 2 + ApplicationData.getFontByID(0).getFontHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        boolean unlocked;
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString(" " + (this.selectedWorld + 1));
        int nFirstLevel = this.selectedWorld * 9;
        boolean bl = unlocked = CGUserCareer.m_arrLevelScore[nFirstLevel] >= 0;
        if (unlocked) {
            this.infoBox.setText("");
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            if (nFirstLevel == 9) {
                this.infoBox.setText(ApplicationData.defaultFont.encodeDynamicString("$" + CGUserCareer.m_arrCashToUnlockWorld[1]) + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CASH_TO_UNLOCK"));
            } else if (nFirstLevel == 18) {
                this.infoBox.setText(ApplicationData.defaultFont.encodeDynamicString("$" + CGUserCareer.m_arrCashToUnlockWorld[2]) + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CASH_TO_UNLOCK"));
            } else if (nFirstLevel == 27) {
                this.infoBox.setText(ApplicationData.defaultFont.encodeDynamicString("$" + CGUserCareer.m_arrCashToUnlockWorld[3]) + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CASH_TO_UNLOCK"));
            } else if (nFirstLevel == 36) {
                this.infoBox.setText(ApplicationData.defaultFont.encodeDynamicString("$" + CGUserCareer.m_arrCashToUnlockWorld[4]) + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CASH_TO_UNLOCK"));
            }
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
    }

    public void autoSize() {
    }

    public void draw() {
        int trackIconX = ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - 2 * this.worldImages[0].GetHeight() / 3;
        this.strMoney = ApplicationData.defaultFont.encodeDynamicString(" " + CGUserCareer.m_nMoney);
        Graphic2D.DrawImage(this.worldImages[this.selectedWorld], trackIconX, trackIconY, 20);
        boolean unlocked = CGUserCareer.IsSurvivalLevelAvailable(this.selectedWorld);
        if (!unlocked) {
            Graphic2D.DrawImage(this.lockTexture, trackIconX, trackIconY, 20);
        }
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        this.infoBox.draw();
        Graphic2D.DrawImage(this.coinsTexture, ApplicationData.screenWidth / 2, trackIconY + this.worldImages[this.selectedWorld].GetHeight() + 3 * ApplicationData.getFontByID(0).getFontHeight(), 17);
        Utils.drawString(this.strMoney + ApplicationData.defaultFont.encodeDynamicString("$"), ApplicationData.screenWidth / 2 + this.coinsTexture.GetWidth(), trackIconY + this.worldImages[this.selectedWorld].GetHeight() + 3 * ApplicationData.getFontByID(0).getFontHeight() + this.coinsTexture.GetHeight() / 2, 6, 0);
    }

    public boolean rightSoftButton() {
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        UIScreen.SetNextScreen(new SelectGameModeScreen());
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        boolean unlocked = CGUserCareer.IsSurvivalLevelAvailable(this.selectedWorld);
        if (!unlocked) {
            return true;
        }
        CGSoundSystem.Play(2, false);
        CGEngine.m_nGameMode = 1;
        CGEngine.m_nCurrentWorld = this.selectedWorld;
        UIScreen.SetNextScreen(new SelectLevelScreen(0));
        UIScreen.GetNextScreen().setParent(this);
        this.readyForClose = true;
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.selectedWorld;
        if (this.selectedWorld >= 5) {
            this.selectedWorld = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.selectedWorld;
        if (this.selectedWorld < 0) {
            this.selectedWorld = 4;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

