/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gui.AbortGameTB;
import baltorogames.project_gui.ConfirmRestart;
import baltorogames.project_gui.HelpMenu;
import baltorogames.project_gui.HudScreen;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class InGameMainMenu
extends MainListAnimated {
    private boolean m_bWasPause;

    public void updateSize() {
        this.wndAreaHeight = 240;
        int topOfClientArea = ApplicationData.screenHeight - 40 - this.wndAreaHeight;
        this.positionX = 0;
        this.positionY = topOfClientArea;
        this.width = ApplicationData.screenWidth;
        this.height = this.wndAreaHeight;
    }

    public InGameMainMenu() {
        this.m_bModalScreen = false;
        this.drawTop = false;
        this.drawTitle = false;
        this.m_bWasPause = CGEngine.m_bPause;
        CGEngine.m_bPause = true;
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESUME"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESTART"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HELP"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_OPTIONS"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_QUIT"));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HEADER_PAUSE"));
    }

    public void drawWindowBackground() {
        this.drawBottom = false;
        if (ObjectsCache.menuBackground != null) {
            // empty if block
        }
        if (this.drawTitle && ObjectsCache.gameLogo != null) {
            Graphic2D.DrawImage(ObjectsCache.gameLogo, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 20, 17);
        }
        if (this.drawBottom) {
            // empty if block
        }
    }

    public void onFocusBack() {
        super.onFocusBack();
        this.currentItem = 0;
    }

    public void currentItemChanged(int oldId, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
        switch (currentItemId) {
            case 0: {
                CGSoundSystem.Play(2, false);
                if (this.getParent() == null) {
                    this.setParent(new HudScreen());
                }
                UIScreen.SetNextScreen(null);
                this.readyForClose = true;
                CGEngine.m_bPause = this.m_bWasPause;
                break;
            }
            case 1: {
                CGSoundSystem.Play(2, false);
                UIScreen.SetNextScreen(new ConfirmRestart());
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
                break;
            }
            case 2: {
                CGSoundSystem.Play(2, false);
                UIScreen.SetNextScreen(new HelpMenu());
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
                break;
            }
            case 3: {
                CGSoundSystem.Play(2, false);
                UIScreen.SetNextScreen(new Options());
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
                break;
            }
            case 4: {
                CGSoundSystem.Play(2, false);
                UIScreen.SetNextScreen(new AbortGameTB());
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
            }
        }
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        this.currentItemSelected(nID - 1000);
        return true;
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }
}

