/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;

public class UIAnimatedButtonV
extends UIButton {
    private int animRange = 3;
    private float animDir = 1.0f;

    public UIAnimatedButtonV() {
    }

    public void setAnimDir(float f) {
        this.animDir = f;
    }

    public UIAnimatedButtonV(int l, int t, int r, int b, int bID) {
        this.top = t - this.animRange;
        this.left = l;
        this.bottom = b + this.animRange;
        this.right = r;
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonV(int l, int t, String csNormalTexture, String csSelectTexture, int bID) {
        this.buttonID = bID;
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.top = t - this.animRange;
        this.left = l;
        this.bottom = this.top + this.textures[0].GetHeight() + 2 * this.animRange;
        this.right = this.left + this.textures[0].GetWidth();
        this.buttonID = bID;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIAnimatedButtonV(int l, int t, CGTexture NormalTexture, CGTexture SelectTexture, int bID) {
        this.buttonID = bID;
        this.top = t - this.animRange;
        this.left = l;
        if (NormalTexture != null && SelectTexture != null) {
            this.textures = new CGTexture[2];
            this.textures[0] = NormalTexture;
            this.textures[1] = SelectTexture;
            this.bottom = this.top + this.textures[0].GetHeight() + 2 * this.animRange;
            this.right = this.left + this.textures[0].GetWidth();
        } else {
            this.textures = null;
            this.bottom = this.top + 10 + 2 * this.animRange;
            this.right = this.left + 10;
        }
        this.buttonID = bID;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public void setPosition(int l, int t, int r, int b) {
        this.top = t - this.animRange;
        this.left = l;
        this.bottom = b + this.animRange;
        this.right = r;
    }

    public void setPosition(int l, int t) {
        int w = this.right - this.left;
        int h = this.bottom - this.top;
        this.top = t - this.animRange;
        this.left = l;
        this.bottom = this.top + h;
        this.right = this.left + w;
    }

    public void setLeft(int l) {
        int w = this.right - this.left;
        this.left = l;
        this.right = this.left + w;
    }

    public void setTop(int t) {
        int h = this.bottom - this.top;
        this.top = t - this.animRange;
        this.bottom = this.top + h;
    }

    public void setTextures(CGTexture NormalTexture, CGTexture SelectTexture) {
        this.textures = new CGTexture[2];
        this.textures[0] = NormalTexture;
        this.textures[1] = SelectTexture;
        this.bottom = this.top + this.textures[0].GetHeight() + 2 * this.animRange;
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setTextures(String csNormalTexture, String csSelectTexture) {
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(csNormalTexture);
        this.textures[1] = TextureManager.AddTexture(csSelectTexture);
        this.bottom = this.top + this.textures[0].GetHeight() + 2 * this.animRange;
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void draw() {
        if (this.isVisible) {
            int xOffset = (int)((double)(this.animDir * (float)this.animRange) * Math.sin(5.0f * this.ownScreen.getLifeTime()));
            int curTop = this.top + this.animRange + xOffset;
            if (!this.isSelected && this.textures[0] != null) {
                Graphic2D.DrawImage(this.textures[0], this.left, curTop, 20);
            } else if (this.isSelected && this.textures[1] != null) {
                Graphic2D.DrawImage(this.textures[1], this.left, curTop, 20);
            }
            if (this.caption != null && this.caption.length() > 0) {
                Utils.drawString(this.caption, (this.left + this.right) / 2, (curTop + this.bottom) / 2, 3, this.fontID);
            }
        }
    }
}

