/*
 * Decompiled with CFR 0.152.
 */
public class ClothingItem
extends GameProperty {
    public static final int STATE_HANGER = 1;
    public static final int STATE_MODEL = 2;
    public static final int STATE_MODEL_BLINK = 3;
    public static final int TYPE_TOP = 1;
    public static final int TYPE_BOTTOM = 2;
    public static final int TYPE_SHOES = 3;
    public static final int TYPE_MAX = 4;
    public static final int GENDER_FEMALE = 1024;
    public static final int GENDER_MALE = 2048;
    public static final int TYPE_FLAGS = 31;
    public int mState = 1;
    GameObject hanger;
    GameObject model;
    UiListener mListener;
    boolean positionChanged = false;
    public int mType;
    public short mClothId;

    BaseObject createCopy(BaseObject baseObject) {
        ClothingItem clothingItem = (ClothingItem)baseObject;
        if (clothingItem != null) {
            clothingItem = new ClothingItem(this.mType, this.mClothId);
        }
        clothingItem.mState = this.mState;
        clothingItem.mType = this.mType;
        clothingItem.mClothId = this.mClothId;
        return clothingItem;
    }

    byte getType() {
        return (byte)(this.mType & 0x1F);
    }

    ClothingItem(int n, short s) {
        this.mType = n;
        this.mClothId = s;
        this.mHashType = (byte)12;
    }

    boolean isDress() {
        Cloth cloth = Cloth.getClothById(this.mClothId);
        cloth.listAttr();
        return cloth.hasAttribute(0);
    }

    void checkState(GameObject gameObject) {
        if (this.hanger == null) {
            this.model = gameObject.getChildByHashName((byte)29);
            this.hanger = gameObject.getChildByHashName((byte)28);
        }
        if (this.hanger != null) {
            switch (this.mState) {
                case 1: {
                    this.hanger.enable(true);
                    this.hanger.visible(true);
                    this.model.enable(false);
                    this.model.visible(false);
                    break;
                }
                case 2: {
                    this.hanger.enable(false);
                    this.hanger.visible(false);
                    this.model.enable(true);
                    this.model.visible(true);
                    break;
                }
                case 3: {
                    this.hanger.enable(false);
                    this.hanger.visible(false);
                    this.model.enable(true);
                    this.model.visible(true);
                }
            }
        }
    }

    ClothingItem setListener(UiListener uiListener) {
        this.mListener = uiListener;
        return this;
    }

    void setState(GameObject gameObject, int n) {
        this.mState = n;
        this.checkState(gameObject);
        GameProperty gameProperty = gameObject.getPropertyByHashType((byte)38);
        switch (this.mState) {
            case 3: {
                if (gameProperty != null) break;
                gameObject.addProperty(new BlinkOnFocus(true));
                break;
            }
            default: {
                if (gameProperty == null) break;
                gameProperty.destroy();
            }
        }
    }

    void onInit(GameObject gameObject) {
        this.checkState(gameObject);
    }

    void onUpdate(GameObject gameObject) {
        this.checkState(gameObject);
        if (this.mState == 3) {
            int n;
            if (this.mListener != null && (n = GameState.getInstance().keyClicked) != 0) {
                this.mListener.onMessage(gameObject, n);
            }
        } else if (this.mState == 1 && GameCanvas.HEIGHT < 320) {
            GameSprite gameSprite = GameSprite.getSprite(this.hanger);
            int n = gameSprite.mAnchor;
            gameSprite.mAnchor = gameObject.mParent.hasFocus() ? 3 : 0x10 | 1;
            if (n != gameSprite.mAnchor) {
                gameSprite.reposition();
            }
        }
    }

    void onFocus(GameObject gameObject) {
    }

    void onFocusStart(GameObject gameObject) {
    }

    void onFocusEnd(GameObject gameObject) {
    }
}

