/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameText
extends GameDrawable {
    public static final int DEFAULT_ANCHOR = 65;
    public static final byte DEFAULT_FONT = 0;
    public int mAnchor;
    public Vector2i position = new Vector2i();
    public Vector2i refPosition = new Vector2i();
    public String mText;
    public byte[] mTextByte;
    public byte font = 0;
    public int width = -1;
    public int height = -1;
    public byte scroll = 0;
    public int lastFlags = 0;
    public Vector textVector;
    public boolean needScroll;
    public boolean dirty;
    public boolean autoLoop;
    public boolean autoLoopDirection;
    public boolean scrollX;
    public static long gLastTimeClicked;

    BaseObject createCopy(BaseObject baseObject) {
        GameText gameText = (GameText)baseObject;
        if (gameText == null) {
            gameText = new GameText();
        }
        gameText.mText = this.mText;
        gameText.mAnchor = this.mAnchor;
        gameText.position.set(this.position);
        gameText.refPosition.set(this.refPosition);
        return gameText;
    }

    void onInit(GameObject gameObject) {
        gLastTimeClicked = System.currentTimeMillis();
    }

    GameText(String string, byte by, int n, int n2, int n3, int n4) {
        this.mHashType = (byte)14;
        this.mText = string;
        if ((n2 & 0x40) != 0) {
            n2 |= 0x40;
            n2 ^= 0x40;
            n2 |= 2;
        }
        this.mAnchor = n2;
        this.refPosition.x = n3;
        this.refPosition.y = n4;
        this.font = by;
        this.dirty = true;
    }

    GameText(String string, byte by, int n, int n2) {
        this(string, by, n, n2, 0, 0);
    }

    GameText(String string, byte by, int n) {
        this(string, by, n, 65);
    }

    GameText(String string, byte by) {
        this(string, by, 0);
    }

    GameText(String string) {
        this(string, 0);
    }

    GameText() {
        this(null);
    }

    void onDestroy(GameObject gameObject) {
        super.onDestroy(gameObject);
        this.mText = null;
    }

    void recalc() {
        this.mTextByte = GameState.gFonts[this.font].getFromString(this.mText);
        if (this.height > 0) {
            int n;
            byte[] byArray;
            int n2;
            if (this.width > 0) {
                GameState.gFonts[this.font].doLinebreaks(this.mTextByte, this.width);
            }
            this.textVector = new Vector();
            int n3 = 4;
            for (n2 = 4; n2 < this.mTextByte.length; ++n2) {
                if (this.mTextByte[n2] != 10 && this.mTextByte[n2] != 13) continue;
                if (n2 > n3) {
                    byArray = new byte[n2 - n3 + 4];
                    for (n = 0; n < n2 - n3; ++n) {
                        byArray[n + 4] = this.mTextByte[n3 + n];
                    }
                    this.textVector.addElement(byArray);
                } else {
                    this.textVector.addElement(null);
                }
                n3 = n2 + 1;
            }
            if (n3 != n2) {
                byArray = new byte[n2 - n3 + 4];
                for (n = 0; n < n2 - n3; ++n) {
                    byArray[n + 4] = this.mTextByte[n3 + n];
                }
                this.textVector.addElement(byArray);
            }
            if (this.height > 0 && this.textVector.size() * GameState.gFonts[this.font].getHeight() >= this.height) {
                this.needScroll = true;
            }
            this.mTextByte = null;
        } else if (this.width > 0 && !this.scrollX) {
            GameState.gFonts[this.font].doLinebreaks(this.mTextByte, this.width);
        }
        this.dirty = false;
    }

    void onUpdate(GameObject gameObject) {
        if (this.autoLoop) {
            if (this.autoLoopDirection) {
                if ((this.lastFlags & 0x400000) != 0) {
                    this.scroll = (byte)(this.scroll + 1);
                } else {
                    this.autoLoopDirection = false;
                }
            } else {
                this.scroll = (byte)Math.max(0, this.scroll - 1);
                if (this.scroll == 0) {
                    this.autoLoopDirection = true;
                }
            }
        }
    }

    GameText setAutoLoop(boolean bl) {
        this.autoLoop = bl;
        this.autoLoopDirection = true;
        return this;
    }

    void onFocus(GameObject gameObject) {
        boolean bl;
        boolean bl2 = bl = System.currentTimeMillis() - gLastTimeClicked > 100L;
        if (GameState.getInstance().keyPressed == 4 && bl || GameState.getInstance().keyClicked == 4) {
            if ((this.lastFlags & 0x400000) != 0) {
                this.scroll = (byte)(this.scroll + 1);
            }
            gLastTimeClicked = System.currentTimeMillis();
        } else if (GameState.getInstance().keyPressed == 3 && bl || GameState.getInstance().keyClicked == 3) {
            this.scroll = (byte)Math.max(0, this.scroll - 1);
            gLastTimeClicked = System.currentTimeMillis();
        }
        GameObject gameObject2 = gameObject.mParent.getChildByHashName((byte)41);
        GameObject gameObject3 = gameObject.mParent.getChildByHashName((byte)42);
        if (gameObject2 != null && gameObject3 != null) {
            if (this.scroll > 0) {
                gameObject2.visible(true);
            } else {
                gameObject2.visible(false);
            }
            if ((this.lastFlags & 0x400000) != 0) {
                gameObject3.visible(true);
            } else {
                gameObject3.visible(false);
            }
        }
    }

    void onPaint(GameObject gameObject, Graphics graphics) {
        int n = 0;
        int n2 = 0;
        this.position.set(gameObject.getGlobalXY().x + this.refPosition.x + n, gameObject.getGlobalXY().y + this.refPosition.y + n2);
        if (this.dirty) {
            this.recalc();
        }
        if (this.height > 0 && this.width > 0) {
            int n3 = this.position.x;
            int n4 = this.position.y;
            int n5 = this.mAnchor;
            int n6 = GameState.gFonts[this.font].getHeight();
            if ((this.mAnchor & 2) != 0) {
                n5 |= 2;
                n5 ^= 2;
                n5 |= 0x10;
                n4 = this.needScroll ? (n4 -= this.height / 2) : (n4 -= this.textVector.size() * GameState.gFonts[this.font].getHeight() / 2);
            } else if ((this.mAnchor & 0x10) != 0) {
                n4 -= this.height / 2;
            } else if ((this.mAnchor & 0x20) != 0) {
                n5 |= 0x20;
                n5 ^= 0x20;
                n5 |= 0x10;
                n4 += this.height / 2 - this.textVector.size() * GameState.gFonts[this.font].getHeight();
            }
            if ((this.mAnchor & 4) != 0) {
                n3 -= this.width >> 1;
            }
            int n7 = n4 + this.height - (n6 >> 1);
            this.lastFlags = 0;
            for (int i = this.scroll; i < this.textVector.size(); ++i) {
                byte[] byArray = (byte[])this.textVector.elementAt(i);
                if (byArray != null) {
                    GameState.gFonts[this.font].drawText(graphics, byArray, n3, n4, -1, -1, 0, n5);
                }
                if ((n4 += n6) < n7) continue;
                if (i != this.textVector.size() - 1) {
                    this.lastFlags = 0x400000;
                }
                break;
            }
        } else if (this.width > 0) {
            if (this.scrollX) {
                int n8 = GameState.gFonts[this.font].getWidth(this.mTextByte);
                if (n8 > this.width) {
                    int n9 = graphics.getClipX();
                    int n10 = graphics.getClipY();
                    int n11 = graphics.getClipWidth();
                    int n12 = graphics.getClipHeight();
                    int n13 = this.position.x;
                    int n14 = n10;
                    int n15 = this.width;
                    int n16 = n12;
                    int n17 = n8 - this.width + n8 / 10;
                    int n18 = n17 < 10 ? 1000 : n17 * 100;
                    int n19 = (int)Math.abs(System.currentTimeMillis() % (long)(n18 << 1) - (long)n18);
                    if ((this.mAnchor & 1) != 0) {
                        n13 -= this.width >> 1;
                        n19 -= n18 / 2;
                    } else if ((this.mAnchor & 8) != 0) {
                        n13 -= this.width;
                    } else {
                        n19 = -n19;
                    }
                    n17 *= n19;
                    graphics.setClip(n13, n14, n15, n16);
                    GameState.gFonts[this.font].drawText(graphics, this.mTextByte, this.position.x + (n17 /= n18), this.position.y, -1, -1, 0, this.mAnchor);
                    graphics.setClip(n9, n10, n11, n12);
                } else {
                    GameState.gFonts[this.font].drawText(graphics, this.mTextByte, this.position.x, this.position.y, -1, -1, 0, this.mAnchor);
                }
            } else {
                GameState.gFonts[this.font].drawText(graphics, this.mTextByte, this.position.x, this.position.y, -1, -1, 0, this.mAnchor);
            }
        } else {
            GameState.gFonts[this.font].drawText(graphics, this.mTextByte, this.position.x, this.position.y, -1, -1, 0, this.mAnchor);
        }
    }

    void changeText(String string) {
        this.mText = string;
        this.dirty = true;
    }

    GameText setWidth(int n) {
        this.dirty = true;
        this.width = n;
        return this;
    }

    GameText setHeight(int n) {
        this.dirty = true;
        this.height = n;
        return this;
    }

    GameText setScrollX(boolean bl) {
        this.scrollX = true;
        this.dirty = true;
        return this;
    }

    static GameText getGameText(GameObject gameObject) {
        return (GameText)gameObject.getPropertyByHashType((byte)14);
    }
}

