/*
 * Decompiled with CFR 0.152.
 */
public class BlinkOnFocus
extends GameProperty {
    public boolean wasVisible;
    int frame = -1;
    boolean blinkOnUpdate = false;

    BaseObject createCopy(BaseObject baseObject) {
        BlinkOnFocus blinkOnFocus = (BlinkOnFocus)baseObject;
        if (blinkOnFocus != null) {
            blinkOnFocus = new BlinkOnFocus();
        }
        return blinkOnFocus;
    }

    BlinkOnFocus(boolean bl) {
        this.blinkOnUpdate = bl;
        this.mHashType = (byte)38;
    }

    BlinkOnFocus() {
        this(false);
    }

    void onInit(GameObject gameObject) {
        if (this.blinkOnUpdate) {
            this.setFocusStart(gameObject);
        }
    }

    void onUpdate(GameObject gameObject) {
        if (this.blinkOnUpdate) {
            if (this.frame++ % 10 < 3) {
                gameObject.visible(false);
            } else {
                gameObject.visible(this.wasVisible);
            }
        }
    }

    void onFocus(GameObject gameObject) {
        if (!this.blinkOnUpdate) {
            if (this.frame++ % 10 < 3) {
                gameObject.visible(false);
            } else {
                gameObject.visible(this.wasVisible);
            }
        }
    }

    void onFocusStart(GameObject gameObject) {
        this.setFocusStart(gameObject);
    }

    void onFocusEnd(GameObject gameObject) {
        this.setFocusEnd(gameObject);
    }

    void setFocusStart(GameObject gameObject) {
        this.frame = 0;
        this.wasVisible = false;
        if ((gameObject.mFlags & 8) != 0) {
            this.wasVisible = true;
        }
    }

    void setFocusEnd(GameObject gameObject) {
        gameObject.visible(true);
    }

    void onDestroy(GameObject gameObject) {
        super.onDestroy(gameObject);
        if (this.blinkOnUpdate) {
            this.setFocusEnd(gameObject);
        }
    }

    static BlinkOnFocus getBlinkOnFocus(GameObject gameObject) {
        return (BlinkOnFocus)gameObject.getPropertyByHashType((byte)38);
    }
}

