/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class GameObject
extends BaseObject {
    Vector2i localPos = new Vector2i();
    Vector2i globalPos = new Vector2i();
    public GameObject mParent = null;
    public GameObject mNext = null;
    public GameObject mChild = null;
    public GameProperty mProperty = null;
    byte mHashName;

    void onInit() {
        this.localPos.x = 0;
        this.localPos.y = 0;
        this.globalPos.x = 0;
        this.globalPos.y = 0;
    }

    BaseObject createCopy(BaseObject baseObject) {
        BaseObject baseObject2;
        GameObject gameObject = (GameObject)baseObject;
        if (gameObject == null) {
            gameObject = new GameObject();
        }
        gameObject.mHashName = this.mHashName;
        gameObject.localPos.x = this.localPos.x;
        gameObject.localPos.y = this.localPos.y;
        gameObject.globalPos.x = this.globalPos.x;
        gameObject.globalPos.y = this.globalPos.y;
        gameObject.mFlags = this.mFlags;
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            baseObject2 = (GameProperty)gameProperty.createCopy(null);
            gameObject.addProperty((GameProperty)baseObject2);
            gameProperty = gameProperty.mNext;
        }
        baseObject2 = this.mChild;
        while (baseObject2 != null) {
            GameObject gameObject2 = (GameObject)((GameObject)baseObject2).createCopy(null);
            gameObject.addChild(gameObject2);
            baseObject2 = ((GameObject)baseObject2).mNext;
        }
        return gameObject;
    }

    GameObject createCopyyy(GameObject gameObject) {
        BaseObject baseObject;
        GameObject gameObject2 = gameObject;
        if (gameObject2 == null) {
            gameObject2 = new GameObject();
        }
        gameObject2.mHashName = this.mHashName;
        gameObject2.localPos.x = this.localPos.x;
        gameObject2.localPos.y = this.localPos.y;
        gameObject2.globalPos.x = this.globalPos.x;
        gameObject2.globalPos.y = this.globalPos.y;
        gameObject2.mFlags = this.mFlags;
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            baseObject = (GameProperty)gameProperty.createCopy(null);
            gameObject2.addProperty((GameProperty)baseObject);
            gameProperty = gameProperty.mNext;
        }
        baseObject = this.mChild;
        while (baseObject != null) {
            GameObject gameObject3 = (GameObject)((GameObject)baseObject).createCopy(null);
            gameObject2.addChild(gameObject3);
            baseObject = ((GameObject)baseObject).mNext;
        }
        return gameObject2;
    }

    void onDestroy() {
        BaseObject baseObject;
        if (this.isFlag(2048)) {
            Tools.println("deleted already");
            return;
        }
        this.setFlag(2);
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            baseObject = gameProperty.mNext;
            gameProperty.onDestroy(this);
            gameProperty = baseObject;
        }
        baseObject = this.mChild;
        while (baseObject != null) {
            GameObject gameObject = ((GameObject)baseObject).mNext;
            ((GameObject)baseObject).onDestroy();
            baseObject = gameObject;
        }
        this.mChild = null;
        this.mProperty = null;
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
        this.setFlag(2048);
    }

    GameObject() {
        this(0);
    }

    GameObject(byte by) {
        this.mHashName = by;
        this.mParent = null;
        this.onInit();
    }

    GameObject getChildByHashName(byte by) {
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            if (gameObject.mHashName == by) {
                return gameObject;
            }
            gameObject = gameObject.mNext;
        }
        return null;
    }

    GameObject getChildTreeByHashName(byte by) {
        GameObject gameObject = this.getChildByHashName(by);
        if (gameObject != null) {
            return gameObject;
        }
        GameObject gameObject2 = this.mChild;
        while (gameObject2 != null) {
            gameObject = gameObject2.getChildTreeByHashName(by);
            if (gameObject != null) {
                return gameObject;
            }
            gameObject2 = gameObject2.mNext;
        }
        return null;
    }

    GameObject getChildByHashName(byte by, Vector vector) {
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            if (gameObject.mHashName == by) {
                vector.addElement(gameObject);
            }
            gameObject = gameObject.mNext;
        }
        return null;
    }

    GameObject getChildTreeByHashName(byte by, Vector vector) {
        this.getChildByHashName(by, vector);
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            gameObject.getChildTreeByHashName(by, vector);
            gameObject = gameObject.mNext;
        }
        return null;
    }

    public GameProperty getPropertyByHashType(byte by) {
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            if (gameProperty.mHashType == by) {
                return gameProperty;
            }
            gameProperty = gameProperty.mNext;
        }
        return null;
    }

    public GameObject addChild(GameObject gameObject) {
        return this.addChild(gameObject, false, null);
    }

    public GameObject addChild(GameObject gameObject, boolean bl, GameObject gameObject2) {
        if (gameObject.mParent != null) {
            Tools.println("addChild go.mParent != null remember to remove it from the parent first!!!");
            gameObject.mParent.removeChild(gameObject);
        }
        gameObject.makeDirty();
        gameObject.makeDirtyFocus();
        gameObject.mParent = this;
        if (this.mChild == null) {
            this.mChild = gameObject;
        } else if (bl) {
            if (gameObject2 != null) {
                gameObject.mNext = gameObject2.mNext;
                gameObject2.mNext = gameObject;
            } else {
                gameObject.mNext = this.mChild;
                this.mChild = gameObject;
            }
        } else if (gameObject2 != null) {
            GameObject gameObject3 = this.getPrevChild(gameObject2);
            if (gameObject3 == null) {
                this.mChild = gameObject;
            } else {
                gameObject3.mNext = gameObject;
            }
            gameObject.mNext = gameObject2;
        } else {
            GameObject gameObject4 = this.mChild;
            while (gameObject4 != null) {
                if (gameObject4.mNext == null) {
                    gameObject.mNext = null;
                    gameObject4.mNext = gameObject;
                    break;
                }
                gameObject4 = gameObject4.mNext;
            }
        }
        return gameObject;
    }

    public void removeChild(GameObject gameObject) {
        GameObject gameObject2 = this.mChild;
        GameObject gameObject3 = null;
        while (gameObject2 != null) {
            if (gameObject2 == gameObject) {
                if (gameObject3 == null) {
                    this.mChild = gameObject2.mNext;
                } else {
                    gameObject3.mNext = gameObject2.mNext;
                }
                gameObject.mNext = null;
                gameObject.mParent = null;
                return;
            }
            gameObject3 = gameObject2;
            gameObject2 = gameObject2.mNext;
        }
    }

    public void destroyNow() {
        this.setFlag(2);
        this.onDestroy();
    }

    public void destroyAllChildrenNow() {
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            GameObject gameObject2 = gameObject.mNext;
            gameObject.onDestroy();
            gameObject = gameObject2;
        }
        GameState.gc();
    }

    boolean hasFocus() {
        if (this.isFlag(8192)) {
            boolean bl = this.isFlag(128);
            this.unsetFlag(8192);
            boolean bl2 = false;
            bl2 = this.mParent != null ? this.mParent.hasFocus() : true;
            if (bl2 && this.isFlag(256)) {
                this.setFlag(128);
                bl2 = true;
            } else {
                this.unsetFlag(128);
                bl2 = false;
            }
            if (!bl && bl2) {
                this.onFocusStart();
            } else if (bl && !bl2) {
                this.onFocusEnd();
            }
            if (this.isFlag(256)) {
                this.setFlag(1024);
            } else {
                this.unsetFlag(1024);
            }
        }
        return this.isFlag(128);
    }

    GameObject focus(boolean bl) {
        if (bl) {
            this.setFlag(256);
        } else {
            this.unsetFlag(256);
        }
        return this;
    }

    void onFocusStart() {
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            gameProperty.onFocusStart(this);
            gameProperty = gameProperty.mNext;
        }
    }

    void onFocusEnd() {
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            gameProperty.onFocusEnd(this);
            gameProperty = gameProperty.mNext;
        }
    }

    boolean isEnabled() {
        if (this.mParent != null && !this.mParent.isEnabled()) {
            return false;
        }
        return (this.mFlags & 4) != 0;
    }

    public void onUpdate(GameState gameState) {
        if (this.isFlag(256) != this.isFlag(1024)) {
            this.makeDirtyFocus();
        }
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            GameProperty gameProperty2 = gameProperty.mNext;
            if ((gameProperty.mFlags & 0x40) == 0) {
                gameProperty.onInit(this);
                gameProperty.setFlag(64);
            }
            if ((gameProperty.mFlags & 4) != 0) {
                gameProperty.onUpdate(this);
                if (this.hasFocus()) {
                    gameProperty.onFocus(this);
                }
            }
            if ((gameProperty.mFlags & 2) != 0) {
                gameProperty.onDestroy(this);
                this.removeProperty(gameProperty);
            }
            if (gameProperty2 == null) {
                gameProperty2 = gameProperty.mNext;
            }
            gameProperty = gameProperty2;
        }
        if (this.mChild != null) {
            GameObject.onUpdateNext(this.mChild, gameState);
        }
    }

    static void onUpdateNext(GameObject gameObject, GameState gameState) {
        GameObject gameObject2 = gameObject;
        GameObject gameObject3 = null;
        GameObject gameObject4 = null;
        while (gameObject2 != null) {
            gameObject4 = gameObject2.mParent;
            GameObject gameObject5 = gameObject2.mNext;
            if ((gameObject2.mFlags & 4) != 0) {
                gameObject2.onUpdate(gameState);
            }
            if (gameObject5 != gameObject2.mNext && gameObject2.mParent == gameObject4) {
                gameObject5 = gameObject2.mNext;
            }
            gameObject3 = gameObject2;
            gameObject2 = gameObject5;
            if ((gameObject3.mFlags & 2) == 0) continue;
            gameObject3.onDestroy();
        }
    }

    private void onPaint(Graphics graphics) {
        if (this.mChild != null && (this.mFlags & 0x200) != 0) {
            GameObject.onPaintNext(this.mChild, graphics);
        }
        GameProperty gameProperty = this.mProperty;
        while (gameProperty != null) {
            GameProperty gameProperty2 = gameProperty.mNext;
            if ((gameProperty.mFlags & 0x20) != 0 && (gameProperty.mFlags & 8) != 0) {
                gameProperty.onPaint(this, graphics);
            }
            if (gameProperty2 == null) {
                gameProperty2 = gameProperty.mNext;
            }
            gameProperty = gameProperty2;
        }
        if (this.mChild != null && (this.mFlags & 0x200) == 0) {
            GameObject.onPaintNext(this.mChild, graphics);
        }
    }

    public static void onPaintNext(GameObject gameObject, Graphics graphics) {
        GameObject gameObject2 = gameObject;
        while (gameObject2 != null) {
            GameObject gameObject3 = gameObject2.mNext;
            if ((gameObject2.mFlags & 8) != 0) {
                gameObject2.onPaint(graphics);
            }
            if (gameObject3 == null) {
                gameObject3 = gameObject2.mNext;
            }
            gameObject2 = gameObject2.mNext;
        }
    }

    GameObject addProperty(GameProperty gameProperty) {
        if (gameProperty == null) {
            return this;
        }
        gameProperty.mNext = null;
        if (this.mProperty == null) {
            this.mProperty = gameProperty;
        } else {
            GameProperty gameProperty2 = this.mProperty;
            while (gameProperty2 != null) {
                GameProperty gameProperty3 = gameProperty2.mNext;
                if (gameProperty3 == null) {
                    gameProperty2.mNext = gameProperty;
                    break;
                }
                gameProperty2 = gameProperty3;
            }
        }
        return this;
    }

    void removeProperty(GameProperty gameProperty) {
        if (this.mProperty != null) {
            if (this.mProperty == gameProperty) {
                this.mProperty = gameProperty.mNext;
            } else {
                GameProperty gameProperty2 = this.mProperty.mNext;
                GameProperty gameProperty3 = this.mProperty;
                while (gameProperty2 != null) {
                    if (gameProperty2 == gameProperty) {
                        if (gameProperty3 == null) break;
                        gameProperty3.mNext = gameProperty2.mNext;
                        break;
                    }
                    gameProperty3 = gameProperty2;
                    gameProperty2 = gameProperty2.mNext;
                }
            }
        }
    }

    void makeDirty() {
        this.mFlags |= 0x10;
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            gameObject.makeDirty();
            gameObject = gameObject.mNext;
        }
    }

    void makeDirtyFocus() {
        this.mFlags |= 0x2000;
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            gameObject.makeDirtyFocus();
            gameObject = gameObject.mNext;
        }
    }

    GameObject setLocalXY(int n, int n2) {
        this.localPos.x = n;
        this.localPos.y = n2;
        this.makeDirty();
        return this;
    }

    void setLocalXY(Vector2i vector2i) {
        this.localPos.set(vector2i);
        this.makeDirty();
    }

    GameObject setLocalX(int n) {
        if (n != this.localPos.x) {
            this.makeDirty();
        }
        this.localPos.x = n;
        return this;
    }

    GameObject setLocalY(int n) {
        if (n != this.localPos.y) {
            this.makeDirty();
        }
        this.localPos.y = n;
        return this;
    }

    final Vector2i getLocalXY() {
        return this.localPos;
    }

    int getLocalX() {
        return this.localPos.x;
    }

    int getLocalY() {
        return this.localPos.y;
    }

    Vector2i getGlobalXY() {
        if ((this.mFlags & 0x10) != 0) {
            this.unsetFlag(16);
            if (this.mParent != null) {
                Vector2i vector2i = this.mParent.getGlobalXY();
                this.globalPos.x = vector2i.x + this.localPos.x;
                this.globalPos.y = vector2i.y + this.localPos.y;
            } else {
                this.globalPos.x = this.localPos.x;
                this.globalPos.y = this.localPos.y;
            }
        }
        return this.globalPos;
    }

    int getGlobalX() {
        return this.getGlobalXY().x;
    }

    int getGlobalY() {
        return this.getGlobalXY().y;
    }

    GameObject getPrevChild(GameObject gameObject) {
        GameObject gameObject2 = this.mChild;
        while (gameObject2 != null) {
            if (gameObject == gameObject2.mNext) {
                return gameObject2;
            }
            gameObject2 = gameObject2.mNext;
        }
        return gameObject2;
    }

    GameObject getLastChild() {
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            if (gameObject.mNext == null) {
                return gameObject;
            }
            gameObject = gameObject.mNext;
        }
        return gameObject;
    }

    int getChildNum() {
        int n = 0;
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            ++n;
            gameObject = gameObject.mNext;
        }
        return n;
    }

    public GameObject[] getChildArray() {
        if (this.mChild == null) {
            return null;
        }
        GameObject[] gameObjectArray = new GameObject[this.getChildNum()];
        GameObject gameObject = this.mChild;
        int n = 0;
        while (gameObject != null) {
            gameObjectArray[n++] = gameObject;
            gameObject = gameObject.mNext;
        }
        return gameObjectArray;
    }

    int getOrder(GameObject gameObject, GameObject gameObject2) {
        GameObject gameObject3 = gameObject.mNext;
        while (gameObject3 != null) {
            if (gameObject3 == gameObject2) {
                return 1;
            }
            gameObject3 = gameObject3.mNext;
        }
        return -1;
    }

    void swap(GameObject gameObject, GameObject gameObject2) {
        GameObject gameObject3 = this.getPrevChild(gameObject);
        GameObject gameObject4 = this.getPrevChild(gameObject2);
        GameObject gameObject5 = gameObject.mNext;
        GameObject gameObject6 = gameObject2.mNext;
        if (gameObject3 == gameObject2) {
            gameObject4.mNext = gameObject;
            gameObject.mNext = gameObject2;
            gameObject2.mNext = gameObject5;
        } else if (gameObject4 == gameObject) {
            gameObject3.mNext = gameObject2;
            gameObject2.mNext = gameObject;
            gameObject.mNext = gameObject6;
        } else {
            if (gameObject3 != null) {
                gameObject3.mNext = gameObject2;
            }
            if (gameObject4 != null) {
                gameObject4.mNext = gameObject;
            }
            gameObject.mNext = gameObject6;
            gameObject2.mNext = gameObject5;
        }
    }

    void enableAllChildren(boolean bl) {
        GameObject gameObject = this.mChild;
        while (gameObject != null) {
            gameObject.enable(bl);
            gameObject = gameObject.mNext;
        }
    }

    boolean isOnParentsTree(GameObject gameObject) {
        GameObject gameObject2 = this.mParent;
        while (gameObject2 != null) {
            if (gameObject2 == gameObject) {
                return true;
            }
            gameObject2 = gameObject2.mParent;
        }
        return false;
    }

    int getChildPosition(GameObject gameObject) {
        if (gameObject != null) {
            GameObject gameObject2 = this.mChild;
            int n = 0;
            while (gameObject2 != null) {
                if (gameObject2 == gameObject) {
                    return n;
                }
                gameObject2 = gameObject2.mNext;
                ++n;
            }
        }
        return -1;
    }
}

