/*
 * Decompiled with CFR 0.152.
 */
public class ObjectExtension
extends GameProperty {
    UiListener listener;
    public Vector2i start = new Vector2i();
    public Vector2i end = new Vector2i();
    public Vector2i step = new Vector2i();
    public int stepsNum;
    public boolean destroyAtEnd = false;
    public Vector2i end1 = new Vector2i();
    public Vector2i end2 = new Vector2i();
    public static final byte TYPE_MOVER = 1;
    public static final byte TYPE_DESTROY = 2;
    public byte mType;
    public long mTime;

    BaseObject createCopy(BaseObject baseObject) {
        ObjectExtension objectExtension = (ObjectExtension)baseObject;
        if (objectExtension != null) {
            objectExtension = new ObjectExtension(0, 0, 0);
        }
        return objectExtension;
    }

    ObjectExtension(int n, int n2, int n3) {
        this.mType = 1;
        this.end.set(n, n2);
        this.end1.set(n / 2, n2);
        this.end2.set(-n / 2, n2);
        this.stepsNum = n3;
        this.mHashType = (byte)44;
    }

    ObjectExtension(long l) {
        this.mType = (byte)2;
        this.mTime = l;
        this.mHashType = (byte)44;
    }

    ObjectExtension setListener(UiListener uiListener) {
        this.listener = uiListener;
        return this;
    }

    ObjectExtension destroyAtEnd(boolean bl) {
        this.destroyAtEnd = bl;
        return this;
    }

    void onInit(GameObject gameObject) {
        if (this.mType == 1) {
            this.start.set(gameObject.getLocalXY());
            this.step.set(this.end.x - this.start.x, this.end.y - this.start.y);
            this.step.toFP();
            this.step.div(this.stepsNum);
            this.start.toFP();
        }
    }

    void onUpdate(GameObject gameObject) {
        switch (this.mType) {
            case 2: {
                if (this.mTime <= 0L) break;
                this.mTime -= GameState.getInstance().mFrameTime;
                if (this.mTime > 0L) break;
                gameObject.destroy();
                break;
            }
            case 1: {
                if (this.stepsNum < 0) {
                    return;
                }
                if (this.stepsNum-- > 0) {
                    gameObject.setLocalXY(Vector2i.toInt(this.start.x), Vector2i.toInt(this.start.y));
                    if (this.stepsNum > 10) {
                        this.start.sub(this.step);
                        break;
                    }
                    this.start.add(this.step);
                    break;
                }
                gameObject.setLocalXY(this.end.x, this.end.y);
                if (this.listener != null) {
                    this.listener.onMessage(gameObject, 104);
                }
                if (!this.destroyAtEnd) break;
                gameObject.destroy();
            }
        }
    }
}

