/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class LevelRunway
implements UiListener,
GameDefs,
BabbleDefs {
    boolean initialized;
    GameState mGameState;
    GameObject mDressingRoom;
    GameObject mLevel;
    GameObject mLevelModel;
    GameObject mScore;
    GameObject mScoreModel;
    GameObject ania;
    GameObject timer;
    int currentStage = 0;
    GameObject mRail;
    GameObject changeItem;
    GameObject gamePlayfield;
    GameObject mStages;
    GameObject mScoreLabel;
    GameObject mTimerLabel;
    GameObject mRunway;
    GameObject mRunwayModel;
    GameObject mRunwayData;
    GameObject mSendButtons;
    GameObject mModelsLeft;
    GameObject mStylesToShow;
    boolean timeOut = false;
    GameObject mMatchingObject;
    GameObject mClimaxLabel;
    GameObject mDoubleTimeLabel;
    GameObject mPointer;
    boolean[] tablica;
    GameObject mTouchedObject;
    public static final int STATE_DRESSING_ROOM = 1;
    public static final int STATE_RUNWAY = 2;
    public static final int STATE_END_LEVEL = 3;
    public static final int STATE_SHOW_STYLES = 4;
    public static final int STATE_HELP = 5;
    public static final int STATE_GET_MATCHING = 6;
    public static final int STATE_SWAP_STYLE = 7;
    public static final int STATE_SWAP_STYLE_CHANGE = 8;
    public static final int STATE_SCORE = 9;
    public static final int RUNWAY_STATE_START = 1;
    public static final int RUNWAY_STATE_TOP = 2;
    public static final int RUNWAY_STATE_BOTTOM = 3;
    public static final int RUNWAY_STATE_SHOES = 4;
    public static final int RUNWAY_STATE_BONUS = 5;
    public static final int RUNWAY_STATE_END = 6;
    public static final int RUNWAY_STATE_MODEL_CHAIN = 7;
    public static final int RUNWAY_STATE_STYLE_CHAIN = 8;
    int mRunwayCurrentModel;
    int mState;
    int mRunwayState = 2;
    int mScoreState;
    int loading;
    short mModelChainBonus;
    int levelScore;
    int displayLevelScore;
    int levelTime;
    int climaxTime;
    int doubleTime;
    int currentStyleToShow = -1;
    int levelStageStartY;
    GameObject[] modelsToGo = new GameObject[3];
    GameObject[] modelsToSend = new GameObject[3];
    int[] lastModelScore = new int[4];
    int latModelScoreAll;
    StringBuffer[] lastModelScoreAttributes = new StringBuffer[4];
    int lastModelScoreOverall = 0;
    public static final int kPowerUp_None = -1;
    public static final int kPowerUp_SuperModel = 0;
    public static final int kPowerUp_ShuffleTops = 1;
    public static final int kPowerUp_ShuffleBottoms = 2;
    public static final int kPowerUp_ShuffleShoes = 3;
    public static final int kPowerUp_ShuffleAll = 4;
    public static final int kPowerUp_Dazzle = 5;
    public static final int kPowerUp_GetMatching = 6;
    public static final int kPowerUp_Highlight = 7;
    public static final int kPowerUp_SwapStyle = 8;
    public static final int kPowerUp_RackScroll = 9;
    public GameObject[] focusArray;
    int currentFocus = 0;
    short[][] stylesAttributes;
    byte[][] stylesAttributesWeight;
    short[][] stylesSampleItems;
    int styleChainId = -1;
    int styleChainNum = 0;
    boolean noScores;
    String levelName;
    public static int gHangerPositionY;
    int whichStage;
    public static GameObject[] scoreModels;
    int[] scoreModelsTable = new int[15];
    int ja;
    int tempLevelScore;
    int temp;
    GameObject highlightedItem = null;
    GameObject highlightedRack = null;
    short[][] levelComboAttributes;
    short[] levelComboAttributesBonus;
    byte levelNumDressingRooms;
    int levelStartTime;
    int levelMaxTime;
    short levelAccessoryAppearPt;
    int levelModelTimeBonus;
    String levelLeftChar;
    String levelRightChar;
    short levelBG;
    short[] levelOutfitStarPoints;
    short[] levelStarPoints;
    byte[] levelStyleBoardClimax;
    byte[] levelStyleBoardDoubleTime;
    short[] levelStyleBoardId;
    byte[] levelStyleBoardFlag;
    byte levelRackAllClothesSlotsNum;
    short[] levelRackAllClothesId;
    byte[] levelRackAllClothesFrequency;
    short[][] levelRackAllClothesBag;
    byte[] levelRackAllClothesBagTypes;
    short[] levelStylesToShow;
    short[] levelStyleUsedStyles;
    short currentStyle;
    int saveCurrentStage;
    int selectedStage;
    public static final int FOCUS_NEXT = 1;
    public static final int FOCUS_PREV = 2;
    public static final int FOCUS_RESET = 3;
    public static final int FOCUS_SET = 4;
    byte levelStars = 0;

    LevelRunway(GameState gameState, String string) {
        this.mGameState = gameState;
        this.loading = 0;
        this.mState = 1;
        this.levelName = string;
        this.levelStageStartY = 40;
    }

    boolean loadNext() {
        switch (this.loading) {
            case 0: {
                this.loadStyles("styles.bin");
                break;
            }
            case 1: {
                this.loadCombo("combo.bin");
                break;
            }
            case 2: {
                if (GameCanvas.HEIGHT < 320) {
                    gHangerPositionY = 4;
                    break;
                }
                if (GameCanvas.WIDTH <= 240) {
                    gHangerPositionY = this.getRackHeight() >> 1;
                    break;
                }
                gHangerPositionY = GameCanvas.HEIGHT - this.getRailHeight() >> 1;
                break;
            }
            case 3: {
                this.loadClothes();
                break;
            }
            case 4: {
                this.loadLevel(this.levelName);
                Tools.println("level loaded");
                break;
            }
            case 5: {
                this.load("a");
                break;
            }
            case 6: {
                GameResourceMgr.loadImage((short)255);
                GameResourceMgr.loadImage((short)256);
                break;
            }
            case 7: {
                break;
            }
            default: {
                GameState.gc();
                return true;
            }
        }
        GameState.gc();
        ++this.loading;
        return false;
    }

    GameObject getFreeHanger(GameObject gameObject, int n) {
        GameObject[] gameObjectArray = gameObject.getChildArray();
        if (gameObjectArray != null) {
            for (int i = 0; i < gameObjectArray.length; ++i) {
                GameObject gameObject2 = gameObjectArray[i].getChildTreeByHashName((byte)12);
                if (gameObject2 != null) continue;
                if (n >= 0) {
                    if (((Hanger)gameObjectArray[i].getPropertyByHashType((byte)10)).mClothType != n) continue;
                    return gameObjectArray[i];
                }
                return gameObjectArray[i];
            }
        }
        if (n >= 0) {
            return this.getFreeHanger(gameObject, -1);
        }
        return null;
    }

    GameObject getFreeHanger(GameObject gameObject) {
        return this.getFreeHanger(gameObject, -1);
    }

    public GameObject addHanger(GameObject gameObject) {
        GameObject gameObject2 = new GameObject(10);
        Hanger hanger = new Hanger();
        gameObject2.addProperty(hanger);
        gameObject2.addProperty(new BlinkOnFocus());
        hanger.setListener(this);
        gameObject.addChild(gameObject2);
        return gameObject2;
    }

    public GameObject createItem(Cloth cloth, boolean bl) {
        GameObject gameObject;
        Tools.println("createItem :1");
        short s = cloth.id;
        short s2 = cloth.id;
        int n = Cloth.getType(cloth.id);
        GameObject gameObject2 = new GameObject(12);
        gameObject2.focus(true);
        gameObject2.addProperty(new ClothingItem(n, cloth.id).setListener(this));
        if (bl) {
            Tools.println("createItem :8");
            gameObject = new GameObject(28);
            gameObject.focus(true);
            int n2 = 3;
            if (GameCanvas.HEIGHT < 320) {
                n2 = 17;
            } else {
                gameObject.setLocalY(gHangerPositionY);
            }
            GameSprite gameSprite = new GameSprite(s, 0, n2);
            gameSprite.setFlag(4096);
            gameSprite.reposition();
            int n3 = 0;
            boolean bl2 = false;
            int n4 = -gHangerPositionY;
            if (GameCanvas.HEIGHT < 320) {
                n4 = 0;
            }
            gameSprite.setTouchListener(this).setBBox(-GameCanvas.WIDTH / 10 - n3, n4, GameCanvas.WIDTH / 5, GameCanvas.HEIGHT / 2);
            gameObject.addProperty(gameSprite);
            gameObject2.addChild(gameObject);
        }
        Tools.println("createItem :8a");
        gameObject = new GameObject(29);
        gameObject.focus(true);
        gameObject.addProperty(new GameSprite(s2, 0, 20));
        gameObject2.addChild(gameObject);
        return gameObject2;
    }

    void addItem(GameObject gameObject, GameObject gameObject2) {
        byte by = ((ClothingItem)gameObject2.getPropertyByHashType((byte)12)).getType();
        ((Hanger)gameObject.getPropertyByHashType((byte)10)).mClothType = by;
        gameObject.addChild(gameObject2);
        gameObject.enable(true);
    }

    GameObject makeModel(short s) {
        GameObject gameObject = new GameObject(11);
        gameObject.addProperty(new GameSprite(46, 0, 20).setTouchListener(this));
        GameObject gameObject2 = new GameObject(15);
        GameObject gameObject3 = new GameObject(16);
        gameObject2.addChild(gameObject3);
        GameObject gameObject4 = new GameObject(17);
        gameObject4.addProperty(new GameSprite(s, 0, 20));
        gameObject2.addChild(gameObject4);
        GameObject gameObject5 = new GameObject(20);
        GameObject gameObject6 = new GameObject(19);
        gameObject6.addProperty(new GameSprite(204, 0, 20));
        GameObject gameObject7 = new GameObject(18);
        gameObject7.addProperty(new GameSprite(205, 0, 20));
        gameObject.addChild(gameObject7);
        gameObject.addChild(gameObject5);
        gameObject.addChild(gameObject6);
        gameObject.addChild(gameObject2);
        return gameObject;
    }

    int advanceStyleBoard() {
        if (this.currentStyle >= this.levelStyleBoardId.length) {
            return -1;
        }
        short s = this.currentStyle;
        this.currentStyle = (short)(s + 1);
        return s;
    }

    GameObject getFreeStage() {
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i] == null || gameObjectArray[i].getChildByHashName((byte)11) != null) continue;
            return gameObjectArray[i];
        }
        return null;
    }

    int getFirstStage() {
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i] == null || gameObjectArray[i].getChildByHashName((byte)11) == null) continue;
            return i;
        }
        return -1;
    }

    void resetTimer() {
        if (this.levelTime < 0) {
            this.levelTime = 0;
        }
        this.levelTime += this.levelModelTimeBonus;
        this.levelTime = Math.min(this.levelTime, this.levelMaxTime);
        Tools.println("levelTime= ");
        Tools.println(this.levelTime);
        if (this.doubleTime > 0) {
            this.levelTime = 25500;
            Tools.println("doublelevelTime= ");
            Tools.println(this.levelTime);
        }
    }

    boolean fillAllStages(boolean bl) {
        Tools.println("fillAllStages");
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.fillFreeStage()) continue;
            ++n;
        }
        n = 0;
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (BlinkOnFocus.getBlinkOnFocus(gameObjectArray[i].getChildByHashName((byte)24)) != null) {
                BlinkOnFocus.getBlinkOnFocus(gameObjectArray[i].getChildByHashName((byte)24)).destroy();
            }
            if (gameObjectArray[i].getChildByHashName((byte)11) != null) {
                this.updateStage(gameObjectArray[i]);
                ++n;
                continue;
            }
            this.changeStageButton(gameObjectArray[i], false);
            GameObject[] gameObjectArray2 = this.mSendButtons.getChildArray();
            gameObjectArray2[i].visible(false);
            gameObjectArray[i].enable(false);
            gameObjectArray[i].visible(false);
        }
        Helper.changeText(this.mModelsLeft, "" + (n + this.levelStyleBoardId.length - this.currentStyle));
        Tools.println("Models left ");
        Tools.println(n);
        if (n == 0) {
            return true;
        }
        if (bl) {
            this.nextStage(true);
        }
        return false;
    }

    short getHair(int n) {
        if (n < 0) {
            n = (short)Tools.getRandom(0, 3);
        }
        switch (n) {
            case 1: {
                return 144;
            }
            case 2: {
                return 143;
            }
        }
        return 145;
    }

    boolean fillFreeStage() {
        Tools.println("fillFreeStage");
        GameObject gameObject = this.getFreeStage();
        if (gameObject == null) {
            return true;
        }
        int n = this.advanceStyleBoard();
        if (n < 0) {
            return false;
        }
        String string = this.getShortStyleNameById(this.levelStyleBoardId[n]);
        short s = (short)DataTable.getInteger(gameObject, "stage", -1);
        GameObject gameObject2 = this.makeModel(this.getHair(s));
        DataTable.setInteger(gameObject2, "styleId", n);
        DataTable.setInteger(gameObject2, "stage", s);
        gameObject2.setLocalXY(-11, 27);
        gameObject.addChild(gameObject2);
        Helper.changeText(gameObject.getChildByHashName((byte)24).getChildByHashName((byte)5), string);
        this.changeStageButton(gameObject, false);
        if (this.levelStyleBoardClimax[n] > 0) {
            this.climaxTime = this.levelStyleBoardClimax[n] * 1000;
        }
        if (this.levelStyleBoardDoubleTime[n] > 0) {
            this.doubleTime = this.levelStyleBoardDoubleTime[n] * 1000;
        }
        return true;
    }

    GameObject createStage(int n) {
        int n2 = 0;
        int n3 = GameResourceMgr.loadImage((short)119).getWidth();
        n2 = (GameCanvas.WIDTH - n3 * 3) / 3;
        int n4 = (GameCanvas.WIDTH - (n3 += n2)) / 2 * n;
        int n5 = this.levelStageStartY;
        GameObject gameObject = new GameObject(23);
        gameObject.setLocalXY(n4 += n2 >> 1, n5);
        GameObject gameObject2 = new GameObject(24);
        int n6 = n3;
        gameObject2.addProperty(new GameSprite(119, 0, 20, 0, 4));
        n6 = GameResourceMgr.getWidth((short)119);
        n6 -= n6 / 12;
        gameObject.addChild(gameObject2);
        GameObject gameObject3 = Helper.makeLabel("lala", (byte)5, 39, 13, 3, (byte)0, n6, -1, false);
        GameText gameText = GameText.getGameText(gameObject3);
        gameText.setScrollX(true);
        gameObject2.addChild(gameObject3);
        gameObject.addProperty(new ListenerProperty(this));
        DataTable.setInteger(gameObject, "stage", n);
        GameObject gameObject4 = Helper.makeButton(null, (byte)26, n4 + 77, n5 + 20, new short[]{65, 65, 65}, this, 24, (byte)1);
        gameObject4.addProperty(new BlinkOnFocus(false));
        DataTable.setInteger(gameObject4, "stage", n);
        gameObject4.enable(false);
        this.mSendButtons.addChild(gameObject4);
        this.tablica = new boolean[this.mSendButtons.getChildArray().length];
        this.changeStageButton(gameObject, false);
        return gameObject;
    }

    public int getRailHeight() {
        return Math.max(GameCanvas.HEIGHT - this.mGameState.calcHeight(85), GameResourceMgr.getHeight((short)119) + this.levelStageStartY);
    }

    void addLevelBackground(GameObject gameObject) {
        gameObject.addChild(new GameObject().addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, this.levelStageStartY, 0, true)));
        gameObject.addChild(new GameObject().setLocalXY(0, this.levelStageStartY).addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, this.getRailHeight(), 12962264, true)));
        gameObject.addChild(new GameObject().setLocalXY(0, this.getRailHeight()).addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, GameCanvas.HEIGHT - this.getRailHeight(), 12239062, true)));
    }

    public boolean load(String string) {
        int n;
        int n2;
        int n3;
        System.out.println("name " + string);
        Tools.println("load start");
        this.mLevel = new GameObject();
        this.mLevel.focus(true);
        this.mDressingRoom = new GameObject();
        this.mDressingRoom.focus(true);
        this.gamePlayfield = new GameObject();
        this.gamePlayfield.focus(true);
        this.gamePlayfield.setLocalXY(0, 0);
        this.mDressingRoom.addChild(this.gamePlayfield);
        this.mPointer = new GameObject();
        this.mPointer.addChild(Helper.createSimpleImage((short)231, 0, 0, 20, 0, false));
        this.mPointer.visible(false);
        this.mDressingRoom.addChild(this.mPointer);
        if (GameCanvas.WIDTH <= 240) {
            this.gamePlayfield.addChild(new GameObject().setLocalXY(0, 0).addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, this.levelStageStartY, 0, true)));
            this.gamePlayfield.addProperty(new GameSprite(142, 0, 20));
            if (this.getRailHeight() > GameResourceMgr.getHeight((short)142)) {
                n3 = 0;
                n2 = GameCanvas.WIDTH_2;
                n = GameResourceMgr.getHeight((short)142);
                int n4 = GameResourceMgr.getHeight((short)16);
                while (n3 * n4 + n < this.getRailHeight()) {
                    this.gamePlayfield.addProperty(new GameSprite(16, 0, 17, n2, n3 * n4 + n));
                    ++n3;
                }
            }
            if ((n3 = this.getRailHeight() + this.getRackHeight()) < GameCanvas.HEIGHT) {
                this.gamePlayfield.addChild(new GameObject().setLocalXY(0, n3).addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, GameCanvas.HEIGHT - n3, 12754307, true)));
            }
        } else {
            this.addLevelBackground(this.gamePlayfield);
        }
        Tools.println("mStages");
        this.mStages = new GameObject(22);
        this.mSendButtons = new GameObject();
        this.mSendButtons.addProperty(new MenuSelector(0));
        this.mSendButtons.enable(false);
        this.gamePlayfield.addChild(this.mSendButtons);
        this.gamePlayfield.addChild(this.mStages, false, this.mSendButtons);
        for (n3 = 0; n3 < 3; ++n3) {
            this.mStages.addChild(this.createStage(n3));
        }
        this.mRail = new GameObject(21);
        this.mRail.setLocalXY(GameCanvas.WIDTH_2, this.getRailHeight());
        this.mPointer.setLocalXY(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2);
        this.gamePlayfield.addChild(this.mRail);
        this.mRail.addProperty(new MenuSelector(1, GameCanvas.WIDTH - GameCanvas.WIDTH / 10, GameCanvas.HEIGHT, GameCanvas.WIDTH / 5));
        if (GameCanvas.WIDTH <= 240) {
            this.mRail.addProperty(new GameSprite(200, 0, 17));
        } else {
            this.mRail.addProperty(new GameShape().setRect(GameCanvas.WIDTH, 2, 11121363, true));
        }
        this.updateRacks();
        Tools.println("timeLabel");
        GameObject gameObject = new GameObject();
        this.timer = new GameObject(51);
        this.timer.addProperty(new GameSprite(308, 0, 20));
        this.timer.addProperty(new BlinkOnFocus());
        gameObject.addProperty(new GameSprite(313, 0, 20, 0, 0));
        gameObject.addProperty(new GameSprite(247, 0, 24, GameCanvas.WIDTH, 0));
        gameObject.addChild(this.timer);
        this.gamePlayfield.addChild(gameObject);
        this.levelTime = this.levelStartTime;
        this.mTimerLabel = new GameObject();
        this.mTimerLabel.setLocalXY(55, 21);
        this.mTimerLabel.addProperty(new GameText("" + this.levelTime / 1000, 1));
        gameObject.addChild(this.mTimerLabel);
        this.mModelsLeft = new GameObject();
        this.mModelsLeft.setLocalXY(188, 21);
        this.mModelsLeft.addProperty(new GameText("0", 1));
        gameObject.addChild(this.mModelsLeft);
        n2 = GameResourceMgr.getWidth((short)308);
        n2 -= n2 / 5;
        this.mClimaxLabel = new GameObject();
        this.mClimaxLabel.setLocalXY(GameCanvas.WIDTH_2, 32);
        this.mClimaxLabel.addProperty(new GameText(GameState.getText(33), 1));
        this.mDoubleTimeLabel = new GameObject();
        this.mDoubleTimeLabel.setLocalXY(GameCanvas.WIDTH_2, 32);
        this.mDoubleTimeLabel.addProperty(new GameText(GameState.getText(51), 1));
        this.gamePlayfield.addChild(this.mClimaxLabel);
        this.gamePlayfield.addChild(this.mDoubleTimeLabel);
        this.mClimaxLabel.visible(false);
        this.mDoubleTimeLabel.visible(false);
        this.mLevelModel = new GameObject();
        this.mGameState.getRoot().addChild(this.mLevelModel);
        this.mLevelModel.enableAndVisible(false);
        Tools.println("mRunway");
        this.mRunway = new GameObject();
        this.mRunwayModel = new GameObject();
        this.mRunway.addChild(this.mRunwayModel);
        this.mRunwayData = new GameObject();
        this.mRunway.addChild(this.mRunwayData);
        this.mGameState.getRoot().addChild(this.mRunway);
        this.mRunway.enable(false);
        this.mRunway.visible(false);
        this.fillAllStages(false);
        Tools.println("mScore");
        this.mScore = new GameObject();
        this.mScore.addChild(Helper.createSimpleImage((short)248, 0, 0, 20, 0, false));
        this.mScoreModel = new GameObject();
        this.mScore.addChild(this.mScoreModel);
        for (n = 0; n < scoreModels.length; ++n) {
            LevelRunway.scoreModels[n] = new GameObject();
            scoreModels[n].setLocalXY(GameCanvas.WIDTH / 4, GameCanvas.HEIGHT / 5);
            scoreModels[n].enableAndVisible(false);
            this.scoreModelsTable[n] = -1;
        }
        this.mGameState.getRoot().addChild(this.mScore);
        this.mScore.enableAndVisible(false);
        Tools.println("focusArray");
        this.focusArray = new GameObject[]{this.mRail, this.mSendButtons};
        this.focusArray[0].focus(true);
        this.mLevel.addChild(this.mDressingRoom);
        this.mGameState.getRoot().addChild(this.mLevel);
        Tools.println("load end");
        return true;
    }

    GameObject currentHighlightedModel(boolean bl, GameObject gameObject) {
        GameObject gameObject2 = this.mStages.mChild;
        GameObject gameObject3 = null;
        while (!gameObject.isOnParentsTree(gameObject2)) {
            gameObject2 = gameObject2.mNext;
        }
        do {
            if ((gameObject2 = bl ? this.mStages.getPrevChild(gameObject2) : gameObject2.mNext) == null || !gameObject2.isFlag(4)) continue;
            gameObject3 = gameObject2;
            break;
        } while (gameObject2 != null);
        if (gameObject3 != null) {
            return gameObject3.getChildByHashName((byte)11);
        }
        return null;
    }

    boolean hasClothOfType(GameObject gameObject, int n, ClothingItem clothingItem) {
        GameObject gameObject2 = gameObject.getChildByHashName((byte)11);
        if (clothingItem != null && clothingItem.isDress()) {
            if (this.hasDress(gameObject2)) {
                return true;
            }
            GameObject gameObject3 = gameObject2.getChildTreeByHashName(this.getHashForType(1));
            GameObject gameObject4 = gameObject3.getChildByHashName((byte)12);
            if (gameObject4 != null) {
                return true;
            }
            gameObject3 = gameObject2.getChildTreeByHashName(this.getHashForType(2));
            gameObject4 = gameObject3.getChildByHashName((byte)12);
            return gameObject4 != null;
        }
        if ((n == 1 || n == 2) && this.hasDress(gameObject2)) {
            return true;
        }
        GameObject gameObject5 = gameObject2.getChildTreeByHashName(this.getHashForType(n));
        GameObject gameObject6 = gameObject5.getChildByHashName((byte)12);
        return gameObject6 != null;
    }

    GameObject currentModel(GameObject gameObject) {
        byte by = 0;
        ClothingItem clothingItem = null;
        if (gameObject != null) {
            clothingItem = (ClothingItem)gameObject.getPropertyByHashType((byte)12);
            if (clothingItem != null) {
                by = clothingItem.getType();
            }
            Tools.println("type to find");
            Tools.println(by);
        }
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        GameObject gameObject2 = null;
        int[] nArray = null;
        nArray = gameObjectArray.length > 2 ? new int[]{1, 0, 2} : new int[]{0, 1};
        for (int i = 0; i < gameObjectArray.length; ++i) {
            int n = nArray[i];
            if (n >= gameObjectArray.length || gameObjectArray[n] == null || !gameObjectArray[n].isFlag(4)) continue;
            if (by > 0) {
                if (this.hasClothOfType(gameObjectArray[n], by, clothingItem)) continue;
                Tools.println("found type");
                Tools.println(by);
                gameObject2 = gameObjectArray[n];
                break;
            }
            gameObject2 = gameObjectArray[n];
            break;
        }
        if (gameObject2 != null) {
            return gameObject2.getChildByHashName((byte)11);
        }
        if (by > 0) {
            return this.currentModel(null);
        }
        return null;
    }

    public boolean destroy() {
        Cloth.clothes = null;
        return true;
    }

    void changeStageButton(GameObject gameObject, boolean bl) {
        short s;
        int n = DataTable.getInteger(gameObject, "stage", -1);
        GameObject[] gameObjectArray = this.mSendButtons.getChildArray();
        GameObject gameObject2 = gameObjectArray[n];
        if (gameObject2 != null) {
            s = 64;
            if (!bl) {
                s = 65;
            }
            gameObject2.enable(bl);
            gameObject2.visible(true);
            Helper.changeButtonImages(gameObject2, new short[]{s, s, s});
        }
        MenuSelector.getMenuSelector(this.mSendButtons).reset();
        this.mSendButtons.enable(false);
        for (s = 0; s < gameObjectArray.length; ++s) {
            if (!gameObjectArray[s].isFlag(4)) continue;
            this.mSendButtons.enable(true);
        }
    }

    void updateSendButton() {
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i].mHashName != 23) continue;
            if (this.isStageModelReady(gameObjectArray[i])) {
                this.modelsToSend[n2++] = gameObjectArray[i].getChildByHashName((byte)11);
                ++n;
                continue;
            }
            this.modelsToSend[n2++] = null;
        }
    }

    boolean isStageModelReady(GameObject gameObject) {
        GameObject gameObject2 = gameObject.getChildByHashName((byte)11);
        if (gameObject2 != null) {
            if (gameObject2.getChildByHashName((byte)19).mChild != null && gameObject2.getChildByHashName((byte)18).mChild != null && gameObject2.getChildByHashName((byte)20).mChild != null) {
                return true;
            }
            if (this.hasDress(gameObject2) && gameObject2.getChildByHashName((byte)20).mChild != null) {
                return true;
            }
        }
        return false;
    }

    void updateStage(GameObject gameObject) {
        if (this.isStageModelReady(gameObject)) {
            this.changeStageButton(gameObject, true);
        } else {
            this.changeStageButton(gameObject, false);
        }
        this.updateSendButton();
    }

    GameObject getCurrentStage() {
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        if (this.currentStage >= gameObjectArray.length) {
            this.currentStage = 0;
        }
        if (this.currentStage < 0) {
            this.currentStage = gameObjectArray.length - 1;
        }
        return gameObjectArray[this.currentStage];
    }

    void nextStage(boolean bl) {
        do {
            if (bl) {
                ++this.currentStage;
                continue;
            }
            --this.currentStage;
        } while (!this.getCurrentStage().isFlag(4));
    }

    void onTimeUp(boolean bl) {
        if (this.getCurrentStage() != null) {
            if (bl) {
                if (BlinkOnFocus.getBlinkOnFocus(this.getCurrentStage().getChildByHashName((byte)24)) == null) {
                    this.getCurrentStage().getChildByHashName((byte)24).addProperty(new BlinkOnFocus(true));
                    this.timer.addProperty(new BlinkOnFocus(true));
                }
            } else {
                this.timeOut = true;
                this.setState(2);
            }
        }
    }

    public void onPostUpdate() {
        if (!this.initialized) {
            return;
        }
        if (this.mTouchedObject != null) {
            if (this.mState == 1) {
                if (this.mTouchedObject.mHashName == 11) {
                    int n = DataTable.getInteger(this.mTouchedObject, "stage", -1);
                    GameObject gameObject = this.mStages.getChildArray()[n].getChildByHashName((byte)11);
                    GameObject gameObject2 = this.hangerGetHighlightedItem(this.mRail).getChildByHashName((byte)12);
                    GameObject gameObject3 = this.hangerGetHighlightedItem(this.mRail);
                    this.itemToChange(gameObject, gameObject2, gameObject3);
                    this.wearCloth(gameObject2);
                } else if (this.mTouchedObject.mHashName == 28) {
                    MenuSelector.getMenuSelector(this.mRail).setCurrent(this.mTouchedObject.mParent.mParent);
                    MenuSelector.getMenuSelector((GameObject)this.mRail).current.focus(true);
                    TouchScreen.getInstance().resetState();
                }
            } else if ((this.mState == 6 || this.mState == 7) && this.mTouchedObject.mHashName == 11) {
                this.selectStage(DataTable.getInteger(this.mTouchedObject, "stage", -1));
            }
            this.mTouchedObject = null;
        }
    }

    public void onUpdate() {
        if (this.displayLevelScore < this.levelScore) {
            this.displayLevelScore += 40;
            if (this.displayLevelScore > this.levelScore) {
                this.displayLevelScore = this.levelScore;
            }
            this.tempLevelScore = this.levelScore;
        }
        switch (this.mState) {
            case 1: {
                if (this.timeOut) {
                    this.mGameState.setSoftkeys(21, 10);
                    break;
                }
                if (!this.mDressingRoom.isFlag(4)) break;
                int n = this.levelTime;
                this.levelTime = (int)((long)this.levelTime - this.mGameState.mFrameTime);
                this.climaxTime = (int)((long)this.climaxTime - this.mGameState.mFrameTime);
                this.doubleTime = (int)((long)this.doubleTime - this.mGameState.mFrameTime);
                if (this.climaxTime <= 0) {
                    if (BlinkOnFocus.getBlinkOnFocus(this.mClimaxLabel) != null) {
                        BlinkOnFocus.getBlinkOnFocus(this.mClimaxLabel).destroy();
                    }
                    this.climaxTime = 0;
                    this.mClimaxLabel.visible(false);
                } else {
                    this.mClimaxLabel.visible(true);
                    if (BlinkOnFocus.getBlinkOnFocus(this.mClimaxLabel) == null) {
                        this.mClimaxLabel.addProperty(new BlinkOnFocus(true));
                    }
                }
                if (this.doubleTime <= 0) {
                    if (BlinkOnFocus.getBlinkOnFocus(this.mDoubleTimeLabel) != null) {
                        BlinkOnFocus.getBlinkOnFocus(this.mDoubleTimeLabel).destroy();
                    }
                    this.doubleTime = 0;
                    this.mDoubleTimeLabel.visible(false);
                } else if (this.doubleTime <= 10000) {
                    this.mDoubleTimeLabel.visible(true);
                    if (BlinkOnFocus.getBlinkOnFocus(this.mDoubleTimeLabel) == null) {
                        this.mDoubleTimeLabel.addProperty(new BlinkOnFocus(true));
                    }
                } else {
                    this.mDoubleTimeLabel.visible(true);
                }
                if (this.levelTime <= 15000) {
                    this.onTimeUp(true);
                }
                if (this.levelTime <= 0) {
                    this.levelTime = 0;
                    this.onTimeUp(false);
                }
                if (this.levelTime / 1000 != n / 1000) {
                    Helper.changeText(this.mTimerLabel, "" + this.levelTime / 1000);
                }
                if (this.currentFocus == 1) {
                    GameObject[] gameObjectArray = this.mSendButtons.getChildArray();
                    if (gameObjectArray == null) break;
                    for (int i = 0; i < gameObjectArray.length; ++i) {
                        if (gameObjectArray[i].hasFocus() && !this.tablica[i]) {
                            this.mPointer.addProperty(new ObjectExtension(gameObjectArray[i].getLocalX() - GameResourceMgr.getHeight((short)64) / 2, gameObjectArray[i].getLocalY() + GameResourceMgr.getHeight((short)64) * 2 / 3, 5));
                            this.whichStage = i;
                            System.out.println("________________________________whichStage= " + this.whichStage);
                        }
                        this.tablica[i] = gameObjectArray[i].hasFocus();
                    }
                } else {
                    GameObject[] gameObjectArray = this.mSendButtons.getChildArray();
                    if (gameObjectArray == null) break;
                    for (int i = 0; i < gameObjectArray.length; ++i) {
                        this.tablica[i] = false;
                    }
                }
                break;
            }
            case 9: {
                if (this.mScoreState == 2) {
                    this.mGameState.setSoftkeys(21, 24);
                    break;
                }
                this.mGameState.setSoftkeys(21, 10);
            }
        }
        if (this.changeItem != null) {
            GameObject gameObject = this.changeItem.getChildByHashName((byte)12);
            if (gameObject != null) {
                this.itemToChange(this.currentModel(gameObject), gameObject, this.changeItem);
            }
            this.changeItem = null;
        }
    }

    void putClothBackOnHanger() {
        if (this.highlightedItem == null) {
            return;
        }
        GameObject gameObject = this.createItem(this.getCloth(this.highlightedItem), true);
        this.highlightedRack.addChild(gameObject);
        this.highlightedRack.enable(true);
        this.highlightedItem.destroyNow();
        this.highlightedRack = null;
        this.highlightedItem = null;
    }

    void sortModelsToSend() {
        if (this.styleChainId != -1) {
            for (int i = 0; i < this.modelsToSend.length; ++i) {
                short s;
                if (this.modelsToSend[i] == null || (s = this.levelStyleBoardId[DataTable.getInteger(this.modelsToSend[i], "styleId", -1)]) != this.styleChainId) continue;
                for (int j = i; j > 0; --j) {
                    GameObject gameObject = this.modelsToSend[j - 1];
                    this.modelsToSend[j - 1] = this.modelsToSend[j];
                    this.modelsToSend[j] = gameObject;
                }
            }
        }
    }

    void sendModels(boolean bl) {
        int n;
        if (bl) {
            this.sortModelsToSend();
            for (n = 0; n < this.modelsToGo.length; ++n) {
                this.modelsToGo[n] = this.modelsToSend[n];
            }
        }
        for (n = 0; n < this.modelsToGo.length; ++n) {
            if (this.modelsToGo[n] == null || this.highlightedItem == null) continue;
            this.putClothBackOnHanger();
        }
        this.setState(2);
    }

    void showMessageBox(GameObject gameObject, boolean bl) {
        if (bl) {
            this.mDressingRoom.enable(false);
            this.mLevel.addChild(gameObject);
            gameObject.focus(true);
            if (this.mGameState.touchScreenOn) {
                this.mGameState.setSoftkeys(1, 10);
            }
            GameState.getInstance().consumeKeyClicked();
        } else {
            gameObject.destroy();
            this.mDressingRoom.enable(true);
        }
    }

    void showRunwayMessageBox(GameObject gameObject, boolean bl) {
        if (bl) {
            this.mRunway.enable(false);
            this.mGameState.getRoot().addChild(gameObject);
            gameObject.focus(true);
            GameState.getInstance().consumeKeyClicked();
        } else {
            gameObject.destroy();
            this.mRunway.enable(true);
        }
    }

    void sendModelsRequest(GameObject gameObject, boolean bl) {
        int n;
        for (n = 0; n < this.modelsToGo.length; ++n) {
            this.modelsToGo[n] = null;
        }
        if (bl) {
            this.modelsToGo[0] = gameObject.getChildByHashName((byte)11);
            this.whichStage = this.mStages.getChildPosition(gameObject);
            System.out.println("________________________________whichStage= " + this.whichStage);
            this.sendModels(false);
        } else {
            n = 0;
            for (int i = 0; i < this.modelsToSend.length; ++i) {
                if (this.modelsToSend[i] == null) continue;
                ++n;
            }
            this.modelsToGo[0] = gameObject.getChildByHashName((byte)11);
            if (this.isStageModelReady(gameObject)) {
                this.whichStage = this.mStages.getChildPosition(gameObject);
                System.out.println("________________________________whichStage= " + this.whichStage);
                this.sendModels(false);
            }
        }
    }

    public void onMessage(GameObject gameObject, int n) {
        System.out.println("________________________________________________LevelRunway-> onMessage()");
        if (this.mState == 8) {
            if (n == 5) {
                Tools.println("1");
                GameObject[] gameObjectArray = this.mStages.getChildArray();
                Tools.println("2");
                GameObject gameObject2 = gameObjectArray[this.selectedStage].getChildByHashName((byte)11);
                Tools.println("3");
                this.levelStyleBoardId[DataTable.getInteger((GameObject)gameObject2, (String)"styleId", (int)-1)] = this.levelStyleUsedStyles[gameObject.mHashName];
                Tools.println("4");
                Helper.changeText(gameObjectArray[this.selectedStage].getChildByHashName((byte)24).getChildByHashName((byte)5), this.getShortStyleNameById(this.levelStyleBoardId[DataTable.getInteger(gameObject2, "styleId", -1)]));
                Tools.println("5");
                GameState.getInstance().consumeKeyClicked();
                this.setState(1);
            }
            return;
        }
        switch (n) {
            case 105: {
                this.mTouchedObject = gameObject;
                break;
            }
            case 5: {
                if (gameObject.mHashName == 1) {
                    Tools.println("new game");
                } else if (gameObject.mHashName == 10) {
                    if (!this.mGameState.touchScreenOn) {
                        this.changeItem = gameObject;
                    }
                } else if (gameObject.mHashName == 26 && this.mState == 1) {
                    this.sendModelsRequest(this.mStages.getChildArray()[DataTable.getInteger(gameObject, "stage", -1)], false);
                    this.mPointer.addProperty(new ObjectExtension(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2, 5));
                }
                if (gameObject.mHashName == 35 && gameObject.mParent.mHashName == 48) {
                    this.showRunwayMessageBox(Helper.getMessageBox(gameObject), false);
                }
                if (gameObject.mHashName == 33) {
                    if (gameObject.mParent.mHashName == 37) {
                        this.sendModels(true);
                        this.showMessageBox(Helper.getMessageBox(gameObject), false);
                    }
                } else if (gameObject.mHashName == 34) {
                    if (gameObject.mParent.mHashName == 37) {
                        this.sendModels(false);
                        this.showMessageBox(Helper.getMessageBox(gameObject), false);
                    }
                } else {
                    if (gameObject.mHashName != 12) break;
                    if (!this.mGameState.touchScreenOn) {
                        this.wearCloth(gameObject);
                        this.mPointer.addProperty(new ObjectExtension(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2, 5));
                    }
                }
                GameState.getInstance().consumeKeyClicked();
                Tools.println("sender.mHashName");
                Tools.println(gameObject.mHashName);
                Tools.println("stage ");
                Tools.println(23);
                break;
            }
            case 4: {
                if (this.mGameState.touchScreenOn || gameObject.mHashName != 12) break;
                this.putClothBackOnHanger();
                this.currentFocus = this.focus(this.focusArray, 4, this.currentFocus, this.getObjectNum(this.focusArray, this.mRail));
                this.mPointer.addProperty(new ObjectExtension(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2, 5));
                GameState.getInstance().consumeKeyClicked();
                break;
            }
            case 100: {
                if (gameObject.mHashName != 23) break;
            }
        }
    }

    void swap(int[] nArray, GameObject[] gameObjectArray, int n, int n2) {
        GameObject gameObject = gameObjectArray[n];
        int n3 = nArray[n];
        gameObjectArray[n] = gameObjectArray[n2];
        nArray[n] = nArray[n2];
        gameObjectArray[n2] = gameObject;
        nArray[n2] = n3;
    }

    void sort(int[] nArray, GameObject[] gameObjectArray) {
        boolean bl = false;
        do {
            bl = false;
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] <= nArray[i + 1]) continue;
                this.swap(nArray, gameObjectArray, i, i + 1);
                bl = true;
            }
        } while (bl);
    }

    void adjustLayers(GameObject gameObject) {
        int n;
        GameObject[] gameObjectArray = new GameObject[]{gameObject.getChildByHashName((byte)18), gameObject.getChildByHashName((byte)19), gameObject.getChildByHashName((byte)20)};
        int[] nArray = new int[3];
        for (n = 0; n < 3; ++n) {
            nArray[n] = this.getCloth(gameObjectArray[n]) != null ? (int)this.getCloth((GameObject)gameObjectArray[n]).layer : 0;
        }
        this.sort(nArray, gameObjectArray);
        for (n = 0; n < 3; ++n) {
            gameObject.addChild(gameObjectArray[n]);
        }
        gameObject.addChild(gameObject.getChildByHashName((byte)15));
    }

    public boolean hasDress(GameObject gameObject) {
        GameObject gameObject2;
        GameObject gameObject3 = gameObject.getChildTreeByHashName(this.getHashForType(1));
        if (gameObject3 != null && (gameObject2 = gameObject3.getChildByHashName((byte)12)) != null) {
            ClothingItem clothingItem = (ClothingItem)gameObject2.getPropertyByHashType((byte)12);
            return clothingItem.isDress();
        }
        return false;
    }

    public void wearCloth(GameObject gameObject) {
        GameObject gameObject2;
        this.mGameState.playSfx(5);
        GameObject gameObject3 = gameObject.mParent.mParent;
        ClothingItem clothingItem = (ClothingItem)gameObject.getPropertyByHashType((byte)12);
        if (clothingItem.mType == 1 && clothingItem.isDress()) {
            this.putClothOnRack(gameObject3, 2);
        } else if (clothingItem.mType == 2 && this.hasDress(gameObject3)) {
            this.putClothOnRack(gameObject3, 1);
        }
        GameObject gameObject4 = gameObject3.getChildTreeByHashName(this.getHashForType(clothingItem.mType));
        GameSprite gameSprite = (GameSprite)gameObject4.getPropertyByHashType((byte)13);
        if (gameSprite != null) {
            gameSprite.visible(false);
        }
        if ((gameObject2 = gameObject4.getChildByHashName((byte)12)) != gameObject) {
            GameObject gameObject5 = this.createItem(this.getCloth(gameObject4), true);
            this.highlightedRack.addChild(gameObject5);
            this.highlightedRack.enable(true);
            gameObject4.removeChild(gameObject2);
        } else {
            this.highlightedRack.destroy();
            this.mRail.onUpdate(this.mGameState);
        }
        clothingItem.setState(gameObject, 2);
        this.currentFocus = this.focus(this.focusArray, 3, this.currentFocus, -1);
        this.updateStage(gameObject3.mParent);
        this.highlightedItem = null;
        this.highlightedRack = null;
        this.adjustLayers(gameObject3);
    }

    public void itemToChange(GameObject gameObject, GameObject gameObject2, GameObject gameObject3) {
        if (gameObject == null) {
            return;
        }
        this.currentFocus = this.focus(this.focusArray, 4, this.currentFocus, -1);
        ClothingItem clothingItem = (ClothingItem)gameObject2.getPropertyByHashType((byte)12);
        GameObject gameObject4 = gameObject.getChildTreeByHashName(this.getHashForType(clothingItem.mType));
        if (clothingItem.mType == 2 && this.hasDress(gameObject) && gameObject4.mChild == null) {
            this.showUnderwear(gameObject, 2, false);
        }
        gameObject4.addChild(gameObject2);
        clothingItem.setState(gameObject2, 3);
        this.mPointer.addProperty(new ObjectExtension(gameObject2.getGlobalX() + GameResourceMgr.getWidth((short)46) / 2, gameObject2.getGlobalY() + GameResourceMgr.getWidth((short)46) / 2, 5));
        gameObject2.setLocalXY(0, 0);
        GameObject gameObject5 = gameObject4.getChildByHashName((byte)12);
        this.highlightedItem = gameObject2;
        if (gameObject3 != null) {
            this.highlightedRack = gameObject3;
            this.highlightedRack.enable(false);
        }
        gameObject.addChild(gameObject4);
    }

    public void exChangeHangerItem(GameObject gameObject, GameObject gameObject2) {
        Hanger hanger = (Hanger)gameObject2.getPropertyByHashType((byte)10);
        GameObject gameObject3 = gameObject.getChildTreeByHashName(this.getHashForType(hanger.mClothType));
        GameObject gameObject4 = gameObject2;
        GameObject gameObject5 = gameObject3.getChildByHashName((byte)12);
        if (gameObject5 != null) {
            GameObject gameObject6 = this.createItem(this.getCloth(gameObject3), true);
            gameObject2.addChild(gameObject6);
            gameObject3.removeChild(gameObject5);
        }
    }

    public void exChangeItem(GameObject gameObject, GameObject gameObject2) {
        GameObject gameObject3;
        GameObject gameObject4;
        ClothingItem clothingItem = (ClothingItem)gameObject2.getPropertyByHashType((byte)12);
        GameObject gameObject5 = gameObject.getChildTreeByHashName(this.getHashForType(clothingItem.mType));
        GameSprite gameSprite = (GameSprite)gameObject5.getPropertyByHashType((byte)13);
        if (gameSprite != null) {
            gameSprite.visible(false);
        }
        if ((gameObject4 = gameObject2.mParent) != null) {
            gameObject4.removeChild(gameObject2);
        }
        if ((gameObject3 = gameObject5.getChildByHashName((byte)12)) != null) {
            gameObject5.removeChild(gameObject3);
            if (gameObject4 != null) {
                gameObject4.addChild(gameObject3);
            }
            ClothingItem clothingItem2 = (ClothingItem)gameObject3.getPropertyByHashType((byte)12);
            clothingItem2.setState(gameObject2, 1);
        }
        gameObject5.addChild(gameObject2);
        clothingItem.setState(gameObject2, 2);
        gameObject2.setLocalXY(0, 0);
    }

    byte getHashForType(int n) {
        switch (n) {
            case 1: {
                return 18;
            }
            case 2: {
                return 19;
            }
            case 3: {
                return 20;
            }
        }
        return -1;
    }

    boolean loadCombo(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string);
        try {
            short s = dataInputStream.readByte();
            if (s > 0) {
                this.levelComboAttributes = new short[s][];
                this.levelComboAttributesBonus = new short[s];
                for (int i = 0; i < this.levelComboAttributes.length; ++i) {
                    this.levelComboAttributesBonus[i] = dataInputStream.readShort();
                    int n = dataInputStream.readByte();
                    this.levelComboAttributes[i] = new short[n];
                    for (int j = 0; j < n; ++j) {
                        this.levelComboAttributes[i][j] = dataInputStream.readShort();
                    }
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean loadStyles(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string);
        try {
            int n = dataInputStream.readShort();
            this.stylesAttributes = new short[n][];
            this.stylesAttributesWeight = new byte[n][];
            this.stylesSampleItems = new short[n][];
            for (int i = 0; i < n; ++i) {
                int n2;
                short s = dataInputStream.readShort();
                int n3 = dataInputStream.readByte();
                this.stylesAttributes[s] = new short[n3];
                this.stylesAttributesWeight[s] = new byte[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.stylesAttributes[s][n2] = dataInputStream.readShort();
                    this.stylesAttributesWeight[s][n2] = dataInputStream.readByte();
                }
                n3 = dataInputStream.readByte();
                this.stylesSampleItems[s] = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.stylesSampleItems[s][n2] = dataInputStream.readShort();
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            return true;
        }
        catch (Exception exception) {
            Tools.println("ERROR load styles: ");
            Tools.println(string);
            return false;
        }
    }

    boolean loadLevel(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string + ".bin");
        try {
            int n;
            int n2;
            int n3;
            String string2 = dataInputStream.readUTF();
            this.levelNumDressingRooms = dataInputStream.readByte();
            this.levelStartTime = (dataInputStream.readByte() * 1000 + 500) * 3;
            this.levelMaxTime = dataInputStream.readByte() * 1000 + 500;
            this.levelStartTime += this.levelStartTime / 5;
            this.levelMaxTime += this.levelMaxTime / 5;
            this.levelAccessoryAppearPt = dataInputStream.readShort();
            this.levelModelTimeBonus = dataInputStream.readByte() * 1000;
            this.levelModelTimeBonus += this.levelModelTimeBonus / 5;
            this.levelLeftChar = dataInputStream.readUTF();
            this.levelRightChar = dataInputStream.readUTF();
            this.levelBG = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            if (by == 1) {
                n3 = dataInputStream.readByte();
                this.levelOutfitStarPoints = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.levelOutfitStarPoints[n2] = (short)(dataInputStream.readShort() * 10);
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                n3 = dataInputStream.readByte();
                this.levelStarPoints = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.levelStarPoints[n2] = dataInputStream.readShort();
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                n3 = dataInputStream.readByte();
                for (n2 = 0; n2 < n3; ++n2) {
                    dataInputStream.readShort();
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                n3 = dataInputStream.readByte();
                for (n2 = 0; n2 < n3; ++n2) {
                    dataInputStream.readByte();
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                n3 = dataInputStream.readByte();
                for (n2 = 0; n2 < n3; ++n2) {
                    for (int i = 0; i < 4; ++i) {
                        if (dataInputStream.readByte() != 1) continue;
                        dataInputStream.readShort();
                    }
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                int n4;
                n3 = dataInputStream.readByte();
                this.levelStyleBoardId = new short[n3];
                this.levelStyleBoardFlag = new byte[n3];
                this.levelStyleBoardClimax = new byte[n3];
                this.levelStyleBoardDoubleTime = new byte[n3];
                this.currentStyle = 0;
                n2 = 0;
                short[] sArray = new short[n3];
                n = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    this.levelStyleBoardId[n4] = dataInputStream.readShort();
                    this.levelStyleBoardFlag[n4] = dataInputStream.readByte();
                    dataInputStream.readByte();
                    if ((this.levelStyleBoardFlag[n4] & 0x10) != 0) {
                        this.levelStyleBoardClimax[n4] = dataInputStream.readByte();
                    }
                    if ((this.levelStyleBoardFlag[n4] & 0x20) != 0) {
                        this.levelStyleBoardDoubleTime[n4] = dataInputStream.readByte();
                    }
                    if ((this.levelStyleBoardFlag[n4] & 4) != 0) {
                        ++n2;
                    }
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (sArray[i] != this.levelStyleBoardId[n4]) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    sArray[n++] = this.levelStyleBoardId[n4];
                }
                this.levelStyleUsedStyles = new short[n];
                for (n4 = 0; n4 < n; ++n4) {
                    this.levelStyleUsedStyles[n4] = sArray[n4];
                }
                if (n2 > 0) {
                    this.levelStylesToShow = new short[n2];
                    n2 = 0;
                    for (n4 = 0; n4 < n3; ++n4) {
                        if ((this.levelStyleBoardFlag[n4] & 4) == 0) continue;
                        this.levelStylesToShow[n2++] = this.levelStyleBoardId[n4];
                    }
                }
            }
            if ((by = dataInputStream.readByte()) == 1) {
                if (dataInputStream.readByte() == 1) {
                    int n5;
                    this.levelRackAllClothesSlotsNum = dataInputStream.readByte();
                    String string3 = dataInputStream.readUTF();
                    n2 = dataInputStream.readByte();
                    this.levelRackAllClothesId = new short[n2];
                    this.levelRackAllClothesFrequency = new byte[n2];
                    for (n5 = 0; n5 < n2; ++n5) {
                        this.levelRackAllClothesId[n5] = dataInputStream.readShort();
                        this.levelRackAllClothesFrequency[n5] = dataInputStream.readByte();
                    }
                    this.levelRackAllClothesBag = new short[4][];
                    n5 = 0;
                    Tools.println("maxtypes :");
                    Tools.println(n5);
                    for (n = 0; n < 4; ++n) {
                        if (this.createBag(n) == null) continue;
                        ++n5;
                    }
                    Tools.println("maxtypes :");
                    Tools.println(n5);
                    this.levelRackAllClothesBagTypes = new byte[n5];
                    n5 = 0;
                    for (n = 0; n < 4; n = (int)((byte)(n + 1))) {
                        if (this.levelRackAllClothesBag[n] == null) continue;
                        this.levelRackAllClothesBagTypes[n5++] = n;
                    }
                }
                if (dataInputStream.readByte() == 1) {
                    // empty if block
                }
                if (dataInputStream.readByte() == 1) {
                    // empty if block
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    Cloth[] loadClothes(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string + ".bin");
        Tools.println("loading clothes " + string);
        try {
            int n = dataInputStream.readShort();
            Tools.println("clothes size ");
            Tools.println(n);
            Cloth[] clothArray = new Cloth[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                clothArray[i] = new Cloth();
                clothArray[i].id = dataInputStream.readShort();
                clothArray[i].layer = dataInputStream.readByte();
                clothArray[i].backIndex = dataInputStream.readByte();
                Tools.println(">  " + clothArray[i].id);
                int n3 = dataInputStream.readByte();
                clothArray[i].attributes = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    clothArray[i].attributes[n2] = dataInputStream.readShort();
                }
                n3 = dataInputStream.readByte();
                if (n3 <= 0) continue;
                clothArray[i].cancels = new short[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    clothArray[i].cancels[n2] = dataInputStream.readShort();
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            return clothArray;
        }
        catch (Exception exception) {
            Tools.println("ERROR loading clothes ");
            Tools.println(string);
            exception.printStackTrace();
            return null;
        }
    }

    void loadClothes() {
        Cloth.clothes = new Cloth[1][4][];
        Cloth.clothes[0][1] = this.loadClothes("ClothingItems_Female_Shirts");
        Cloth.clothes[0][2] = this.loadClothes("ClothingItems_Female_Pants");
        Cloth.clothes[0][3] = this.loadClothes("ClothingItems_Female_Shoes");
    }

    int getRackItemsAction(GameObject gameObject, int n, int n2) {
        int n3 = 0;
        GameObject[] gameObjectArray = gameObject.getChildArray();
        if (gameObjectArray != null) {
            block6: for (int i = 0; i < gameObjectArray.length; ++i) {
                GameObject gameObject2 = gameObjectArray[i].getChildTreeByHashName((byte)12);
                switch (n) {
                    case 0: {
                        if (gameObject2 == null) continue block6;
                        ++n3;
                        continue block6;
                    }
                    case 1: {
                        ClothingItem clothingItem;
                        if (gameObject2 == null || (clothingItem = (ClothingItem)gameObject2.getPropertyByHashType((byte)12)) == null || clothingItem.mType != n2 && n2 != -1) continue block6;
                        ++n3;
                    }
                }
            }
        }
        switch (n) {
            default: 
        }
        return n3;
    }

    GameObject getBestScoreItem(int n, int n2) {
        GameObject[] gameObjectArray = this.mRail.getChildArray();
        GameObject gameObject = null;
        int n3 = -9999;
        if (gameObjectArray != null) {
            for (int i = 0; i < gameObjectArray.length; ++i) {
                ClothingItem clothingItem;
                GameObject gameObject2 = gameObjectArray[i].getChildTreeByHashName((byte)12);
                if (gameObject2 == null || (clothingItem = (ClothingItem)gameObject2.getPropertyByHashType((byte)12)) == null || clothingItem.mType != n2) continue;
                int n4 = this.getItemScore(gameObject2, n, null);
                Tools.println("style=");
                Tools.println(n);
                Tools.println(" score = ");
                Tools.println(n4);
                Tools.println(" max=");
                Tools.println(n3);
                if (n4 <= n3) continue;
                gameObject = gameObject2;
                n3 = n4;
            }
        }
        return gameObject;
    }

    int getCurrentFewestType() {
        int n = 99999999;
        int n2 = -1;
        int n3 = Tools.getRandom(0, this.levelRackAllClothesBagTypes.length);
        Tools.println("rand ");
        Tools.println(n3);
        n2 = this.levelRackAllClothesBagTypes[n3];
        n = this.getRackItemsAction(this.mRail, 1, n2);
        for (int i = 0; i < this.levelRackAllClothesBagTypes.length; ++i) {
            int n4 = this.levelRackAllClothesBagTypes[i];
            int n5 = this.getRackItemsAction(this.mRail, 1, n4);
            if (n5 >= n) continue;
            n = n5;
            n2 = n4;
        }
        return n2;
    }

    short[] createBag(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.levelRackAllClothesId.length; ++n2) {
            if (Cloth.getType(this.levelRackAllClothesId[n2]) != n) continue;
            ++n3;
        }
        if (n3 > 0) {
            this.levelRackAllClothesBag[n] = new short[n3];
            for (n2 = 0; n2 < this.levelRackAllClothesBag[n].length; ++n2) {
                this.levelRackAllClothesBag[n][n2] = -1;
            }
            return this.levelRackAllClothesBag[n];
        }
        return null;
    }

    int getBagNum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.levelRackAllClothesBag[n].length; ++i) {
            if (this.levelRackAllClothesBag[n][i] == -1) continue;
            ++n2;
        }
        return n2;
    }

    void fillBag(int n) {
        int n2 = 0;
        for (int i = 0; i < this.levelRackAllClothesId.length; ++i) {
            if (Cloth.getType(this.levelRackAllClothesId[i]) != n) continue;
            this.levelRackAllClothesBag[n][n2++] = this.levelRackAllClothesId[i];
        }
    }

    void refreshBag(int n) {
        if (this.getBagNum(n) <= 0) {
            this.fillBag(n);
        }
    }

    Cloth grabFromBag(int n) {
        int n2 = Tools.getRandom(0, this.getBagNum(n));
        Tools.println(" random num ");
        Tools.println(n2);
        int n3 = 0;
        for (int i = 0; i < this.levelRackAllClothesBag[n].length; ++i) {
            if (this.levelRackAllClothesBag[n][i] == -1 || n3++ != n2) continue;
            short s = this.levelRackAllClothesBag[n][i];
            this.levelRackAllClothesBag[n][i] = -1;
            Tools.println(" grab id ");
            Tools.println(s);
            Tools.println(" i ");
            Tools.println(i);
            return Cloth.getClothById(s);
        }
        return null;
    }

    void addNewItem(GameObject gameObject, int n, GameObject gameObject2) {
        Tools.println("type :");
        Tools.println(n);
        this.refreshBag(n);
        Cloth cloth = this.grabFromBag(n);
        if (gameObject2 == null) {
            gameObject2 = this.addHanger(gameObject);
        }
        Tools.println("addNewItem :a");
        this.addItem(gameObject2, this.createItem(cloth, true));
    }

    void addNewItem(GameObject gameObject, Cloth cloth, GameObject gameObject2) {
        if (gameObject2 == null) {
            gameObject2 = this.addHanger(gameObject);
        }
        Tools.println("addNewItem :b");
        this.addItem(gameObject2, this.createItem(cloth, true));
    }

    void addNewItem(GameObject gameObject) {
        int n = this.getCurrentFewestType();
        this.addNewItem(gameObject, n, null);
    }

    void updateRacks() {
        while (this.getRackItemsAction(this.mRail, 1, -1) < this.levelRackAllClothesSlotsNum) {
            this.addNewItem(this.mRail);
        }
    }

    void stagesSetBlink(int n) {
        GameObject[] gameObjectArray = this.mStages.getChildArray();
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i].getChildByHashName((byte)24);
            BlinkOnFocus blinkOnFocus = BlinkOnFocus.getBlinkOnFocus(gameObject);
            if (blinkOnFocus != null) {
                blinkOnFocus.destroy();
            }
            gameObject.visible(true);
            if (i != n) continue;
            gameObject.addProperty(new BlinkOnFocus(true));
        }
    }

    void selectStage(int n) {
        this.stagesSetBlink(-1);
        if (this.mState == 6) {
            GameObject[] gameObjectArray = this.mStages.getChildArray();
            GameObject gameObject = gameObjectArray[n].getChildByHashName((byte)11);
            this.putClothesOnRack(gameObject, true);
            for (int i = 1; i < 4; ++i) {
                GameObject gameObject2 = this.getBestScoreItem(this.levelStyleBoardId[DataTable.getInteger(gameObject, "styleId", -1)], i);
                if (gameObject2 == null) continue;
                this.itemToChange(gameObject, gameObject2, gameObject2.mParent);
                this.wearCloth(gameObject2);
            }
            this.setState(1);
        } else {
            this.selectedStage = n;
            this.setState(8);
        }
    }

    void onKeyClicked(int n) {
        System.out.println(" __onKeyClicked-> keyAction= " + n + "  mState= " + this.mState);
        if (n == 6 && this.mScoreState != 2) {
            this.mGameState.onPause();
            return;
        }
        switch (this.mState) {
            case 6: 
            case 7: {
                if (this.mGameState.touchScreenOn) break;
                if (n == 1) {
                    this.nextStage(false);
                    this.stagesSetBlink(this.currentStage);
                    break;
                }
                if (n == 2) {
                    this.nextStage(true);
                    this.stagesSetBlink(this.currentStage);
                    break;
                }
                if (n != 5) break;
                this.selectStage(this.currentStage);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                if (this.timeOut && n == 5) {
                    this.setState(3);
                }
                if (this.mGameState.touchScreenOn || !this.mDressingRoom.isFlag(4)) break;
                if (this.highlightedItem != null) {
                    if (n == 1) {
                        GameObject gameObject = this.currentHighlightedModel(true, this.highlightedItem);
                        this.itemToChange(gameObject, this.highlightedItem, this.highlightedRack);
                        break;
                    }
                    if (n != 2) break;
                    GameObject gameObject = this.currentHighlightedModel(false, this.highlightedItem);
                    this.itemToChange(gameObject, this.highlightedItem, this.highlightedRack);
                    break;
                }
                switch (n) {
                    case 3: {
                        this.currentFocus = this.focus(this.focusArray, 1, this.currentFocus, -1);
                        if (this.currentFocus != 0) break;
                        this.mPointer.addProperty(new ObjectExtension(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2, 5));
                        break;
                    }
                    case 4: {
                        this.currentFocus = this.focus(this.focusArray, 2, this.currentFocus, -1);
                        if (this.currentFocus != 0) break;
                        this.mPointer.addProperty(new ObjectExtension(GameCanvas.WIDTH_2, this.getRailHeight() + this.getRackHeight() / 2, 5));
                    }
                }
                break;
            }
            case 2: {
                System.out.println("____________________________________________________ALA MA KOTA");
                if (n != 5) break;
                this.advanceRunwayState();
                break;
            }
            case 9: {
                if (n == 5) {
                    this.advanceScoreState();
                    break;
                }
                if (n != 6) break;
                if (this.levelStars >= 3) {
                    GameState.levelReplay = true;
                    this.advanceScoreState();
                    break;
                }
                this.mGameState.onPause();
                return;
            }
            case 3: {
                break;
            }
            case 4: {
                if (n != 5) break;
                this.nextStyleToShow();
                break;
            }
            case 5: {
                if (n != 5) break;
                this.setState(1);
            }
        }
    }

    void advanceRunwayState() {
        System.out.println("_________________________________________adavanceRunwayState()");
        switch (this.mRunwayState) {
            case 2: {
                this.setStyleShowState(2);
                this.setStyleShowState(3);
                this.setStyleShowState(4);
                this.setStyleShowState(5);
                break;
            }
            case 8: {
                this.setStyleShowState(6);
                break;
            }
            case 7: {
                this.mRunwayState = 1;
                this.setState(1);
            }
        }
    }

    void advanceScoreState() {
        switch (this.mScoreState) {
            case 0: {
                this.showScore(1);
                break;
            }
            case 1: {
                this.showScore(2);
                break;
            }
            case 2: {
                this.setState(3);
            }
        }
    }

    void showScore(int n) {
        int n2;
        int n3;
        this.mScoreState = n;
        int n4 = 15;
        int n5 = -1;
        GameObject gameObject = new GameObject();
        for (n3 = 0; n3 < this.scoreModelsTable.length; ++n3) {
            System.out.println("____________________przed_____________scoreModelTable[" + n3 + "]= " + this.scoreModelsTable[n3]);
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            for (n2 = 0; n2 < n4 - 1 - 1; ++n2) {
                if (this.scoreModelsTable[n2] <= this.scoreModelsTable[n2 + 1] || this.scoreModelsTable[n2 + 1] == -1) continue;
                n5 = this.scoreModelsTable[n2];
                this.scoreModelsTable[n2] = this.scoreModelsTable[n2 + 1];
                this.scoreModelsTable[n2 + 1] = n5;
                gameObject = scoreModels[n2];
                LevelRunway.scoreModels[n2] = scoreModels[n2 + 1];
                LevelRunway.scoreModels[n2 + 1] = gameObject;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.mScore.addChild(scoreModels[n3]);
        }
        for (n3 = 0; n3 < this.scoreModelsTable.length; ++n3) {
            System.out.println("_______________po__________________scoreModelTable[" + n3 + "]= " + this.scoreModelsTable[n3]);
        }
        n3 = 0;
        switch (this.mScoreState) {
            case 0: {
                this.mScoreModel.destroyAllChildrenNow();
                this.mScoreModel.addChild(this.mGameState.makeText(GameState.getText(59), GameCanvas.WIDTH_2));
                n2 = Tools.getRandom(0, 7);
                this.mScoreModel.addChild(this.mGameState.makeText(GameState.getText(61 + n2), GameCanvas.WIDTH_2 + GameState.gFonts[1].getHeight() + GameState.gFonts[1].getHeight() / 2));
                GameSprite.flagMirror = true;
                this.mScoreModel.addChild(Helper.createSimpleImage((short)170, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)173, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)164, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)168, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                GameSprite.flagMirror = false;
                scoreModels[0].enableAndVisible(true);
                break;
            }
            case 1: {
                this.mScoreModel.destroyAllChildrenNow();
                this.mScoreModel.addChild(this.mGameState.makeText(GameState.getText(60), GameCanvas.WIDTH_2));
                int n6 = Tools.getRandom(0, 7);
                this.mScoreModel.addChild(this.mGameState.makeText(GameState.getText(68 + n6), GameCanvas.WIDTH_2 + GameState.gFonts[1].getHeight() + GameState.gFonts[1].getHeight() / 2));
                GameSprite.flagMirror = true;
                this.mScoreModel.addChild(Helper.createSimpleImage((short)170, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)174, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)163, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                this.mScoreModel.addChild(Helper.createSimpleImage((short)167, GameCanvas.WIDTH, GameCanvas.HEIGHT, 40, 0, true));
                GameSprite.flagMirror = false;
                scoreModels[0].enableAndVisible(false);
                n3 = 5;
                for (int i = 6; i < this.scoreModelsTable.length; ++i) {
                    if (this.scoreModelsTable[i] == -1) {
                        n3 = i - 1;
                        break;
                    }
                    if (this.scoreModelsTable[14] == -1) continue;
                    n3 = 14;
                    break;
                }
                scoreModels[n3].visible(true);
                break;
            }
            case 2: {
                int n7;
                this.mScoreModel.destroyAllChildrenNow();
                this.mScoreModel.enableAndVisible(false);
                int n8 = 6;
                for (n7 = 6; n7 < this.scoreModelsTable.length; ++n7) {
                    if (this.scoreModelsTable[n7] == -1) {
                        n8 = n7;
                        break;
                    }
                    if (this.scoreModelsTable[14] == -1) continue;
                    n8 = 15;
                    break;
                }
                n8 -= 6;
                for (n7 = 0; n7 < 6; ++n7) {
                    scoreModels[n7 + n8].enableAndVisible(true);
                }
                for (n7 = 0; n7 < 6; ++n7) {
                    if (n7 == 0 || n7 == 1) {
                        scoreModels[n7 + n8].setLocalXY(2 * GameCanvas.WIDTH / 3 - (n7 + 1) * GameCanvas.WIDTH / 12 - n7 * 4 * GameCanvas.WIDTH / 12, GameCanvas.HEIGHT / 5);
                        scoreModels[n7 + n8].enableAndVisible(true);
                    }
                    if (n7 == 2 || n7 == 3) {
                        scoreModels[n7 + n8].setLocalXY(2 * GameCanvas.WIDTH / 3 - (n7 - 1) * GameCanvas.WIDTH / 6 - (n7 - 2) * 4 * GameCanvas.WIDTH / 12, GameCanvas.HEIGHT / 4);
                        scoreModels[n7 + n8].enableAndVisible(true);
                    }
                    if (n7 != 4 && n7 != 5) continue;
                    scoreModels[n7 + n8].setLocalXY(2 * GameCanvas.WIDTH / 3 - 0 - (n7 - 4) * 4 * GameCanvas.WIDTH / 12, GameCanvas.HEIGHT / 3);
                    scoreModels[n7 + n8].enableAndVisible(true);
                }
                if (this.levelStars < 3) break;
                this.mGameState.setSoftkeys(21, 24);
                int n9 = Tools.getRandom(0, 7);
                GameObject gameObject2 = this.mScore.addChild(this.mGameState.makeText(GameState.getText(75 + n9), GameCanvas.WIDTH_2 + GameState.gFonts[1].getHeight() + GameState.gFonts[1].getHeight() / 2));
                if (gameObject2 == null) break;
            }
        }
    }

    void setStyleShowState(int n) {
        this.mRunwayState = n;
        switch (this.mRunwayState) {
            case 2: {
                this.addInfo(this.modelsToGo[this.mRunwayCurrentModel], 1);
                break;
            }
            case 3: {
                this.addInfo(this.modelsToGo[this.mRunwayCurrentModel], 2);
                break;
            }
            case 4: {
                this.addInfo(this.modelsToGo[this.mRunwayCurrentModel], 3);
                break;
            }
            case 5: {
                if (this.noScores) {
                    this.resetStyleChain();
                    this.setStyleShowState(6);
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = this.addComboScore(this.modelsToGo[this.mRunwayCurrentModel], stringBuffer);
                if (n2 != 0) {
                    this.mRunwayData.destroyAllChildrenNow();
                    this.addBonusInfo(this.mRunwayData, n2, GameState.getText(25), 100, 190, stringBuffer.toString(), 3);
                    this.setStyleShowState(8);
                    break;
                }
                this.setStyleShowState(8);
                break;
            }
            case 8: {
                Tools.println("modelsToGo[ mRunwayCurrentModel ]");
                Tools.println(" num: ");
                Tools.println(this.mRunwayCurrentModel);
                int n3 = this.addClimaxScore(this.modelsToGo[this.mRunwayCurrentModel]);
                int n4 = this.addStyleChainScore(this.modelsToGo[this.mRunwayCurrentModel]);
                if (n4 <= 0 && n3 <= 0) break;
                this.mRunwayData.destroyAllChildrenNow();
                String string = null;
                if (n4 > 0) {
                    string = GameState.getText(53);
                }
                if (n3 > 0) {
                    string = string != null ? string + "\n" : "";
                    string = string + GameState.getText(33);
                }
                this.addBonusInfo(this.mRunwayData, n4 + n3, GameState.getText(25), 100, 190, string, 3);
                break;
            }
            case 6: {
                Tools.println("RUNWAY_STATE_END");
                this.ania = this.modelsToGo[this.mRunwayCurrentModel];
                scoreModels[this.ja].addChild(this.ania);
                int n5 = 0;
                if (this.ja - 1 > -1) {
                    for (int i = 0; i < this.ja; ++i) {
                        n5 += this.scoreModelsTable[i];
                    }
                    this.scoreModelsTable[this.ja] = this.levelScore - n5;
                } else {
                    this.scoreModelsTable[this.ja] = this.levelScore;
                }
                this.putClothesOnRack(this.modelsToGo[this.mRunwayCurrentModel], false);
                if (this.ania != null && this.hasDress(this.ania)) {
                    this.showUnderwear(this.ania, 2, false);
                    this.showUnderwear(this.ania, 1, false);
                }
                this.modelsToGo[this.mRunwayCurrentModel] = null;
                this.nextModelToCheck();
                break;
            }
            case 7: {
                if (this.mModelChainBonus > 0) {
                    this.levelScore += this.mModelChainBonus;
                    this.updateLevelScore();
                    this.mRunwayData.destroyAllChildrenNow();
                    this.addBonusInfo(this.mRunwayData, this.mModelChainBonus, GameState.getText(25), 100, 190, GameState.getText(52), 3);
                    this.mModelChainBonus = 0;
                    break;
                }
                this.mRunwayState = 1;
            }
        }
    }

    int focus(GameObject[] gameObjectArray, int n, int n2, int n3) {
        GameObject gameObject;
        int n4 = n2;
        if (n == 1) {
            if (++n4 >= gameObjectArray.length) {
                n4 = n3 == 999 ? 0 : gameObjectArray.length - 1;
            }
        } else if (n == 2) {
            if (--n4 < 0) {
                n4 = n3 == 999 ? gameObjectArray.length - 1 : 0;
            }
        } else if (n == 3) {
            n4 = 0;
        } else if (n == 4) {
            n4 = n3;
        } else {
            return n4;
        }
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject2 = gameObjectArray[i];
            if (gameObject2 == null) continue;
            if (i == n4) {
                gameObject2.focus(true);
                continue;
            }
            gameObject2.focus(false);
        }
        if (!(n != 1 && n != 2 || (gameObject = gameObjectArray[n4]).isFlag(4))) {
            return this.focus(gameObjectArray, n, n4, 999);
        }
        return n4;
    }

    void setState(int n) {
        int n2;
        GameState.getInstance().consumeKeyClicked();
        System.out.println("____________________________________________________setStste-> ma zmienic na state= " + n);
        System.out.println("_____________________________________________________setStste-> byl state= " + this.mState);
        if (this.mState == n) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.mLevel.enableAndVisible(false);
                break;
            }
            case 2: {
                System.out.println("_____________________________________________________wyszlo z STATE_RUNWAY");
                this.mRunway.enableAndVisible(false);
                this.mLevelModel.enableAndVisible(false);
                this.mRunwayModel.destroyAllChildrenNow();
                this.mRunwayState = 2;
                break;
            }
            case 4: {
                Tools.println("remove styles show");
                this.mStylesToShow.destroyNow();
                this.mStylesToShow = null;
                break;
            }
            case 9: {
                this.mScore.enableAndVisible(false);
                this.mScoreState = 0;
                if (this.ania != null) {
                    this.ania.destroyNow();
                }
                for (n2 = 0; n2 < this.scoreModelsTable.length; ++n2) {
                    this.scoreModelsTable[n2] = -1;
                }
                break;
            }
            case 5: {
                if (this.mStylesToShow != null) {
                    this.mStylesToShow.destroyNow();
                }
                this.mStylesToShow = null;
                break;
            }
            case 6: 
            case 7: {
                this.currentStage = this.saveCurrentStage;
                this.gamePlayfield.addChild(this.mStages, false, this.mSendButtons);
                this.mMatchingObject.destroyNow();
                this.mMatchingObject = null;
                break;
            }
            case 8: {
                this.mMatchingObject.destroyNow();
                this.mMatchingObject = null;
            }
        }
        this.mState = n;
        switch (n) {
            case 1: {
                if (this.timeOut) break;
                this.mLevel.enableAndVisible(true);
                if (this.levelTime <= 0) {
                    this.currentStage = this.getFirstStage();
                    if (this.currentStage < 0) {
                        this.setState(9);
                    }
                } else if (this.fillAllStages(true)) {
                    this.setState(9);
                }
                this.currentFocus = this.focus(this.focusArray, 3, this.currentFocus, -1);
                this.displayLevelScore = this.levelScore;
                this.temp = this.levelScore;
                this.mGameState.setSoftkeys(this.mGameState.touchScreenOn ? -1 : 1, 10);
                break;
            }
            case 2: {
                Tools.println("state = STATE_RUNWAY");
                System.out.println("________________________________________________________setState-> STATE_RUNWAY");
                this.mLevel.enable(false);
                this.mLevelModel.enableAndVisible(true);
                this.mLevel.visible(true);
                if (this.timeOut) {
                    this.mLevel.addChild(Helper.makePopup(GameState.getText(82), (byte)5, this, (byte)1, 0, 16729234, 0xE0E0E0));
                    this.setState(1);
                    break;
                }
                n2 = 0;
                this.mModelChainBonus = 0;
                for (int i = 0; i < this.modelsToGo.length; ++i) {
                    if (this.modelsToGo[i] == null) continue;
                    short[] sArray = new short[]{0, 250, 500};
                    this.mModelChainBonus = sArray[n2++];
                }
                this.nextModelToCheck();
                this.mGameState.setSoftkeys(21, 10);
                break;
            }
            case 9: {
                Tools.println("state = STATE_SCORE");
                this.mLevel.destroyAllChildrenNow();
                this.mScore.enableAndVisible(true);
                GameState.levelReplay = false;
                this.showScore(0);
                this.mGameState.setSoftkeys(21, 10);
                break;
            }
            case 3: {
                this.mScore.destroyAllChildrenNow();
                if (this.mGameState.stageLevelScores[this.mGameState.levelToLoad >> 16][this.mGameState.levelToLoad & 0xFF] < (short)(this.levelScore / 10) && !this.timeOut) {
                    this.mGameState.stageLevelScores[this.mGameState.levelToLoad >> 16][this.mGameState.levelToLoad & 0xFF] = (short)(this.levelScore / 10);
                    this.mGameState.stageLevelStars[this.mGameState.levelToLoad >> 16][this.mGameState.levelToLoad & 0xFF] = this.levelStars;
                }
                this.mGameState.saveRms();
                Tools.println("levelStars ");
                Tools.println(this.levelStars);
                Tools.println("levelScore ");
                Tools.println(this.levelScore);
                this.mGameState.lastLevelStars = this.levelStars;
                this.mGameState.lastLevelScore = (short)(this.levelScore / 10);
                if (this.levelStars >= 3 && !this.timeOut) {
                    GameState.getInstance().gotoState(14);
                    break;
                }
                GameState.getInstance().gotoState(15);
                break;
            }
            case 4: {
                if (this.mStylesToShow == null) {
                    this.mStylesToShow = new GameObject();
                    this.mGameState.getRoot().addChild(this.mStylesToShow);
                }
                this.nextStyleToShow();
                this.mGameState.setSoftkeys(21, 10);
                break;
            }
            case 5: {
                this.mLevel.enableAndVisible(true);
                this.mLevel.onUpdate(this.mGameState);
                this.mLevel.enable(false);
                this.mStylesToShow = new GameObject();
                this.mStylesToShow.focus(true);
                this.mStylesToShow.addChild(Helper.makeMessageBox(this.mGameState.getHowToPlayText(), 21, 10, (byte)37, this, (byte)1, 3, 16729234, 0xE0E0E0, 3).focus(true));
                this.mLevel.visible(true);
                this.mGameState.getRoot().addChild(this.mStylesToShow);
                break;
            }
            case 6: 
            case 7: {
                this.putClothBackOnHanger();
                this.saveCurrentStage = this.currentStage;
                GameObject[] gameObjectArray = this.mStages.getChildArray();
                for (int i = 0; i < gameObjectArray.length; ++i) {
                    if (!gameObjectArray[i].isFlag(4)) continue;
                    this.currentStage = i;
                    break;
                }
                this.stagesSetBlink(this.currentStage);
                this.mMatchingObject = new GameObject();
                this.mMatchingObject.addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, GameCanvas.HEIGHT, 0, true));
                this.mMatchingObject.addChild(Helper.makeLabel(n == 6 ? GameState.getText(35) : GameState.getText(34), (byte)0, GameCanvas.WIDTH_2, this.levelStageStartY / 2, 3, (byte)1, GameCanvas.WIDTH, -1, false));
                this.mMatchingObject.addChild(this.mStages);
                this.mGameState.getRoot().addChild(this.mMatchingObject);
                break;
            }
            case 8: {
                String[] stringArray = new String[this.levelStyleUsedStyles.length];
                byte[] byArray = new byte[this.levelStyleUsedStyles.length];
                for (int i = 0; i < byArray.length; ++i) {
                    stringArray[i] = this.getShortStyleNameById(this.levelStyleUsedStyles[i]);
                    byArray[i] = (byte)i;
                }
                this.mMatchingObject = new GameObject();
                this.mMatchingObject.focus(true);
                this.mMatchingObject.addChild(Helper.makeLabel(GameState.getText(34), (byte)0, GameCanvas.WIDTH_2, this.levelStageStartY / 2, 3, (byte)1, GameCanvas.WIDTH, -1, false));
                this.mMatchingObject.addChild(this.mGameState.makeSimpleMenu(stringArray, byArray, 20, true, this));
                this.mGameState.getRoot().addChild(this.mMatchingObject);
            }
        }
    }

    void updateLevelScore() {
        for (int i = this.levelStarPoints.length - 1; i >= 0; --i) {
            if (this.levelScore < this.levelStarPoints[i] * 10) continue;
            this.levelStars = (byte)(i + 1);
            break;
        }
    }

    boolean nextModelToCheck() {
        if (this.mRunwayModel != null) {
            this.mRunwayModel.destroyAllChildrenNow();
        }
        if (this.mRunwayData != null) {
            this.mRunwayData.destroyAllChildrenNow();
        }
        for (int i = 0; i < this.modelsToGo.length; ++i) {
            if (this.modelsToGo[i] == null) continue;
            Tools.println("modelsToGo= ");
            Tools.println(i);
            this.mRunwayModel.addChild(this.modelsToGo[i]);
            int n = GameDefs.RUNWAY_MODEL_Y;
            if (n + this.modelHeight() > GameCanvas.GAME_HEIGHT) {
                n = GameCanvas.GAME_HEIGHT - this.modelHeight();
            }
            this.modelsToGo[i].setLocalXY(0, n);
            this.mRunwayCurrentModel = i;
            ++this.ja;
            this.calcScore(this.modelsToGo[i]);
            return false;
        }
        this.updateSendButton();
        if (this.mModelChainBonus > 0) {
            this.setStyleShowState(7);
            return true;
        }
        this.setState(1);
        return true;
    }

    void goToRunway() {
    }

    void updateState() {
    }

    ClothingItem getClothingItem(GameObject gameObject) {
        if (gameObject != null) {
            GameObject gameObject2 = gameObject.getChildByHashName((byte)12);
            if (gameObject2 == null) {
                gameObject2 = gameObject;
            }
            if (gameObject2 != null) {
                return (ClothingItem)gameObject2.getPropertyByHashType((byte)12);
            }
        }
        return null;
    }

    Cloth getCloth(GameObject gameObject) {
        ClothingItem clothingItem = this.getClothingItem(gameObject);
        if (clothingItem != null) {
            return Cloth.getClothById(clothingItem.mClothId);
        }
        return null;
    }

    int getItemScore(GameObject gameObject, int n, StringBuffer stringBuffer) {
        return this.getItemScore(n, this.getCloth(gameObject), stringBuffer);
    }

    int addComboScores(GameObject gameObject) {
        boolean bl = false;
        for (int i = 0; i < this.levelComboAttributes.length; ++i) {
            int n = 0;
            block1: for (int j = 0; j < this.levelComboAttributes[i].length; ++j) {
                for (int k = 1; k < 4; ++k) {
                    Cloth cloth;
                    byte by = this.getHashForType(k);
                    if (by <= 0 || (cloth = this.getCloth(gameObject.getChildByHashName(by))) == null || !cloth.hasAttribute(this.levelComboAttributes[i][j])) continue;
                    ++n;
                    continue block1;
                }
            }
            if (n < this.levelComboAttributes[i].length) continue;
            Tools.println("add bonus[ ");
            Tools.println(i);
            Tools.println(" ] ");
            Tools.println(this.levelComboAttributesBonus[i]);
            return i;
        }
        return -1;
    }

    String getStyleNameById(int n) {
        return GameState.getText(84 + n);
    }

    String getShortStyleNameById(int n) {
        return this.getStyleNameById(n);
    }

    int getStarBurstY() {
        return Math.min(250, GameCanvas.GAME_HEIGHT);
    }

    int modelHeight() {
        return GameResourceMgr.getHeight((short)46);
    }

    void addBonusInfo(GameObject gameObject, int n, String string, int n2, int n3, String string2, int n4) {
        int n5 = 0;
        int n6 = GameCanvas.WIDTH - 100 - n5 / 2;
        if (n3 + n5 / 2 > GameCanvas.GAME_HEIGHT) {
            n3 = GameCanvas.GAME_HEIGHT - n5 / 2;
        }
        if (string2 != null) {
            int n7 = this.getStarBurstY() - 130 + n5;
            if (n7 / 2 + 190 > GameCanvas.GAME_HEIGHT) {
                n7 = (GameCanvas.GAME_HEIGHT - 190) * 2;
            }
            gameObject.addChild(Helper.makeMessageBox(string2, -1, -1, (byte)0, null, (byte)0, 5, n6, n7, 0xFFFFFF, 0, n4).setLocalXY(100 + n5 / 2 + n6 / 2, 190));
        }
    }

    void updateModelScore(GameObject gameObject) {
        GameObject gameObject2 = this.mRunwayModel.getChildByHashName((byte)5);
        if (gameObject2 == null) {
            gameObject2 = Helper.makeLabel("", (byte)5, GameCanvas.WIDTH_2, 60, 3, (byte)1);
            this.mRunwayModel.addChild(gameObject2);
        }
        Helper.changeText(gameObject2, "" + this.lastModelScoreOverall);
        int n = -1;
        for (int i = 0; i < this.levelOutfitStarPoints.length; ++i) {
            if (this.lastModelScoreOverall < this.levelOutfitStarPoints[i]) continue;
            n = i;
        }
        if (n < 0 || n >= 2) {
            // empty if block
        }
        this.updateLevelScore();
    }

    void addInfo(GameObject gameObject, int n) {
        this.mRunwayData.destroyAllChildrenNow();
        int n2 = 0;
        Object var4_4 = null;
        int n3 = this.lastModelScore[n] > 0 ? this.lastModelScore[n] : 0;
        int n4 = 0;
        switch (n) {
            case 1: {
                n4 = 130;
                n2 = 17;
                break;
            }
            case 2: {
                n4 = 190;
                n2 = 3;
                break;
            }
            case 3: {
                n4 = this.getStarBurstY();
                n2 = 33;
            }
        }
        int n5 = 0;
        int n6 = GameCanvas.WIDTH - 100 - n5 / 2;
        String string = null;
        string = this.lastModelScore[n] >= 0 ? this.lastModelScoreAttributes[n].toString() : (this.lastModelScore[n] == -1 ? GameState.getText(31) : GameState.getText(32));
        if (this.noScores) {
            n3 = 0;
        }
        this.addBonusInfo(this.mRunwayData, n3, null, 100, n4, string, n2);
        this.levelScore += n3;
        this.lastModelScoreOverall += n3;
        Tools.println("item score");
        Tools.println(n3);
        this.updateModelScore(gameObject);
    }

    void calcScore(GameObject gameObject) {
        int n;
        for (n = 0; n < this.lastModelScore.length; ++n) {
            this.lastModelScore[n] = -10;
            this.lastModelScoreAttributes[n] = new StringBuffer();
        }
        n = this.levelStyleBoardId[DataTable.getInteger(gameObject, "styleId", 2)];
        String string = this.getStyleNameById(n);
        this.lastModelScore[1] = this.getItemScore(gameObject.getChildByHashName((byte)18), n, this.lastModelScoreAttributes[1]);
        this.lastModelScore[2] = this.hasDress(gameObject) ? this.lastModelScore[1] : this.getItemScore(gameObject.getChildByHashName((byte)19), n, this.lastModelScoreAttributes[2]);
        this.lastModelScore[3] = this.getItemScore(gameObject.getChildByHashName((byte)20), n, this.lastModelScoreAttributes[3]);
        this.noScores = false;
        for (int i = 0; i < this.lastModelScore.length; ++i) {
            if (this.lastModelScore[i] != -1) continue;
            this.noScores = true;
        }
        this.mRunwayData.destroyAllChildrenNow();
        this.lastModelScoreOverall = 0;
        this.mRunwayModel.addChild(Helper.makeLabel(string, (byte)0, GameCanvas.WIDTH_2, 90, 3, (byte)1));
        this.mRunwayModel.addChild(Helper.createSimpleImage((short)254, GameCanvas.WIDTH_2, 50, 3, 0));
        if (this.mRunwayState == 2) {
            this.advanceRunwayState();
        }
    }

    int addComboScore(GameObject gameObject, StringBuffer stringBuffer) {
        int n = this.addComboScores(gameObject);
        if (n <= 0) {
            return 0;
        }
        short s = this.levelComboAttributesBonus[n];
        for (int i = 0; i < this.levelComboAttributes[n].length; ++i) {
            if (i != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getStyleAttributeName(this.levelComboAttributes[n][i]));
        }
        Tools.println(" bonus score ");
        this.lastModelScoreOverall += s;
        this.levelScore += s;
        this.updateModelScore(gameObject);
        return s;
    }

    int addClimaxScore(GameObject gameObject) {
        int n = 0;
        if (this.climaxTime > 0) {
            Tools.println("add climax:");
            n += this.lastModelScoreOverall;
        }
        GameObject gameObject2 = this.mRunwayModel.getChildByHashName((byte)5);
        Helper.changeText(gameObject2, "" + this.lastModelScoreOverall * (this.climaxTime > 0 ? 2 : 1));
        this.levelScore += n;
        this.updateLevelScore();
        return n;
    }

    void resetStyleChain() {
        this.styleChainNum = 0;
        this.styleChainId = -1;
        this.updateStyleChain();
    }

    void updateStyleChain() {
    }

    int addStyleChainScore(GameObject gameObject) {
        int n = DataTable.getInteger(gameObject, "styleId", 2);
        boolean bl = false;
        int n2 = 0;
        if (!this.noScores) {
            if (this.levelStyleBoardId[n] == this.styleChainId) {
                ++this.styleChainNum;
            } else {
                this.styleChainNum = 0;
                this.styleChainId = this.levelStyleBoardId[n];
            }
        } else {
            this.resetStyleChain();
        }
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        if (this.styleChainNum < nArray.length) {
            n2 += nArray[this.styleChainNum];
            Tools.println(" style chain bonus score ");
            Tools.println(nArray[this.styleChainNum]);
        } else {
            n2 += nArray[nArray.length - 1];
            Tools.println(" style chain bonus score ");
            Tools.println(nArray[nArray.length - 1]);
        }
        this.levelScore += n2;
        Tools.println("overall score ");
        Tools.println(n2);
        Tools.println("level score ");
        Tools.println(this.levelScore);
        this.updateStyleChain();
        this.updateLevelScore();
        return n2;
    }

    void showUnderwear(GameObject gameObject, int n, boolean bl) {
        GameObject gameObject2 = gameObject.getChildByHashName(this.getHashForType(n));
        GameSprite gameSprite = (GameSprite)gameObject2.getPropertyByHashType((byte)13);
        if (gameSprite != null) {
            gameSprite.visible(bl);
        }
    }

    void putClothOnRack(GameObject gameObject, int n) {
        if (gameObject != null) {
            MenuSelector menuSelector;
            byte by;
            int n2 = n;
            if (this.hasDress(gameObject)) {
                this.showUnderwear(gameObject, 1, true);
                this.showUnderwear(gameObject, 2, true);
            }
            if ((by = this.getHashForType(n2)) > 0) {
                GameSprite gameSprite;
                GameObject gameObject2 = gameObject.getChildByHashName(by);
                ClothingItem clothingItem = this.getClothingItem(gameObject2);
                if (clothingItem != null) {
                    this.addNewItem(this.mRail, Cloth.getClothById(clothingItem.mClothId), null);
                }
                if ((gameSprite = (GameSprite)gameObject2.getPropertyByHashType((byte)13)) != null) {
                    gameSprite.visible(true);
                }
                gameObject2.destroyAllChildrenNow();
            }
            if ((menuSelector = MenuSelector.getMenuSelector(this.mRail)) != null) {
                menuSelector.reset();
                menuSelector.sortItems(this.mRail);
            }
        }
    }

    void putClothesOnRack(GameObject gameObject, boolean bl) {
        if (gameObject != null) {
            this.showUnderwear(gameObject, 1, true);
            this.showUnderwear(gameObject, 2, true);
            for (int i = 1; i < 4; ++i) {
                byte by = this.getHashForType(i);
                if (by <= 0) continue;
                GameObject gameObject2 = gameObject.getChildByHashName(by);
                ClothingItem clothingItem = this.getClothingItem(gameObject2);
                if (bl) {
                    if (clothingItem == null) continue;
                    this.addNewItem(this.mRail, Cloth.getClothById(clothingItem.mClothId), null);
                    continue;
                }
                if (clothingItem == null) continue;
                this.addNewItem(this.mRail, clothingItem.getType(), null);
            }
            MenuSelector menuSelector = MenuSelector.getMenuSelector(this.mRail);
            if (menuSelector != null) {
                menuSelector.reset();
                menuSelector.sortItems(this.mRail);
            }
        }
    }

    String getStyleAttributeName(int n) {
        return GameState.getText(116 + n);
    }

    int getItemScore(int n, Cloth cloth, StringBuffer stringBuffer) {
        if (cloth == null) {
            return -1;
        }
        if (cloth.hasCancels(n)) {
            Tools.println("no matches!");
            Tools.println(n);
            System.out.println("no matches! -> styleId= " + n);
            return -2;
        }
        int n2 = 0;
        for (int i = 0; i < this.stylesAttributes[n].length; ++i) {
            if (!cloth.hasAttribute(this.stylesAttributes[n][i])) continue;
            n2 += 50 * this.stylesAttributesWeight[n][i];
            if (stringBuffer != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(this.getStyleAttributeName(this.stylesAttributes[n][i]));
                continue;
            }
            Tools.println("null attr");
        }
        return n2;
    }

    void replaceItemsOfType(int n) {
        GameObject[] gameObjectArray = this.mRail.getChildArray();
        if (gameObjectArray != null) {
            for (int i = 0; i < gameObjectArray.length; ++i) {
                ClothingItem clothingItem = this.getClothingItem(gameObjectArray[i]);
                if (clothingItem == null) continue;
                GameObject gameObject = gameObjectArray[i].getChildByHashName((byte)12);
                if (n == 0) {
                    byte by = clothingItem.getType();
                    gameObject.destroyNow();
                    this.addNewItem(this.mRail, by, gameObjectArray[i]);
                    this.mRail.onUpdate(this.mGameState);
                    continue;
                }
                if (clothingItem.getType() != n) continue;
                gameObject.destroyNow();
                this.addNewItem(this.mRail, n, gameObjectArray[i]);
                this.mRail.onUpdate(this.mGameState);
            }
        }
    }

    int getObjectNum(GameObject[] gameObjectArray, GameObject gameObject) {
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i] != gameObject) continue;
            return i;
        }
        return -1;
    }

    void onPaint(Graphics graphics) {
        if (this.mState == 1 || this.mState == 2) {
            this.mGameState.drawLevelStars(graphics, GameCanvas.WIDTH_2, 12, this.levelStars, this.displayLevelScore);
        }
        if (this.mLevelModel.isEnabled()) {
            if (this.timeOut) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            } else {
                this.mGameState.drawModelScore(graphics, this.whichStage * GameCanvas.WIDTH / 3 + GameCanvas.WIDTH / 6, this.levelStageStartY + GameResourceMgr.getHeight((short)46) / 2, this.levelStars, this.tempLevelScore - this.temp);
            }
        }
        if (this.mScore.isEnabled() && !this.mScoreModel.isEnabled()) {
            this.mGameState.drawLevelStarsBig(graphics, GameCanvas.WIDTH_2, 20, this.levelStars, this.displayLevelScore);
        }
    }

    GameObject makeStyleShowOutfit(int n) {
        GameObject gameObject = this.makeModel(this.getHair(-1));
        try {
            for (int i = 0; i < this.stylesSampleItems[n].length; ++i) {
                if (this.stylesSampleItems[n][i] == -1) continue;
                this.exChangeItem(gameObject, this.createItem(Cloth.getClothById(this.stylesSampleItems[n][i]), false));
            }
            this.adjustLayers(gameObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return gameObject;
    }

    GameObject makeLine(int n, int n2) {
        GameObject gameObject = new GameObject();
        gameObject.setLocalX(n);
        gameObject.addProperty(new GameShape(0, 20).setRect(n2, GameCanvas.HEIGHT, 685696, true));
        return gameObject;
    }

    void nextStyleToShow() {
        int n;
        if (++this.currentStyleToShow >= this.levelStylesToShow.length) {
            this.setState(this.mGameState.levelToLoad == 0 ? 5 : 1);
            return;
        }
        this.mStylesToShow.destroyAllChildrenNow();
        this.mStylesToShow.enableAndVisible(true);
        int n2 = GameCanvas.WIDTH - GameCanvas.WIDTH / 8;
        int n3 = GameCanvas.WIDTH / 16;
        GameObject gameObject = new GameObject();
        gameObject.addProperty(new GameSprite(36, 0, 20));
        this.mStylesToShow.addChild(gameObject);
        this.mStylesToShow.addChild(gameObject);
        int n4 = GameCanvas.WIDTH_2 - (n2 >> 1);
        int n5 = GameState.gFonts[1].getHeight() * 4;
        gameObject = new GameObject();
        gameObject.setLocalXY(GameCanvas.WIDTH_2, n5 / 2);
        int n6 = n2 - GameCanvas.WIDTH / 8;
        gameObject.addProperty(new GameSprite(35, 0, 3));
        GameText gameText = new GameText(this.getStyleNameById(this.levelStylesToShow[this.currentStyleToShow]), 1, 0, 3);
        gameText.setWidth(n6);
        gameText.setScrollX(true);
        gameObject.addProperty(gameText);
        this.mStylesToShow.addChild(gameObject);
        this.mStylesToShow.addChild(this.makeStyleShowOutfit(this.levelStylesToShow[this.currentStyleToShow]).setLocalXY(n4, n5));
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.stylesAttributes[this.levelStylesToShow[this.currentStyleToShow]].length; ++n) {
            if (n != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getStyleAttributeName(this.stylesAttributes[this.levelStylesToShow[this.currentStyleToShow]][n]));
        }
        n = GameCanvas.HEIGHT - 40 - n5;
        GameObject gameObject2 = Helper.makeMessageBox(stringBuffer.toString(), -1, -1, (byte)0, null, (byte)1, 5, n2 / 2 + 20, n, 0xFFFFFF, 0, 6).setLocalXY(GameCanvas.WIDTH_2 + 40, n5 + (n >> 1));
        this.mStylesToShow.addChild(gameObject2);
    }

    void onBegin() {
        if (this.levelStylesToShow != null) {
            this.setState(4);
        }
        this.ja = -1;
        this.initialized = true;
    }

    GameObject hangerGetHighlightedItem(GameObject gameObject) {
        MenuSelector menuSelector = MenuSelector.getMenuSelector(gameObject);
        if (menuSelector != null) {
            return menuSelector.getCurrent();
        }
        return null;
    }

    int getRackHeight() {
        return GameResourceMgr.getHeight((short)200);
    }

    static {
        scoreModels = new GameObject[15];
    }
}

