/*
 * Decompiled with CFR 0.152.
 */
public class MenuSelector
extends GameProperty {
    byte mType;
    int mSize;
    int mWidth;
    int mHeight;
    boolean allVisible = true;
    int actionLeft = 1;
    int actionRight = 2;
    int actionUp = 3;
    int actionDown = 4;
    boolean reversed = false;
    boolean loop = false;
    boolean mShowArrowsAlways = false;
    int numItems = -1;
    GameObject current;
    GameObject next;
    GameObject arrowUp;
    GameObject arrowDown;
    boolean mDontHighlight = false;
    static final int ACTION_ENABLE = 1;
    static final int ACTION_DISABLE = 2;
    static final int ACTION_SHOW = 3;
    static final int ACTION_HIDE = 4;
    static final int ACTION_NEXT = 5;
    static final int ACTION_PREV = 6;
    static final int ACTION_CLIP = 7;
    static final int ACTION_UP = 8;
    static final int ACTION_DOWN = 9;
    static final byte TYPE_SIMPLE = 0;
    static final byte TYPE_RAIL = 1;
    static final byte TYPE_GRID = 2;
    static final byte TYPE_RAIL_2 = 3;

    private MenuSelector() {
        this.mHashType = (byte)27;
    }

    MenuSelector setLoop(boolean bl) {
        this.loop = bl;
        return this;
    }

    MenuSelector(byte by) {
        this();
        this.mType = by;
    }

    MenuSelector(byte by, int n) {
        this();
        this.mType = by;
        this.mWidth = n;
    }

    MenuSelector(byte by, int n, int n2, int n3) {
        this();
        this.mType = by;
        this.mSize = n3;
        this.mWidth = n;
        this.mHeight = n2;
    }

    void setArrows(GameObject gameObject, GameObject gameObject2, boolean bl) {
        this.arrowUp = gameObject;
        this.arrowDown = gameObject2;
        this.mShowArrowsAlways = bl;
    }

    void setArrows(GameObject gameObject, GameObject gameObject2) {
        this.arrowUp = gameObject;
        this.arrowDown = gameObject2;
    }

    BaseObject createCopy(BaseObject baseObject) {
        MenuSelector menuSelector = (MenuSelector)baseObject;
        if (menuSelector != null) {
            menuSelector = new MenuSelector(this.mType);
        }
        menuSelector.mType = this.mType;
        return menuSelector;
    }

    void onInit(GameObject gameObject) {
        this.sortItems(gameObject);
    }

    void setCurrent(GameObject gameObject) {
        this.current = gameObject;
        this.next = null;
        if (this.current != null) {
            this.next = this.current.mNext;
        }
    }

    GameObject getCurrent() {
        return this.current;
    }

    int getCurrentPosition(GameObject gameObject) {
        return gameObject.getChildPosition(this.current);
    }

    void focus(GameObject gameObject, boolean bl) {
        if (!this.mDontHighlight) {
            gameObject.focus(bl);
        }
    }

    boolean find(GameObject gameObject) {
        if (this.current == null) {
            this.setCurrent(gameObject.mChild);
            if (this.current != null) {
                this.focus(this.current, false);
            } else {
                return false;
            }
        }
        GameObject gameObject2 = this.current;
        do {
            if (gameObject2 != null && !gameObject2.isFlag(2) && gameObject2.isFlag(4)) {
                if (gameObject2 != this.current) {
                    this.focus(this.current, false);
                    this.setCurrent(gameObject2);
                    this.sortItems(gameObject);
                }
                return true;
            }
            if ((gameObject2 = gameObject2 == this.current ? this.next : gameObject2.mNext) != null) continue;
            Tools.println("child== null");
            gameObject2 = gameObject.mChild;
        } while (gameObject2 != this.current && gameObject2 != null);
        this.setCurrent(null);
        return false;
    }

    public void sortItems(GameObject gameObject) {
        try {
            this.find(gameObject);
            if (this.current == null) {
                return;
            }
            this.allVisible = gameObject.getChildNum() * this.mSize < this.mWidth;
            switch (this.mType) {
                case 0: 
                case 2: {
                    this.setAction(gameObject, 2);
                    this.focus(this.current, true);
                    break;
                }
                case 1: 
                case 3: {
                    int n;
                    this.setAction(gameObject, 2);
                    GameObject[] gameObjectArray = gameObject.getChildArray();
                    for (n = 0; n < gameObjectArray.length && gameObjectArray[n] != this.current; ++n) {
                    }
                    int n2 = -n * this.mSize;
                    int n3 = this.mWidth / 2;
                    if (this.mType == 3) {
                        n2 = -(n3 -= this.mSize / 2);
                        while (n2 + (gameObjectArray.length - 1) * this.mSize > n3 && n2 + (n + 1) * this.mSize > n3) {
                            n2 -= this.mSize;
                        }
                    }
                    Tools.println("start x = ");
                    Tools.println(n2);
                    Tools.println(" width= ");
                    Tools.println(this.mWidth);
                    Tools.println("size");
                    Tools.println(this.mSize);
                    for (int i = 0; i < gameObjectArray.length; ++i) {
                        if (this.reversed) {
                            gameObjectArray[i].setLocalY(n2);
                        } else {
                            gameObjectArray[i].setLocalX(n2);
                        }
                        if (n2 < -n3 || n2 > n3) {
                            gameObjectArray[i].visible(false);
                        } else {
                            gameObjectArray[i].visible(true);
                        }
                        n2 += this.mSize;
                    }
                    this.focus(this.current, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setAction(GameObject gameObject, int n) {
        switch (n) {
            case 5: 
            case 6: {
                this.find(gameObject);
                if (this.current == null) {
                    return;
                }
                do {
                    if (n == 5) {
                        if (this.current.mNext != null) {
                            this.setCurrent(this.current.mNext);
                            continue;
                        }
                        if (this.loop) {
                            this.setCurrent(gameObject.mChild);
                            continue;
                        }
                        this.setCurrent(gameObject.getLastChild());
                        n = 6;
                        continue;
                    }
                    this.setCurrent(gameObject.getPrevChild(this.current));
                    if (this.current != null) continue;
                    if (this.loop) {
                        this.setCurrent(gameObject.getLastChild());
                        continue;
                    }
                    this.current = gameObject.mChild;
                    this.setCurrent(this.current);
                    n = 5;
                } while (!this.current.isFlag(4));
                this.sortItems(gameObject);
                break;
            }
            case 8: {
                int n2;
                if (this.mType != 2) break;
                this.find(gameObject);
                GameObject[] gameObjectArray = gameObject.getChildArray();
                for (n2 = 0; n2 < gameObjectArray.length && gameObjectArray[n2] != this.current; ++n2) {
                }
                int n3 = n2 - this.mWidth;
                if (n3 >= 0) {
                    this.setCurrent(gameObjectArray[n3]);
                }
                this.sortItems(gameObject);
                break;
            }
            case 9: {
                int n4;
                if (this.mType != 2) break;
                this.find(gameObject);
                GameObject[] gameObjectArray = gameObject.getChildArray();
                for (n4 = 0; n4 < gameObjectArray.length && gameObjectArray[n4] != this.current; ++n4) {
                }
                int n5 = n4 + this.mWidth;
                if (n5 < gameObjectArray.length) {
                    this.setCurrent(gameObjectArray[n5]);
                }
                this.sortItems(gameObject);
                break;
            }
            default: {
                GameObject gameObject2 = gameObject.mChild;
                while (gameObject2 != null) {
                    switch (n) {
                        case 1: {
                            gameObject2.focus(true);
                            break;
                        }
                        case 2: {
                            gameObject2.focus(false);
                            break;
                        }
                        case 3: {
                            gameObject2.visible(true);
                            break;
                        }
                        case 4: {
                            gameObject2.visible(false);
                            break;
                        }
                    }
                    gameObject2 = gameObject2.mNext;
                }
                break block0;
            }
        }
    }

    void onFocus(GameObject gameObject) {
        if (this.find(gameObject)) {
            this.setAction(gameObject, 2);
            this.focus(this.current, true);
        }
        if (this.current == null) {
            return;
        }
        int n = gameObject.getChildNum();
        if (this.numItems != n) {
            this.numItems = n;
            this.sortItems(gameObject);
        }
        GameObject gameObject2 = this.arrowUp;
        GameObject gameObject3 = this.arrowDown;
        if (gameObject2 == null) {
            gameObject2 = gameObject.mParent.getChildByHashName((byte)41);
        }
        if (gameObject3 == null) {
            gameObject3 = gameObject.mParent.getChildByHashName((byte)42);
        }
        if (gameObject2 != null && gameObject3 != null) {
            if (!this.allVisible || this.mShowArrowsAlways) {
                if (this.current != gameObject.mChild) {
                    gameObject2.visible(true);
                } else {
                    gameObject2.visible(false);
                }
                if (this.current != gameObject.getLastChild()) {
                    gameObject3.visible(true);
                } else {
                    gameObject3.visible(false);
                }
            } else {
                gameObject2.visible(false);
                gameObject3.visible(false);
            }
        }
        if (GameState.getInstance().keyClicked == this.actionLeft) {
            this.setAction(gameObject, 6);
        } else if (GameState.getInstance().keyClicked == this.actionRight) {
            this.setAction(gameObject, 5);
        } else if (GameState.getInstance().keyClicked == this.actionUp) {
            this.setAction(gameObject, 8);
        } else if (GameState.getInstance().keyClicked == this.actionDown) {
            this.setAction(gameObject, 9);
        }
    }

    void reset() {
        if (this.current != null) {
            this.focus(this.current, false);
        }
        this.setCurrent(null);
    }

    MenuSelector reverse() {
        this.reversed = !this.reversed;
        int n = this.actionLeft;
        this.actionLeft = this.actionUp;
        this.actionUp = n;
        n = this.actionRight;
        this.actionRight = this.actionDown;
        this.actionDown = n;
        return this;
    }

    static MenuSelector getMenuSelector(GameObject gameObject) {
        return (MenuSelector)gameObject.getPropertyByHashType((byte)27);
    }
}

