/*
 * Decompiled with CFR 0.152.
 */
public class Button
extends GameProperty
implements UiListener {
    GameObject mNormal;
    GameObject mSelected;
    GameObject mRollover;
    UiListener mListener;
    public static final int BUTTON_NORMAL = 1;
    public static final int BUTTON_SELECTED = 2;
    public static final int BUTTON_ROLLOVER = 3;
    int mState = 1;
    boolean fireNextFrame = false;

    Button() {
        this.mHashType = (byte)25;
    }

    BaseObject createCopy(BaseObject baseObject) {
        Button button = (Button)baseObject;
        if (button != null) {
            button = new Button();
        }
        button.mState = this.mState;
        return button;
    }

    void setState(int n) {
        this.mState = n;
        if (this.mNormal != null) {
            switch (n) {
                case 1: {
                    this.mNormal.setFlag(12);
                    this.mSelected.unsetFlag(12);
                    this.mRollover.unsetFlag(12);
                    break;
                }
                case 2: {
                    this.mNormal.unsetFlag(12);
                    this.mSelected.setFlag(12);
                    this.mRollover.unsetFlag(12);
                    break;
                }
                case 3: {
                    this.mNormal.unsetFlag(12);
                    this.mSelected.unsetFlag(12);
                    this.mRollover.setFlag(12);
                }
            }
        }
    }

    void prepare(GameObject gameObject) {
        try {
            this.mNormal = gameObject.getChildByHashName((byte)4);
            this.mSelected = gameObject.getChildByHashName((byte)2);
            this.mRollover = gameObject.getChildByHashName((byte)3);
            this.setState(this.mState);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInit(GameObject gameObject) {
        this.prepare(gameObject);
    }

    public void onUpdate(GameObject gameObject) {
        this.prepare(gameObject);
        if (this.fireNextFrame) {
            Tools.println(" button pressed ");
            if (this.mListener != null) {
                this.mListener.onMessage(gameObject, 5);
            }
        } else if (!gameObject.hasFocus()) {
            this.setState(1);
        }
        this.fireNextFrame = false;
    }

    void setListener(UiListener uiListener) {
        this.mListener = uiListener;
    }

    void onFocusStart(GameObject gameObject) {
        this.prepare(gameObject);
        this.setState(3);
    }

    void onFocusEnd(GameObject gameObject) {
        this.prepare(gameObject);
        this.setState(1);
    }

    void onFire(GameObject gameObject) {
        this.fireNextFrame = true;
        this.setState(2);
    }

    void onFocus(GameObject gameObject) {
        if (this.mState == 2) {
            this.setState(3);
        }
        if (GameState.getInstance().keyClicked == 5) {
            this.onFire(gameObject);
        }
    }

    public void onMessage(GameObject gameObject, int n) {
        if (n == 105) {
            MenuSelector menuSelector;
            if (gameObject.mParent.mParent != null && (menuSelector = MenuSelector.getMenuSelector(gameObject.mParent.mParent)) != null) {
                menuSelector.setCurrent(gameObject.mParent);
            }
            this.onFire(gameObject.mParent);
        }
    }
}

