/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameState
implements UiListener,
BabbleDefs,
GameDefs {
    public static final byte RMS_VERSION = 4;
    public static final int STATE_RESET = -2;
    public static final int STATE_NULL = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_INTRO = 1;
    public static final int STATE_LANGUAGE = 2;
    public static final int STATE_SOUND = 3;
    public static final int STATE_LOGO = 4;
    public static final int STATE_MAIN_MENU = 5;
    public static final int STATE_OPTIONS = 6;
    public static final int STATE_HELP = 7;
    public static final int STATE_CREDITS = 8;
    public static final int STATE_EXIT = 9;
    public static final int STATE_NEW_GAME = 10;
    public static final int STATE_LOADING = 11;
    public static final int STATE_RUNWAY = 12;
    public static final int STATE_SELECT_LEVEL = 13;
    public static final int STATE_LEVEL_WIN = 14;
    public static final int STATE_LEVEL_LOSE = 15;
    public static final int STATE_WEEK_INTRO = 16;
    public static final int STATE_SHOW_INTRO = 17;
    public static final int STATE_END_GAME = 18;
    public static final int STATE_OUTRO = 19;
    public static final int STATE_MORE_GAMES = 20;
    public static final int STATE_DEMO_END = 21;
    public static final int SOUND_MENU = 0;
    public static final int SOUND_GAME = 1;
    public static final int SOUND_WIN = 2;
    public static final int SOUND_LOSE = 3;
    public static final int SOUND_SELECT = 4;
    public static final int SOUND_ITEM_SELECT = 5;
    public static final int SOUND_MAX = 6;
    public static final String[] SOUND_NAMES = new String[]{"/theme.mid", "/ingame.mid", "/win_fx.mid", "/lose_fx.mid", "/menu_sfx.mid", "/place_item_sfx.mid"};
    public static final boolean[] SOUND_TYPE = new boolean[]{false, false, false, false, true, true};
    public static final int[] SOUND_LENGTH = new int[]{32, 31, 2, 5, 3, 3};
    public int mMusicTime;
    public static final int[] gSounds = new int[6];
    public static String[] gCachedText;
    public int numDialogs;
    int[] gSoftkeysTable = new int[]{-1, -1, -1, -1, 1, -1, 8, 9, -1, -1, 1, 7, 1, 12, -1, 12, -1, 12, 8, 9, 8, 9, -1, -1, -2, -2, 1, 12, 24, 21, 24, 7, 21, 12, 21, 12, 21, -1, -1, -1, -1, -1, -1, -1};
    public static final int ACTION_NONE = 0;
    public static final int ACTION_LEFT = 1;
    public static final int ACTION_RIGHT = 2;
    public static final int ACTION_UP = 3;
    public static final int ACTION_DOWN = 4;
    public static final int ACTION_FIRE = 5;
    public static final int ACTION_BACK = 6;
    public static final int ACTION_OTHER = 7;
    public static final int FLAG_CLEAR = 1;
    public static final byte FONT_SMALL = 0;
    public static final byte FONT_BIG = 1;
    public static final byte FONT_MEDIUM = 2;
    public static final byte FONT_MAX = 3;
    public static final String[] FONT_NAMES;
    public static final HFont[] gFonts;
    public int mState = 0;
    public int mNewState = -1;
    public int mLastState = -1;
    public int mSubState = -1;
    public int mNewSubState = -1;
    public int mLastSubState = -1;
    GameCanvas mCanvas;
    int keyClicked;
    int keyPressed;
    GameObject mRoot;
    GameObject mPausedObject;
    Image[] mSoftkey;
    boolean[] mSoftkeyVisible;
    String[] mSoftkeyText;
    boolean[] mSavedSoftkeyVisible;
    String[] mSavedSoftkeyText;
    LevelRunway mLevelRunway;
    public static GameState gInstance;
    public boolean mIsLoading;
    public boolean mIsPaused;
    public int mPauseState;
    public int mNewPauseState = -1;
    public int mLoadingStep;
    public int mMaxLoadingStep;
    public int mStateFlags;
    public long mStateStartTime;
    public long mFrameStartTime;
    public long mStateTime;
    public long mFrameTime;
    public int mClearColor;
    public boolean soundOn = false;
    public int mMusicToPlay = -1;
    public boolean mLoopMusic = false;
    public boolean CHEAT_UNLOCK_LEVELS = false;
    public boolean CHEAT_UNLOCK_POWERUPS = false;
    public boolean firePressed;
    public boolean backPressed;
    public boolean mBuyMoreMenu = false;
    public boolean mBuyMoreExit = false;
    public boolean mIsDemo = false;
    public String mBuyMoreText;
    public String mBuyMoreUrl;
    public String mVersion;
    public String mMidletName;
    public byte lastLevelStars;
    public short lastLevelScore;
    public byte tempLang = 0;
    public boolean touchScreenOn = false;
    public boolean hasKeyboard = true;
    boolean[] changeLeft;
    boolean[] changeRight;
    char tylerOrLisa;
    byte tyler = 0;
    byte lisa = 0;
    public static boolean levelReplay;
    int whichLevel;
    short whichLogo;
    short[] character1Table = new short[4];
    short[] character2Table = new short[4];
    GameObject mMainMenu;
    String[][] stageLevelNames = null;
    short[][] stageLevelScores = null;
    byte[][] stageLevelStars = null;
    int levelToLoad;
    public int[] languages_available;
    public boolean bLangSwap = false;
    static byte[] babdata;
    static byte babdialect;
    protected static DataInputStream babdis;
    public static final String[] babble_languages;
    static String[] babble_szUntranslated;
    static final String[][] babble_szSource;
    public static final int babble_untranslated_start = 0;
    public static final int babble_untranslated_end = -1;
    public static final int babble_source_start = 0;
    public static final int babble_source_end = 2;

    GameState(GameCanvas gameCanvas) {
        this.mCanvas = gameCanvas;
        gInstance = this;
    }

    void onDestroy() {
        Tools.println("onDestroy state ");
        this.onResume();
        this.onStateEnd();
        this.mRoot.destroyNow();
        gInstance = null;
    }

    void onInit() {
        this.mRoot = new GameObject();
        this.mRoot.focus(true);
        this.mSoftkey = new Image[2];
        this.mSoftkeyVisible = new boolean[2];
        this.mSoftkeyText = new String[2];
        this.mSavedSoftkeyVisible = new boolean[2];
        this.mSavedSoftkeyText = new String[2];
        this.mSoftkey[0] = GameResourceMgr.loadImage((short)55);
        this.mSoftkey[1] = GameResourceMgr.loadImage((short)55);
        this.mIsDemo = this.isDemoVersion();
        this.mVersion = this.appProperty("MIDlet-Version");
        this.mMidletName = this.appProperty("MIDlet-Name");
        this.mFrameStartTime = System.currentTimeMillis();
        boolean bl = this.hasKeyboard = Boxal.bInfNavKeys || Boxal.bInfNumKeys;
        if (!this.hasKeyboard && !Boxal.bInfNoTouch) {
            this.touchScreenOn = true;
        }
    }

    GameObject getRoot() {
        return this.mRoot;
    }

    void onUpdate() {
        if (this.touchScreenOn) {
            TouchScreen.getInstance().onUpdate();
            TouchScreen.getInstance();
            if (TouchScreen._pointer_state == 2) {
                this.onTouched(2, TouchScreen._pointer_x, TouchScreen._pointer_y);
            }
        }
        long l = this.mFrameTime;
        this.mFrameTime = System.currentTimeMillis() - this.mFrameStartTime;
        if (l > 0L && l * 10L < this.mFrameTime) {
            this.mFrameTime = 0L;
        }
        if (Boxal.bInfUseWatchdog && this.mFrameTime > (long)Boxal.iInfWatchdogTimeout) {
            this.mFrameTime = 0L;
        }
        this.mFrameStartTime = System.currentTimeMillis();
        this.mIsPaused = false;
        if (this.mPausedObject != null) {
            this.mIsPaused = true;
        }
        if (this.touchScreenOn) {
            if (this.mState == 12 && !this.mIsPaused && this.keyClicked != 5 && this.keyClicked != 6) {
                this.keyClicked = 0;
            }
            if (this.mSoftkeyVisible[0] && TouchScreen.PointerReleased(0, GameCanvas.HEIGHT - 20, 80, 20)) {
                this.keyClicked = 5;
                TouchScreen.getInstance().resetState();
            } else if (this.mSoftkeyVisible[1] && TouchScreen.PointerReleased(GameCanvas.WIDTH - 80, GameCanvas.HEIGHT - 20, 80, 20)) {
                this.keyClicked = 6;
                TouchScreen.getInstance().resetState();
            }
        }
        if (this.touchScreenOn) {
            if (TouchScreen.PointerDragged(3)) {
                this.keyClicked = 1;
            } else if (TouchScreen.PointerDragged(4)) {
                this.keyClicked = 2;
            } else if (TouchScreen.PointerDragged(1)) {
                this.keyClicked = 3;
            } else if (TouchScreen.PointerDragged(2)) {
                this.keyClicked = 4;
            }
        }
        if (this.keyClicked != 0) {
            this.onKeyClicked(this.keyClicked);
        }
        if (this.mNewState != -1) {
            this.onStateEnd();
            this.mLastState = this.mState;
            this.mState = this.mNewState;
            this.mNewState = -1;
            this.onLoadingStart();
        }
        if (this.mNewSubState != -1) {
            this.onSubStateEnd();
            this.mLastSubState = this.mSubState;
            this.mSubState = this.mNewSubState;
            this.mNewSubState = -1;
            this.onSubStateBegin();
        }
        if (this.mIsLoading && this.onLoading()) {
            this.onLoadingEnd();
        }
        if (this.mIsPaused) {
            if (this.mNewPauseState != -1) {
                this.setPauseState(this.mNewPauseState);
                this.mNewPauseState = -1;
            }
            if (this.mPausedObject != null) {
                this.mPausedObject.onUpdate(this);
            }
        } else if (!this.mIsLoading) {
            this.onStateUpdate();
            if (this.mRoot != null) {
                this.mRoot.onUpdate(this);
            }
            this.onStatePostUpdate();
        }
    }

    void onLoadingStart() {
        this.mLoadingStep = 0;
        this.mClearColor = 0;
        this.mIsLoading = true;
        this.mStateFlags = 1;
    }

    void onLoadingEnd() {
        if (this.mIsLoading) {
            this.onStateBegin();
            this.mIsLoading = false;
        }
    }

    boolean onLoading() {
        if (this.onStateLoading() || this.mLoadingStep >= this.mMaxLoadingStep) {
            return true;
        }
        ++this.mLoadingStep;
        return false;
    }

    void onSubStateBegin() {
    }

    void onSubStateEnd() {
    }

    void clearScreen(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    void drawSoftkeys(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (Boxal.bInfPandQ) {
            n3 = 13;
        }
        if (this.mSoftkey != null) {
            n = this.mSoftkey[0].getWidth();
            n2 = this.mSoftkey[0].getHeight();
        }
        graphics.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        if (this.mSoftkeyVisible[0]) {
            if (this.mSoftkey != null) {
                graphics.drawImage(this.mSoftkey[0], -(n - 80 - n3), GameCanvas.GAME_HEIGHT + (this.firePressed ? 1 : 0), 0);
                gFonts[0].drawString(graphics, this.mSoftkeyText[0], 40, GameCanvas.HEIGHT, 0x20 | 1);
            } else {
                gFonts[0].drawString(graphics, this.mSoftkeyText[0], 1, GameCanvas.HEIGHT, 0x20 | 4);
            }
        }
        if (this.mSoftkeyVisible[1]) {
            if (this.mSoftkey != null) {
                graphics.drawImage(this.mSoftkey[1], GameCanvas.WIDTH - 80 - n3, GameCanvas.GAME_HEIGHT + (this.backPressed ? 1 : 0), 0);
                gFonts[0].drawString(graphics, this.mSoftkeyText[1], GameCanvas.WIDTH - 40, GameCanvas.HEIGHT, 0x20 | 1);
            } else {
                gFonts[0].drawString(graphics, this.mSoftkeyText[1], GameCanvas.WIDTH - 1, GameCanvas.HEIGHT, 0x20 | 8);
            }
        }
        this.firePressed = false;
        this.backPressed = false;
    }

    public static void gc() {
        if (!Boxal.bInfNoSystemGC) {
            System.gc();
        }
    }

    void onPaint(Graphics graphics) {
        if ((this.mStateFlags & 1) != 0) {
            this.clearScreen(graphics, this.mClearColor);
        }
        if (this.mIsLoading) {
            int n = GameCanvas.WIDTH / 8;
            graphics.setColor(16729234);
            graphics.fillArc(GameCanvas.WIDTH_2 - n / 2, GameCanvas.HEIGHT_2 - n / 2, n, n, this.mLoadingStep % 8 * 45 % 360, 45);
        } else if (this.mIsPaused) {
            if (this.mPausedObject != null) {
                GameObject.onPaintNext(this.mPausedObject, graphics);
                this.drawSoftkeys(graphics);
            }
        } else {
            if (this.mRoot != null) {
                GameObject.onPaintNext(this.mRoot, graphics);
            }
            this.onStatePaint(graphics);
            this.drawSoftkeys(graphics);
        }
    }

    void gotoState(int n) {
        this.mNewState = n;
    }

    void gotoSubState(int n) {
        this.mNewSubState = n;
    }

    void gotoPauseState(int n) {
        this.mNewPauseState = n;
    }

    void setPauseState(int n) {
        switch (this.mPauseState) {
            case 0: {
                this.mPausedObject.destroyAllChildrenNow();
                break;
            }
            case 6: {
                this.mPausedObject.destroyAllChildrenNow();
                break;
            }
            case 9: {
                this.mPausedObject.destroyAllChildrenNow();
            }
        }
        switch (n) {
            case 0: {
                byte[] byArray;
                String[] stringArray;
                if (this.mState == 12) {
                    stringArray = new String[]{GameState.getText(29), GameState.getText(4), GameState.getText(30)};
                    byArray = new byte[]{45, 6, 9};
                    this.setSoftkeys(1, -1);
                } else {
                    stringArray = new String[]{GameState.getText(29)};
                    byArray = new byte[]{45};
                    this.setSoftkeys(1, -1);
                }
                this.mPausedObject.addChild(this.makeSimpleMenu(stringArray, byArray, 20, true));
                if (!this.touchScreenOn) break;
                this.setLeftSoftkey(null);
                break;
            }
            case 6: {
                this.setSoftkeys(6);
                this.mPausedObject.addChild(this.makeOptions());
                break;
            }
            case 9: {
                this.mPausedObject.addChild(Helper.makeYesNoMessageBox(58, this));
            }
        }
        this.mPauseState = n;
    }

    void onPause() {
        if (this.mState > 2) {
            this.stopSound();
            if (this.mPausedObject == null) {
                this.mPausedObject = new GameObject();
                this.mPausedObject.addProperty(new GameShape(0, 20).setRect(GameCanvas.WIDTH, GameCanvas.HEIGHT, 0, true));
                this.mPausedObject.focus(true);
                this.mSavedSoftkeyVisible[0] = this.mSoftkeyVisible[0];
                this.mSavedSoftkeyVisible[1] = this.mSoftkeyVisible[1];
                this.mSavedSoftkeyText[0] = this.mSoftkeyText[0];
                this.mSavedSoftkeyText[1] = this.mSoftkeyText[1];
                this.setPauseState(0);
            }
            this.consumeKeyClicked();
        }
    }

    void onResume() {
        if (this.mPausedObject != null) {
            this.mSoftkeyVisible[0] = this.mSavedSoftkeyVisible[0];
            this.mSoftkeyVisible[1] = this.mSavedSoftkeyVisible[1];
            this.mSoftkeyText[0] = this.mSavedSoftkeyText[0];
            this.mSoftkeyText[1] = this.mSavedSoftkeyText[1];
            this.mPausedObject.destroyNow();
        }
        this.mPausedObject = null;
        this.consumeKeyClicked();
    }

    public static GameState getInstance() {
        return gInstance;
    }

    String getSoundText() {
        return GameState.getText(18) + GameState.getText(this.soundOn ? 19 : 20);
    }

    void switchSound(GameObject gameObject) {
        Tools.println("switch sound");
        boolean bl = this.soundOn = !this.soundOn;
        if (!this.soundOn) {
            this.stopSound();
        }
        if (gameObject != null) {
            Tools.println("cange sound");
            Helper.buttonChangeText(gameObject, this.getSoundText());
            if (this.touchScreenOn) {
                gameObject.mParent.focus(false);
            }
        }
    }

    GameObject makeOptions() {
        GameObject gameObject = this.makeSimpleMenu(new String[]{this.getSoundText()}, new byte[]{39}, 20, true);
        gameObject.focus(true);
        if (this.touchScreenOn) {
            this.setLeftSoftkey(null);
        }
        return gameObject;
    }

    void onStateBegin() {
        this.mStateFlags = 1;
        this.mStateStartTime = System.currentTimeMillis();
        this.mStateTime = 0L;
        this.mClearColor = 0;
        this.keyClicked = 0;
        this.playSfx(4);
        if (babdata != null) {
            this.setSoftkeys(this.mState);
        }
        if (this.mState >= 4) {
            if (this.mState == 12) {
                this.setMusic(1, true);
            } else {
                this.setMusic(0, true);
            }
        }
        switch (this.mState) {
            case 1: {
                this.mClearColor = 0xFFFFFF;
                this.getRoot().addChild(Helper.createSimpleImage((short)186, GameCanvas.WIDTH_2, GameCanvas.HEIGHT_2, 3, 0));
                break;
            }
            case 4: {
                this.mClearColor = 0xFFFFFF;
                this.getRoot().addChild(this.makeMainMenuLogo(0));
                String string = GameState.getText(this.touchScreenOn ? 85 : 27);
                this.getRoot().addChild(Helper.makeLabel(string, (byte)0, GameCanvas.WIDTH_2, GameCanvas.HEIGHT - GameCanvas.HEIGHT / 4, 3, (byte)1, GameCanvas.WIDTH - 5, -1, false).addProperty(new BlinkOnFocus(true)));
                this.mBuyMoreText = this.getBuyLabel();
                this.mBuyMoreUrl = this.getBuyURL();
                this.mBuyMoreMenu = this.showBuyButton(true);
                this.mBuyMoreExit = this.showBuyButton(false);
                break;
            }
            case 5: {
                this.onMainMenuBegin();
                break;
            }
            case 2: {
                this.languages_available = this.setupLangs();
                if (this.languages_available.length == 1) {
                    this.loadLanguage("/language", babble_languages[this.languages_available[0]], -1);
                    Tools.println("init lang");
                    this.gotoState(3);
                } else {
                    String[] stringArray = new String[this.languages_available.length];
                    byte[] byArray = new byte[this.languages_available.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        stringArray[i] = babble_szSource[0][this.languages_available[i]];
                        byArray[i] = (byte)this.languages_available[i];
                        Tools.println("lang");
                        Tools.println(i);
                    }
                    this.setSoftkeys(babble_szSource[1][this.languages_available[0]], null);
                    this.mMainMenu = this.makeSimpleMenu(stringArray, byArray, 20, true);
                    this.getRoot().addChild(this.mMainMenu);
                }
                if (!this.touchScreenOn) break;
                this.setLeftSoftkey(null);
                break;
            }
            case 3: {
                Tools.println("STATE_SOUND");
                this.getRoot().addChild(Helper.makeYesNoMessageBox(11, this));
                Tools.println("STATE_SOUND end");
                break;
            }
            case 9: {
                this.getRoot().addChild(Helper.makeYesNoMessageBox(13, this));
                break;
            }
            case 8: {
                String string = GameState.getText(83) + "\n\n" + GameState.getText(17);
                string = GameState.convertString("{ver}", this.mVersion + (this.mIsDemo ? " " + GameState.getText(54) : ""), string);
                this.getRoot().addChild(Helper.makeMessageBox(string, -1, 12, (byte)37, this, (byte)1, 3, 16729234, 0xE0E0E0, 3).focus(true));
                break;
            }
            case 7: {
                String string;
                String string2 = GameState.getText(15);
                if (this.mBuyMoreMenu) {
                    string = this.mIsDemo ? GameState.getText(494) : GameState.getText(495);
                    string = GameState.convertString("{more}", this.mBuyMoreText, string);
                    string = "\n" + string + "\n";
                } else {
                    string = " ";
                }
                string2 = GameState.convertString("{moregames}", string, string2);
                string2 = string2 + "\n\n";
                string2 = string2 + GameState.getText(57);
                string2 = string2 + "\n\n";
                string2 = string2 + this.getHowToPlayText();
                this.getRoot().addChild(Helper.makeMessageBox(string2, -1, 12, (byte)37, this, (byte)1, 3, 16729234, 0xE0E0E0, 3).focus(true));
                break;
            }
            case 6: {
                this.getRoot().addChild(this.makeOptions());
                break;
            }
            case 13: {
                this.onSelectLevelBegin();
                break;
            }
            case 12: {
                Tools.println("STATE_RUNWAY begin");
                this.mStateFlags = 0;
                GameResourceMgr.destroyImages();
                this.mLevelRunway.onBegin();
                break;
            }
            case 14: 
            case 15: {
                this.setMusic(this.mState == 14 ? 2 : 3, false);
                this.mClearColor = 0xFFFFFF;
                if (this.mState == 14 && levelReplay) {
                    this.gotoState(12);
                    break;
                }
                if (this.mState == 14 && (this.whichLevel + 1) % 5 != 0) {
                    this.nextLevel(true);
                    break;
                }
                byte by = 1;
                this.mClearColor = 0xFFFFFF;
                if (this.mState == 14) {
                    // empty if block
                }
                this.numDialogs = 0;
                GameObject gameObject = new GameObject(43).focus(true);
                GameObject gameObject2 = new GameObject(49).focus(true);
                GameObject gameObject3 = new GameObject(50).focus(true);
                int n = GameCanvas.WIDTH - GameCanvas.WIDTH / 8;
                n = GameResourceMgr.getWidth((short)28);
                boolean bl = false;
                if (this.mState == 14) {
                    char c;
                    char c2;
                    char c3 = '\u0004';
                    int[] nArray = new int[]{4, 2, 2, 3, 2, 4};
                    int n2 = (this.whichLevel + 1) / 5 - 1;
                    int n3 = 0;
                    if (n2 > 0) {
                        for (int i = 0; i < n2; ++i) {
                            n3 += nArray[i];
                        }
                    }
                    String string = GameState.getText(477 + n3);
                    c3 = c2 = string.charAt(11) - 48;
                    this.changeRight = new boolean[c3];
                    this.changeLeft = new boolean[c3];
                    for (c = '\u0000'; c < c3; ++c) {
                        this.changeLeft[c] = false;
                        this.changeRight[c] = false;
                    }
                    c = ' ';
                    char c4 = ' ';
                    for (char c5 = '\u0000'; c5 < c3; ++c5) {
                        int n4;
                        int n5;
                        String string3 = GameState.getText(477 + n3 + c5);
                        if (string3 == null || string3.length() <= 7) continue;
                        ++this.numDialogs;
                        GameObject gameObject4 = new GameObject();
                        GameObject gameObject5 = new GameObject();
                        GameObject gameObject6 = new GameObject();
                        if (c5 == '\u0000') {
                            gameObject4.focus(true);
                            gameObject5.focus(true);
                            gameObject6.focus(true);
                        } else {
                            gameObject4.focus(false);
                            gameObject5.focus(false);
                            gameObject6.focus(false);
                        }
                        int n6 = GameResourceMgr.getHeight(this.getCharacterId(string3));
                        String string4 = string3.substring(12, string3.length());
                        int n7 = Helper.getMessageBoxHeight(string4, by, 19, n, GameCanvas.GAME_HEIGHT - n6);
                        int n8 = GameResourceMgr.getWidth(this.getCharacterId(string3));
                        int n9 = GameResourceMgr.getWidth(this.getCharacterId2(string3));
                        int n10 = GameResourceMgr.getWidth((short)29);
                        boolean bl2 = false;
                        if (string3.charAt(1) == 'L' || string3.charAt(6) == 'R') {
                            n5 = 8;
                            n4 = 4;
                            bl2 = true;
                        } else {
                            n5 = 4;
                            n4 = 8;
                            bl2 = false;
                        }
                        if (c5 == '\u0000') {
                            c = string3.charAt(0);
                        } else {
                            if (c != string3.charAt(0)) {
                                this.changeLeft[c5] = true;
                            }
                            c = string3.charAt(0);
                        }
                        if (c5 == '\u0000') {
                            c4 = string3.charAt(5);
                        } else {
                            if (c4 != string3.charAt(5)) {
                                this.changeRight[c5] = true;
                            }
                            c4 = string3.charAt(5);
                        }
                        GameSprite.flagMirror = false;
                        gameObject4.addChild(Helper.createSimpleImage(this.getCharacterId(string3), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n5, 0, !bl2));
                        GameSprite.flagMirror = true;
                        gameObject5.addChild(Helper.createSimpleImage(this.getCharacterId2(string3), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n4, 0, bl2));
                        int n11 = GameResourceMgr.getHeight((short)28) / 2;
                        int n12 = GameResourceMgr.getHeight((short)28);
                        int n13 = 0;
                        gameObject6.addChild(Helper.createSimpleImage((short)31, GameCanvas.WIDTH_2, n11, 3, 0));
                        for (n13 = 0; n13 < n7 / n12; ++n13) {
                            gameObject6.addChild(Helper.createSimpleImage((short)28, GameCanvas.WIDTH_2, n12 + n11 + n13 * n12, 3, 0));
                        }
                        gameObject6.addChild(Helper.createSimpleImage((short)26, GameCanvas.WIDTH_2, n12 + n11 + n11 + (n13 - 1) * n12, 3, 0));
                        if (string3.charAt(10) == '<') {
                            gameObject6.addChild(Helper.createSimpleImage((short)29, GameCanvas.WIDTH_2 - n10, n12 + n11 + n11 + n13 * n12, 3, 0));
                            if (c5 == '\u0000') {
                                bl = false;
                            }
                        } else {
                            gameObject6.addChild(Helper.createSimpleImage((short)30, GameCanvas.WIDTH_2 + n10, n12 + n11 + n11 + n13 * n12, 3, 0));
                            if (c5 == '\u0000') {
                                bl = true;
                            }
                        }
                        GameSprite.flagMirror = false;
                        gameObject4.addChild(Helper.createSimpleImage(this.character1Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n5, 0, !bl2));
                        gameObject4.addChild(Helper.createSimpleImage(this.character1Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n5, 0, !bl2));
                        gameObject4.addChild(Helper.createSimpleImage(this.character1Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n5, 0, !bl2));
                        GameSprite.flagMirror = true;
                        gameObject5.addChild(Helper.createSimpleImage(this.character2Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n4, 0, bl2));
                        gameObject5.addChild(Helper.createSimpleImage(this.character2Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n4, 0, bl2));
                        gameObject5.addChild(Helper.createSimpleImage(this.character2Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n4, 0, bl2));
                        GameSprite.flagMirror = false;
                        gameObject6.addChild(Helper.makeMessageBox(string4, 21, 12, (byte)37, this, by, 128, n, n7, 0xE0E0E0, 0xE0E0E0, 3, true).focus(true).setLocalXY(GameCanvas.WIDTH_2, n7 / 2 + n11));
                        gameObject.addChild(gameObject4);
                        gameObject2.addChild(gameObject5);
                        gameObject3.addChild(gameObject6);
                        if (c5 % 2 == 0) {
                            gameObject6.setLocalXY(0, 0);
                        } else {
                            gameObject6.setLocalXY(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0);
                        }
                        if (c5 == '\u0000') {
                            gameObject5.setLocalXY(0, 0);
                            gameObject4.setLocalXY(0, 0);
                        } else {
                            gameObject5.setLocalXY(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0);
                            gameObject4.setLocalXY(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0);
                        }
                        if (c5 == '\u0000') {
                            gameObject4.enableAndVisible(true);
                            gameObject5.enableAndVisible(true);
                            gameObject6.enableAndVisible(true);
                        } else {
                            gameObject4.enableAndVisible(false);
                            gameObject5.enableAndVisible(false);
                            gameObject6.enableAndVisible(false);
                        }
                        if (string3.charAt(5) != '0') continue;
                        gameObject5.visible(false);
                    }
                } else if (this.mState == 15) {
                    String string;
                    if (this.tyler > 2) {
                        this.tyler = 0;
                    }
                    if (this.lisa > 2) {
                        this.lisa = 0;
                    }
                    if (this.tylerOrLisa == 'T') {
                        string = GameState.getText(474 + this.tyler);
                        this.tyler = (byte)(this.tyler + 1);
                    } else {
                        string = GameState.getText(471 + this.lisa);
                        this.lisa = (byte)(this.lisa + 1);
                    }
                    if (string != null && string.length() > 7) {
                        int n14;
                        int n15;
                        ++this.numDialogs;
                        GameObject gameObject7 = new GameObject();
                        GameObject gameObject8 = new GameObject();
                        GameObject gameObject9 = new GameObject();
                        gameObject7.focus(true);
                        gameObject8.focus(true);
                        gameObject9.focus(true);
                        int n16 = GameResourceMgr.getHeight(this.getCharacterId(string));
                        String string5 = string.substring(12, string.length());
                        int n17 = Helper.getMessageBoxHeight(string5, by, 19, n, GameCanvas.GAME_HEIGHT - n16);
                        int n18 = GameResourceMgr.getWidth(this.getCharacterId(string));
                        int n19 = GameResourceMgr.getWidth(this.getCharacterId2(string));
                        int n20 = GameResourceMgr.getWidth((short)29);
                        boolean bl3 = false;
                        if (string.charAt(1) == 'L' || string.charAt(6) == 'R') {
                            n15 = 8;
                            n14 = 4;
                            bl3 = true;
                        } else {
                            n15 = 4;
                            n14 = 8;
                            bl3 = false;
                        }
                        GameSprite.flagMirror = false;
                        gameObject7.addChild(Helper.createSimpleImage(this.getCharacterId(string), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n15, 0, !bl3));
                        GameSprite.flagMirror = true;
                        gameObject8.addChild(Helper.createSimpleImage(this.getCharacterId2(string), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n14, 0, bl3));
                        int n21 = GameResourceMgr.getHeight((short)28) / 2;
                        int n22 = GameResourceMgr.getHeight((short)28);
                        int n23 = 0;
                        gameObject9.addChild(Helper.createSimpleImage((short)31, GameCanvas.WIDTH_2, n21, 3, 0));
                        for (n23 = 0; n23 < n17 / n22; ++n23) {
                            gameObject9.addChild(Helper.createSimpleImage((short)28, GameCanvas.WIDTH_2, n22 + n21 + n23 * n22, 3, 0));
                        }
                        gameObject9.addChild(Helper.createSimpleImage((short)26, GameCanvas.WIDTH_2, n22 + n21 + n21 + (n23 - 1) * n22, 3, 0));
                        if (string.charAt(10) == '<') {
                            gameObject9.addChild(Helper.createSimpleImage((short)29, GameCanvas.WIDTH_2 - n20, n22 + n21 + n21 + n23 * n22, 3, 0));
                            bl = false;
                        } else {
                            gameObject9.addChild(Helper.createSimpleImage((short)30, GameCanvas.WIDTH_2 + n20, n22 + n21 + n21 + n23 * n22, 3, 0));
                            bl = true;
                        }
                        GameSprite.flagMirror = false;
                        gameObject7.addChild(Helper.createSimpleImage(this.character1Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n15, 0, !bl3));
                        gameObject7.addChild(Helper.createSimpleImage(this.character1Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n15, 0, !bl3));
                        gameObject7.addChild(Helper.createSimpleImage(this.character1Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n15, 0, !bl3));
                        GameSprite.flagMirror = true;
                        gameObject8.addChild(Helper.createSimpleImage(this.character2Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n14, 0, bl3));
                        gameObject8.addChild(Helper.createSimpleImage(this.character2Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n14, 0, bl3));
                        gameObject8.addChild(Helper.createSimpleImage(this.character2Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n14, 0, bl3));
                        GameSprite.flagMirror = false;
                        gameObject9.addChild(Helper.makeMessageBox(string5, 21, 12, (byte)37, this, by, 128, n, n17, 0xE0E0E0, 0xE0E0E0, 3, true).focus(true).setLocalXY(GameCanvas.WIDTH_2, n17 / 2 + n21));
                        gameObject.addChild(gameObject7);
                        gameObject2.addChild(gameObject8);
                        gameObject3.addChild(gameObject9);
                        gameObject9.setLocalXY(0, 0);
                        gameObject8.setLocalXY(0, 0);
                        gameObject7.setLocalXY(0, 0);
                        gameObject7.enableAndVisible(true);
                        gameObject8.enableAndVisible(true);
                        gameObject9.enableAndVisible(true);
                    }
                }
                gameObject.setLocalXY(-GameCanvas.WIDTH, 0);
                gameObject2.setLocalXY(GameCanvas.WIDTH, 0);
                if (!bl) {
                    gameObject3.setLocalXY(-GameCanvas.WIDTH, 0);
                } else {
                    gameObject3.setLocalXY(GameCanvas.WIDTH, 0);
                }
                gameObject.addProperty(new ObjectExtension(0, 0, 10));
                gameObject2.addProperty(new ObjectExtension(0, 0, 10));
                gameObject3.addProperty(new ObjectExtension(0, 0, 10));
                this.getRoot().addChild(this.makeMainMenuLogo(2));
                this.getRoot().addChild(gameObject);
                this.getRoot().addChild(gameObject2);
                this.getRoot().addChild(gameObject3);
                this.setSoftkeys(this.mState == 14 ? 21 : 24, this.mState == 14 ? 24 : 7);
                break;
            }
            case 16: {
                this.mClearColor = 0xFFFFFF;
                this.getRoot().addChild(this.makeFWDText(GameState.getText(330 + (this.levelToLoad >> 16)), GameState.getText(338 + (this.levelToLoad >> 16))));
                break;
            }
            case 17: {
                char c;
                char c6;
                int n;
                byte by = 1;
                this.mClearColor = 0xFFFFFF;
                char c7 = '\u0007';
                int[] nArray = new int[]{7, 5, 4, 4, 5, 4, 4, 4, 3, 3, 5, 4, 5, 4, 4, 4, 5, 3, 6, 4, 4, 3, 3, 3, 4, 4, 4, 3, 4, 8};
                this.whichLevel = n = this.getLevelNum(this.levelToLoad);
                int n24 = 0;
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        n24 += nArray[i];
                    }
                }
                String string = GameState.getText(344 + n24);
                c7 = c6 = string.charAt(11) - 48;
                this.numDialogs = 0;
                GameObject gameObject = new GameObject(43).focus(true);
                GameObject gameObject10 = new GameObject(49).focus(true);
                GameObject gameObject11 = new GameObject(50).focus(true);
                int n25 = GameCanvas.WIDTH - GameCanvas.WIDTH / 8;
                n25 = GameResourceMgr.getWidth((short)28);
                this.changeRight = new boolean[c7];
                this.changeLeft = new boolean[c7];
                for (c = '\u0000'; c < c7; ++c) {
                    this.changeLeft[c] = false;
                    this.changeRight[c] = false;
                }
                c = ' ';
                char c8 = ' ';
                boolean bl = false;
                for (char c9 = '\u0000'; c9 < c7; ++c9) {
                    int n26;
                    int n27;
                    String string6 = GameState.getText(344 + n24 + c9);
                    if (string6 == null || string6.length() <= 7) continue;
                    ++this.numDialogs;
                    GameObject gameObject12 = new GameObject();
                    GameObject gameObject13 = new GameObject();
                    GameObject gameObject14 = new GameObject();
                    if (c9 == '\u0000') {
                        gameObject12.focus(true);
                        gameObject13.focus(true);
                        gameObject14.focus(true);
                    } else {
                        gameObject12.focus(false);
                        gameObject13.focus(false);
                        gameObject14.focus(false);
                    }
                    int n28 = GameResourceMgr.getHeight(this.getCharacterId(string6));
                    String string7 = string6.substring(12, string6.length());
                    int n29 = Helper.getMessageBoxHeight(string7, by, 19, n25, GameCanvas.GAME_HEIGHT - n28);
                    int n30 = GameResourceMgr.getWidth(this.getCharacterId(string6));
                    int n31 = GameResourceMgr.getWidth(this.getCharacterId2(string6));
                    int n32 = GameResourceMgr.getWidth((short)29);
                    boolean bl4 = false;
                    if (string6.charAt(1) == 'L' || string6.charAt(6) == 'R') {
                        n27 = 8;
                        n26 = 4;
                        bl4 = true;
                    } else {
                        n27 = 4;
                        n26 = 8;
                        bl4 = false;
                    }
                    if (c9 == '\u0000') {
                        c = string6.charAt(0);
                        this.tylerOrLisa = string6.charAt(0);
                    } else {
                        if (c != string6.charAt(0)) {
                            this.changeLeft[c9] = true;
                        }
                        c = string6.charAt(0);
                    }
                    if (c9 == '\u0000') {
                        c8 = string6.charAt(5);
                    } else {
                        if (c8 != string6.charAt(5)) {
                            this.changeRight[c9] = true;
                        }
                        c8 = string6.charAt(5);
                    }
                    GameSprite.flagMirror = false;
                    gameObject12.addChild(Helper.createSimpleImage(this.getCharacterId(string6), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n27, 0, !bl4));
                    GameSprite.flagMirror = true;
                    gameObject13.addChild(Helper.createSimpleImage(this.getCharacterId2(string6), GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n26, 0, bl4));
                    int n33 = GameResourceMgr.getHeight((short)28) / 2;
                    int n34 = GameResourceMgr.getHeight((short)28);
                    int n35 = 0;
                    gameObject14.addChild(Helper.createSimpleImage((short)31, GameCanvas.WIDTH_2, n33, 3, 0));
                    for (n35 = 0; n35 < n29 / n34; ++n35) {
                        gameObject14.addChild(Helper.createSimpleImage((short)28, GameCanvas.WIDTH_2, n34 + n33 + n35 * n34, 3, 0));
                    }
                    gameObject14.addChild(Helper.createSimpleImage((short)26, GameCanvas.WIDTH_2, n34 + n33 + n33 + (n35 - 1) * n34, 3, 0));
                    if (string6.charAt(10) == '<') {
                        gameObject14.addChild(Helper.createSimpleImage((short)29, GameCanvas.WIDTH_2 - n32, n34 + n33 + n33 + n35 * n34, 3, 0));
                        if (c9 == '\u0000') {
                            bl = false;
                        }
                    } else {
                        gameObject14.addChild(Helper.createSimpleImage((short)30, GameCanvas.WIDTH_2 + n32, n34 + n33 + n33 + n35 * n34, 3, 0));
                        if (c9 == '\u0000') {
                            bl = true;
                        }
                    }
                    GameSprite.flagMirror = false;
                    gameObject12.addChild(Helper.createSimpleImage(this.character1Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n27, 0, !bl4));
                    gameObject12.addChild(Helper.createSimpleImage(this.character1Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n27, 0, !bl4));
                    gameObject12.addChild(Helper.createSimpleImage(this.character1Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n27, 0, !bl4));
                    GameSprite.flagMirror = true;
                    gameObject13.addChild(Helper.createSimpleImage(this.character2Table[1], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n26, 0, bl4));
                    gameObject13.addChild(Helper.createSimpleImage(this.character2Table[2], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n26, 0, bl4));
                    gameObject13.addChild(Helper.createSimpleImage(this.character2Table[3], GameCanvas.WIDTH / 2, GameCanvas.HEIGHT, 0x20 | n26, 0, bl4));
                    GameSprite.flagMirror = false;
                    gameObject14.addChild(Helper.makeMessageBox(string7, 21, 12, (byte)37, this, by, 128, n25, n29, 0xE0E0E0, 0xE0E0E0, 3, true).focus(true).setLocalXY(GameCanvas.WIDTH_2, n29 / 2 + n33));
                    gameObject.addChild(gameObject12);
                    gameObject10.addChild(gameObject13);
                    gameObject11.addChild(gameObject14);
                    if (c9 % 2 == 0) {
                        gameObject14.setLocalXY(0, 0);
                    } else {
                        gameObject14.setLocalXY(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0);
                    }
                    if (c9 == '\u0000') {
                        gameObject13.setLocalXY(0, 0);
                        gameObject12.setLocalXY(0, 0);
                    } else {
                        gameObject13.setLocalXY(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0);
                        gameObject12.setLocalXY(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0);
                    }
                    if (c9 == '\u0000') {
                        gameObject12.enableAndVisible(true);
                        gameObject13.enableAndVisible(true);
                        gameObject14.enableAndVisible(true);
                    } else {
                        gameObject12.enableAndVisible(false);
                        gameObject13.enableAndVisible(false);
                        gameObject14.enableAndVisible(false);
                    }
                    if (string6.charAt(5) != '0') continue;
                    gameObject13.visible(false);
                }
                gameObject.setLocalXY(-GameCanvas.WIDTH, 0);
                gameObject10.setLocalXY(GameCanvas.WIDTH, 0);
                if (!bl) {
                    gameObject11.setLocalXY(-GameCanvas.WIDTH, 0);
                } else {
                    gameObject11.setLocalXY(GameCanvas.WIDTH, 0);
                }
                gameObject.addProperty(new ObjectExtension(0, 0, 10));
                gameObject10.addProperty(new ObjectExtension(0, 0, 10));
                gameObject11.addProperty(new ObjectExtension(0, 0, 10));
                this.getRoot().addChild(this.makeMainMenuLogo(2));
                this.getRoot().addChild(gameObject);
                this.getRoot().addChild(gameObject10);
                this.getRoot().addChild(gameObject11);
                break;
            }
            case 18: {
                this.mClearColor = 0xFFFFFF;
                this.getRoot().addChild(this.makeFWDText(GameState.getText(56)));
                this.setSoftkeys(21, -1);
                break;
            }
            case 19: {
                this.mClearColor = 0xFFFFFF;
                this.setMusic(-1, false);
                GameResourceMgr.destroyImages();
                this.getRoot().addChild(Helper.createSimpleImage((short)186, GameCanvas.WIDTH_2, GameCanvas.HEIGHT_2, 3, 0));
                this.mSoftkey = null;
                if (!this.mBuyMoreExit) break;
                this.setSoftkeys(this.mBuyMoreText, GameState.getText(7));
                break;
            }
            case 20: {
                this.getRoot().addChild(Helper.makeMessageBox(GameState.getText(this.mIsDemo ? 496 : 497), this.mIsDemo ? 501 : 8, this.mIsDemo ? 12 : 9, (byte)37, this, (byte)1, 3, 16729234, 0xE0E0E0, 3).focus(true));
                break;
            }
            case 21: {
                this.getRoot().addChild(Helper.makeMessageBox(GameState.getText(this.mBuyMoreMenu ? 496 : 500), -1, 12, (byte)37, this, (byte)1, 3, 16729234, 0xE0E0E0, 3).focus(true));
                if (this.mBuyMoreMenu) {
                    this.setSoftkeys(501, 7);
                    break;
                }
                this.setSoftkeys(-1, 7);
            }
        }
    }

    GameObject makeFWDText(String string, String string2) {
        GameObject gameObject = new GameObject();
        gameObject.focus(true);
        this.loadFonts();
        gameObject.addChild(this.makeMainMenuLogo(2));
        GameObject gameObject2 = new GameObject();
        int n = 20 + GameResourceMgr.getHeight((short)188);
        int n2 = GameCanvas.HEIGHT - 40 - n - gFonts[1].getHeight() - (string2 == null ? 0 : gFonts[1].getHeight() * 2);
        int n3 = GameResourceMgr.getWidth((short)187) - GameResourceMgr.getWidth((short)187) / 6;
        gameObject2.focus(true);
        gameObject2.setLocalXY(this.mLastState == 17 ? -GameCanvas.WIDTH : GameCanvas.WIDTH, 0);
        gameObject2.addProperty(new ObjectExtension(0, 0, 10));
        gameObject2.addChild(this.makeFWD());
        if (string2 != null) {
            gameObject2.addChild(new GameObject().addProperty(new GameText(string2, 1, 0, 3).setWidth(n3).setHeight(gFonts[1].getHeight() * 2)).setLocalXY(GameCanvas.WIDTH_2, n + gFonts[1].getHeight()));
        }
        GameObject gameObject3 = Helper.makeMessageBox(string, 21, 12, (byte)37, this, (byte)2, 5, n3, n2, 16729234, 0xE0E0E0, 17).focus(true).setLocalXY(GameCanvas.WIDTH_2, n + n2 / 2 + (string2 == null ? 0 : gFonts[1].getHeight() * 2));
        gameObject3.addChild((GameObject)Helper.createSimpleImage((short)16, 0, n2 / 2 + 5, 24, 0, (byte)41).visible(false));
        gameObject3.addChild((GameObject)Helper.createSimpleImage((short)13, 0, n2 / 2 + 5, 20, 0, (byte)42).visible(false));
        gameObject2.addChild(gameObject3);
        gameObject.addChild(gameObject2);
        return gameObject;
    }

    GameObject makeFWDText(String string) {
        return this.makeFWDText(string, null);
    }

    GameObject makeText(String string, int n) {
        GameObject gameObject = new GameObject();
        gameObject.focus(true);
        this.loadFonts();
        GameObject gameObject2 = new GameObject();
        int n2 = 20 + GameResourceMgr.getHeight((short)188);
        int n3 = GameCanvas.HEIGHT - 40 - n2 - gFonts[1].getHeight() - 0;
        int n4 = GameResourceMgr.getWidth((short)187) - GameResourceMgr.getWidth((short)187) / 6;
        gameObject2.focus(true);
        GameObject gameObject3 = Helper.makeMessageBox(string, 21, 12, (byte)37, this, (byte)2, 5, n4, n3, 16729234, 0xE0E0E0, 17).focus(true).setLocalXY(GameCanvas.WIDTH_2, n);
        gameObject2.addChild(gameObject3);
        gameObject.addChild(gameObject2);
        return gameObject;
    }

    short getCharacterId(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        switch (string.charAt(2)) {
            case 'G': {
                n = 0;
                break;
            }
            case 'N': {
                n = 1;
                break;
            }
            case 'S': {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        switch (string.charAt(3)) {
            case 'F': {
                n2 = 0;
                break;
            }
            case 'O': {
                n2 = 1;
                break;
            }
            case 'R': {
                n2 = 2;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        switch (string.charAt(4)) {
            case 'F': {
                n3 = 0;
                break;
            }
            case 'O': {
                n3 = 1;
                break;
            }
            case 'R': {
                n3 = 2;
                break;
            }
            default: {
                n3 = 3;
            }
        }
        if (string.charAt(0) == 'L') {
            this.character1Table[0] = 180;
            this.character1Table[1] = (short)(181 + n);
            this.character1Table[2] = (short)(172 + n2);
            this.character1Table[3] = (short)(176 + n3);
            return 180;
        }
        if (string.charAt(0) == 'K') {
            this.character1Table[0] = 159;
            this.character1Table[1] = (short)(160 + n);
            this.character1Table[2] = (short)(151 + n2);
            this.character1Table[3] = (short)(155 + n3);
            return 159;
        }
        if (string.charAt(0) == 'T') {
            switch (string.charAt(3)) {
                case 'F': {
                    n2 = 0;
                    break;
                }
                case 'R': {
                    n2 = 1;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            switch (string.charAt(4)) {
                case 'F': {
                    n3 = 0;
                    break;
                }
                case 'R': {
                    n3 = 1;
                    break;
                }
                case 'S': {
                    n3 = 2;
                    break;
                }
                default: {
                    n3 = 3;
                }
            }
            this.character1Table[0] = 317;
            this.character1Table[1] = (short)(318 + n);
            this.character1Table[2] = (short)(310 + n2);
            this.character1Table[3] = (short)(313 + n3);
            return 317;
        }
        this.character1Table[0] = 159;
        this.character1Table[1] = (short)(160 + n);
        this.character1Table[2] = (short)(151 + n2);
        this.character1Table[3] = (short)(155 + n3);
        return 159;
    }

    short getCharacterId2(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        switch (string.charAt(7)) {
            case 'G': {
                n = 0;
                break;
            }
            case 'N': {
                n = 1;
                break;
            }
            case 'S': {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        switch (string.charAt(8)) {
            case 'F': {
                n2 = 0;
                break;
            }
            case 'O': {
                n2 = 1;
                break;
            }
            case 'R': {
                n2 = 2;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        switch (string.charAt(9)) {
            case 'F': {
                n3 = 0;
                break;
            }
            case 'O': {
                n3 = 1;
                break;
            }
            case 'R': {
                n3 = 2;
                break;
            }
            default: {
                n3 = 3;
            }
        }
        if (string.charAt(5) == 'L') {
            this.character2Table[0] = 180;
            this.character2Table[1] = (short)(181 + n);
            this.character2Table[2] = (short)(172 + n2);
            this.character2Table[3] = (short)(176 + n3);
            return 180;
        }
        if (string.charAt(5) == 'K') {
            this.character2Table[0] = 159;
            this.character2Table[1] = (short)(160 + n);
            this.character2Table[2] = (short)(151 + n2);
            this.character2Table[3] = (short)(155 + n3);
            return 159;
        }
        if (string.charAt(5) == 'T') {
            switch (string.charAt(8)) {
                case 'F': {
                    n2 = 0;
                    break;
                }
                case 'R': {
                    n2 = 1;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            switch (string.charAt(9)) {
                case 'F': {
                    n3 = 0;
                    break;
                }
                case 'R': {
                    n3 = 1;
                    break;
                }
                case 'S': {
                    n3 = 2;
                    break;
                }
                default: {
                    n3 = 3;
                }
            }
            this.character2Table[0] = 317;
            this.character2Table[1] = (short)(318 + n);
            this.character2Table[2] = (short)(310 + n2);
            this.character2Table[3] = (short)(313 + n3);
            return 317;
        }
        this.character2Table[0] = 180;
        this.character2Table[1] = (short)(181 + n);
        this.character2Table[2] = (short)(172 + n2);
        this.character2Table[3] = (short)(176 + n3);
        return 180;
    }

    int getLevelNum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.stageLevelNames.length; ++i) {
            for (int j = 0; j < this.stageLevelNames[i].length; ++j) {
                if (i == n >> 16 && j == (n & 0xFF)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    void consumeKeyClicked() {
        this.keyClicked = 0;
        if (this.touchScreenOn) {
            TouchScreen.getInstance().resetState();
        }
    }

    void onStateEnd() {
        this.consumeKeyClicked();
        GameState.gFonts[2] = null;
        switch (this.mState) {
            case 12: {
                this.mLevelRunway.destroy();
                this.mLevelRunway = null;
                GameResourceMgr.destroyImages();
                break;
            }
            case 2: 
            case 5: {
                this.mMainMenu = null;
                break;
            }
            case 1: {
                GameResourceMgr.destroyImages();
                break;
            }
            default: {
                this.mRoot = new GameObject();
                this.mRoot.focus(true);
            }
        }
        this.mLevelRunway = null;
        this.mRoot = new GameObject();
        this.mRoot.focus(true);
        GameState.gc();
    }

    boolean onStateLoading() {
        this.mMaxLoadingStep = 10;
        block0 : switch (this.mState) {
            case 1: {
                switch (this.mLoadingStep) {
                    case 1: {
                        GameResourceMgr.loadBBox("bbox.bin");
                        break block0;
                    }
                    case 2: {
                        GameResourceMgr.loadImages(new short[]{186});
                        break block0;
                    }
                    case 3: {
                        this.loadFonts();
                        break block0;
                    }
                    case 4: {
                        this.loadStages("stages.bin");
                        break block0;
                    }
                    case 5: {
                        this.loadRms();
                        break block0;
                    }
                    case 6: {
                        this.loadSounds();
                        break block0;
                    }
                    case 7: {
                        return true;
                    }
                }
                break;
            }
            case 12: {
                switch (this.mLoadingStep) {
                    case 0: {
                        GameResourceMgr.destroyImages();
                        this.mLevelRunway = new LevelRunway(this, this.stageLevelNames[this.levelToLoad >> 16][this.levelToLoad & 0xFF]);
                        break block0;
                    }
                }
                this.mLevelRunway.loadNext();
                break;
            }
            case 5: 
            case 13: {
                if (!GameResourceMgr.isLoaded((short)(290 + this.whichLogo))) {
                    switch (this.mLoadingStep) {
                        case 0: {
                            GameResourceMgr.loadImage((short)17);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            GameResourceMgr.loadImage((short)(290 + this.whichLogo));
                        }
                    }
                    break;
                }
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    void onStateUpdate() {
        this.mStateTime = System.currentTimeMillis() - this.mStateStartTime;
        if (this.mMusicToPlay > -1 && this.mPausedObject == null) {
            if (this.mMusicTime >= -1) {
                this.mMusicTime = (int)((long)this.mMusicTime - this.mFrameTime);
            }
            if (Boxal.bInfSoundLoopfix) {
                if (this.soundOn && Boxal.bInfMusicOn && this.mMusicTime <= 0) {
                    this.stopSound();
                    Boxal.play(gSounds[this.mMusicToPlay], 1);
                    if (this.mLoopMusic) {
                        this.mMusicTime = SOUND_LENGTH[gSounds[this.mMusicToPlay]] * 1000;
                    } else {
                        this.mMusicToPlay = -1;
                    }
                }
            } else {
                this.playMusic(this.mMusicToPlay, this.mLoopMusic);
                if (!this.mLoopMusic) {
                    this.mMusicToPlay = -1;
                }
            }
        }
        switch (this.mState) {
            case 0: {
                this.gotoState(1);
                break;
            }
            case 12: {
                this.mLevelRunway.onUpdate();
                break;
            }
            case 2: {
                GameObject gameObject = this.mMainMenu.getChildByHashName((byte)27);
                this.tempLang = (byte)MenuSelector.getMenuSelector(gameObject).getCurrentPosition(gameObject);
                if (this.tempLang >= 0) {
                    Boxal.setFrenchSoftkeys(this.languages_available[this.tempLang] == 1);
                    this.setSoftkeys(babble_szSource[1][this.languages_available[this.tempLang]], null);
                }
                if (!this.touchScreenOn) break;
                this.setLeftSoftkey(null);
                break;
            }
            case 1: {
                GameObject[] gameObjectArray = this.getRoot().getChildArray();
                if (this.mStateTime > 2000L) {
                    this.gotoState(2);
                    break;
                }
                gameObjectArray[0].visible(true);
                break;
            }
            case 5: {
                this.onMainMenuUpdate();
                break;
            }
            case 8: {
                if (this.mCanvas.cheatCode == 338174) {
                    this.mCanvas.cheatCode = 0;
                    this.CHEAT_UNLOCK_LEVELS = !this.CHEAT_UNLOCK_LEVELS;
                    break;
                }
                if (this.mCanvas.cheatCode != 338175) break;
                this.mCanvas.cheatCode = 0;
                this.CHEAT_UNLOCK_POWERUPS = !this.CHEAT_UNLOCK_POWERUPS;
                break;
            }
            case 19: {
                if (this.mStateTime <= 3000L) break;
                this.mCanvas.quit();
            }
        }
        switch (this.mSubState) {
            default: 
        }
    }

    void onStatePostUpdate() {
        switch (this.mState) {
            case 12: {
                if (this.mLevelRunway == null) break;
                this.mLevelRunway.onPostUpdate();
            }
        }
    }

    void onStatePaint(Graphics graphics) {
        switch (this.mState) {
            case 12: {
                this.mLevelRunway.onPaint(graphics);
                break;
            }
        }
    }

    void onTouched(int n, int n2, int n3) {
        if (this.touchScreenOn) {
            if (this.mIsLoading) {
                return;
            }
            if (this.mState == 4) {
                if (!this.mIsPaused) {
                    this.gotoState(5);
                }
            } else if (this.mState == 1) {
                this.onKeyClicked(5);
            }
        }
    }

    void onKeyClicked(int n) {
        if (this.mIsLoading) {
            return;
        }
        if (this.mIsPaused) {
            if (n == 6) {
                switch (this.mPauseState) {
                    case 6: {
                        this.gotoPauseState(0);
                        break;
                    }
                    case 9: {
                        this.gotoPauseState(0);
                    }
                }
            } else if (n == 5) {
                switch (this.mPauseState) {
                    case 9: {
                        this.onResume();
                        this.gotoState(5);
                    }
                }
            }
            return;
        }
        Tools.println("action ");
        Tools.println(n);
        block7 : switch (this.mState) {
            case 4: {
                if (this.touchScreenOn) break;
                this.gotoState(5);
                break;
            }
            case 12: {
                this.mLevelRunway.onKeyClicked(n);
                break;
            }
            case 1: {
                this.gotoState(2);
                break;
            }
            case 3: {
                if (n == 6) {
                    this.soundOn = false;
                } else {
                    if (n != 5) break;
                    this.soundOn = true;
                }
                this.gotoState(4);
                break;
            }
            case 8: {
                if (n != 6) break;
                this.gotoState(5);
                break;
            }
            case 6: 
            case 7: {
                if (n != 6) break;
                this.gotoState(5);
                break;
            }
            case 5: {
                if (n != 6) break;
                this.gotoState(9);
                break;
            }
            case 9: {
                if (n == 5) {
                    this.gotoState(19);
                }
                if (n != 6) break;
                this.gotoState(5);
                break;
            }
            case 13: {
                if (n != 6) break;
                this.gotoState(5);
                break;
            }
            case 14: {
                if (n == 5) {
                    if ((this.whichLevel + 1) % 5 != 0) {
                        this.nextLevel(true);
                        break;
                    }
                    GameObject gameObject = this.getRoot().getChildByHashName((byte)43);
                    GameObject gameObject2 = this.getRoot().getChildByHashName((byte)49);
                    GameObject gameObject3 = this.getRoot().getChildByHashName((byte)50);
                    GameObject[] gameObjectArray = gameObject.getChildArray();
                    GameObject[] gameObjectArray2 = gameObject2.getChildArray();
                    GameObject[] gameObjectArray3 = gameObject3.getChildArray();
                    for (int i = 0; i < gameObjectArray3.length; ++i) {
                        if (!gameObjectArray3[i].hasFocus()) continue;
                        gameObjectArray3[i].focus(false);
                        gameObjectArray[i].focus(false);
                        gameObjectArray2[i].focus(false);
                        if (i < gameObjectArray3.length - 1) {
                            gameObjectArray3[i + 1].focus(true);
                            gameObjectArray[i + 1].focus(true);
                            gameObjectArray2[i + 1].focus(true);
                            gameObject3.getPropertyByHashType((byte)44).destroy();
                            if (i % 2 == 0) {
                                gameObject3.addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                if (this.changeLeft[i + 1]) {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 10));
                                } else {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                                if (this.changeRight[i + 1]) {
                                    gameObjectArray2[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 10));
                                    gameObjectArray2[i + 1].addProperty(new ObjectExtension(0, 0, 10));
                                } else {
                                    gameObjectArray2[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 1));
                                    gameObjectArray2[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                            } else {
                                gameObject3.addProperty(new ObjectExtension(0, 0, 1));
                                if (this.changeLeft[i + 1]) {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 10));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 10));
                                } else {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                                if (this.changeRight[i + 1]) {
                                    gameObjectArray2[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 10));
                                } else {
                                    gameObjectArray2[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 1));
                                    gameObjectArray2[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                            }
                            gameObjectArray3[i + 1].enableAndVisible(true);
                            gameObjectArray[i + 1].enableAndVisible(true);
                            gameObjectArray2[i + 1].enableAndVisible(true);
                            if (i > 0) {
                                gameObjectArray3[i - 1].enableAndVisible(false);
                            }
                            if (i > 0) {
                                gameObjectArray2[i - 1].enableAndVisible(false);
                            }
                            if (i <= 0) break block7;
                            gameObjectArray[i - 1].enableAndVisible(false);
                            break block7;
                        }
                        this.nextLevel(true);
                    }
                    break;
                }
                if (n != 6) break;
                this.gotoState(12);
                break;
            }
            case 15: {
                if (n == 5) {
                    this.gotoState(12);
                    break;
                }
                if (n != 6) break;
                this.gotoState(5);
                break;
            }
            case 16: {
                if (n == 5) {
                    this.gotoState(17);
                    break;
                }
                if (n != 6) break;
                this.gotoState(13);
                break;
            }
            case 17: {
                if (n == 5) {
                    GameObject gameObject = this.getRoot().getChildByHashName((byte)43);
                    GameObject gameObject4 = this.getRoot().getChildByHashName((byte)49);
                    GameObject gameObject5 = this.getRoot().getChildByHashName((byte)50);
                    GameObject[] gameObjectArray = gameObject.getChildArray();
                    GameObject[] gameObjectArray4 = gameObject4.getChildArray();
                    GameObject[] gameObjectArray5 = gameObject5.getChildArray();
                    for (int i = 0; i < gameObjectArray5.length; ++i) {
                        if (!gameObjectArray5[i].hasFocus()) continue;
                        gameObjectArray5[i].focus(false);
                        gameObjectArray[i].focus(false);
                        gameObjectArray4[i].focus(false);
                        if (i < gameObjectArray5.length - 1) {
                            gameObjectArray5[i + 1].focus(true);
                            gameObjectArray[i + 1].focus(true);
                            gameObjectArray4[i + 1].focus(true);
                            gameObject5.getPropertyByHashType((byte)44).destroy();
                            if (i % 2 == 0) {
                                gameObject5.addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                if (this.changeLeft[i + 1]) {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 10));
                                } else {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                                if (this.changeRight[i + 1]) {
                                    gameObjectArray4[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 10));
                                    gameObjectArray4[i + 1].addProperty(new ObjectExtension(0, 0, 10));
                                } else {
                                    gameObjectArray4[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 1));
                                    gameObjectArray4[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                            } else {
                                gameObject5.addProperty(new ObjectExtension(0, 0, 1));
                                if (this.changeLeft[i + 1]) {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 10));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 10));
                                } else {
                                    gameObjectArray[i].addProperty(new ObjectExtension(-(GameCanvas.WIDTH + GameCanvas.WIDTH / 6), 0, 1));
                                    gameObjectArray[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                                if (this.changeRight[i + 1]) {
                                    gameObjectArray4[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 10));
                                } else {
                                    gameObjectArray4[i].addProperty(new ObjectExtension(GameCanvas.WIDTH + GameCanvas.WIDTH / 6, 0, 1));
                                    gameObjectArray4[i + 1].addProperty(new ObjectExtension(0, 0, 1));
                                }
                            }
                            gameObjectArray5[i + 1].enableAndVisible(true);
                            gameObjectArray[i + 1].enableAndVisible(true);
                            gameObjectArray4[i + 1].enableAndVisible(true);
                            if (i > 0) {
                                gameObjectArray5[i - 1].enableAndVisible(false);
                            }
                            if (i > 0) {
                                gameObjectArray4[i - 1].enableAndVisible(false);
                            }
                            if (i <= 0) break block7;
                            gameObjectArray[i - 1].enableAndVisible(false);
                            break block7;
                        }
                        System.out.println("STATE_RUNWAY");
                        this.gotoState(12);
                    }
                    break;
                }
                if (n != 6) break;
                this.gotoState(this.mLastState);
                break;
            }
            case 18: {
                if (n != 5) break;
                this.gotoState(5);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                if (n == 5 && (this.mBuyMoreMenu && (this.mState == 20 || this.mState == 21) || this.mBuyMoreExit && this.mState == 19)) {
                    this.mCanvas.mMidlet.mGotoUrl = this.mBuyMoreUrl;
                    this.mCanvas.quit();
                }
                if (n != 6) break;
                if (this.mState == 19) {
                    if (!this.mBuyMoreExit) break;
                    this.mCanvas.quit();
                    break;
                }
                if (this.mState == 21) {
                    this.mCanvas.quit();
                    break;
                }
                this.gotoState(this.mLastState);
            }
        }
    }

    GameObject makeFWD() {
        GameObject gameObject = new GameObject();
        int n = GameResourceMgr.getWidth((short)187);
        int n2 = GameResourceMgr.getHeight((short)187);
        int n3 = 0;
        int n4 = GameCanvas.WIDTH_2;
        while ((n3 + 1) * n2 < GameCanvas.HEIGHT - 40) {
            gameObject.addProperty(new GameSprite(187, 0, 17, n4, n3 * n2 + 20));
            ++n3;
        }
        gameObject.addProperty(new GameSprite(188, 0, 17, n4, 20));
        return gameObject;
    }

    boolean nextLevel(boolean bl) {
        boolean bl2 = true;
        int n = this.levelToLoad;
        for (int i = 0; i < this.stageLevelNames.length; ++i) {
            for (int j = 0; j < this.stageLevelNames[i].length; ++j) {
                if (this.shouldEnable(i, j)) {
                    this.levelToLoad = (i << 16) + j;
                    continue;
                }
                bl2 = false;
            }
        }
        if (bl && bl2 && n >> 16 == this.stageLevelNames.length - 1 && (n & 0xFF) == this.stageLevelNames[this.stageLevelNames.length - 1].length - 1) {
            this.gotoState(5);
            return false;
        }
        this.gotoState(13);
        return true;
    }

    int calcHeight(int n) {
        return (GameCanvas.HEIGHT << 8) / 320 * n >> 8;
    }

    int calcWidth(int n) {
        return (GameCanvas.WIDTH << 8) / 240 * n >> 8;
    }

    GameObject makeMainMenuLogo(int n) {
        Tools.println("makeMainMenuLogo");
        GameObject gameObject = new GameObject();
        if (GameCanvas.WIDTH <= 240) {
            gameObject.addChild(Helper.createSimpleImage((short)17, GameCanvas.WIDTH - 240, GameCanvas.HEIGHT, 36, 0));
        }
        if (n == 0) {
            gameObject.addChild(Helper.createSimpleImage((short)17, GameCanvas.WIDTH - 240, GameCanvas.HEIGHT, 36, 0));
            if (GameCanvas.WIDTH <= 240) {
                gameObject.addChild(Helper.createSimpleImage((short)(290 + this.whichLogo), GameCanvas.WIDTH_2, 0, 17, 0));
            } else {
                gameObject.addChild(Helper.createSimpleImage((short)(290 + this.whichLogo), GameCanvas.WIDTH_2, GameCanvas.HEIGHT_2, 3, 0));
            }
        } else if (n != 2) {
            gameObject.addChild(Helper.createSimpleImage((short)17, GameCanvas.WIDTH - 240, GameCanvas.HEIGHT, 36, 0));
            gameObject.addChild(Helper.createSimpleImage((short)(290 + this.whichLogo), GameCanvas.WIDTH_2, 0, 17, 0));
        }
        Tools.println("makeMainMenuLogo end");
        return gameObject;
    }

    GameObject makeSimpleMenu(String[] stringArray, byte[] byArray, int n, boolean bl) {
        return this.makeSimpleMenu(stringArray, byArray, n, bl, this);
    }

    GameObject makeSimpleMenu(String[] stringArray, byte[] byArray, int n, boolean bl, UiListener uiListener) {
        GameObject gameObject = new GameObject();
        GameObject gameObject2 = new GameObject(27);
        int n2 = GameCanvas.GAME_HEIGHT - n;
        int n3 = GameResourceMgr.loadImage((short)54).getHeight() + GameCanvas.HEIGHT / 30;
        MenuSelector menuSelector = new MenuSelector(3, n2, GameResourceMgr.loadImage((short)54).getWidth(), n3);
        if (this.touchScreenOn) {
            menuSelector.mDontHighlight = true;
        }
        menuSelector.reverse();
        gameObject2.addProperty(menuSelector);
        gameObject2.setLocalX(GameCanvas.WIDTH_2);
        int n4 = 0;
        if (bl && n3 * byArray.length < n2) {
            n4 = (n2 - n3 * byArray.length) / 2;
        }
        gameObject2.setLocalY(n + n2 / 2 + n4);
        gameObject.addChild((GameObject)Helper.createSimpleImage((short)16, GameCanvas.WIDTH, n, 24, 0, (byte)41).visible(false));
        gameObject.addChild((GameObject)Helper.createSimpleImage((short)13, GameCanvas.WIDTH, n + n2, 40, 0, (byte)42).visible(false));
        int n5 = byArray.length;
        n2 /= n5 + 1;
        for (int i = 0; i < n5; ++i) {
            GameObject gameObject3 = Helper.makeButton(stringArray[i], byArray[i], 0, 0, new short[]{54, 56, 55}, uiListener, 3, (byte)1);
            gameObject2.addChild(gameObject3);
            GameObject gameObject4 = gameObject3.getChildByHashName((byte)5);
            if (gameObject4 == null) continue;
            GameText gameText = GameText.getGameText(gameObject4);
            gameText.setWidth(GameResourceMgr.getWidth((short)54) - GameResourceMgr.getWidth((short)54) / 8);
            gameText.setScrollX(true);
        }
        gameObject2.focus(true);
        gameObject.addChild(gameObject2);
        gameObject.focus(true);
        return gameObject;
    }

    void onMainMenuBegin() {
        byte[] byArray;
        String[] stringArray;
        this.mClearColor = 0xFFFFFF;
        this.mMainMenu = new GameObject();
        this.mMainMenu.focus(true);
        this.mMainMenu.addChild(this.makeMainMenuLogo(1));
        if (this.mBuyMoreMenu) {
            stringArray = new String[]{GameState.getText(3), GameState.getText(4), GameState.getText(5), GameState.getText(6), this.mBuyMoreText};
            byArray = new byte[]{1, 6, 7, 8, 47};
        } else {
            stringArray = new String[]{GameState.getText(3), GameState.getText(4), GameState.getText(5), GameState.getText(6)};
            byArray = new byte[]{1, 6, 7, 8};
        }
        this.mMainMenu.addChild(this.makeSimpleMenu(stringArray, byArray, 100, true));
        if (this.mIsDemo) {
            this.mMainMenu.addChild(Helper.makeLabel(GameState.getText(54), (byte)0, GameCanvas.WIDTH, 1, 24, (byte)1).addProperty(new BlinkOnFocus(true)));
        }
        this.getRoot().addChild(this.mMainMenu);
        if (this.touchScreenOn) {
            this.setLeftSoftkey(null);
        }
    }

    boolean loadStages(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string);
        try {
            int n = dataInputStream.readByte();
            this.stageLevelNames = new String[n][];
            this.stageLevelScores = new short[n][];
            this.stageLevelStars = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readByte();
                this.stageLevelNames[i] = new String[n2];
                this.stageLevelScores[i] = new short[n2];
                this.stageLevelStars[i] = new byte[n2];
                for (int j = 0; j < n2; ++j) {
                    this.stageLevelNames[i][j] = dataInputStream.readUTF();
                    this.stageLevelScores[i][j] = 0;
                    this.stageLevelStars[i][j] = 0;
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            return true;
        }
        catch (Exception exception) {
            Tools.println("Error load stages:");
            Tools.println(string);
            return false;
        }
    }

    boolean shouldEnable(int n, int n2) {
        if (this.CHEAT_UNLOCK_LEVELS) {
            return true;
        }
        if (n >= this.stageLevelStars.length) {
            return false;
        }
        if (n2 >= this.stageLevelStars[n].length) {
            return false;
        }
        if (n2 == 0) {
            if (n == 0) {
                return true;
            }
            return this.stageLevelStars[n - 1][this.stageLevelStars[n - 1].length - 1] >= 3;
        }
        return this.stageLevelStars[n][n2 - 1] >= 3;
    }

    String getStars(int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + "*";
        }
        return string;
    }

    void onSelectLevelBegin() {
        Tools.println("onSelectLevelBegin");
        int n = GameResourceMgr.getHeight((short)71) / 2;
        GameObject gameObject = new GameObject();
        gameObject.focus(true);
        this.getRoot().addChild(gameObject);
        GameObject gameObject2 = new GameObject();
        gameObject2.focus(true);
        MenuSelector menuSelector = new MenuSelector(1, GameCanvas.WIDTH, GameCanvas.WIDTH, GameCanvas.WIDTH);
        gameObject2.addProperty(menuSelector);
        GameObject gameObject3 = new GameObject();
        gameObject3.focus(true);
        MenuSelector menuSelector2 = new MenuSelector(1, GameCanvas.WIDTH, GameCanvas.WIDTH, GameResourceMgr.getWidth((short)71));
        gameObject3.addProperty(menuSelector2);
        gameObject3.setLocalXY(GameCanvas.WIDTH_2, n);
        n += n;
        GameObject gameObject4 = new GameObject();
        gameObject4.setLocalXY(GameCanvas.WIDTH_2, n += GameCanvas.HEIGHT / 15);
        GameObject gameObject5 = (GameObject)Helper.createSimpleImage((short)14, -GameCanvas.WIDTH_2, 0, 6, 0, (byte)41).visible(false);
        GameObject gameObject6 = (GameObject)Helper.createSimpleImage((short)15, GameCanvas.WIDTH_2, 0, 10, 0, (byte)42).visible(false);
        gameObject4.addChild(gameObject5);
        gameObject4.addChild(gameObject6);
        menuSelector2.setArrows(gameObject5, gameObject6, true);
        gameObject.addChild(gameObject4);
        gameObject.addChild(gameObject3);
        int n2 = GameCanvas.GAME_HEIGHT - (n += GameCanvas.HEIGHT / 15);
        gameObject5 = (GameObject)Helper.createSimpleImage((short)16, GameCanvas.WIDTH, n, 24, 0, (byte)41).visible(false);
        gameObject6 = (GameObject)Helper.createSimpleImage((short)13, GameCanvas.WIDTH, n + n2, 40, 0, (byte)42).visible(false);
        gameObject.addChild(gameObject5);
        gameObject.addChild(gameObject6);
        gameObject2.setLocalXY(GameCanvas.WIDTH_2, n += n2 / 2);
        int n3 = 0;
        for (int i = 0; i < this.stageLevelNames.length; ++i) {
            GameObject gameObject7 = new GameObject();
            MenuSelector menuSelector3 = new MenuSelector(3, n2, GameResourceMgr.loadImage((short)54).getWidth(), GameResourceMgr.loadImage((short)54).getHeight() + 5);
            if (this.touchScreenOn) {
                menuSelector3.mDontHighlight = true;
            }
            menuSelector3.setArrows(gameObject5, gameObject6, true);
            menuSelector3.reverse();
            gameObject7.addProperty(menuSelector3);
            GameText gameText = new GameText(GameState.getText(338 + i), 1, 0, 65, 0, -n + GameResourceMgr.getHeight((short)71) + gFonts[1].getHeight());
            gameObject7.addProperty(gameText);
            gameObject2.addChild(gameObject7);
            GameObject gameObject8 = Helper.createSimpleImage((short)(71 + i), 0, 0, 3, 0);
            if (!this.shouldEnable(i, 0)) {
                gameObject8.addProperty(new GameSprite(185));
            }
            gameObject3.addChild(gameObject8);
            if (this.levelToLoad >> 16 == i) {
                menuSelector2.setCurrent(gameObject8);
                menuSelector.setCurrent(gameObject7);
            }
            if (!this.shouldEnable(i, 0)) {
                gameObject7.enable(false);
                gameObject8.enable(false);
            }
            int n4 = 0;
            while (n4 < this.stageLevelNames[i].length) {
                BaseObject baseObject;
                GameObject gameObject9 = Helper.makeButton(this.shouldEnable(i, n4) ? GameState.getText(300 + n3) + "\n" + this.getStars(this.stageLevelStars[i][n4]) + " " + this.stageLevelScores[i][n4] * 10 : "", (byte)40, 0, 0, this, (byte)1);
                GameObject gameObject10 = gameObject9.getChildByHashName((byte)5);
                if (gameObject10 != null) {
                    baseObject = GameText.getGameText(gameObject10);
                    gameObject10.setLocalXY(0, 2);
                    ((GameText)baseObject).setWidth(GameResourceMgr.getWidth((short)54) - GameResourceMgr.getWidth((short)54) / 8);
                    ((GameText)baseObject).setScrollX(true);
                }
                gameObject7.addChild(gameObject9);
                gameObject.onUpdate(this);
                if (!this.shouldEnable(i, n4)) {
                    Helper.changeButtonImages(gameObject9, new short[]{53, 53, 53});
                    baseObject = new GameObject();
                    ((GameObject)baseObject).addProperty(new GameSprite(185));
                    gameObject9.addChild((GameObject)baseObject);
                    gameObject9.enable(false);
                }
                if (this.levelToLoad >> 16 == i && (this.levelToLoad & 0xFF) == n4) {
                    menuSelector3.setCurrent(gameObject9);
                }
                DataTable.setInteger(gameObject9, "level", (i << 16) + n4);
                ++n4;
                ++n3;
            }
        }
        gameObject.addChild(gameObject2);
        if (this.touchScreenOn) {
            this.setLeftSoftkey(null);
        }
        Tools.println("onSelectLevelBegin end");
    }

    void onMainMenuUpdate() {
    }

    void drawLevelStars(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(GameResourceMgr.loadImage((short)245), n, n2, 1 | 2);
        boolean bl = false;
        graphics.setClip(n - (GameResourceMgr.loadImage((short)245).getWidth() >> 1), n2 - (GameResourceMgr.loadImage((short)245).getHeight() >> 1), (n3 > 0 ? 5 : 0) + n3 * 22 + (n3 >= 5 ? 5 : 0), GameResourceMgr.loadImage((short)245).getHeight());
        graphics.drawImage(GameResourceMgr.loadImage((short)246), n, n2, 1 | 2);
        graphics.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        if (n4 >= 0) {
            gFonts[1].drawString(graphics, "" + n4, n, n2 + 22, 1 | 2);
        }
    }

    void drawLevelStarsBig(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(GameResourceMgr.loadImage((short)244), n, n2, 1 | 2);
        boolean bl = false;
        graphics.setClip(n - (GameResourceMgr.loadImage((short)244).getWidth() >> 1), n2 - (GameResourceMgr.loadImage((short)244).getHeight() >> 1), (n3 > 0 ? 5 : 0) + n3 * 40 + (n3 >= 5 ? 5 : 0), GameResourceMgr.loadImage((short)244).getHeight());
        graphics.drawImage(GameResourceMgr.loadImage((short)243), n, n2, 1 | 2);
        graphics.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        if (n4 >= 0) {
            gFonts[1].drawString(graphics, "" + n4, n, n2 + 35, 1 | 2);
        }
    }

    void drawModelScore(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = false;
        graphics.setClip(n - (GameResourceMgr.loadImage((short)245).getWidth() >> 1), n2 - (GameResourceMgr.loadImage((short)245).getHeight() >> 1), (n3 > 0 ? 5 : 0) + n3 * 22 + (n3 >= 5 ? 5 : 0), GameResourceMgr.loadImage((short)245).getHeight());
        graphics.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        if (n4 >= 0) {
            gFonts[1].drawString(graphics, "" + n4, n, n2 + 22, 1 | 2);
        }
    }

    public void onMessage(GameObject gameObject, int n) {
        Tools.println("onMesage ");
        Tools.println(n);
        if (this.mIsPaused) {
            switch (n) {
                case 5: {
                    if (gameObject.mHashName == 45) {
                        this.onResume();
                        break;
                    }
                    if (gameObject.mHashName == 6) {
                        this.gotoPauseState(6);
                        break;
                    }
                    if (gameObject.mHashName == 9) {
                        this.gotoPauseState(9);
                        break;
                    }
                    if (gameObject.mHashName != 39) break;
                    Tools.println("sound");
                    this.switchSound(gameObject);
                }
            }
            this.consumeKeyClicked();
            return;
        }
        switch (this.mState) {
            case 2: {
                this.loadLanguage("/language", babble_languages[gameObject.mHashName], -1);
                Boxal.setFrenchSoftkeys(babdialect == 1);
                Tools.println("init lang");
                this.whichLogo = gameObject.mHashName == 1 ? (short)2 : (gameObject.mHashName == 3 ? (short)1 : 0);
                this.gotoState(3);
                break;
            }
            case 5: {
                switch (n) {
                    case 5: {
                        this.mMainMenu.enable(false);
                        Tools.println("onMesage fire");
                        Tools.println(n);
                        if (gameObject.mHashName == 1) {
                            Tools.println("new game");
                            this.nextLevel(false);
                            break;
                        }
                        if (gameObject.mHashName == 9) {
                            Tools.println("exit");
                            this.mCanvas.quit();
                            break;
                        }
                        if (gameObject.mHashName == 7) {
                            Tools.println("help");
                            this.gotoState(7);
                            break;
                        }
                        if (gameObject.mHashName == 8) {
                            Tools.println("credits");
                            this.gotoState(8);
                            break;
                        }
                        if (gameObject.mHashName == 6) {
                            Tools.println("options");
                            this.gotoState(6);
                            break;
                        }
                        if (gameObject.mHashName == 47) {
                            Tools.println("options");
                            this.gotoState(20);
                            break;
                        }
                        this.gotoState(5);
                    }
                }
                break;
            }
            case 6: {
                if (gameObject.mHashName != 39 || n != 5) break;
                Tools.println("sound msg");
                this.switchSound(gameObject);
                this.consumeKeyClicked();
                break;
            }
            case 13: {
                if (gameObject.mHashName != 40) break;
                this.levelToLoad = DataTable.getInteger(gameObject, "level", -1);
                if (this.mIsDemo && this.levelToLoad > 1) {
                    this.gotoState(21);
                    break;
                }
                if ((this.levelToLoad & 0xFF) == 0) {
                    this.gotoState(17);
                    break;
                }
                this.gotoState(17);
            }
        }
    }

    void setSoftkeys(int n) {
        this.setSoftkeys(this.gSoftkeysTable[n << 1], this.gSoftkeysTable[(n << 1) + 1]);
    }

    void setLeftSoftkey(String string) {
        if (string == null) {
            this.mSoftkeyVisible[0] = false;
        } else {
            this.mSoftkeyVisible[0] = true;
            this.mSoftkeyText[0] = string;
        }
    }

    void setSoftkeys(int n, int n2) {
        Tools.println("left:");
        Tools.println(n);
        Tools.println("right:");
        Tools.println(n2);
        this.setSoftkeys(n >= 0 ? GameState.getText(n) : null, n2 >= 0 ? GameState.getText(n2) : null);
    }

    void setSoftkeys(String string, String string2) {
        if (string == null) {
            this.mSoftkeyVisible[0] = false;
        } else {
            this.mSoftkeyVisible[0] = true;
            this.mSoftkeyText[0] = Boxal.bInfPandQ ? "(" + this.getSoftkeyText(48) + ") " + string : string;
        }
        if (string2 == null) {
            this.mSoftkeyVisible[1] = false;
        } else {
            this.mSoftkeyVisible[1] = true;
            this.mSoftkeyText[1] = Boxal.bInfPandQ ? string2 + " (" + this.getSoftkeyText(49) + ")" : string2;
        }
    }

    public void loadFonts() {
        byte[] byArray = new byte[]{0, 1, 2};
        for (int i = 0; i < byArray.length; ++i) {
            if (gFonts[byArray[i]] != null) {
                GameState.gFonts[i] = gFonts[byArray[i]];
                continue;
            }
            Tools.println("Load font ");
            Tools.println(FONT_NAMES[i]);
            GameState.gFonts[i] = new HFont(FONT_NAMES[i]);
            gFonts[i].setCharSpacing(-1);
        }
    }

    public void loadSounds() {
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5};
        if (Boxal.bInfOneMusic) {
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
        }
        String[] stringArray = new String[byArray.length];
        boolean[] blArray = new boolean[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            GameState.gSounds[i] = byArray[i];
            if (byArray[i] != i) continue;
            stringArray[i] = SOUND_NAMES[i];
            blArray[i] = SOUND_TYPE[i];
        }
        Boxal.initSound(stringArray, blArray);
    }

    static String getText(int n) {
        if (Boxal.bInfCacheStrings) {
            return gCachedText[n];
        }
        GameState.getInstance();
        return GameState.bab(n);
    }

    public void setMusic(int n, boolean bl) {
        if (Boxal.bInfMusicOn) {
            if (this.mMusicToPlay != n) {
                this.stopSound();
                this.mMusicTime = 0;
            }
            this.mMusicToPlay = n;
            this.mLoopMusic = bl;
        }
    }

    public void playMusic(int n, boolean bl) {
        if (this.soundOn && Boxal.bInfMusicOn && !Boxal.isPlaying(gSounds[n])) {
            Boxal.play(gSounds[n], bl ? -1 : 1);
        }
    }

    public void playSfx(int n) {
        if (this.soundOn && Boxal.bInfSFXOn && !Boxal.isPlaying(gSounds[n])) {
            Boxal.play(gSounds[n], 1);
        }
    }

    public void stopSound() {
        this.mMusicTime = 0;
        Boxal.stopAll();
    }

    void saveRms() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(this.stageLevelScores.length);
            for (int n = 0; n < this.stageLevelScores.length; n = (int)((byte)(n + 1))) {
                dataOutputStream.writeByte(this.stageLevelScores[n].length);
                for (int n2 = 0; n2 < this.stageLevelScores[n].length; n2 = (int)((byte)(n2 + 1))) {
                    dataOutputStream.writeShort(this.stageLevelScores[n][n2]);
                    dataOutputStream.writeByte(this.stageLevelStars[n][n2]);
                }
            }
            GameResourceMgr.saveRecord("jojo3rms", byteArrayOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadRms() {
        DataInputStream dataInputStream = GameResourceMgr.openRecord("jojo3rms");
        if (dataInputStream != null) {
            try {
                Tools.println("load rms");
                if (dataInputStream.readByte() != 4) {
                    return;
                }
                if (dataInputStream.readByte() == this.stageLevelScores.length) {
                    for (int n = 0; n < this.stageLevelScores.length && dataInputStream.readByte() == this.stageLevelScores[n].length; n = (int)((byte)(n + 1))) {
                        for (int n2 = 0; n2 < this.stageLevelScores[n].length; n2 = (int)((byte)(n2 + 1))) {
                            this.stageLevelScores[n][n2] = dataInputStream.readShort();
                            this.stageLevelStars[n][n2] = dataInputStream.readByte();
                        }
                    }
                }
                dataInputStream.close();
                dataInputStream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String addKeyText(String string, int n) {
        string = string != null ? string + "/ " : "";
        string = string + GameState.getText(n);
        return string;
    }

    String getSoftkeyText(int n) {
        String string;
        if (babdialect >= 0) {
            switch (n) {
                case 48: {
                    string = GameState.getText(Boxal.bInfPandQ ? 2 : 48);
                    break;
                }
                default: {
                    string = GameState.getText(Boxal.bInfPandQ ? 50 : 49);
                    break;
                }
            }
        } else {
            string = Boxal.bInfPandQ && n == 48 ? babble_szSource[2][this.languages_available[this.tempLang]] : "";
        }
        return string;
    }

    String getKeyText(int n) {
        String string = null;
        if (n == 45) {
            string = this.getSoftkeyText(48);
            if (Boxal.bInfCNK) {
                string = this.addKeyText(string, 46);
            }
            if (Boxal.bInfOkKey) {
                string = this.addKeyText(string, 45);
            }
            if (Boxal.bInfNumKeys) {
                string = this.addKeyText(string, 47);
            }
        } else if (n == 49) {
            string = this.getSoftkeyText(49);
        } else {
            if (Boxal.bInfNavKeys) {
                string = this.addKeyText(string, 37 + n - 37);
            }
            if (Boxal.bInfNumKeys) {
                string = this.addKeyText(string, 41 + n - 37);
            }
        }
        if (string == null) {
            return "NULL!! SET KEYS IN BOXGEN!";
        }
        return string;
    }

    String getHowToPlayText() {
        String[] stringArray = new String[]{"{left}", "{right}", "{up}", "{down}", "{ok}", "{rsk}"};
        int[] nArray = new int[]{37, 38, 39, 40, 45, 49};
        String string = GameState.getText(this.touchScreenOn ? 84 : 36);
        for (int i = 0; i < stringArray.length; ++i) {
            string = GameState.convertString(stringArray[i], this.getKeyText(nArray[i]), string);
        }
        return string;
    }

    static String convertString(String string, String string2, String string3) {
        int n = -1;
        while ((n = string3.indexOf(string)) >= 0) {
            string3 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        }
        return string3;
    }

    private int[] setupLangs() {
        int n;
        String string = this.mCanvas.mMidlet.getAppProperty("C2M-LangList");
        if (string == null) {
            int[] nArray = new int[babble_languages.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        String[] stringArray = this.split(string, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("en-US") < 0) continue;
            Tools.println("found EN-US");
            Tools.println("babble_languages.length:");
            Tools.println(babble_languages.length);
            stringArray[i] = "en-GB";
            this.bLangSwap = true;
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < babble_languages.length; ++i) {
                if (stringArray[n].indexOf(babble_languages[i]) < 0) continue;
                vector.addElement(Integer.toString(i));
            }
        }
        if (vector.size() == 0) {
            int[] nArray = new int[babble_languages.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
            return nArray;
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.parseInt((String)vector.elementAt(n));
        }
        return nArray;
    }

    private String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(string2);
        while (n >= 0) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        vector.addElement(string);
        String[] stringArray = new String[vector.size()];
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    public boolean isDemoVersion() {
        String string = this.appProperty("C2M-Demo");
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.trim().hashCode() != -1657742682;
    }

    public String getBuyLabel() {
        String string;
        String string2 = "C2M-Label-" + babble_languages[babdialect];
        String string3 = this.appProperty(string2);
        if (string3 == null || string3.length() == 0) {
            if (this.mIsDemo) {
                return GameState.bab(498);
            }
            return GameState.bab(499);
        }
        if (string3.indexOf("\\u") >= 0) {
            String string4;
            StringBuffer stringBuffer = new StringBuffer(string3);
            int n = 0;
            char[] cArray = new char[4];
            do {
                if (stringBuffer.charAt(n++) != '\\' || stringBuffer.charAt(n) != 'u') continue;
                stringBuffer.getChars(n + 1, n + 5, cArray, 0);
                stringBuffer.setCharAt(n - 1, (char)Integer.parseInt(new String(cArray), 16));
                stringBuffer.delete(n, n + 5);
            } while (n < stringBuffer.length());
            int n2 = (string4 = stringBuffer.toString()).length();
            return string4.substring(0, n2 < 16 ? n2 : 16);
        }
        int n = (string = string3).length();
        return string.substring(0, n < 16 ? n : 16);
    }

    public String getBuyURL() {
        String string = "C2M-URL-" + babble_languages[babdialect];
        String string2 = this.appProperty(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    private boolean showBuyButton(boolean bl) {
        String string = this.appProperty("C2M-BuySetup");
        String string2 = "C2M-URL-" + babble_languages[babdialect];
        String string3 = this.appProperty(string2);
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        if (bl) {
            return string.indexOf("menu") > -1;
        }
        return string.indexOf("exit") > -1;
    }

    public String appProperty(String string) {
        return this.mCanvas.mMidlet.getAppProperty(string);
    }

    public void loadLanguage(String string, String string2, int n) {
        GameState.bab_init(string, string2, n);
        Boxal.setFrenchSoftkeys(babdialect == 1);
    }

    public static int bab_locale(String string) {
        int n = -1;
        try {
            if (string == null) {
                string = System.getProperty("microedition.locale");
            }
        }
        catch (Exception exception) {
            string = null;
        }
        if (string != null) {
            int n2;
            for (n2 = 0; n2 < babble_languages.length; ++n2) {
                if (babble_languages[n2].toLowerCase().compareTo(string.toLowerCase()) != 0) continue;
                n = n2;
                break;
            }
            if (n == -1) {
                for (n2 = 0; n2 < babble_languages.length; ++n2) {
                    if (babble_languages[n2].toLowerCase().substring(0, 2).compareTo(string.toLowerCase().substring(0, 2)) != 0) continue;
                    n = n2 | 0x8000;
                    break;
                }
            }
        }
        return n;
    }

    public static void bab_init(String string, String string2, int n) {
        try {
            int n2;
            if (n < 0 && (n = GameState.bab_locale(string2)) == -1) {
                n = 0;
            }
            babdialect = (byte)(n & Short.MAX_VALUE);
            String string3 = string + "." + babble_languages[babdialect];
            InputStream inputStream = string3.getClass().getResourceAsStream(string3);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n3 = dataInputStream.readInt();
            babdata = new byte[n3];
            int n4 = 0;
            while ((n4 += (n2 = dataInputStream.read(babdata, n4, n3 - n4))) < n3) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        babdis = new DataInputStream(new ByteArrayInputStream(babdata));
        GameState.gc();
        if (Boxal.bInfCacheStrings) {
            gCachedText = new String[502];
            for (int i = 0; i < gCachedText.length; ++i) {
                GameState.gCachedText[i] = GameState.bab(i);
            }
            try {
                babdis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            babdis = null;
        }
    }

    public static String bab(int n) {
        try {
            int n2 = 0;
            if (n <= 2) {
                return babble_szSource[n - n2][babdialect];
            }
            n2 = 3;
            babdis.reset();
            babdis.skip((n -= n2) << 2);
            babdis.skip(babdis.readInt());
            babdis.skip(2L);
            String string = babdis.readUTF();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        FONT_NAMES = new String[]{"/small", "/big", "/medium"};
        gFonts = new HFont[3];
        babdialect = (byte)-1;
        babble_languages = new String[]{"en-GB", "fr-FR", "de-DE", "es-ES", "pt-PT"};
        babble_szUntranslated = new String[0];
        babble_szSource = new String[][]{{"ENGLISH", "FRAN\u00c7AIS", "DEUTSCH", "ESPA\u00d1OL", "PORTUGU\u00caS"}, {"Select", "S\u00e9lectionner", "Ausw\u00e4hlen", "Seleccionar", "Seleccionar"}, {"Q", "A", "Q", "Q", "Q"}};
    }
}

