/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameResourceMgr
implements Resources {
    public static Image[] mImages = new Image[330];
    public static short[] gBBoxIndex;
    public static byte[] gBBoxData;
    public static final short[] mNeverUnload;

    public static void onDestroy() {
        GameResourceMgr.destroyImages();
        gBBoxIndex = null;
        gBBoxData = null;
    }

    public static boolean isLoaded(short s) {
        return mImages[s] != null;
    }

    public static void loadBBox(String string) {
        DataInputStream dataInputStream = GameResourceMgr.loadBin(string);
        try {
            int n = dataInputStream.readShort();
            gBBoxIndex = new short[n];
            gBBoxData = new byte[n * 8];
            for (int i = 0; i < n; ++i) {
                GameResourceMgr.gBBoxIndex[i] = dataInputStream.readShort();
                dataInputStream.read(gBBoxData, i * 8, 8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadImages(short[] sArray) {
        Tools.println("load [");
        for (int i = 0; i < sArray.length; ++i) {
            GameResourceMgr.loadImage(sArray[i]);
        }
        Tools.println("] load");
    }

    public static boolean isUnloadable(short s) {
        for (int i = 0; i < mNeverUnload.length; ++i) {
            if (s != mNeverUnload[i]) continue;
            return false;
        }
        return true;
    }

    public static void destroyImages(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!GameResourceMgr.isUnloadable(sArray[i])) continue;
            GameResourceMgr.mImages[sArray[i]] = null;
            GameSprite.gRefId[sArray[i]] = 0;
        }
        GameState.gc();
    }

    public static void destroyImage(short s) {
        if (!GameResourceMgr.isUnloadable(s)) {
            return;
        }
        GameResourceMgr.mImages[s] = null;
        GameSprite.gRefId[s] = 0;
        GameState.gc();
    }

    public static Image loadImage(short s) {
        if (mImages[s] == null) {
            try {
                Tools.println("Loading image: " + s);
                GameResourceMgr.mImages[s] = Image.createImage((InputStream)GameResourceMgr.loadBin("/" + s));
            }
            catch (Exception exception) {
                Tools.println("No image : " + s);
                exception.printStackTrace();
            }
        }
        return mImages[s];
    }

    public static DataInputStream loadImageDataStream(short s) {
        if (gBBoxIndex != null) {
            for (int i = 0; i < gBBoxIndex.length; ++i) {
                if (gBBoxIndex[i] != s) continue;
                return new DataInputStream(new ByteArrayInputStream(gBBoxData, i * 8, 8));
            }
        }
        return null;
    }

    public static void destroyImages() {
        for (short s = 0; s < mImages.length; s = (short)(s + 1)) {
            if (!GameResourceMgr.isUnloadable(s)) continue;
            GameResourceMgr.mImages[s] = null;
            GameSprite.gRefId[s] = 0;
        }
        GameState.gc();
    }

    public static InputStream getResource(String string) {
        try {
            if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            return Boxal.getInputStream(string);
        }
        catch (Exception exception) {
            Tools.println("no resource" + string);
            return null;
        }
    }

    public static DataInputStream loadBin(String string) {
        InputStream inputStream = GameResourceMgr.getResource(string);
        if (inputStream != null) {
            return new DataInputStream(inputStream);
        }
        return null;
    }

    public static DataInputStream openRecord(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            byte[] byArray = null;
            try {
                byArray = recordStore.getRecord(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordStore.closeRecordStore();
            if (null != byArray) {
                return new DataInputStream(new ByteArrayInputStream(byArray));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void saveRecord(String string, ByteArrayOutputStream byteArrayOutputStream) {
        System.out.println("write record ");
        try {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            int n = recordStore.getNumRecords();
            if (n == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            byteArrayOutputStream.close();
            Tools.println("record saved");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getWidth(short s) {
        DataInputStream dataInputStream = GameResourceMgr.loadImageDataStream(s);
        if (dataInputStream != null) {
            try {
                dataInputStream.readShort();
                dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                dataInputStream.close();
                dataInputStream = null;
                return s2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GameResourceMgr.loadImage(s).getWidth();
    }

    public static int getHeight(short s) {
        DataInputStream dataInputStream = GameResourceMgr.loadImageDataStream(s);
        if (dataInputStream != null) {
            try {
                dataInputStream.readShort();
                dataInputStream.readShort();
                dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                dataInputStream.close();
                dataInputStream = null;
                return s2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GameResourceMgr.loadImage(s).getHeight();
    }

    static {
        mNeverUnload = new short[]{56, 246, 245, 55};
    }
}

