/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Boxal {
    static final int INF_CALL_SERIALLY = 1;
    static final int INF_FIXED_SLEEP = 2;
    static final int INF_NO_SYSTEM_GC = 3;
    static final int INF_USE_WATCHDOG = 11;
    static final int INF_IGNORE_HIDE_NOTIFY = 12;
    static final int INF_INTERRUPT_VIA_START_APP = 13;
    static final int INF_FORCE_SIZE = 21;
    static final int INF_FORCE_NO_FLIPPING_CODE = 22;
    static final int INF_FORCE_USE_ALTERNATE_SIZE_DETECT = 23;
    static final int INF_FORCE_KEYS = 41;
    static final int INF_NO_TOUCH = 42;
    static final int INF_NO_QWERTY = 43;
    static final int INF_MMAPI = 60;
    static final int INF_MUSIC_ON = 61;
    static final int INF_SFX_ON = 63;
    static final int INF_ALERTS = 65;
    static final int INF_BEEPS_ON = 68;
    static final int INF_SOUND_THREAD = 73;
    static final int INF_SET_VOLUME = 74;
    static final int INF_SOUND_LISTENER = 76;
    static final int INF_SOUND_PREFETCH = 77;
    static final int INF_SOUND_REALIZE = 78;
    static final int INF_SOUND_DEALLOCATE = 79;
    static final int INF_SOUND_RELOAD = 80;
    static final int INF_SOUND_RELOAD_ALL = 81;
    static final int INF_SOUND_STOP_BEFORE = 82;
    static final int INF_SOUND_LOOP_FIX = 83;
    static final int INF_DOUBLE_TAP = 101;
    static final int INF_VIBRATION = 102;
    static final int INF_ALT_BUYMORE_LOGIC = 103;
    static final int INF_ALT_BUYMORE_AT_END_OF_RUN = 1;
    static final int INF_ALT_BUYMORE_IN_DESTROY_APP = 2;
    static final int INF_USE_MIDP_IMAGE = 111;
    static final int INF_MIDP_IMAGE_FRAME_BUFFER = 112;
    static final int INF_NO_RT_DEPACK = 113;
    static final int INF_NO_MIDP_IMAGES = 114;
    static final int INF_FILE_CACHE_ALWAYS_ON = 115;
    static final int INF_ORIENTATION = 131;
    static final int INF_ORIENTATION_PORTRAIT = 1;
    static final int INF_ORIENTATION_LANDSCAPE = 2;
    static final int INF_ORIENTATION_ANY = 3;
    static final int INF_PROJECT_DEFINES = 200;
    static final int INF_HAS_NAV_KEYS = 201;
    static final int INF_HAS_NUM_KEYS = 202;
    static final int INF_HAS_CNK = 203;
    static final int INF_HAS_OK_KEY = 227;
    static final int INF_IGNORE_KEYCODES = 228;
    static final int INF_DOUBLE_BUFFER = 208;
    static final int INF_P_AND_Q = 245;
    static final int INF_ONE_MUSIC = 253;
    static final int INF_FILL_FULLSCREEN = 225;
    static final int INF_CACHE_STRINGS = 262;
    static final int INF_RESCOMBINE_BUFFER = 266;
    static final int INF_SIMPLE_FRAMES = 240;
    static final int VALUE_NOT_SET = -999;
    static int lastInfKey = -1;
    static String value;
    static final char SEP = ',';
    public static Boxal _self;
    static Hashtable infs;
    public static boolean bInfCallSerially;
    public static boolean bInfFixedSleep;
    public static int iInfFixedSleepLength;
    public static boolean bInfNoSystemGC;
    public static boolean bInfUseWatchdog;
    public static int iInfWatchdogTimeout;
    public static boolean bInfIgnoreHideNotify;
    public static boolean bInfInterruptViaStartApp;
    public static boolean bInfForceSize;
    public static int iInfForcedWidth;
    public static int iInfForcedHeight;
    public static boolean bInfUseAlternateSizeDetect;
    public static int iInfSizeDetectMethod;
    public static boolean bInfForceKeys;
    public static boolean bInfNoTouch;
    public static boolean bInfMMAPI;
    public static boolean bInfMusicOn;
    public static int iInfMusicType;
    public static boolean bInfSFXOn;
    public static int iInfSFXType;
    public static boolean bInfAlertsOn;
    public static int iInfAlertOne;
    public static int iInfAlertTwo;
    public static boolean bInfBeepsOn;
    public static int iInfMinPitch;
    public static int iInfMaxPitch;
    public static int iInfMinDuration;
    public static int iInfBeepVolume;
    public static boolean bInfSoundThread;
    public static boolean bInfSetVolume;
    public static int iInfMaxVolume;
    public static boolean bInfSoundListener;
    public static boolean bInfSoundPrefetch;
    public static boolean bInfSoundRealize;
    public static boolean bInfSoundDeallocate;
    public static boolean bInfSoundReload;
    public static boolean bInfSoundReloadAll;
    public static boolean bInfSoundStopBefore;
    public static boolean bInfSoundLoopfix;
    public static boolean bInfVibrationOff;
    public static String sInfProjectDefines;
    public static boolean bInfRotationEnabled;
    public static boolean bInfPortrait;
    public static boolean bInfLandscape;
    public static boolean bInfAnyOrientation;
    public static boolean bInfNavKeys;
    public static boolean bInfNumKeys;
    public static boolean bInfOkKey;
    public static boolean bInfCNK;
    public static boolean bInfPandQ;
    public static int[][] keyCodes;
    public static int[] ignoreKeyCodes;
    public static final int KEY_LSK = 0;
    public static final int KEY_RSK = 1;
    public static final int KEY_FIRE = 2;
    public static final int KEY_UP = 3;
    public static final int KEY_DOWN = 4;
    public static final int KEY_LEFT = 5;
    public static final int KEY_RIGHT = 6;
    public static final int KEY_1 = 7;
    public static final int KEY_2 = 8;
    public static final int KEY_3 = 9;
    public static final int KEY_4 = 10;
    public static final int KEY_5 = 11;
    public static final int KEY_6 = 12;
    public static final int KEY_7 = 13;
    public static final int KEY_8 = 14;
    public static final int KEY_9 = 15;
    public static final int KEY_0 = 16;
    public static final int KEY_STAR = 17;
    public static final int KEY_POUND = 18;
    public static boolean bInfDoubleBuffer;
    public static boolean bInfFillFullscreen;
    public static boolean bInfOneMusic;
    public static boolean bInfCacheStrings;
    public static boolean bInfResCombineBuffer;
    public static boolean bInfSimpleFrames;
    public static final int KEY_SOFTLEFT = 1000;
    public static final int KEY_SOFTRIGHT = 1001;
    public static int[] returnKeyCodes;
    private static Player[] playerArray;
    private static String[] fileNames;
    private static String[] mime;
    private static boolean[] sfx;
    private static int lastIndex;
    private static int volume;
    private static int lastPlayed;
    private static final String[] ext;
    public static long watchDogLastTick;
    public static long watchDogTime;
    public static boolean ignoreWatchDogFrame;
    private static boolean reorientate;
    public static byte[] fileIdx;
    public static int[] startPos;
    public static int[] endPos;
    public static Hashtable fileMap;

    public static Boxal getInstance() {
        if (_self == null) {
            _self = new Boxal();
        }
        return _self;
    }

    static boolean getParamBool(int n, int n2) {
        if (infs == null) {
            return false;
        }
        String string = Boxal.getParamString(n, n2);
        if (string != null) {
            return !string.equals("");
        }
        return false;
    }

    static int getParamInt(int n, int n2) {
        if (infs == null) {
            return -999;
        }
        String string = Boxal.getParamString(n, n2);
        if (string != null) {
            if (string.equals("")) {
                return -999;
            }
            return Integer.valueOf(string);
        }
        return -999;
    }

    static String getParamString(int n, int n2) {
        if (infs == null) {
            return null;
        }
        if (lastInfKey != n) {
            value = (String)infs.get(new Integer(n));
            if (value == null) {
                lastInfKey = -1;
                return null;
            }
            lastInfKey = n;
        }
        return Boxal.getParamString(value, n2, ',');
    }

    static String getParamString(String string, int n, char c) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            if ((n3 = string.indexOf(c, n3 + 1)) != -1) continue;
            return null;
        }
        n2 = string.indexOf(c, n3 + 1);
        if (n2 == -1) {
            return string.substring(n3 + 1).trim();
        }
        return string.substring(n3 + 1, n2).trim();
    }

    static int getParamCount(int n) {
        int n2 = 0;
        String string = null;
        while ((string = Boxal.getParamString(n, n2++)) != null) {
        }
        return --n2;
    }

    public static void processInfVariables() {
        int n;
        System.out.println("processInfVariables");
        bInfCallSerially = Boxal.getParamBool(1, 0);
        bInfFixedSleep = Boxal.getParamBool(2, 0);
        iInfFixedSleepLength = Boxal.getParamInt(2, 1);
        bInfNoSystemGC = Boxal.getParamBool(3, 0);
        bInfUseWatchdog = Boxal.getParamBool(11, 0);
        iInfWatchdogTimeout = Boxal.getParamInt(11, 1);
        bInfIgnoreHideNotify = Boxal.getParamBool(12, 0);
        bInfInterruptViaStartApp = Boxal.getParamBool(13, 0);
        bInfForceSize = Boxal.getParamBool(21, 0);
        iInfForcedWidth = Boxal.getParamInt(21, 1);
        iInfForcedHeight = Boxal.getParamInt(21, 2);
        bInfUseAlternateSizeDetect = Boxal.getParamBool(23, 0);
        iInfSizeDetectMethod = Boxal.getParamInt(23, 1);
        bInfPandQ = Boxal.getParamBool(245, 0);
        bInfForceKeys = Boxal.getParamBool(41, 0);
        if (bInfForceKeys) {
            for (n = 0; n < keyCodes.length; ++n) {
                String string = Boxal.getParamString(41, n + 1);
                if (string == null) continue;
                int n2 = 0;
                while (Boxal.getParamString(string, n2, ':') != null) {
                    ++n2;
                }
                if (n2 <= 0) continue;
                Boxal.keyCodes[n] = new int[n2];
                for (n2 = 0; n2 < keyCodes[n].length; ++n2) {
                    String string2 = Boxal.getParamString(string, n2, ':');
                    try {
                        Boxal.keyCodes[n][n2] = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Boxal.keyCodes[n][n2] = -999;
                    }
                }
            }
        }
        if (Boxal.getParamBool(228, 0)) {
            n = Boxal.getParamCount(228);
            ignoreKeyCodes = new int[n];
            for (int i = 0; i < n; ++i) {
                Boxal.ignoreKeyCodes[i] = Boxal.getParamInt(228, 1 + i);
            }
        }
        bInfNoTouch = Boxal.getParamBool(42, 0);
        bInfMMAPI = Boxal.getParamBool(60, 0);
        bInfMusicOn = Boxal.getParamBool(61, 0);
        iInfMusicType = Boxal.getParamInt(61, 1);
        bInfSFXOn = Boxal.getParamBool(63, 0);
        iInfSFXType = Boxal.getParamInt(63, 1);
        bInfBeepsOn = Boxal.getParamBool(68, 0);
        iInfMinPitch = Boxal.getParamInt(68, 1);
        iInfMaxPitch = Boxal.getParamInt(68, 2);
        iInfMinDuration = Boxal.getParamInt(68, 3);
        iInfBeepVolume = Boxal.getParamInt(68, 4);
        bInfSoundThread = Boxal.getParamBool(73, 0);
        bInfSetVolume = Boxal.getParamBool(74, 0);
        iInfMaxVolume = Boxal.getParamInt(74, 1);
        bInfSoundListener = Boxal.getParamBool(76, 0);
        bInfSoundPrefetch = Boxal.getParamBool(77, 0);
        bInfSoundRealize = Boxal.getParamBool(78, 0);
        bInfSoundDeallocate = Boxal.getParamBool(79, 0);
        bInfSoundReload = Boxal.getParamBool(80, 0);
        bInfSoundReloadAll = Boxal.getParamBool(81, 0);
        bInfSoundStopBefore = Boxal.getParamBool(82, 0);
        bInfSoundLoopfix = Boxal.getParamBool(83, 0);
        bInfVibrationOff = Boxal.getParamBool(102, 0);
        bInfNavKeys = Boxal.getParamBool(201, 0);
        bInfNumKeys = Boxal.getParamBool(202, 0);
        bInfCNK = Boxal.getParamBool(203, 0);
        bInfOkKey = Boxal.getParamBool(227, 0);
        bInfRotationEnabled = Boxal.getParamBool(131, 0);
        bInfPortrait = Boxal.getParamInt(131, 1) == 1;
        bInfLandscape = Boxal.getParamInt(131, 1) == 2;
        bInfAnyOrientation = Boxal.getParamInt(131, 1) == 3;
        bInfDoubleBuffer = Boxal.getParamBool(208, 0);
        bInfFillFullscreen = Boxal.getParamBool(225, 0);
        bInfOneMusic = Boxal.getParamBool(253, 0);
        bInfCacheStrings = Boxal.getParamBool(262, 0);
        bInfResCombineBuffer = Boxal.getParamBool(266, 0);
        bInfSimpleFrames = Boxal.getParamBool(240, 0);
    }

    public static boolean readBoxalInf() {
        String string = "/boxal.inf";
        Boxal.initResCombine();
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.out.println("no stream");
                return false;
            }
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                infs = new Hashtable();
                while ((n = inputStream.read()) != -1) {
                    char c = (char)n;
                    if (c == '\n') {
                        String string2 = stringBuffer.toString();
                        int n2 = string2.indexOf(44);
                        if (n2 == -1) {
                            n2 = string2.length() - 1;
                        }
                        infs.put(new Integer(Integer.parseInt(string2.substring(0, n2))), string2);
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                    stringBuffer.append(c);
                }
                inputStream.close();
                Boxal.processInfVariables();
                infs = null;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        return true;
    }

    public static void initSound(String[] stringArray, boolean[] blArray) {
        volume = iInfMaxVolume;
        try {
            int n;
            int n2;
            fileNames = stringArray;
            sfx = blArray;
            for (n2 = 0; n2 < fileNames.length; ++n2) {
                if (fileNames[n2] != null && fileNames[n2].length() < 1) {
                    Boxal.fileNames[n2] = null;
                }
                if (fileNames[n2] != null && fileNames[n2].charAt(0) != '/') {
                    Boxal.fileNames[n2] = "/" + fileNames[n2];
                }
                if (sfx == null) continue;
                if (!sfx[n2] && !bInfMusicOn) {
                    Boxal.fileNames[n2] = null;
                }
                if (!sfx[n2] || bInfSFXOn) continue;
                Boxal.fileNames[n2] = null;
            }
            if (bInfBeepsOn) {
                return;
            }
            mime = new String[fileNames.length];
            n2 = iInfSFXType - 1;
            for (n = 0; n < mime.length; ++n) {
                if (fileNames[n] == null) continue;
                String string = fileNames[n].toLowerCase();
                for (int i = 0; i < ext.length / 2; ++i) {
                    int n3 = string.indexOf(ext[i * 2]);
                    if (n3 <= -1) continue;
                    if (sfx != null && sfx[n] && n2 < 3 && bInfSFXOn) {
                        Boxal.fileNames[n] = fileNames[n].substring(0, n3) + ext[n2 * 2];
                        Boxal.mime[n] = ext[n2 * 2 + 1];
                        continue;
                    }
                    Boxal.mime[n] = ext[i * 2 + 1];
                }
            }
            if (bInfSoundReload) {
                playerArray = new Player[1];
            } else {
                playerArray = new Player[fileNames.length];
                for (n = 0; n < playerArray.length; ++n) {
                    Boxal.load(n);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("sound error" + exception.toString());
        }
    }

    private static void load(int n) {
        int n2 = n;
        if (bInfBeepsOn) {
            return;
        }
        if (bInfSoundReload) {
            n2 = 0;
        }
        if (fileNames[n] == null) {
            return;
        }
        try {
            InputStream inputStream = Boxal.getInputStream(fileNames[n]);
            Boxal.playerArray[n2] = Manager.createPlayer((InputStream)inputStream, (String)mime[n]);
        }
        catch (Throwable throwable) {
            System.out.println("unable to load " + fileNames[n] + "mime " + mime[n]);
        }
    }

    private static void GenericAudioDoTone(int n, int n2, int n3) {
        if (n > iInfMaxPitch) {
            n = iInfMaxPitch;
        }
        if (n < iInfMinPitch) {
            n = iInfMinPitch;
        }
        if (n2 < iInfMinDuration) {
            n2 = iInfMinDuration;
        }
        if (n3 > iInfBeepVolume) {
            n3 = iInfBeepVolume;
        }
        try {
            Manager.playTone((int)n, (int)n2, (int)n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int n, int n2) {
        try {
            if (n < 0) {
                return;
            }
            if (bInfBeepsOn) {
                if (n % 2 == 1) {
                    Boxal.GenericAudioDoTone(40, 200, 80);
                } else {
                    Boxal.GenericAudioDoTone(50, 120, 70);
                }
                return;
            }
            if (playerArray == null) {
                return;
            }
            if (sfx != null) {
                if (!sfx[n] && !bInfMusicOn) {
                    return;
                }
                if (sfx[n] && !bInfSFXOn) {
                    return;
                }
            }
            if (bInfSoundStopBefore) {
                Boxal.stop(n);
            }
            int n3 = n;
            if (bInfSoundReload) {
                if (lastIndex != n || bInfSoundReloadAll) {
                    Boxal.load(n);
                }
                n3 = 0;
                lastIndex = n;
            }
            if (playerArray[n3] == null) {
                return;
            }
            if (bInfSoundRealize) {
                playerArray[n3].realize();
            }
            if (bInfSoundPrefetch) {
                playerArray[n3].prefetch();
            }
            if (bInfSetVolume) {
                try {
                    VolumeControl volumeControl = (VolumeControl)playerArray[n3].getControl("javax.microedition.media.control.VolumeControl");
                    if (volumeControl != null) {
                        volumeControl.setLevel(volume);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            playerArray[n3].setLoopCount(n2);
            playerArray[n3].start();
            lastPlayed = n3;
        }
        catch (Throwable throwable) {
            System.out.println("play error: " + throwable.toString());
        }
    }

    public static void stop(int n) {
        lastPlayed = -1;
        if (bInfBeepsOn) {
            return;
        }
        if (playerArray == null) {
            return;
        }
        int n2 = n;
        if (bInfSoundReload) {
            n2 = 0;
            lastIndex = -1;
        }
        if (playerArray[n2] == null) {
            return;
        }
        if (bInfSetVolume) {
            try {
                VolumeControl volumeControl = (VolumeControl)playerArray[n2].getControl("javax.microedition.media.control.VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            playerArray[n2].stop();
            if (bInfSoundDeallocate) {
                playerArray[n2].deallocate();
            }
            if (bInfSoundReload && bInfSoundReloadAll) {
                playerArray[n2].close();
                Boxal.playerArray[n2] = null;
                lastIndex = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopAll() {
        if (playerArray == null) {
            return;
        }
        for (int i = 0; i < playerArray.length; ++i) {
            Boxal.stop(i);
        }
    }

    public static int getPlaying() {
        if (bInfBeepsOn) {
            return -1;
        }
        if (playerArray == null) {
            return -1;
        }
        for (int i = playerArray.length - 1; i >= 0; --i) {
            Player player = playerArray[i];
            if (null == player || player.getState() != 400) continue;
            if (bInfSoundReload) {
                return lastIndex;
            }
            return i;
        }
        return -1;
    }

    public static void addVolume(boolean bl) {
        volume = bl ? (volume += 10) : (volume -= 10);
        if (volume > iInfMaxVolume) {
            volume = iInfMaxVolume;
        }
        if (volume < 0) {
            volume = 0;
        }
        if (lastPlayed != -1) {
            try {
                VolumeControl volumeControl;
                int n = lastPlayed;
                if (bInfSoundReload) {
                    n = 0;
                }
                if ((volumeControl = (VolumeControl)playerArray[n].getControl("javax.microedition.media.control.VolumeControl")) != null) {
                    volumeControl.setLevel(volume);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isPlaying(int n) {
        Player player;
        if (bInfBeepsOn) {
            return false;
        }
        if (playerArray == null) {
            return false;
        }
        if (bInfSoundReload) {
            if (lastIndex != n) {
                return false;
            }
            n = 0;
        }
        if (null == (player = playerArray[n])) {
            return false;
        }
        return player.getState() == 400;
    }

    public static boolean isAnyPlaying() {
        if (bInfBeepsOn) {
            return false;
        }
        if (playerArray == null) {
            return false;
        }
        for (int i = 0; i < playerArray.length; ++i) {
            Player player = playerArray[i];
            if (null == player || player.getState() != 400) continue;
            return true;
        }
        return false;
    }

    public static boolean watchDogTick() {
        if (bInfUseWatchdog) {
            if (watchDogLastTick != 0L && (watchDogTime = System.currentTimeMillis() - watchDogLastTick) > (long)iInfWatchdogTimeout && !ignoreWatchDogFrame) {
                watchDogLastTick = System.currentTimeMillis();
                return true;
            }
            watchDogLastTick = System.currentTimeMillis();
            ignoreWatchDogFrame = false;
        }
        return false;
    }

    public static void ignoreWatchDog() {
        ignoreWatchDogFrame = true;
    }

    public static void makeReturnKeycodes(Canvas canvas) {
        int[] nArray = new int[19];
        nArray[0] = 1000;
        nArray[1] = 1001;
        nArray[2] = canvas.getKeyCode(8);
        nArray[3] = canvas.getKeyCode(1);
        nArray[4] = canvas.getKeyCode(6);
        nArray[5] = canvas.getKeyCode(2);
        nArray[6] = canvas.getKeyCode(5);
        nArray[7] = 49;
        nArray[8] = 50;
        nArray[9] = 51;
        nArray[10] = 52;
        nArray[11] = 53;
        nArray[12] = 54;
        nArray[13] = 55;
        nArray[14] = 56;
        nArray[15] = 57;
        nArray[16] = 42;
        nArray[17] = 48;
        nArray[18] = 35;
        returnKeyCodes = nArray;
    }

    public static int translateKeyCode(Canvas canvas, int n) {
        int n2;
        if (ignoreKeyCodes != null) {
            for (n2 = 0; n2 < ignoreKeyCodes.length; ++n2) {
                if (n != ignoreKeyCodes[n2]) continue;
                return -999;
            }
        }
        if (bInfForceKeys) {
            if (returnKeyCodes == null) {
                Boxal.makeReturnKeycodes(canvas);
            }
            for (n2 = 0; n2 < returnKeyCodes.length; ++n2) {
                for (int i = 0; i < keyCodes[n2].length; ++i) {
                    if (keyCodes[n2][i] != n && (Math.abs(keyCodes[n2][i]) != 21 && Math.abs(keyCodes[n2][i]) != 22 || keyCodes[n2][i] != -n)) continue;
                    return returnKeyCodes[n2];
                }
            }
        } else {
            if (n == -6) {
                return 1000;
            }
            if (n == -7) {
                return 1001;
            }
        }
        return n;
    }

    public static boolean checkRotation(Canvas canvas, Graphics graphics) {
        if (bInfRotationEnabled) {
            boolean bl;
            boolean bl2 = bl = canvas.getWidth() < canvas.getHeight();
            if (!bl && bInfPortrait || bl && bInfLandscape) {
                reorientate = true;
            } else if (bl && bInfPortrait || !bl && bInfLandscape) {
                reorientate = false;
            }
            String[] stringArray = new String[]{"PLEASE REORIENTATE HANDSET SCREEN", "R\u00c9ORIENTEZ L'\u00c9CRAN S'IL VOUS PLA\u00ceT", "BITTE RICHTE DISPLAY NEU AUS", "RIPOSIZIONA SCHERMO", "REORIENTA LA PANTALLA DEL M\u00d3VIL", "POR FAVOR REORIENTAR O ECR\u0102"};
            if (reorientate) {
                Font font = graphics.getFont();
                graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                graphics.setColor(0);
                graphics.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
                graphics.setColor(-1);
                int n = canvas.getHeight() - stringArray.length * 20 >> 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    graphics.drawString(stringArray[i], 7, n, 20);
                    n += 20;
                }
                graphics.setFont(font);
            }
            return reorientate;
        }
        return false;
    }

    public static int getKeyCode(Canvas canvas, int n) {
        if (returnKeyCodes == null) {
            Boxal.makeReturnKeycodes(canvas);
        }
        if (bInfForceKeys) {
            return keyCodes[n][0];
        }
        return returnKeyCodes[n];
    }

    public static void initResCombine() {
        try {
            InputStream inputStream = "".getClass().getResourceAsStream("/index.idx");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            fileIdx = new byte[n];
            fileMap = new Hashtable();
            startPos = new int[n];
            endPos = new int[n];
            for (int i = 0; i < n; ++i) {
                Boxal.fileIdx[i] = dataInputStream.readByte();
                fileMap.put("/" + dataInputStream.readUTF().toUpperCase(), new Integer(i));
                Boxal.startPos[i] = dataInputStream.readInt();
                Boxal.endPos[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            System.out.println("ResCombine init error : " + exception.toString());
        }
    }

    public static byte[] getByteArray(String string) {
        try {
            Tools.println("loading file: " + string);
            int n = (Integer)fileMap.get(string.toUpperCase());
            InputStream inputStream = string.getClass().getResourceAsStream("/" + fileIdx[n]);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (startPos[n] > 0) {
                dataInputStream.skipBytes(startPos[n]);
            }
            byte[] byArray = new byte[endPos[n] - startPos[n]];
            dataInputStream.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("no file");
            return null;
        }
    }

    public static InputStream getInputStream(String string) {
        try {
            Tools.println("loading file: " + string);
            int n = (Integer)fileMap.get(string.toUpperCase());
            InputStream inputStream = string.getClass().getResourceAsStream("/" + fileIdx[n]);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (startPos[n] > 0) {
                dataInputStream.skipBytes(startPos[n]);
            }
            if (bInfResCombineBuffer) {
                byte[] byArray = new byte[endPos[n] - startPos[n]];
                dataInputStream.read(byArray);
                return new ByteArrayInputStream(byArray);
            }
            return dataInputStream;
        }
        catch (Exception exception) {
            System.out.println("no file");
            return null;
        }
    }

    public static void setFrenchSoftkeys(boolean bl) {
        if (bInfPandQ && keyCodes != null) {
            for (int i = 0; i < keyCodes.length; ++i) {
                if (keyCodes[i] == null) continue;
                for (int j = 0; j < keyCodes[i].length; ++j) {
                    if (bl) {
                        if (keyCodes[i][j] == 81) {
                            Boxal.keyCodes[i][j] = 65;
                        }
                        if (keyCodes[i][j] != 113) continue;
                        Boxal.keyCodes[i][j] = 97;
                        continue;
                    }
                    if (keyCodes[i][j] == 65) {
                        Boxal.keyCodes[i][j] = 81;
                    }
                    if (keyCodes[i][j] != 97) continue;
                    Boxal.keyCodes[i][j] = 113;
                }
            }
        }
    }

    static {
        keyCodes = new int[19][];
        ignoreKeyCodes = null;
        returnKeyCodes = null;
        lastIndex = -1;
        volume = 100;
        lastPlayed = -1;
        ext = new String[]{"mid", "audio/midi", "wav", "audio/x-wav", "amr", "audio/amr", "mp3", "audio/mpeg"};
        watchDogLastTick = 0L;
        watchDogTime = 0L;
        ignoreWatchDogFrame = false;
        reorientate = false;
    }
}

