/*
 * Util.java
 *
 * Created on November 20, 2007, 2:31 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package net.oauth.jme;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import com.shephertz.app42.paas.sdk.jme.App42Log;

/**
 *
 * @author Administrator
 */
public class Util {
    
    /** Creates a new instance of Util */
    public Util() {
    }
    
    // if the same key occurs in h1 and h2, use the value from h1
    public static final Hashtable hashtableMerge(Hashtable h1, Hashtable h2) {
        App42Log.debug("in hastableMerge");
        Hashtable h=new Hashtable();
        Enumeration keys=h1.keys();
        while (keys.hasMoreElements()) {
            Object k=keys.nextElement();
            if (h1.get(k)!=null) {
                h.put(k, h1.get(k));
            }
        }
        keys=h2.keys();
        while (keys.hasMoreElements()) {
            Object k=keys.nextElement();
            if (!h.containsKey(k) && h2.get(k)!=null) {
                h.put(k, h2.get(k));
            }
        }
        return h;
    }
    
    // sorts String values
    public static final Enumeration sort(Enumeration e){
        Vector v=new Vector();
        while (e.hasMoreElements()) {
            String s=(String)e.nextElement();
            int i=0;
            for (i=0; i<v.size(); i++) {
                int c=s.compareTo((String)v.elementAt(i));
                if (c<0) { // s should go before i
                    v.insertElementAt(s, i);
                    break;
                } else if (c==0) { // s already there
                    break;
                }
            }
            if (i>=v.size()) { // add s at end
                v.addElement(s);
            }
        }
        return v.elements();
    }
    
    
    
    /** Split string into multiple strings
     * @param original      Original string
     * @param separator     Separator string in original string
     * @return              Splitted string array
     */
    // TODO -- add in a max split param
    public static final String[] split(String original, String separator) {
        Vector nodes = new Vector();
        
        // Parse nodes into vector
        int index = original.indexOf(separator);
        while(index>=0) {
            nodes.addElement( original.substring(0, index) );
            original = original.substring(index+separator.length());
            index = original.indexOf(separator);
        }
        // Get the last node
        nodes.addElement( original );
        
        // Create splitted string array
        String[] result = new String[ nodes.size() ];
        if( nodes.size()>0 ) {
            for(int loop=0; loop<nodes.size(); loop++)
                result[loop] = (String)nodes.elementAt(loop);
        }
        return result;
    }
    
    // this is an OAuth-friendly url encode -- should work fine for ordniary encoding also
    public static final String urlEncode(String s) {
        if (s == null)
            return s;
        StringBuffer sb = new StringBuffer(s.length() * 3);
        try {
            char c;
            for (int i = 0; i < s.length(); i++) {
                c = s.charAt(i);
                if (c == '&') {
                    //sb.append("&amp;"); // don't do this
                    sb.append("%26");
                    //} else if (c == ' ') {
                    //    sb.append('+'); // maybe don't do this either
                } else if (
                        // safe characters
                        c == '-'
                        || c == '_'
                        || c == '.'
                        || c == '~'
						/*
                        || c == '!'
                        || c == '*'
                        || c == '\''
                        || c == '('
                        || c == ')'
						*/
                        || (c >= 'A' && c <= 'Z')
                        || (c >= 'a' && c <= 'z') ) {
                    sb.append(c);
                } else {
                    sb.append('%');
                    if (c > 15) { // is it a non-control char, ie. >x0F so 2 chars
                        sb.append(Integer.toHexString((int)c).toUpperCase()); // just add % and the string
                    } else {
                        sb.append("0" + Integer.toHexString((int)c).toUpperCase());
                        // otherwise need to add a leading 0
                    }
                }
            }
            
        } catch (Exception ex) {
            return (null);
        }
        return (sb.toString());
    }
    
 
    private static char[]  map1  = new char[64];
    static {
        int  i  = 0;
        for ( char c = 'A'; c <= 'Z'; c++ ) {
            map1[i++] = c;
        }
        for ( char c = 'a'; c <= 'z'; c++ ) {
            map1[i++] = c;
        }
        for ( char c = '0'; c <= '9'; c++ ) {
            map1[i++] = c;
        }
        map1[i++] = '+';
        map1[i++] = '/';
    }
    
    public static final String base64Encode( byte[] in ) {
        int     iLen      = in.length;
        int     oDataLen  = ( iLen * 4 + 2 ) / 3;// output length without padding
        int     oLen      = ( ( iLen + 2 ) / 3 ) * 4;// output length including padding
        char[]  out       = new char[oLen];
        int     ip        = 0;
        int     op        = 0;
        int     i0;
        int     i1;
        int     i2;
        int     o0;
        int     o1;
        int     o2;
        int     o3;
        while ( ip < iLen ) {
            i0 = in[ip++] & 0xff;
            i1 = ip < iLen ? in[ip++] & 0xff : 0;
            i2 = ip < iLen ? in[ip++] & 0xff : 0;
            o0 = i0 >>> 2;
            o1 = ( ( i0 & 3 ) << 4 ) | ( i1 >>> 4 );
            o2 = ( ( i1 & 0xf ) << 2 ) | ( i2 >>> 6 );
            o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : '=';
            op++;
            out[op] = op < oDataLen ? map1[o3] : '=';
            op++;
        }
        return new String( out );
    }
    
    
    public static String replace(String _text, String _searchStr, String _replacementStr) {
		// String buffer to store str
		StringBuffer sb = new StringBuffer();

		// Search for search
		int searchStringPos = _text.indexOf(_searchStr);
		int startPos = 0;
		int searchStringLength = _searchStr.length();

		// Iterate to add string
		while (searchStringPos != -1) {
		sb.append(_text.substring(startPos, searchStringPos)).append(_replacementStr);
		startPos = searchStringPos + searchStringLength;
		searchStringPos = _text.indexOf(_searchStr, startPos);
		}

		// Create string
		sb.append(_text.substring(startPos,_text.length()));

		return sb.toString();
		}
	
    
}
