/*
 * Decompiled with CFR 0.152.
 */
package iec.animalsescape;

import iec.animalsescape.AnimalsEscape;
import iec.animalsescape.Func;
import iec.animalsescape.GameMID;
import iec.animalsescape.IECRecordStore;
import iec.animalsescape.MainCanvas;
import iec.animalsescape.Set;
import iec.animalsescape.SetValues;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StageMode {
    final byte animalsNum = (byte)8;
    final int[] animalsCollectNum = new int[]{300, 500, 650, 700, 800, 1000, 1200, 1500};
    Image animalsImg;
    Image animals_selectImg;
    Image scoreImg;
    int scoreW;
    int scoreH;
    Image stageNoImg;
    byte[] animalsIdData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    int[] animalsNumData;
    int[][] animalsPosition;
    byte select;
    IECRecordStore rms;

    public StageMode() {
        this.init();
        this.initRes();
    }

    private void init() {
        this.select = 0;
        this.animalsNumData = new int[8];
        Vector v = this.readRms();
        int i = 0;
        while (i < 8) {
            int[] d = (int[])v.elementAt(i);
            this.animalsNumData[i] = d[1];
            ++i;
        }
        this.animalsPosition = new int[8][2];
        int x = MainCanvas.menu.kuang_x + SetValues.kuang_bian;
        int y = MainCanvas.menu.kuang_y + SetValues.kuang_up * 2 / 3;
        int w = MainCanvas.menu.kuang_w - SetValues.kuang_bian * 2;
        int h = SetValues.textH;
        int with = w / 3;
        h /= 3;
        int i2 = 0;
        while (i2 < 2) {
            this.animalsPosition[i2][0] = x + with + i2 * with;
            this.animalsPosition[i2][1] = y + h / 2;
            ++i2;
        }
        with = w / 3;
        y += h;
        i2 = 0;
        while (i2 < 3) {
            this.animalsPosition[i2 + 2][0] = x + with / 2 + i2 * with;
            this.animalsPosition[i2 + 2][1] = y + h / 2;
            ++i2;
        }
        y += h;
        i2 = 0;
        while (i2 < 3) {
            this.animalsPosition[i2 + 5][0] = x + with / 2 + i2 * with;
            this.animalsPosition[i2 + 5][1] = y + h / 2;
            ++i2;
        }
    }

    public void initRes() {
        this.animalsImg = Func.crtImg("/back_animals.png");
        this.animals_selectImg = Func.crtImg("/back_animals2.png");
        if (this.scoreImg == null) {
            this.scoreImg = Func.crtImg("/animals_num.png");
            this.scoreW = this.scoreImg.getWidth() / 10;
            this.scoreH = this.scoreImg.getHeight();
        }
        this.stageNoImg = Func.crtImg("/back_num.png");
    }

    public void setNullRes() {
        this.animalsImg = null;
        this.animals_selectImg = null;
        this.stageNoImg = null;
    }

    public void draw(Graphics g) {
        int y;
        int x;
        int w = this.animalsImg.getWidth() / 8;
        int h = this.animalsImg.getHeight();
        int kw = this.animals_selectImg.getWidth() / 2;
        int kh = this.animals_selectImg.getHeight();
        int stageW = this.stageNoImg.getWidth() / 10;
        int stageH = this.stageNoImg.getHeight();
        int i = 0;
        while (i < this.animalsPosition.length) {
            x = this.animalsPosition[i][0] - kw / 2;
            y = this.animalsPosition[i][1] - kh / 4;
            g.setClip(x, y, kw, kh);
            if (this.select == i) {
                g.drawImage(this.animals_selectImg, x - kw, y, 0);
            } else {
                g.drawImage(this.animals_selectImg, x, y, 0);
            }
            if (this.animalsNumData[i] >= this.animalsCollectNum[i]) {
                x = this.animalsPosition[i][0] - w / 2;
                y = this.animalsPosition[i][1] - h / 2 + kh / 4;
                g.setClip(x, y, w, h);
                g.drawImage(this.animalsImg, x - (this.animalsIdData[i] - 1) * w, y, 0);
            } else {
                x = this.animalsPosition[i][0] - stageW / 2;
                y = this.animalsPosition[i][1] - stageH / 2 + kh / 4;
                g.setClip(x, y, stageW, stageH);
                g.drawImage(this.stageNoImg, x - (i + 1) * stageW, y, 0);
            }
            ++i;
        }
        x = Set.width - (SetValues.housex + SetValues.smScoreHousex);
        y = Set.height - (SetValues.housey + SetValues.smScoreHousey);
        AnimalsEscape.drawScore(g, x, y, String.valueOf(this.animalsNumData[this.select]), 2, this.scoreW, this.scoreH, this.scoreImg);
        MainCanvas.menu.drawSoftkey(g, 0, 1);
    }

    public void logic() {
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -21: {
                MainCanvas.menu.getClass();
                MainCanvas.menu.status = 0;
                break;
            }
            case -22: {
                break;
            }
            case -20: 
            case 53: {
                GameMID.sc.ae = new AnimalsEscape(this.animalsIdData[this.select]);
                GameMID.sc.toFromto = 1;
                GameMID.sc.getClass();
                GameMID.sc.status = (byte)12;
                break;
            }
            case -1: 
            case 50: {
                if (this.select == 2) {
                    this.select = 0;
                    break;
                }
                if (this.select == 3 || this.select == 4) {
                    this.select = 1;
                    break;
                }
                this.select = (byte)(this.select - 3);
                if (this.select >= 0) break;
                this.select = (byte)(this.select + 8);
                break;
            }
            case -2: 
            case 52: {
                this.select = (byte)(this.select - 1);
                if (this.select >= 0) break;
                this.select = (byte)7;
                break;
            }
            case -6: 
            case 56: {
                if (this.select == 0 || this.select == 1) {
                    this.select = (byte)(this.select + 2);
                    break;
                }
                this.select = (byte)(this.select + 3);
                if (this.select < 8) break;
                this.select = (byte)(this.select - 8);
                if (this.select != 2) break;
                this.select = 1;
                break;
            }
            case -5: 
            case 54: {
                this.select = (byte)(this.select + 1);
                if (this.select < 8) break;
                this.select = 0;
            }
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (MainCanvas.menu.liftKey(x, y)) {
            this.keyPressed(-21);
        } else if (MainCanvas.menu.rightKey(x, y)) {
            this.keyPressed(-22);
        } else {
            int w = this.animalsImg.getWidth() / 8 + 10;
            int h = this.animalsImg.getHeight() + 10;
            int i = 0;
            while (i < this.animalsPosition.length) {
                if (Func.isRect(x, y, this.animalsPosition[i][0] - w / 2 - 5, this.animalsPosition[i][1] - h / 2 - 5 + this.animals_selectImg.getHeight() / 4, w, h)) {
                    this.select = (byte)i;
                    this.keyPressed(-20);
                    return;
                }
                ++i;
            }
        }
    }

    public Vector readRms() {
        this.rms = new IECRecordStore();
        Vector<int[]> totalLevel = new Vector<int[]>();
        try {
            if (this.rms.hasRecord(SetValues.Rms_name)) {
                int[][] bl = this.rms.readIntArrays(SetValues.Rms_name, 2);
                int i = 0;
                while (i < bl.length) {
                    totalLevel.addElement(bl[i]);
                    System.out.println("\u6709\u6570\u636e.\u6570\u636e\u662f\u7b2c" + i + "\u4e2a:" + bl[i][0] + ":\u5f97\u5206:" + bl[i][1]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < 8) {
                    int[] nArray = new int[2];
                    nArray[0] = this.animalsIdData[i];
                    totalLevel.addElement(nArray);
                    ++i;
                }
                this.rms.saveIntArrys(SetValues.Rms_name, totalLevel);
                System.out.println("\u6ca1\u6709\u6570\u636e!!!" + totalLevel.size());
            }
            this.rms.closeRMS();
            this.rms = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalLevel;
    }

    public void setRms(Vector v) {
        if (this.rms == null) {
            this.rms = new IECRecordStore();
        }
        int i = 0;
        while (i < v.size() / 2) {
            int id = (Integer)v.elementAt(i * 2);
            int[] data = (int[])v.elementAt(i * 2 + 1);
            this.rms.saveIntArry(SetValues.Rms_name, id, data);
            ++i;
        }
        this.rms.closeRMS();
        this.rms = null;
    }

    public static int[] gerBarrier(int stage) {
        System.out.println("\u6765\u5f97\u8fd9\u91cc\u7684\u5173\u5361\u6570\u5b57\u662f:" + stage);
        int[] d = null;
        switch (stage) {
            case 1: 
            case 2: {
                d = new int[]{1, 2, 3, 4, 5};
                break;
            }
            case 3: 
            case 4: {
                d = new int[]{1, 2, 3, 4, 5, 6};
                break;
            }
            case 5: 
            case 6: {
                d = new int[]{1, 2, 3, 4, 5, 6, 7};
                break;
            }
            case 7: 
            case 8: {
                d = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
                break;
            }
            default: {
                d = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            }
        }
        return d;
    }
}

