/*
 * Decompiled with CFR 0.152.
 */
package iec.animalsescape;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class DragText {
    private String text;
    private Vector textV = new Vector();
    private Font font;
    private int lineH;
    private int areaX;
    private int areaY;
    private int areaW;
    private int areaH;
    private int startOff = 0;
    private int maxOff = 0;

    public DragText(String text, int x, int y, int w, int h, Font f) {
        this.text = text;
        this.font = f;
        this.lineH = f.getHeight() + 2;
        this.onAreaChange(x, y, w, h);
    }

    public void paint(Graphics g) {
        g.setClip(this.areaX, this.areaY, this.areaW, this.areaH);
        if (this.startOff > this.maxOff) {
            this.startOff = this.maxOff;
        }
        if (this.startOff < 0) {
            this.startOff = 0;
        }
        Font f = g.getFont();
        g.setFont(this.font);
        int y = this.areaY - this.startOff;
        if (this.areaH > this.lineH * this.textV.size()) {
            y = this.areaY + (this.areaH - this.lineH * this.textV.size()) / 2;
        }
        int i = 0;
        while (i < this.textV.size()) {
            if (y + this.font.getHeight() > this.areaY) {
                String str = (String)this.textV.elementAt(i);
                g.drawString(str, this.areaX + (this.areaW - this.font.stringWidth(str)) / 2, y, 0);
            }
            if ((y += this.lineH) > this.areaY + this.areaH) break;
            ++i;
        }
        g.setFont(f);
    }

    public void drag(int dragH) {
        this.startOff += dragH;
        if (this.startOff > this.maxOff) {
            this.startOff = this.maxOff;
        }
        if (this.startOff < 0) {
            this.startOff = 0;
        }
    }

    public void onAreaChange(int X, int Y, int W, int H) {
        this.areaX = X;
        this.areaY = Y;
        this.areaW = W;
        this.areaH = H;
        this.textV = DragText.getSubsection(this.text, this.font, this.areaW, " ");
        this.maxOff = this.textV.size() * this.lineH - this.areaH;
        if (this.maxOff < 0) {
            this.maxOff = 0;
        }
    }

    public static Vector getSubsection(String strSource, Font font, int width, String strSplit) {
        Vector<String> vector = new Vector<String>();
        String temp = strSource;
        int LastLength = 1;
        int step = 0;
        try {
            while (!temp.equals("")) {
                int i = temp.indexOf("\n");
                if (i > 0 && font.stringWidth(temp.substring(0, i - 1)) > width) {
                    i = -1;
                }
                if (i == -1) {
                    if (LastLength > temp.length()) {
                        i = temp.length();
                    } else {
                        i = LastLength;
                        int n = step = font.stringWidth(temp.substring(0, i)) > width ? -1 : 1;
                        if (i < temp.length()) {
                            while (font.stringWidth(temp.substring(0, i)) > width || font.stringWidth(temp.substring(0, i + 1)) <= width) {
                                if ((i += step) == temp.length()) break;
                            }
                        }
                    }
                    if (!strSplit.equals("")) {
                        int j = i;
                        if (i < temp.length()) {
                            while (strSplit.indexOf(temp.substring(i - 1, i)) == -1) {
                                if (--i != 0) continue;
                                i = j;
                                break;
                            }
                        }
                    }
                }
                LastLength = i;
                vector.addElement(temp.substring(0, i));
                if (i == temp.length()) {
                    temp = "";
                    continue;
                }
                if (!(temp = temp.substring(i)).substring(0, 1).equals("\n")) continue;
                temp = temp.substring(1);
            }
        }
        catch (Exception e) {
            System.out.println("getSubsection:" + e);
        }
        return vector;
    }

    public void resetDrag() {
        this.startOff = 0;
    }
}

