/*
 * Decompiled with CFR 0.152.
 */
package iec.octopusblast;

import iec.octopusblast.Func;
import iec.octopusblast.GameMID;
import iec.octopusblast.IECRecordStore;
import iec.octopusblast.MainCanvas;
import iec.octopusblast.OctopusBlasts;
import iec.octopusblast.Set;
import iec.octopusblast.SetValues;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BarrierMenu {
    Image barrierBackImg;
    Image barrierIconImg;
    int barrierIconW;
    int barrierIconH;
    Image menuStarImg;
    int menuStarW;
    int menuStarH;
    Image barrierNoImg;
    int barrierNoW;
    int barrierNoH;
    Image[] selectImg;
    byte allLevelNo = (byte)20;
    int level = 1;
    Vector totalLevel;
    byte level_horizontal_no = SetValues.barrierLevel_horizontal_no;
    byte level_vertical_no = SetValues.barrierLevel_vertical_no;
    String[][] menuLevel;
    int selectI = 0;
    int selectJ = 0;
    int selectPage = 0;
    int barrierOffest = 0;
    int barrierX;
    int barrierY;
    int barrierW;
    int barrierH;
    IECRecordStore rms;

    public BarrierMenu(int a) {
    }

    public BarrierMenu() {
        this.reStart();
        this.loadRes();
    }

    void reStart() {
        int scale = Set.width * 100000 / 240;
        this.barrierX = 15 * scale / 100000;
        this.barrierY = SetValues.barrierY;
        this.barrierW = (Set.width - this.barrierX * 2) / this.level_horizontal_no;
        this.barrierH = (Set.height - this.barrierY * 2) / this.level_vertical_no;
        this.totalLevel = this.readRms();
        this.level = this.totalLevel.size();
        int page = this.allLevelNo / (this.level_vertical_no * this.level_horizontal_no);
        if (this.allLevelNo % (this.level_vertical_no * this.level_horizontal_no) > 0) {
            ++page;
        }
        this.menuLevel = new String[page * this.level_vertical_no][this.level_horizontal_no];
        int i = 0;
        while (i < this.menuLevel.length) {
            int j = 0;
            while (j < this.menuLevel[i].length) {
                page = i * this.level_horizontal_no + j + 1;
                if (page <= this.level) {
                    this.menuLevel[i][j] = String.valueOf(page);
                    if (page == this.level) {
                        this.selectPage = (this.level - 1) / (this.level_vertical_no * this.level_horizontal_no);
                        this.selectI = i;
                        this.selectJ = j;
                    }
                } else {
                    this.menuLevel[i][j] = page > this.allLevelNo ? "w" : "n";
                }
                ++j;
            }
            ++i;
        }
        System.out.println("\u5f00\u5230\u7684\u5173\u5361\u662f:" + this.level);
    }

    void drawBarrier(Graphics g) {
        g.drawImage(this.barrierBackImg, 0, 0, 0);
        int y = this.barrierY;
        MainCanvas.menu.drawTitle(g, 0, 0, Set.width, y, 0);
        int w = this.barrierW;
        int h = this.barrierH;
        int x = this.barrierX + (w - this.barrierIconW >> 1);
        y -= MainCanvas.menu.titleImg.getHeight() / 5;
        int page = this.allLevelNo / (this.level_vertical_no * this.level_horizontal_no);
        if (this.allLevelNo % (this.level_vertical_no * this.level_horizontal_no) > 0) {
            ++page;
        }
        int ww = this.barrierIconW;
        int hh = this.barrierIconH;
        int sw = this.selectImg[0].getWidth();
        int sh = this.selectImg[0].getHeight();
        int starXoff = (ww * 2 / 3 - this.menuStarW * 3) / 4;
        int starW = ww / 3;
        byte starParam = SetValues.barrierstarparm;
        int k = 0;
        while (k < 3) {
            if (!(k == 0 && this.barrierOffest >= 0 || k == 2 && this.barrierOffest <= 0)) {
                int i = 0;
                while (i < this.level_vertical_no) {
                    int j = 0;
                    while (j < this.level_horizontal_no) {
                        int ii = this.selectPage == 0 && k == 0 ? i + (page + k - 1) * this.level_vertical_no : (this.selectPage == page - 1 && k == 2 ? i + (-1 + k - 1) * this.level_vertical_no : i + (this.selectPage + k - 1) * this.level_vertical_no);
                        if (ii >= 0 && !this.menuLevel[ii][j].equals("w")) {
                            int xx = x + j * w - this.barrierOffest + (k - 1) * w * this.level_horizontal_no;
                            int yy = y + i * hh * (SetValues.stage_icon_interval_y + 1) / SetValues.stage_icon_interval_y + SetValues.stage_icon_yoff;
                            if (xx < x) {
                                g.setClip(x - sw, yy, ww - (x - xx) + 2 * sw, hh + sh / 4);
                            } else if (xx + ww > x + w * this.level_horizontal_no) {
                                g.setClip(xx - sw, yy, ww - (xx + ww - x - w * this.level_horizontal_no) + 2 * sw, hh + sh / 4);
                            } else {
                                g.setClip(xx - sw, yy, ww + 2 * sw, hh + sh / 4);
                            }
                            if (!this.menuLevel[ii][j].equals("n")) {
                                g.drawImage(this.barrierIconImg, xx, yy, 0);
                                if (this.selectI == ii && this.selectJ == j) {
                                    g.drawImage(this.selectImg[0], xx - sw / 8, yy + hh / 6, 0);
                                    g.drawImage(this.selectImg[1], xx + ww - sw * 7 / 8, yy + hh / 6, 0);
                                    g.drawImage(this.selectImg[2], xx - sw / 8, yy + hh - sh * 3 / 4, 0);
                                    g.drawImage(this.selectImg[3], xx + ww - sw * 7 / 8, yy + hh - sh * 3 / 4, 0);
                                }
                                int[] barr = (int[])this.totalLevel.elementAt(ii * this.level_horizontal_no + j);
                                System.out.println("barr[0]----" + barr[0]);
                                int l = 0;
                                while (l < 3) {
                                    if (barr[0] == 0) {
                                        this.drawLevel(g, xx, yy + hh / 2 + 1, ww, hh, this.menuLevel[ii][j], this.barrierNoW, this.barrierNoH, this.barrierNoImg, x, y, w * this.level_horizontal_no, hh * this.level_vertical_no + hh / SetValues.stage_icon_interval_y);
                                    } else if (l + 1 <= barr[0]) {
                                        this.drawStar(g, l * (starXoff + this.menuStarW) + xx + ww / 6 + starXoff, yy + hh / 2, true, x, w * this.level_horizontal_no);
                                    }
                                    ++l;
                                }
                            } else {
                                g.drawImage(this.barrierIconImg, xx, yy - hh, 0);
                            }
                            if (this.selectI == ii && this.selectJ == j) {
                                g.drawImage(this.selectImg[0], xx - sw / 8, yy + hh / 6, 0);
                                g.drawImage(this.selectImg[1], xx + ww - sw * 7 / 8, yy + hh / 6, 0);
                                g.drawImage(this.selectImg[2], xx - sw / 8, yy + hh - sh * 3 / 4, 0);
                                g.drawImage(this.selectImg[3], xx + ww - sw * 7 / 8, yy + hh - sh * 3 / 4, 0);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++k;
        }
        MainCanvas.setClipFullScreen(g);
        MainCanvas.menu.drawSoftkey(g, 0, 1);
        MainCanvas.menu.drawSoftkey(g, 1, 2);
    }

    public void drawLevel(Graphics g, int x, int y, int w, int h, String level, int levelW, int levelH, Image img, int zoneX, int zoneY, int zoneW, int zoneH) {
        x += w - level.length() * levelW >> 1;
        int i = 0;
        while (i < level.length()) {
            int xright = x + i * levelW + levelW < zoneX + zoneW ? x + i * levelW + levelW : zoneX + zoneW;
            int xleft = zoneX > x + i * levelW ? zoneX : x + i * levelW;
            int ydown = y + levelH < zoneY + zoneH ? y + levelH : zoneY + zoneH;
            int yup = zoneY > y ? zoneY : y;
            int clipW = xright - xleft;
            int clipH = ydown - yup;
            if (clipW < 0) {
                clipW = 0;
            }
            if (clipH < 0) {
                clipH = 0;
            }
            g.setClip(xleft, yup, clipW, clipH);
            g.drawImage(img, x + i * levelW - (level.charAt(i) - 48) * levelW, y, 0);
            ++i;
        }
    }

    public void drawStar(Graphics g, int x, int y, boolean islighting, int zoneX, int zoneW) {
        if (x < zoneX) {
            g.setClip(zoneX, y, this.menuStarW - (zoneX - x), this.menuStarH);
        } else if (x + this.menuStarW > zoneX + zoneW) {
            g.setClip(x, y, this.menuStarW - (x + this.menuStarW - zoneX - zoneW), this.menuStarH);
        } else {
            g.setClip(x, y, this.menuStarW, this.menuStarH);
        }
        g.drawImage(this.menuStarImg, x, y, 0);
    }

    void logicBarrier() {
        if (this.barrierOffest > 0) {
            this.barrierOffest -= SetValues.barrierStringRate;
            if (this.barrierOffest < 0) {
                this.barrierOffest = 0;
            }
        } else if (this.barrierOffest < 0) {
            this.barrierOffest += SetValues.barrierStringRate;
            if (this.barrierOffest > 0) {
                this.barrierOffest = 0;
            }
        }
    }

    void keyBarrier(int keyCode) {
        switch (keyCode) {
            case -5: 
            case 53: {
                if (this.menuLevel[this.selectI][this.selectJ].equals("n")) {
                    return;
                }
                MainCanvas.menu.gameMenuStatus = 1;
                int level = Integer.parseInt(this.menuLevel[this.selectI][this.selectJ]);
                GameMID.sc.toFromto = 1;
                GameMID.sc.ob = new OctopusBlasts(this, level);
                GameMID.sc.getClass();
                GameMID.sc.status = (byte)12;
                break;
            }
            case -3: 
            case 52: {
                if (this.barrierOffest != 0) {
                    return;
                }
                --this.selectJ;
                if (this.selectJ >= 0) break;
                this.keyBarrier(49);
                break;
            }
            case -4: 
            case 54: {
                if (this.barrierOffest != 0) {
                    return;
                }
                ++this.selectJ;
                if (this.selectI * this.level_horizontal_no + this.selectJ + 1 <= this.allLevelNo && this.selectJ <= this.menuLevel[this.selectI].length - 1) break;
                this.keyBarrier(51);
                break;
            }
            case -1: 
            case 50: {
                --this.selectI;
                if (this.selectI >= this.selectPage * this.level_vertical_no) break;
                this.selectI += this.level_vertical_no;
                while (this.menuLevel[this.selectI][this.selectJ].equals("w")) {
                    --this.selectI;
                }
                break;
            }
            case -2: 
            case 56: {
                ++this.selectI;
                if (this.selectI < (this.selectPage + 1) * this.level_vertical_no && this.menuLevel[this.selectI][this.selectJ].equals("w")) {
                    this.selectI = this.selectPage * this.level_vertical_no;
                    break;
                }
                if (this.selectI < (this.selectPage + 1) * this.level_vertical_no) break;
                this.selectI = this.selectPage * this.level_vertical_no;
                break;
            }
            case -6: {
                GameMID.sc.getClass();
                GameMID.sc.status = 0;
                MainCanvas.menu.getClass();
                MainCanvas.menu.status = 0;
                break;
            }
            case -7: {
                this.keyBarrier(51);
                break;
            }
            case 42: 
            case 49: {
                if (this.barrierOffest != 0) {
                    return;
                }
                int allPage1 = this.allLevelNo / (this.level_horizontal_no * this.level_vertical_no);
                if (this.allLevelNo % (this.level_horizontal_no * this.level_vertical_no) > 0) {
                    ++allPage1;
                }
                --this.selectPage;
                if (this.selectPage < 0) {
                    this.selectPage = allPage1 - 1;
                }
                this.barrierOffest = Set.width - 30 + SetValues.barrierStringRate;
                this.selectI = this.selectPage * this.level_vertical_no;
                this.selectJ = 0;
                break;
            }
            case 35: 
            case 51: {
                if (this.barrierOffest != 0) {
                    return;
                }
                int allPage = this.allLevelNo / (this.level_horizontal_no * this.level_vertical_no);
                if (this.allLevelNo % (this.level_horizontal_no * this.level_vertical_no) > 0) {
                    ++allPage;
                }
                ++this.selectPage;
                if (this.selectPage > allPage - 1) {
                    this.selectPage = 0;
                }
                this.barrierOffest = -(Set.width - 30) - SetValues.barrierStringRate;
                this.selectI = this.selectPage * this.level_vertical_no;
                this.selectJ = 0;
            }
        }
    }

    private void loadRes() {
        System.out.println("\u5173\u5361\u83dc\u5355\u52a0\u8f7d++");
        this.barrierNoImg = Func.crtImg("/stage_num.png");
        this.barrierNoW = this.barrierNoImg.getWidth() / 10;
        this.barrierNoH = this.barrierNoImg.getHeight();
        this.barrierIconImg = Func.crtImg("/stage_icon.png");
        this.barrierIconW = this.barrierIconImg.getWidth();
        this.barrierIconH = this.barrierIconImg.getHeight() / 2;
        this.menuStarImg = Func.crtImg("/stage_star.png");
        this.menuStarW = this.menuStarImg.getWidth();
        this.menuStarH = this.menuStarImg.getHeight();
        if (MainCanvas.menu.otherback == null) {
            MainCanvas.menu.loadRes(3);
        }
        this.barrierBackImg = MainCanvas.menu.otherback;
        this.selectImg = new Image[4];
        this.selectImg[0] = Func.crtImg("/stage_select.png");
        this.selectImg[1] = Image.createImage((Image)this.selectImg[0], (int)0, (int)0, (int)this.selectImg[0].getWidth(), (int)this.selectImg[0].getHeight(), (int)2);
        this.selectImg[2] = Image.createImage((Image)this.selectImg[0], (int)0, (int)0, (int)this.selectImg[0].getWidth(), (int)this.selectImg[0].getHeight(), (int)1);
        this.selectImg[3] = Image.createImage((Image)this.selectImg[0], (int)0, (int)0, (int)this.selectImg[0].getWidth(), (int)this.selectImg[0].getHeight(), (int)3);
    }

    public void setNullRes() {
        System.out.println("\u6e05\u7a7abarrier\u7684res");
        this.barrierNoImg = null;
        this.barrierIconImg = null;
        this.barrierBackImg = null;
        this.menuStarImg = null;
        this.selectImg = null;
    }

    void loadRes(int type) {
        switch (type) {
            case 10: {
                this.loadRes();
                break;
            }
            case 20: {
                MainCanvas.menu.loadRes(4);
                break;
            }
            case 30: {
                MainCanvas.menu.loadRes(9);
                break;
            }
        }
    }

    public Vector readRms() {
        this.rms = new IECRecordStore();
        Vector<int[]> totalLevel = new Vector<int[]>();
        try {
            if (this.rms.hasRecord(SetValues.Rms_name)) {
                int[][] bl = this.rms.readIntArrays(SetValues.Rms_name, 2);
                int i = 0;
                while (i < bl.length) {
                    totalLevel.addElement(bl[i]);
                    System.out.println("\u6709\u6570\u636e.\u6570\u636e\u662f\u7b2c" + i + "\u4e2a:" + bl[i][0] + ":\u5f97\u5206:" + bl[i][1]);
                    ++i;
                }
            } else {
                this.level = 1;
                totalLevel.addElement(new int[2]);
                this.rms.saveIntArrys(SetValues.Rms_name, totalLevel);
                System.out.println("\u6ca1\u6709\u6570\u636e!!!" + totalLevel.size());
            }
            this.rms.closeRMS();
            this.rms = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalLevel;
    }

    public void setRms(Vector v) {
        if (this.rms == null) {
            this.rms = new IECRecordStore();
        }
        int i = 0;
        while (i < v.size() / 2) {
            int id = (Integer)v.elementAt(i * 2);
            int[] data = (int[])v.elementAt(i * 2 + 1);
            this.rms.saveIntArry(SetValues.Rms_name, id, data);
            ++i;
        }
        this.rms.closeRMS();
        this.rms = null;
    }
}

