/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Func;
import Main.GameMID;
import Main.Set;
import Main.SetValue;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InputClass {
    protected static char[][] Char = new char[][]{{'0', ' ', '_'}, {'.', ',', '?', '!', '1'}, {'a', 'b', 'c', '2', 'A', 'B', 'C'}, {'d', 'e', 'f', '3', 'D', 'E', 'F'}, {'g', 'h', 'i', '4', 'G', 'H', 'I'}, {'j', 'k', 'l', '5', 'J', 'K', 'L'}, {'m', 'n', 'o', '6', 'M', 'N', 'O'}, {'p', 'q', 'r', 's', '7', 'P', 'Q', 'R', 'S'}, {'t', 'u', 'v', '8', 'T', 'U', 'V'}, {'w', 'x', 'y', 'z', '9', 'W', 'X', 'Y', 'Z'}};
    private static char[][] upcase = new char[][]{{'0', ' ', '_'}, {'.', ',', '?', '!', '1'}, {'A', 'B', 'C', '2'}, {'D', 'E', 'F', '3'}, {'G', 'H', 'I', '4'}, {'J', 'K', 'L', '5'}, {'M', 'N', 'O', '6'}, {'P', 'Q', 'R', 'S', '7'}, {'T', 'U', 'V', '8'}, {'W', 'X', 'Y', 'Z', '9'}};
    private static char[][] lowcase = new char[][]{{'0', ' ', '_'}, {'.', ',', '?', '!', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}};
    private static char[] fulllowcase = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static char[] fullupcase = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static Image key;
    static Image fontImg;
    static int letterNo;
    static Image[] letters;
    static int letterW;
    static int letterH;
    static Font f;
    private static String strTemp;
    private static int lastKey;
    static long lastPress;
    private static int pressCount;
    private static int pressTime;
    private static boolean defaultFont;
    static int maxLength;
    static int maxChar;
    static int keyX;
    static int keyY;
    static int keyW;
    static int keyH;
    static int keyCol;
    static int keyRow;
    static boolean isVKOn;

    static {
        letterNo = 26;
        letters = new Image[letterNo];
        letterW = 0;
        letterH = 0;
        f = SetValue.f;
        strTemp = "";
        lastKey = 9999;
        lastPress = -1L;
        pressCount = 0;
        pressTime = 700;
        defaultFont = true;
        maxLength = 0;
        maxChar = 6;
        keyX = 0;
        keyY = 0;
        keyW = 0;
        keyH = 0;
        keyCol = 5;
        keyRow = 2;
        isVKOn = false;
    }

    private static char getChar(int keyName, int times) {
        --times;
        char ch = strTemp.length() == 0 ? upcase[keyName][times %= upcase[keyName].length] : lowcase[keyName][times %= lowcase[keyName].length];
        return ch;
    }

    protected static void pressKey(int keyCode) {
        if (keyCode != lastKey || System.currentTimeMillis() - lastPress > (long)pressTime) {
            pressCount = 0;
            lastKey = keyCode;
        }
        if (keyCode == lastKey) {
            lastPress = System.currentTimeMillis();
            if (++pressCount != 1) {
                strTemp = new String(strTemp.toCharArray(), 0, strTemp.length() - 1);
            }
            strTemp = String.valueOf(strTemp) + InputClass.getChar(keyCode - 48, pressCount);
        }
        while (maxLength > 0 && InputClass.getStringWidth(strTemp) > maxLength) {
            InputClass.erase();
        }
        while (maxChar > 0 && strTemp.length() > maxChar) {
            InputClass.erase();
        }
    }

    protected static String getString() {
        return strTemp;
    }

    protected static void erase() {
        if (strTemp.length() > 0) {
            strTemp = new String(strTemp.toCharArray(), 0, strTemp.length() - 1);
        }
        lastKey = 9999;
        lastPress = -1L;
    }

    protected static void initFontImg(String src) {
        fontImg = Func.crtImg(src);
        letterW = fontImg.getWidth() * 2 / 53;
        letterH = fontImg.getHeight();
        InputClass.initImageTo();
        defaultFont = false;
        fontImg = null;
    }

    protected static void setDefault(boolean i) {
        defaultFont = i;
        if (letters == null) {
            defaultFont = true;
        }
    }

    protected static boolean isDefault() {
        return defaultFont;
    }

    protected static void releaseFont() {
        letters = new Image[letterNo];
        defaultFont = true;
    }

    private static void initImageTo() {
        int x = 0;
        int i = 0;
        while (i < 26) {
            InputClass.letters[i] = Image.createImage((Image)fontImg, (int)x, (int)0, (int)letterW, (int)letterH, (int)0);
            if (i == 12) {
                InputClass.letters[i] = Image.createImage((Image)fontImg, (int)x, (int)0, (int)(letterW * 3 / 2), (int)letterH, (int)0);
                x += letterW / 2;
            }
            x += letterW;
            ++i;
        }
    }

    private static Image getLetter(char letter) {
        Image i = null;
        int n = letterNo;
        switch (letter) {
            case 'a': {
                --n;
            }
            case 'b': {
                --n;
            }
            case 'c': {
                --n;
            }
            case 'd': {
                --n;
            }
            case 'e': {
                --n;
            }
            case 'f': {
                --n;
            }
            case 'g': {
                --n;
            }
            case 'h': {
                --n;
            }
            case 'i': {
                --n;
            }
            case 'j': {
                --n;
            }
            case 'k': {
                --n;
            }
            case 'l': {
                --n;
            }
            case 'm': {
                --n;
            }
            case 'n': {
                --n;
            }
            case 'o': {
                --n;
            }
            case 'p': {
                --n;
            }
            case 'q': {
                --n;
            }
            case 'r': {
                --n;
            }
            case 's': {
                --n;
            }
            case 't': {
                --n;
            }
            case 'u': {
                --n;
            }
            case 'v': {
                --n;
            }
            case 'w': {
                --n;
            }
            case 'x': {
                --n;
            }
            case 'y': {
                --n;
            }
            case 'z': {
                --n;
                break;
            }
            default: {
                n = 100;
            }
        }
        i = n < 40 ? letters[n] : null;
        return i;
    }

    static int getStringWidth(String s) {
        if (defaultFont) {
            return f.stringWidth(s);
        }
        int width = 0;
        s = s.toLowerCase();
        char[] sChar = s.toCharArray();
        int i = 0;
        while (i < sChar.length) {
            width = InputClass.getLetter(sChar[i]) != null ? (width += InputClass.getLetter(sChar[i]).getWidth()) : (width += letterW);
            ++i;
        }
        return width;
    }

    static void drawString(Graphics g, String s, int x, int y) {
        if (defaultFont) {
            g.drawString(s, x, y, 0);
        } else {
            s = s.toLowerCase();
            char[] sChar = s.toCharArray();
            int i = 0;
            while (i < sChar.length) {
                if (InputClass.getLetter(sChar[i]) != null) {
                    g.drawImage(InputClass.getLetter(sChar[i]), x, y, 0);
                    x += InputClass.getLetter(sChar[i]).getWidth();
                } else {
                    x += letterW;
                }
                ++i;
            }
        }
    }

    static void initVK(int x, int y) {
        if (key == null) {
            key = Func.crtImg("/keyboard.png");
        }
        keyX = x;
        keyY = y;
        keyW = key.getWidth() / keyCol;
        keyH = key.getHeight() / keyRow;
        isVKOn = true;
    }

    static void initVK_at_bottom() {
        if (key == null) {
            key = Func.crtImg("/keyboard.png");
        }
        keyX = (Set.width - key.getWidth()) / 2;
        keyY = Set.height - key.getHeight();
        keyW = key.getWidth() / keyCol;
        keyH = key.getHeight() / keyRow;
        isVKOn = true;
    }

    static void VKOff() {
        isVKOn = false;
        key = null;
    }

    static void drawKeyboard(Graphics g) {
        g.setClip(keyX, keyY, key.getWidth(), key.getHeight());
        g.drawImage(key, keyX, keyY, 0);
    }

    static void press(int x, int y) {
        if (x < keyX || x > keyX + keyW * keyCol || y < keyY || y > keyY + keyH * keyRow) {
            return;
        }
        int n = 0;
        n = (y -= keyY) / keyH * keyCol + ((x -= keyX) / keyW + 1);
        System.out.println("n=" + n);
        if (n == 10) {
            GameMID.sc.menu.menuKey(48);
        } else {
            GameMID.sc.menu.menuKey(48 + n);
        }
    }

    static void getFullChar(int id) {
        strTemp = strTemp.length() == 0 ? String.valueOf(strTemp) + fullupcase[id] : String.valueOf(strTemp) + fulllowcase[id];
        while (maxLength > 0 && InputClass.getStringWidth(strTemp) > maxLength) {
            InputClass.erase();
        }
        while (maxChar > 0 && strTemp.length() > maxChar) {
            InputClass.erase();
        }
    }
}

