/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.ColorMatrixColorFilter;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class StainedGlassView
extends View {
    private static final int MAX_TOUCHES = 2;
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement back;
    private AnimatedElement background;
    private AnimatedElement[] parts;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private boolean back_tapped = false;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "stainedglass_bg";
    private boolean close_page = false;
    private int maxlevel;
    private int delays = 0;
    private boolean to_level;
    private boolean on_dialog_pre = false;
    private boolean on_dialog_post = false;
    private boolean dialog_tapped = false;
    private boolean show_complete = false;
    private long transition_time = 0L;
    private boolean sound_played = false;

    public StainedGlassView(MainActivity mainActivity, boolean bl) {
        super(mainActivity);
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        this.maxlevel = this.activity.getSharedPref().getInt("maxlevel", 0);
        this.to_level = bl;
        this.on_dialog_pre = this.activity.checkMessage(this.maxlevel, 4);
        if (!this.on_dialog_pre) {
            this.on_dialog_post = this.activity.checkMessage(this.maxlevel, 5);
        }
        if (this.maxlevel == 120 && !this.activity.getSharedPref().getBoolean("end_shown", false)) {
            this.show_complete = true;
            this.activity.getPrefEditor().putBoolean("end_shown", true);
            this.activity.getPrefEditor().commit();
        }
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.back != null) {
            return this.back;
        }
        return null;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.background != null) {
            this.back.unload();
            this.background.unload();
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].unload();
            }
        }
    }

    public boolean onBack() {
        if (this.on_dialog_pre) {
            this.on_dialog_pre = this.activity.progressDialog();
            if (!this.on_dialog_pre) {
                this.on_dialog_post = this.activity.checkMessage(this.maxlevel, 5);
            }
            return true;
        }
        if (this.on_dialog_post) {
            this.on_dialog_post = this.activity.progressDialog();
            return true;
        }
        if (this.show_complete && (this.transition_time == 0L || (float)(this.last_time - this.transition_time) < 500.0f)) {
            return true;
        }
        if (this.show_complete) {
            this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[(this.maxlevel - 1) / 10]);
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.back = new AnimatedElement(this.activity.getAssetLoader(), "button_272_ok", 0.5f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 2L);
        this.parts = new AnimatedElement[this.maxlevel / 4 + 1];
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = new AnimatedElement(this.activity.getAssetLoader(), Params.STAINED_GLASS_IMG[i], (Params.STAINED_GLASS_COORDS[i][0] + 126.0f) / 1152.0f, (Params.STAINED_GLASS_COORDS[i][1] + 116.0f) / 1152.0f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        }
        this.activity.getCanvas().setFocus(this.back);
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        int n;
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n2 = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 360;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        if (this.on_dialog_pre) {
            this.start_time = Math.max(System.currentTimeMillis() - 500L, this.start_time);
            this.time = System.currentTimeMillis() - this.start_time;
        } else {
            this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        }
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (this.show_complete && this.transition_time == 0L && !this.on_dialog_pre && !this.on_dialog_post) {
            this.activity.setPlaceholder("introscreen_bg");
            this.transition_time = this.time + 500L;
        }
        if (this.time < 302L) {
            bl = true;
        }
        if (this.transition_time > 0L && this.time > this.transition_time && this.background.getAnimation() != 8) {
            this.background.setPNG("introscreen_bg");
            this.background.animate(8, 0L);
        }
        if (this.transition_time > 0L && !this.background.isLoaded()) {
            this.transition_time = this.time;
        }
        this.background.render(graphicsContainer, n2, this.time);
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n2);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n2);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        graphicsContainer.save();
        for (n = 0; n < this.parts.length; ++n) {
            long l = 1000L;
            long l2 = 1000L;
            float f = (float)(this.time - l2) / (float)l;
            if (this.to_level && n == this.parts.length - 1 && this.time < 1000L + l) {
                bl = true;
                if (this.time <= l2) continue;
                this.parts[n].setColorFilter(new ColorMatrixColorFilter(3));
                graphicsContainer.save();
                graphicsContainer.translate(this.parts[n].getX(this.time) * (f - 1.0f), this.parts[n].getY(this.time) * (f - 1.0f));
                graphicsContainer.scale(2.0f - f, 2.0f - f);
                this.parts[n].render(graphicsContainer, n2, this.time);
                graphicsContainer.restore();
                this.parts[n].setColorFilter(null);
                if (this.sound_played) continue;
                this.activity.getMusic().playEffect("stained_glass_appear");
                this.sound_played = true;
                continue;
            }
            if (this.parts[n].render(graphicsContainer, n2, this.time)) continue;
            bl = true;
        }
        if (this.transition_time > 0L && this.time > this.transition_time) {
            graphicsContainer.save();
            graphicsContainer.setColor(-1);
            graphicsContainer.translate((float)graphicsContainer.getWidth() / this.scale / 2.0f, (float)graphicsContainer.getWidth() / this.scale + ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 4.0f / 3.0f) / 2.0f);
            this.activity.getBrady().setSize(45.0f);
            graphicsContainer.translate(0.0f, (float)(-(C2MValues.VICTORY_LINES[this.activity.getLanguage()].length - 1)) * this.activity.getBrady().getSize(graphicsContainer) * 2.0f / 3.0f);
            graphicsContainer.fillRect((float)(-graphicsContainer.getWidth() / 2), -this.activity.getBrady().getSize(graphicsContainer) * 2.0f / 3.0f, (float)graphicsContainer.getWidth(), this.activity.getBrady().getSize(graphicsContainer) * (float)(C2MValues.VICTORY_LINES[this.activity.getLanguage()].length + 1) * 4.0f / 3.0f);
            graphicsContainer.setColor(-16777216);
            for (n = 0; n < C2MValues.VICTORY_LINES[this.activity.getLanguage()].length; ++n) {
                graphicsContainer.save();
                graphicsContainer.translate((float)(-this.activity.getBrady().measure(C2MValues.VICTORY_LINES[this.activity.getLanguage()][n]) / 2), (float)n * this.activity.getBrady().getSize(graphicsContainer) * 4.0f / 3.0f);
                this.activity.getBrady().renderString(graphicsContainer, n2, C2MValues.VICTORY_LINES[this.activity.getLanguage()][n]);
                graphicsContainer.restore();
            }
            graphicsContainer.restore();
        }
        graphicsContainer.restore();
        if (this.back_tapped) {
            this.back.setColorFilter(Params.filter_dark);
        }
        if (!this.back.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.back_tapped) {
            this.back.setColorFilter(null);
        }
        if (this.on_dialog_pre || this.on_dialog_post && this.time > 2500L) {
            this.activity.renderDialog(graphicsContainer, n2, this.scale, this.dialog_tapped);
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time < 0L) {
            this.activity.openKitchen();
            this.destroy();
        } else if (bl) {
            this.callInvalidate();
        } else if (this.delays == 0) {
            this.postInvalidateDelayed(50L);
        }
    }

    public void postInvalidateDelayed(long l) {
        ++this.delays;
        super.postInvalidateDelayed(l);
    }

    public void callInvalidate() {
        ++this.delays;
        this.invalidate();
    }

    public void invalidate() {
        this.delays = Math.max(0, this.delays - 1);
        super.invalidate();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.close_page) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        if (this.on_dialog_pre) {
                            this.on_dialog_pre = false;
                            this.on_dialog_post = this.activity.checkMessage(this.maxlevel, 5);
                        } else {
                            this.on_dialog_post = false;
                        }
                    }
                    this.dialog_tapped = false;
                } else if (this.back_tapped) {
                    this.back_tapped = false;
                    if (this.to_level) {
                        if (this.show_complete) {
                            this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[(this.maxlevel - 1) / 10]);
                        }
                        this.activity.startPostgame(this.maxlevel - 1, false);
                    } else {
                        this.activity.startMap(this.maxlevel / 70);
                    }
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog_pre || this.on_dialog_post) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.back.isLoaded() && this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    if (this.show_complete && (this.transition_time == 0L || (float)(this.last_time - this.transition_time) < 500.0f)) {
                        return false;
                    }
                    this.back_tapped = true;
                    this.activity.playSound("standard_click");
                } else {
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.back_tapped && !this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.back_tapped = false;
                } else if (this.swipe_active[n]) {
                    // empty if block
                }
                return true;
            }
        }
        return true;
    }
}

