/*
 * Decompiled with CFR 0.152.
 */
package org.kson.me;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.kson.me.KSONArray;
import org.kson.me.KSONException;
import org.kson.me.KSONString;
import org.kson.me.KSONTokener;

public class KSONObject {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    private Hashtable myHashMap = new Hashtable();
    public static final Object NULL = new Null();

    public KSONObject() {
    }

    public KSONObject(KSONTokener x) throws KSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public KSONObject(String string) throws KSONException {
        this(new KSONTokener(string));
    }

    public KSONObject accumulate(String key, Object value) throws KSONException {
        KSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof KSONArray) {
            ((KSONArray)o).put(value);
        } else {
            this.put(key, new KSONArray().put(o).put(value));
        }
        return this;
    }

    public Object get(String key) throws KSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws KSONException {
        Object o = this.get(key);
        if (o.equals(FALSE) || o instanceof String && ((String)o).toLowerCase().equals("false")) {
            return false;
        }
        if (o.equals(TRUE) || o instanceof String && ((String)o).toLowerCase().equals("true")) {
            return true;
        }
        throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] is not a Boolean.");
    }

    public int getInt(String key) throws KSONException {
        Object o = this.get(key);
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] is not a number.");
    }

    public KSONArray getJSONArray(String key) throws KSONException {
        Object o = this.get(key);
        if (o instanceof KSONArray) {
            return (KSONArray)o;
        }
        throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] is not a JSONArray.");
    }

    public KSONObject getJSONObject(String key) throws KSONException {
        Object o = this.get(key);
        if (o instanceof KSONObject) {
            return (KSONObject)o;
        }
        throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws KSONException {
        Object o = this.get(key);
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new KSONException("JSONObject[" + KSONObject.quote(key) + "] is not a number.");
    }

    public String getString(String key) throws KSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Enumeration keys() {
        return this.myHashMap.keys();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public KSONArray names() {
        KSONArray ja = new KSONArray();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            ja.put(keys.nextElement());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String numberToString(Object n) throws KSONException {
        if (n == null) {
            throw new KSONException("Null pointer");
        }
        KSONObject.testValidity(n);
        return KSONObject.trimNumber(n.toString());
    }

    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public KSONObject put(String key, Vector value) throws KSONException {
        this.put(key, new KSONArray(value));
        return this;
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public KSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof KSONArray ? (KSONArray)o : null;
    }

    public KSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof KSONObject ? (KSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public KSONObject put(String key, boolean value) throws KSONException {
        this.put(key, value ? TRUE : FALSE);
        return this;
    }

    public KSONObject put(String key, int value) throws KSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public KSONObject put(String key, long value) throws KSONException {
        this.put(key, new Long(value));
        return this;
    }

    public KSONObject put(String key, Object value) throws KSONException {
        if (key == null) {
            throw new KSONException("Null key.");
        }
        if (value != null) {
            KSONObject.testValidity(value);
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public KSONObject putOpt(String key, Object value) throws KSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    static void testValidity(Object o) throws KSONException {
        if (o != null) {
            // empty if block
        }
    }

    public KSONArray toJSONArray(KSONArray names) throws KSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        KSONArray ja = new KSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            Enumeration keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasMoreElements()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.nextElement();
                sb.append(KSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(KSONObject.valueToString(this.myHashMap.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws KSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws KSONException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Enumeration keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.nextElement();
            sb.append(KSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(KSONObject.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasMoreElements()) {
                Object o = keys.nextElement();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(KSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(KSONObject.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws KSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof KSONString) {
            String o;
            try {
                o = ((KSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new KSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new KSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return KSONObject.numberToString(value);
        }
        if (value instanceof Boolean || value instanceof KSONObject || value instanceof KSONArray) {
            return value.toString();
        }
        return KSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws KSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o;
            if (value instanceof KSONString && (o = ((KSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return KSONObject.numberToString(value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof KSONObject) {
            return ((KSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof KSONArray) {
            return ((KSONArray)value).toString(indentFactor, indent);
        }
        return KSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws KSONException {
        try {
            boolean b = false;
            Enumeration keys = this.keys();
            writer.write(123);
            while (keys.hasMoreElements()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.nextElement();
                writer.write(KSONObject.quote(k.toString()));
                writer.write(58);
                Object v = this.myHashMap.get(k);
                if (v instanceof KSONObject) {
                    ((KSONObject)v).write(writer);
                } else if (v instanceof KSONArray) {
                    ((KSONArray)v).write(writer);
                } else {
                    writer.write(KSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new KSONException(e);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

