/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.trampas;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.SP;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Patrulla {
    private int strength = 1;
    private int posX;
    private int posY;
    private int width = 64;
    private int height = 32;
    private boolean facingRight;
    private int moveSpeed;
    private int state = 0;
    private final int IDLE;
    private final int WALK;
    private final int ATTACK;
    private final int AIM;
    private final int DEAD;
    private boolean isAlive;
    private int sightDistanceX;
    private int sightDistanceY;
    private boolean playerSight = false;
    private Random random;
    private int idleTime;
    private int time;
    private boolean bNearPlayer;
    private int countBullets;
    private final int maxBullets;
    private boolean initReloadBullets;
    private int bufferRealodBullets;
    private int bufferFirstCharging;
    private final int timeRecharging;
    private WeeldSprite sprite;
    private final String pngPath;
    private final String anuPath;

    public Patrulla(int _ID, int _posX, int _posY) {
        this.IDLE = 0;
        this.WALK = 1;
        this.ATTACK = 2;
        this.AIM = 3;
        this.DEAD = 4;
        this.maxBullets = 100;
        this.timeRecharging = 2000;
        this.pngPath = "/ePatrulla.png";
        this.anuPath = "/ePatrulla.anu";
        this.posX = _posX - 32;
        this.posY = _posY - this.height + 32;
        this.facingRight = false;
        this.moveSpeed = 2;
        this.sightDistanceX = 120;
        this.sightDistanceY = this.height;
        this.idleTime = 3000;
        this.state = 0;
        try {
            this.sprite = new WeeldSprite(_ID, new String[]{"/ePatrulla.png", "/fx_01.png", "/fx_05.png", "/fx_06.png"}, "/ePatrulla.anu", _posX, _posY, Gfx.totalWeeldSprite);
            this.sprite.loadPoolImage();
            this.sprite.setAnimation(this.state, false);
            this.sprite.setSpriteOrientation((byte)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.time = (int)System.currentTimeMillis();
        if (this.random == null) {
            this.random = new Random();
        }
        this.countBullets = 0;
        this.initReloadBullets = false;
        this.isAlive = true;
    }

    public void updateIA() {
        if (this.isAlive) {
            this.updateMagic();
            this.CheckAnimation();
            this.CheckPlayerPos();
            if (!Game.isInTheGetho) {
                if (!this.playerSight) {
                    this.Patrol();
                    this.bufferRealodBullets = 0;
                    this.bufferFirstCharging = 0;
                    this.initReloadBullets = false;
                    this.countBullets = 0;
                } else if (!Game.checkWallBetweenPLayer(this.posX, this.posY, this.height, this.width)) {
                    this.Attack();
                } else {
                    this.Patrol();
                }
            } else if (this.sprite.getAnimation() != 0) {
                this.sprite.setAnimation(0, true);
            }
        }
    }

    private void Patrol() {
        switch (Game.getTileX(this.posX, this.posY, this.width, this.height, this.facingRight, false)) {
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 43: 
            case 44: {
                this.Walk();
                break;
            }
            default: {
                this.state = 0;
                if ((int)System.currentTimeMillis() - this.time <= this.idleTime) break;
                this.state = 1;
                this.Flip();
            }
        }
    }

    private void Attack() {
        if (Player.getY() + Player.getHeight() == this.posY + this.height && !this.initReloadBullets) {
            if (this.bufferFirstCharging < 2000) {
                this.bufferFirstCharging = (int)((long)this.bufferFirstCharging + SP.dt);
                this.state = 3;
            } else {
                this.state = 2;
                this.attackPlayer(5);
                ++this.countBullets;
                if (this.countBullets > 100) {
                    this.initReloadBullets = true;
                }
            }
        } else {
            this.state = 3;
            if (this.facingRight && Player.getX() < this.posX) {
                this.Flip();
            }
            if (!this.facingRight && Player.getX() > this.posX) {
                this.Flip();
            }
        }
        if (this.initReloadBullets) {
            this.bufferRealodBullets = (int)((long)this.bufferRealodBullets + SP.dt);
            if (this.bufferRealodBullets > 2000) {
                this.bufferRealodBullets = 0;
                this.initReloadBullets = false;
                this.countBullets = 0;
            }
        }
    }

    private void CheckPlayerPos() {
        if (this.facingRight) {
            if (Player.getX() > this.posX - this.width && Player.getX() < this.posX + this.sightDistanceX && Player.getY() + Player.getHeight() >= this.posY + this.height - this.sightDistanceY && Player.getY() + Player.getHeight() <= this.posY + this.height) {
                this.playerSight = true;
                if (Player.getX() > this.posX - this.width && Player.getX() < this.posX) {
                    this.Flip();
                }
            } else if (!Player.isPlayerJumping() && Player.getY() + Player.getHeight() != this.posY + this.height || Player.getX() > this.posX + this.sightDistanceX) {
                this.playerSight = false;
            }
        } else if (Player.getX() < this.posX + (this.width + (this.width >> 1)) && Player.getX() > this.posX + (this.width >> 1) - this.sightDistanceX && Player.getY() + Player.getHeight() >= this.posY + this.height - this.sightDistanceY && Player.getY() + Player.getHeight() <= this.posY + this.height) {
            this.playerSight = true;
            if (Player.getX() < this.posX + (this.width + (this.width >> 1)) && Player.getX() > this.posX) {
                this.Flip();
            }
        } else if (!Player.isPlayerJumping() && Player.getY() + Player.getHeight() != this.posY + this.height || Player.getX() < this.posX - this.sightDistanceX) {
            this.playerSight = false;
        }
    }

    private void CheckAnimation() {
        this.sprite.update();
        switch (this.state) {
            case 1: {
                if (this.sprite.getAnimation() == 1) break;
                this.sprite.setAnimation(1, true);
                break;
            }
            case 2: {
                if (this.sprite.getAnimation() == 2) break;
                this.sprite.setAnimation(2, true);
                break;
            }
            case 0: {
                if (this.sprite.getAnimation() == 0) break;
                this.sprite.setAnimation(0, true);
                break;
            }
            case 3: {
                if (this.sprite.getAnimation() == 3) break;
                this.sprite.setAnimation(3, false);
                break;
            }
            case 4: {
                if (this.sprite.getAnimation() != 4) {
                    this.sprite.setAnimation(4, false);
                }
                if (!this.sprite.loopFinished()) break;
                this.isAlive = false;
            }
        }
    }

    private void Walk() {
        this.state = 1;
        this.posX = this.facingRight ? (this.posX += this.moveSpeed) : (this.posX -= this.moveSpeed);
        this.time = (int)System.currentTimeMillis();
    }

    private void Flip() {
        if (this.facingRight) {
            this.sprite.setSpriteOrientation((byte)1);
        } else if (!this.facingRight) {
            this.sprite.setSpriteOrientation((byte)0);
        }
        this.facingRight = !this.facingRight;
    }

    public void paint(Graphics g) {
        if (this.isAlive) {
            this.sprite.setDrawPosition(this.posX + (this.width >> 1) - Game.getScrollX(), this.posY + this.height - Game.getScrollY());
            this.sprite.drawFrame(g);
        }
    }

    public int getAnimation() {
        return this.state;
    }

    public void setAnimation(int animation) {
        this.state = animation;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setFacingRight(boolean facingRight) {
        this.facingRight = facingRight;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setMoveSpeed(int moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getState() {
        return this.state;
    }

    public boolean getNear() {
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.getHeight()) {
            this.bNearPlayer = true;
            return true;
        }
        this.bufferFirstCharging = 0;
        this.bNearPlayer = false;
        return false;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.sprite.unloadPoolImage();
            this.sprite.unloadSpriteData();
            this.sprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attackPlayer(int _strong) {
        if (!Player.isInmune()) {
            boolean direction = false;
            SP.pressUp = false;
            Player.jumping = false;
            Player.setAceleration(0);
            direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
            Player.lessLife(_strong, direction, false, false);
        }
    }

    private void updateMagic() {
        if (Player.getAnimation() == 15) {
            if (Player.getOrientation()) {
                if (this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && this.getPosX() > Player.getX() + Player.getWidth() && Player.getFrame() > 16) {
                    this.state = 4;
                }
            } else if (this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && this.getPosX() + this.width < Player.getX() && Player.getFrame() > 16) {
                this.state = 4;
            }
        }
    }
}

