/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.resources;

import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class RainParticleSystem {
    private RainParticle[] particles;
    public boolean emit;

    public RainParticleSystem(int max_particles) {
        this.particles = new RainParticle[max_particles];
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new RainParticle();
        }
    }

    public void update(long dt, int dx) {
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.emit && !this.particles[i].isAlive) {
                this.particles[i].reset();
            }
            if (!this.particles[i].isAlive) continue;
            this.particles[i].update(dt, dx);
        }
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].isAlive) continue;
            this.particles[i].draw(g);
        }
    }

    public static class RainParticle {
        private static final int MAX_DY = 10;
        private static final int MIN_DY = 2;
        private static final int MAX_LENGHT = 8;
        private static final int MIN_LENGHT = 4;
        private static Random rand;
        int x;
        int y;
        int dx;
        int dy;
        int lenght;
        boolean isAlive;

        public RainParticle() {
            if (rand == null) {
                rand = new Random(System.currentTimeMillis());
            }
        }

        public void reset() {
            this.isAlive = true;
            this.x = Math.abs(rand.nextInt()) % 240;
            this.y = -(Math.abs(rand.nextInt()) % 320);
            this.lenght = Math.abs(rand.nextInt()) % 4 + 4;
            this.dy = Math.abs(8) + 2;
            this.dx = -8;
        }

        private void update(long dt, int edx) {
            this.y += this.dy;
            this.x += this.dx - edx;
            if (this.x < 0) {
                this.x += 240;
            }
            if (this.x > 240) {
                this.x -= 240;
            }
            if (this.y > 320) {
                this.isAlive = false;
            }
        }

        public void draw(Graphics g) {
            g.setColor(0xFFFFFF);
            g.drawLine(this.x, this.y, this.x - this.lenght, this.y + this.lenght);
        }
    }
}

