/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.resources;

import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class MissileRainSystem {
    private Missile[] missiles;
    private int amount;

    public MissileRainSystem(int _amount, int _initialPositionX, int _initialPositionY) {
        this.amount = _amount << 1;
        this.missiles = new Missile[this.amount];
        for (int i = 0; i < this.missiles.length; ++i) {
            if (i < this.missiles.length >> 1) {
                this.missiles[i] = new Missile(_initialPositionX + 32 * (i + 1), _initialPositionY - 64 * i);
                this.missiles[i].alive = false;
                continue;
            }
            this.missiles[i] = new Missile(_initialPositionX - 32 * (i - _amount + 1), _initialPositionY - 64 * (i - _amount));
            this.missiles[i].alive = false;
        }
    }

    public void Update() {
        for (int i = 0; i < this.missiles.length; ++i) {
            if (!this.missiles[i].getAlive()) continue;
            this.missiles[i].update();
        }
    }

    public void Draw(Graphics g) {
        for (int i = 0; i < this.missiles.length; ++i) {
            if (this.missiles[i].getAlive()) {
                this.missiles[i].draw(g);
            }
            if (!this.missiles[i].spawnExplosion) continue;
            this.missiles[i].DrawExplosion(g);
        }
    }

    public void LaunchMissiles() {
        for (int i = 0; i < this.missiles.length; ++i) {
            this.missiles[i].alive = true;
        }
    }

    public class Missile {
        private int posX;
        private int posY;
        private int moveSpeed;
        private boolean alive;
        private int initialPosY;
        private int explosionFrame = 0;
        private boolean spawnExplosion = false;
        private int loopCount = 0;
        private int explosionX;
        private int explosionY;

        public Missile(int _posX, int _posY) {
            this.posX = _posX;
            this.initialPosY = this.posY = _posY;
            this.moveSpeed = 6;
        }

        private void update() {
            if (this.alive) {
                this.explosionX = this.posX - (Gfx.explosion.getWidth() >> 1);
                this.explosionY = this.posY - (Gfx.explosion.getHeight() >> 1) + 4;
                this.posY += this.moveSpeed;
                switch (Game.getTileY(this.posX - Gfx.missile.getWidth(), this.posY - Gfx.missile.getHeight(), 32, Gfx.missile.getHeight(), false)) {
                    case 9: 
                    case 10: 
                    case 11: {
                        this.alive = false;
                        this.SpawnExplosion();
                    }
                }
            }
        }

        private void draw(Graphics g) {
            if (this.alive) {
                g.drawImage(Gfx.missile, this.posX - Game.getScrollX(), this.posY + 16 - Game.getScrollY(), 33);
            }
        }

        public void setAlive(boolean _alive) {
            this.alive = _alive;
        }

        public boolean getAlive() {
            return this.alive;
        }

        private void SpawnExplosion() {
            this.spawnExplosion = true;
        }

        private void DrawExplosion(Graphics g) {
            Gfx.explosion.setPosition(this.posX - (Gfx.explosion.getWidth() >> 1) - Game.getScrollX(), this.posY - (Gfx.explosion.getHeight() >> 1) + 4 - Game.getScrollY());
            Gfx.explosion.setFrame(this.explosionFrame);
            Gfx.explosion.paint(g);
            switch (this.explosionFrame) {
                case 0: {
                    this.explosionFrame = 1;
                    break;
                }
                case 1: {
                    this.explosionFrame = 2;
                    break;
                }
                case 2: {
                    this.explosionFrame = 3;
                    break;
                }
                case 3: {
                    this.explosionFrame = 4;
                    break;
                }
                case 4: {
                    this.explosionFrame = 5;
                    break;
                }
                case 5: {
                    this.explosionFrame = 6;
                    break;
                }
                case 6: {
                    ++this.loopCount;
                    this.explosionFrame = 4;
                }
            }
            if (this.loopCount > 7) {
                this.spawnExplosion = false;
                this.posY = this.initialPosY;
                this.explosionFrame = 0;
                this.loopCount = 0;
            }
            this.hitPlayerExplosion(20);
        }

        private void hitPlayerExplosion(int _strong) {
            if (Player.getY() < this.explosionY + Gfx.explosion.getHeight() && Player.getY() + Player.getHeight() > this.explosionY && Player.getX() + Player.getWidth() > this.explosionX && Player.getX() < this.explosionX + Gfx.explosion.getWidth()) {
                boolean direction = false;
                direction = this.posX + 16 < Player.getX() + (Player.getWidth() >> 1);
                Player.lessLife(_strong, direction, true, false);
                Game.setQuake(_strong);
            }
        }
    }
}

